/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.minepiplus;

import ca.pfv.spmf.algorithms.episodes.minepiplus.Episode;
import ca.pfv.spmf.algorithms.episodes.minepiplus.Level;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FrequentEpisodes {
    private final List<Level> levels = new ArrayList<Level>();
    private int episodeCount = 0;

    public FrequentEpisodes() {
        this.levels.add(new Level());
    }

    public void addFrequentEpisode(Episode episode, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new Level());
        }
        this.levels.get(k).addFreEpisode(episode);
        ++this.episodeCount;
    }

    public void saveToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        StringBuilder buffer = new StringBuilder();
        for (Level l : this.levels) {
            for (Episode episode : l.getKFrequentEpisodes()) {
                buffer.append(episode.toString());
                buffer.append("\r\n");
            }
        }
        writer.write(buffer.toString());
        writer.close();
    }

    public int getTotalLevelNum() {
        return this.levels.size();
    }

    public int getFrequentEpisodesCount() {
        return this.episodeCount;
    }

    public void printFrequentEpisodes() {
        int numLevel = 0;
        for (Level l : this.levels) {
            System.out.println("  L" + numLevel + " +\r\n");
            for (Episode episode : l.getKFrequentEpisodes()) {
                System.out.println(episode.toString() + "\r\n");
            }
            System.out.println("\r\n");
            ++numLevel;
        }
    }
}

