/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.tup.tup_combined;

import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.AlgoTUP_Combined;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.Database_preinsertion_EWU;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.Sequence_preinsertion_EWU;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Episode_preinsertion_EWU {
    ArrayList<String> name = new ArrayList();
    public double utility = 0.0;
    public double ewu = 0.0;
    public static List<String> singleLengthEpi = new ArrayList<String>();
    private Map<Occurrence, Double> occUtilityMap = new HashMap<Occurrence, Double>();
    List<Occurrence> occ = new ArrayList<Occurrence>();
    List<Occurrence> minOcc = new ArrayList<Occurrence>();
    public static List<Episode_preinsertion_EWU> episodes = new ArrayList<Episode_preinsertion_EWU>();

    public Episode_preinsertion_EWU(ArrayList<String> name) {
        this.name = name;
    }

    public static void setEpisodeSet(List<Episode_preinsertion_EWU> allEpisode) {
        episodes = allEpisode;
    }

    public Map<Occurrence, Double> getMap() {
        return this.occUtilityMap;
    }

    public void addOccAndUtill(Occurrence minOcc, Double utill) {
        Map<Occurrence, Double> map = this.getMap();
        map.put(minOcc, utill);
    }

    public double getUtility(Occurrence minOcc) {
        return this.getMap().get(minOcc);
    }

    public double getUtility() {
        return this.utility;
    }

    public void setUtility(double utility) {
        this.utility = utility;
    }

    public double getEwu() {
        return this.ewu;
    }

    public void setEwu(double ewu) {
        this.ewu = ewu;
    }

    public ArrayList<String> getName() {
        return this.name;
    }

    public List<Occurrence> getOcc() {
        if (null == this.occ) {
            this.occ = new ArrayList<Occurrence>();
        }
        return this.occ;
    }

    public void setOcc(List<Occurrence> occ) {
        this.occ = occ;
    }

    public void addOccurrence(Occurrence occ) {
        this.getOcc().add(occ);
    }

    public void addMinOcc(Occurrence occ) {
        this.getMinOcc().add(occ);
    }

    public List<Occurrence> getMinOcc() {
        if (null == this.minOcc) {
            this.minOcc = new ArrayList<Occurrence>();
        }
        return this.minOcc;
    }

    public void setMinOccSerial(ArrayList<Occurrence> occList, Map<Occurrence, Double> occUtillMap) {
        ArrayList finalMinOccList = new ArrayList();
        boolean flag = false;
        if (this.getName().size() == 1) {
            this.minOcc = occList;
        } else {
            boolean lastIndex = false;
            for (int i = 0; i < occList.size(); ++i) {
                int size = occList.size();
                flag = false;
                Occurrence minOcc = occList.get(i);
                int start = minOcc.startTime;
                int end = minOcc.endTime;
                if (start >= end) continue;
                for (int j = 1; j < size; ++j) {
                    int inStart = occList.get((int)((i + j) % size)).startTime;
                    int inEnd = occList.get((int)((i + j) % size)).endTime;
                    if (start > inStart || inEnd > end) continue;
                    occList.remove(i);
                    --i;
                    flag = true;
                    break;
                }
                if (flag) continue;
                this.addMinOcc(minOcc);
                double utility = occUtillMap.get(minOcc);
                this.addOccAndUtill(minOcc, utility);
                this.addUtility(utility);
            }
        }
    }

    public static List<Episode_preinsertion_EWU> allEpisodes() {
        if (null == episodes) {
            episodes = new ArrayList<Episode_preinsertion_EWU>();
        }
        return episodes;
    }

    public static void addEpisode(Episode_preinsertion_EWU e) {
        Episode_preinsertion_EWU.allEpisodes().add(e);
    }

    public static Episode_preinsertion_EWU getEpisode(int i) {
        return episodes.get(i);
    }

    public String toString() {
        String str = "" + this.name;
        return str;
    }

    public void addUtility(double utility) {
        this.utility += utility;
    }

    public static Episode_preinsertion_EWU fromString(String l) {
        int index = Episode_preinsertion_EWU.contains(l);
        if (index != -1) {
            return Episode_preinsertion_EWU.allEpisodes().get(index);
        }
        ArrayList<String> nameStr = new ArrayList<String>();
        nameStr.add(l);
        Episode_preinsertion_EWU oneLengthEpi = new Episode_preinsertion_EWU(nameStr);
        Episode_preinsertion_EWU.addEpisode(oneLengthEpi);
        return oneLengthEpi;
    }

    public void oneLengthEwu() {
        List<Occurrence> minOccList = this.getMinOcc();
        double ewu = 0.0;
        for (Occurrence minOcc : minOccList) {
            for (int i = minOcc.endTime; i <= minOcc.startTime + AlgoTUP_Combined.getMaxTimeDuration() - 1; ++i) {
                Sequence_preinsertion_EWU s = Database_preinsertion_EWU.getSequence(i);
                if (s == null) continue;
                ewu += s.getSeqUtility();
            }
        }
        this.setEwu(ewu);
    }

    public double calculateEwu(List<Occurrence> epiMinOcc) {
        double ewu = 0.0;
        ArrayList<String> name = this.getName();
        String lastEpi = name.get(name.size() - 1);
        String[] events = lastEpi.split(" ");
        String lastEvent = events[events.length - 1];
        double finalEwu = 0.0;
        double firstPartEwu = this.getUtility();
        double leftFirstUtility = 0.0;
        for (Occurrence occ : epiMinOcc) {
            int end;
            double secondEwu = 0.0;
            int start = occ.startTime;
            for (int j = end = occ.endTime; j <= start + AlgoTUP_Combined.getMaxTimeDuration() - 1; ++j) {
                Sequence_preinsertion_EWU s = Database_preinsertion_EWU.getSequence(j);
                if (s == null) continue;
                secondEwu += s.getSeqUtility();
            }
            finalEwu += secondEwu;
            Sequence_preinsertion_EWU seq = Database_preinsertion_EWU.getSequence(end);
            int lastEpiUtility = 0;
            for (int i = 0; i < events.length; ++i) {
                int index = seq.contains(events[i]);
                lastEpiUtility = (int)((double)lastEpiUtility + seq.getUtill(index));
            }
            leftFirstUtility += (double)lastEpiUtility;
        }
        ewu = finalEwu += (firstPartEwu -= leftFirstUtility);
        return ewu;
    }

    public boolean equals(String epiName) {
        ArrayList<String> name = this.getName();
        for (int i = 0; i < name.size(); ++i) {
            if (!name.get(i).equals(epiName) && !name.get(i).contains(epiName)) continue;
            return true;
        }
        return false;
    }

    public static int contains(String epi) {
        for (int i = 0; i < episodes.size(); ++i) {
            Episode_preinsertion_EWU e = episodes.get(i);
            if (!e.getName().get(0).equals(epi)) continue;
            return i;
        }
        return -1;
    }

    public boolean simultEpiPresent() {
        String epiName = this.getName().get(0);
        Object[] tokens = epiName.split(" ");
        Arrays.sort(tokens);
        for (int i = 0; i < singleLengthEpi.size(); ++i) {
            String epiPresent = singleLengthEpi.get(i);
            Object[] tokensPresent = epiPresent.split(" ");
            if (tokens.length != tokensPresent.length) continue;
            Arrays.sort(tokensPresent);
            if (!Arrays.equals(tokens, tokensPresent)) continue;
            return true;
        }
        return false;
    }

    public String getFormattedName() {
        String episodeName = this.name.toString();
        episodeName = episodeName.substring(1, episodeName.length() - 1);
        episodeName = episodeName.replaceAll(",", " -1");
        StringBuilder buffer = new StringBuilder();
        buffer.append(episodeName);
        buffer.append(" -1");
        return buffer.toString();
    }

    public class Occurrence {
        public int startTime;
        public int endTime;

        public Occurrence(int startTime, int endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public boolean equals(Occurrence o) {
            return this.startTime == o.startTime && this.endTime == o.endTime;
        }

        public String toString() {
            String str = this.startTime + " " + this.endTime;
            return str;
        }
    }
}

