/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.episodes.upspan;

import ca.pfv.spmf.algorithms.episodes.upspan.CalculateDatabaseInfo;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class AlgoUP_Span {
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    boolean outputSingleEvents = false;
    int allCalculateCount = 0;
    long timePoint = 1112949L;
    int eventType = 50000;
    double minUtility = 0.9;
    String inputFile;
    String outputFile;
    int maximumTimeDuration = 4;
    ArrayList<Integer> freF1 = new ArrayList();
    ArrayList<Integer> totalUtilityByTimeAndDuration = new ArrayList();
    ArrayList<Integer> totalUtilityByTime = new ArrayList();
    long totalUtilityinAllSequence = 0L;
    ArrayList<HashMap<Integer, Integer>> eventUtilityByTime = new ArrayList();
    HashMap<Integer, Integer> F1TotalUtilitybackward = new HashMap();
    HashMap<Integer, Integer> F1TotalUtility = new HashMap();
    HashMap<Integer, HashSet<Integer>> F1TotalUtilityTime = new HashMap();
    int[] EventCount;
    HashMap<Integer, ArrayList<Integer>> eventTID = new HashMap();
    HashMap<Integer, ArrayList<Integer>> freDB = new HashMap();
    ArrayList<String> FreEP = new ArrayList();
    ArrayList<Integer> EPCount = new ArrayList();
    long Num_FreEP = 0L;
    long numberOfCandidates = 0L;
    int numberOfEpisodes = 0;
    int numberOfSingleEvents = 0;

    public void runAlgorithm(String inputFile, String outputFile, double minimumUtility, int maximumTimeDuration, boolean outputSingleEvents) {
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        CalculateDatabaseInfo cal = new CalculateDatabaseInfo(inputFile);
        cal.runCalculate();
        this.timePoint = cal.getDBSize();
        this.eventType = cal.getMaxID();
        this.minUtility = minimumUtility;
        this.inputFile = inputFile;
        this.maximumTimeDuration = maximumTimeDuration;
        this.outputSingleEvents = outputSingleEvents;
        this.outputFile = outputFile;
        this.MiningProcess();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void printStats() {
        System.out.println("=============  UP-SPAN v2.23- STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Number of high utility episodes = " + this.numberOfEpisodes);
        System.out.println(" Maximum memory : " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        if (this.outputSingleEvents) {
            System.out.println(" Number of high utility single events = " + this.numberOfSingleEvents);
        }
        System.out.println(" Number of candidates = " + this.numberOfCandidates);
        System.out.println("===================================================");
    }

    private void MiningProcess() {
        Thread t1 = new Thread(){

            @Override
            public void run() {
                AlgoUP_Span.this.EventCount = new int[AlgoUP_Span.this.eventType + 1];
                AlgoUP_Span.this.ReadFileToGetF1(AlgoUP_Span.this.inputFile);
                AlgoUP_Span.this.PruneF1InDB();
                AlgoUP_Span.this.Mining();
                AlgoUP_Span.this.saveResultToFile();
            }
        };
        t1.start();
        MemoryLogger.getInstance().checkMemory();
        try {
            t1.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void ReadFileToGetF1(String filename) {
        File file = new File(filename);
        FileInputStream fis = null;
        DataInputStream dis = null;
        BufferedReader br = null;
        try {
            String line;
            fis = new FileInputStream(file);
            dis = new DataInputStream(fis);
            br = new BufferedReader(new InputStreamReader(dis));
            int LineNumber = 0;
            this.totalUtilityByTime.add(0, 0);
            this.eventUtilityByTime.add(0, null);
            this.totalUtilityByTimeAndDuration.add(0);
            while ((line = br.readLine()) != null) {
                int R;
                ++LineNumber;
                String[] target = line.split(":");
                String[] element = target[0].split(" ");
                String TotalUtility = target[1];
                String[] elementUtitle = target[2].split(" ");
                HashMap<Integer, Integer> EventUtility = new HashMap<Integer, Integer>();
                this.freDB.put(LineNumber, new ArrayList());
                if (element.length <= 0) continue;
                for (int i = 0; i < element.length; ++i) {
                    int event = Integer.valueOf(element[i]);
                    int utility = Integer.valueOf(elementUtitle[i]);
                    EventUtility.put(event, utility);
                    int n = event;
                    this.EventCount[n] = this.EventCount[n] + utility;
                    if (this.eventTID.get(event) == null) {
                        this.eventTID.put(event, new ArrayList());
                    }
                    this.eventTID.get(event).add(LineNumber);
                    this.freDB.get(LineNumber).add(event);
                }
                this.totalUtilityByTime.add(LineNumber, Integer.valueOf(TotalUtility));
                this.totalUtilityinAllSequence += (long)Integer.valueOf(TotalUtility).intValue();
                this.eventUtilityByTime.add(LineNumber, EventUtility);
                this.totalUtilityByTimeAndDuration.add(Integer.valueOf(TotalUtility));
                if (LineNumber <= this.maximumTimeDuration) {
                    for (R = 1; R <= this.maximumTimeDuration && LineNumber - R >= 1; ++R) {
                        this.totalUtilityByTimeAndDuration.set(LineNumber - R, this.totalUtilityByTimeAndDuration.get(LineNumber - R) + Integer.valueOf(TotalUtility));
                    }
                    continue;
                }
                for (R = 1; R <= this.maximumTimeDuration; ++R) {
                    this.totalUtilityByTimeAndDuration.set(LineNumber - R, this.totalUtilityByTimeAndDuration.get(LineNumber - R) + Integer.valueOf(TotalUtility));
                }
            }
            fis.close();
            dis.close();
            br.close();
            for (int L = 1; L < this.eventUtilityByTime.size(); ++L) {
                Set<Integer> AllEventAtTime = this.eventUtilityByTime.get(L).keySet();
                for (Integer Event2 : AllEventAtTime) {
                    int EndRange;
                    if (!this.F1TotalUtilitybackward.containsKey(Event2)) {
                        this.F1TotalUtilitybackward.put(Event2, this.totalUtilityByTimeAndDuration.get(L));
                    } else {
                        this.F1TotalUtilitybackward.put(Event2, this.F1TotalUtilitybackward.get(Event2) + this.totalUtilityByTimeAndDuration.get(L));
                    }
                    int StartRange = L - this.maximumTimeDuration;
                    if (StartRange < 1) {
                        StartRange = 1;
                    }
                    if ((EndRange = L + this.maximumTimeDuration) >= this.eventUtilityByTime.size()) {
                        EndRange = this.eventUtilityByTime.size() - 1;
                    }
                    for (int range = StartRange; range <= EndRange; ++range) {
                        if (!this.F1TotalUtilityTime.containsKey(Event2)) {
                            HashSet<Integer> Windows = new HashSet<Integer>();
                            Windows.add(range);
                            this.F1TotalUtilityTime.put(Event2, Windows);
                            continue;
                        }
                        this.F1TotalUtilityTime.get(Event2).add(range);
                    }
                }
            }
            Set<Integer> AllEventAtTime = this.F1TotalUtilityTime.keySet();
            for (Integer Event3 : AllEventAtTime) {
                int Total = 0;
                for (int i = 0; i < this.F1TotalUtilityTime.get(Event3).size(); ++i) {
                    Total += this.totalUtilityByTimeAndDuration.get(i).intValue();
                }
                this.F1TotalUtility.put(Event3, Total);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("\u00ef\u00bf\u00bd\u00e4\u00a4\u00a3\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00c9\u00ae\u00ef\u00bf\u00bd:" + e);
        }
        catch (IOException e) {
            System.out.println("\u00c5\u00aa\u00ef\u00bf\u00bd\u00c9\u00b5o\u00ef\u00bf\u00bd\u00cd\u00bf\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd~:" + e);
        }
        for (int i = 0; i < this.eventType + 1; ++i) {
            if (this.EventCount[i] <= 0) continue;
            this.freF1.add(i);
        }
        this.F1TotalUtilityTime.clear();
    }

    private void PruneF1InDB() {
        ArrayList<Integer> WPurneF1 = new ArrayList<Integer>();
        for (int j = this.freF1.size() - 1; j >= 0; --j) {
            if (!((double)this.F1TotalUtility.get(this.freF1.get(j)).intValue() < this.minUtility * (double)this.totalUtilityinAllSequence)) continue;
            WPurneF1.add(this.freF1.get(j));
            this.eventTID.remove(this.freF1.get(j));
            this.freF1.remove(j);
        }
        if (WPurneF1.size() > 0) {
            for (int LineNumber = 1; LineNumber < this.totalUtilityByTime.size(); ++LineNumber) {
                int R;
                for (int j = 0; j < WPurneF1.size(); ++j) {
                    if (!this.eventUtilityByTime.get(LineNumber).containsKey(WPurneF1.get(j))) continue;
                    this.totalUtilityByTime.set(LineNumber, this.totalUtilityByTime.get(LineNumber) - this.eventUtilityByTime.get(LineNumber).get(WPurneF1.get(j)));
                    this.eventUtilityByTime.get(LineNumber).remove(WPurneF1.get(j));
                    this.freDB.get(LineNumber).remove(WPurneF1.get(j));
                }
                int TotalUtility = this.totalUtilityByTime.get(LineNumber);
                this.totalUtilityByTimeAndDuration.set(LineNumber, TotalUtility);
                if (LineNumber <= this.maximumTimeDuration) {
                    for (R = 1; R <= this.maximumTimeDuration && LineNumber - R >= 1; ++R) {
                        this.totalUtilityByTimeAndDuration.set(LineNumber - R, this.totalUtilityByTimeAndDuration.get(LineNumber - R) + TotalUtility);
                    }
                    continue;
                }
                for (R = 1; R <= this.maximumTimeDuration; ++R) {
                    this.totalUtilityByTimeAndDuration.set(LineNumber - R, this.totalUtilityByTimeAndDuration.get(LineNumber - R) + TotalUtility);
                }
            }
        }
        this.F1TotalUtility.clear();
        this.totalUtilityByTime.clear();
    }

    private void Mining() {
        for (int i = 0; i < this.freF1.size(); ++i) {
            if (!((double)this.F1TotalUtilitybackward.get(this.freF1.get(i)).intValue() >= this.minUtility * (double)this.totalUtilityinAllSequence)) continue;
            ++this.allCalculateCount;
            this.FreEP.add(String.valueOf(this.freF1.get(i)));
            this.EPCount.add(this.EventCount[this.freF1.get(i)]);
            this.MiningEP(String.valueOf(this.freF1.get(i)), this.EventCount[this.freF1.get(i)], this.eventTID.get(this.freF1.get(i)), this.eventTID.get(this.freF1.get(i)), this.eventTID.get(this.freF1.get(i)), this.eventTID.get(this.freF1.get(i)));
        }
    }

    public void MiningEP(String Pepisode, int EpisodeExactUtility, ArrayList<Integer> Pos, ArrayList<Integer> Poe, ArrayList<Integer> Pmos, ArrayList<Integer> Pmoe) {
        ++this.numberOfCandidates;
        this.MiningSimult(Pepisode, EpisodeExactUtility, Pos, Poe, Pmos, Pmoe);
        this.MiningSerial(Pepisode, EpisodeExactUtility, Pos, Poe, Pmos, Pmoe);
    }

    public void MiningSimult(String Pepisode, int EpisodeExactUtility, ArrayList<Integer> Pos, ArrayList<Integer> Poe, ArrayList<Integer> Pmos, ArrayList<Integer> Pmoe) {
        int i;
        int[] LocalCount = new int[this.eventType + 1];
        int[] EventExactUtility = new int[this.eventType + 1];
        Arrays.fill(LocalCount, 0);
        Arrays.fill(EventExactUtility, 0);
        HashMap OS = new HashMap();
        HashMap OE = new HashMap();
        HashMap MOS = new HashMap();
        HashMap MOE = new HashMap();
        for (int i2 = 1; i2 < this.eventType + 1; ++i2) {
            MOS.put(i2, new ArrayList());
            MOE.put(i2, new ArrayList());
        }
        String[] element1 = Pepisode.split(",");
        String[] element2 = element1[element1.length - 1].split(" ");
        int lastevent = Integer.valueOf(element2[element2.length - 1]);
        for (i = 0; i < Pos.size(); ++i) {
            ArrayList<Integer> EventList;
            int ocs = Pos.get(i);
            int timepoint = Poe.get(i);
            long TC = this.timePoint;
            if ((long)(ocs + this.maximumTimeDuration) < TC) {
                TC = ocs + this.maximumTimeDuration;
            }
            if ((EventList = this.freDB.get(timepoint)) == null) continue;
            for (int k = 0; k < EventList.size(); ++k) {
                if (EventList.get(k) <= lastevent) continue;
                int oce = timepoint;
                if (OS.get(EventList.get(k)) == null) {
                    OS.put(EventList.get(k), new ArrayList());
                    OE.put(EventList.get(k), new ArrayList());
                }
                ((ArrayList)OS.get(EventList.get(k))).add(ocs);
                ((ArrayList)OE.get(EventList.get(k))).add(oce);
                int ismo = this.IsMo((ArrayList)MOS.get(EventList.get(k)), (ArrayList)MOE.get(EventList.get(k)), ocs, oce);
                if (ismo == -1) {
                    ((ArrayList)MOS.get(EventList.get(k))).add(ocs);
                    ((ArrayList)MOE.get(EventList.get(k))).add(oce);
                    int n = EventList.get(k);
                    LocalCount[n] = LocalCount[n] + this.totalUtilityByTimeAndDuration.get(ocs);
                    int n2 = EventList.get(k);
                    EventExactUtility[n2] = EventExactUtility[n2] + this.CalculateUtility(Pepisode + " " + EventList.get(k), ocs, oce, 1);
                    continue;
                }
                if (ismo == -2) continue;
                ((ArrayList)MOS.get(EventList.get(k))).remove(ismo);
                ((ArrayList)MOE.get(EventList.get(k))).remove(ismo);
                ((ArrayList)MOS.get(EventList.get(k))).add(ocs);
                ((ArrayList)MOE.get(EventList.get(k))).add(oce);
            }
        }
        for (i = 0; i < this.freF1.size(); ++i) {
            if (!((double)LocalCount[this.freF1.get(i)] >= this.minUtility * (double)this.totalUtilityinAllSequence)) continue;
            ++this.Num_FreEP;
            String Nepisode = Pepisode.concat(" " + String.valueOf(this.freF1.get(i)));
            this.FreEP.add(Nepisode);
            this.EPCount.add(EventExactUtility[this.freF1.get(i)]);
            this.MiningEP(Nepisode, EventExactUtility[this.freF1.get(i)], (ArrayList)OS.get(this.freF1.get(i)), (ArrayList)OE.get(this.freF1.get(i)), (ArrayList)MOS.get(this.freF1.get(i)), (ArrayList)MOE.get(this.freF1.get(i)));
        }
    }

    public void MiningSerial(String Pepisode, int EpisodeExactUtility, ArrayList<Integer> Pos, ArrayList<Integer> Poe, ArrayList<Integer> Pmos, ArrayList<Integer> Pmoe) {
        int oce;
        int k;
        ArrayList<Integer> EventList;
        int j;
        long TC;
        int timepoint;
        int ocs;
        int i;
        int[] LocalCount = new int[this.eventType + 1];
        int[] EventExactUtility = new int[this.eventType + 1];
        Arrays.fill(LocalCount, 0);
        Arrays.fill(EventExactUtility, 0);
        HashMap OS = new HashMap();
        HashMap OE = new HashMap();
        HashMap MOS = new HashMap();
        HashMap MOE = new HashMap();
        for (i = 0; i < this.eventType + 1; ++i) {
            MOS.put(i, new ArrayList());
            MOE.put(i, new ArrayList());
        }
        for (i = 0; i < Pos.size(); ++i) {
            ocs = Pos.get(i);
            timepoint = Poe.get(i);
            TC = this.timePoint;
            if ((long)(ocs + this.maximumTimeDuration) < TC) {
                TC = ocs + this.maximumTimeDuration;
            }
            j = timepoint + 1;
            while ((long)j < TC + 1L) {
                EventList = this.freDB.get(j);
                if (EventList != null) {
                    for (k = 0; k < EventList.size(); ++k) {
                        oce = j;
                        if (OS.get(EventList.get(k)) == null) {
                            OS.put(EventList.get(k), new ArrayList());
                            OE.put(EventList.get(k), new ArrayList());
                        }
                        ((ArrayList)OS.get(EventList.get(k))).add(ocs);
                        ((ArrayList)OE.get(EventList.get(k))).add(oce);
                    }
                }
                ++j;
            }
        }
        for (i = 0; i < Pmos.size(); ++i) {
            ocs = Pmos.get(i);
            timepoint = Pmoe.get(i);
            TC = this.timePoint;
            if ((long)(ocs + this.maximumTimeDuration) < TC) {
                TC = ocs + this.maximumTimeDuration;
            }
            j = timepoint + 1;
            while ((long)j < TC + 1L) {
                EventList = this.freDB.get(j);
                if (EventList != null) {
                    for (k = 0; k < EventList.size(); ++k) {
                        oce = j;
                        int ismo = this.IsMo((ArrayList)MOS.get(EventList.get(k)), (ArrayList)MOE.get(EventList.get(k)), ocs, oce);
                        if (ismo == -1) {
                            ((ArrayList)MOS.get(EventList.get(k))).add(ocs);
                            ((ArrayList)MOE.get(EventList.get(k))).add(oce);
                            int n = EventList.get(k);
                            LocalCount[n] = LocalCount[n] + this.totalUtilityByTimeAndDuration.get(ocs);
                            int n2 = EventList.get(k);
                            EventExactUtility[n2] = EventExactUtility[n2] + this.CalculateUtility(Pepisode + "," + EventList.get(k), ocs, oce, 1);
                            continue;
                        }
                        if (ismo == -2) continue;
                        ((ArrayList)MOS.get(EventList.get(k))).remove(ismo);
                        ((ArrayList)MOE.get(EventList.get(k))).remove(ismo);
                        ((ArrayList)MOS.get(EventList.get(k))).add(ocs);
                        ((ArrayList)MOE.get(EventList.get(k))).add(oce);
                    }
                }
                ++j;
            }
        }
        for (i = 0; i < this.freF1.size(); ++i) {
            if (!((double)LocalCount[this.freF1.get(i)] >= this.minUtility * (double)this.totalUtilityinAllSequence)) continue;
            ++this.Num_FreEP;
            String Nepisode = Pepisode.concat("," + String.valueOf(this.freF1.get(i)));
            this.FreEP.add(Nepisode);
            this.EPCount.add(EventExactUtility[this.freF1.get(i)]);
            if (!((double)(EpisodeExactUtility + this.F1TotalUtilitybackward.get(this.freF1.get(i))) >= this.minUtility * (double)this.totalUtilityinAllSequence)) continue;
            ++this.allCalculateCount;
            this.MiningEP(Nepisode, EventExactUtility[this.freF1.get(i)], (ArrayList)OS.get(this.freF1.get(i)), (ArrayList)OE.get(this.freF1.get(i)), (ArrayList)MOS.get(this.freF1.get(i)), (ArrayList)MOE.get(this.freF1.get(i)));
        }
    }

    public int CalculateUtility(String Pepisode, int ocs, int oce, int type) {
        int i;
        int CheckEventInStarttime;
        int i2;
        String[] event;
        int j;
        int utility = 0;
        String[] SubEpisode = Pepisode.split(",");
        if (type == 1 && SubEpisode.length < 2) {
            String[] event2 = SubEpisode[SubEpisode.length - 1].split(" ");
            for (int i3 = 0; i3 < event2.length; ++i3) {
                if (!this.eventUtilityByTime.get(oce).containsKey(event2[i3])) continue;
                utility += this.eventUtilityByTime.get(oce).get(Integer.valueOf(event2[i3])).intValue();
            }
        } else if (type == 1 && SubEpisode.length >= 2) {
            int starttime = ocs;
            block1: for (j = 0; j < SubEpisode.length; ++j) {
                event = SubEpisode[j].split(" ");
                if (j == 0) {
                    for (i2 = 0; i2 < event.length; ++i2) {
                        utility += this.eventUtilityByTime.get(starttime).get(Integer.valueOf(event[i2])).intValue();
                    }
                    ++starttime;
                    continue;
                }
                while (starttime <= oce) {
                    CheckEventInStarttime = 0;
                    for (i = 0; i < event.length && this.eventUtilityByTime.get(starttime).containsKey(Integer.valueOf(event[i])); ++i) {
                        ++CheckEventInStarttime;
                    }
                    if (CheckEventInStarttime == event.length) {
                        for (i = 0; i < event.length; ++i) {
                            utility += this.eventUtilityByTime.get(starttime).get(Integer.valueOf(event[i])).intValue();
                        }
                        continue block1;
                    }
                    ++starttime;
                }
            }
        }
        if (type == 2 && SubEpisode.length < 2) {
            utility = this.totalUtilityByTimeAndDuration.get(ocs);
        } else if (type == 2 && SubEpisode.length >= 2) {
            int starttime = ocs;
            block6: for (j = 0; j < SubEpisode.length; ++j) {
                event = SubEpisode[j].split(" ");
                if (j == 0) {
                    for (i2 = 0; i2 < event.length; ++i2) {
                        utility += this.eventUtilityByTime.get(starttime).get(Integer.valueOf(event[i2])).intValue();
                    }
                    ++starttime;
                    continue;
                }
                while (starttime <= oce) {
                    CheckEventInStarttime = 0;
                    for (i = 0; i < event.length && this.eventUtilityByTime.get(starttime).containsKey(Integer.valueOf(event[i])); ++i) {
                        ++CheckEventInStarttime;
                    }
                    if (CheckEventInStarttime == event.length) {
                        if (starttime == oce) continue block6;
                        for (i = 0; i < event.length; ++i) {
                            utility += this.eventUtilityByTime.get(starttime).get(Integer.valueOf(event[i])).intValue();
                        }
                        continue block6;
                    }
                    ++starttime;
                }
            }
        }
        return utility;
    }

    public int IsMo(ArrayList<Integer> mos, ArrayList<Integer> moe, int ocs, int oce) {
        int ismo = -1;
        if (mos.size() == 0) {
            ismo = -1;
        } else {
            for (int i = 0; i < mos.size(); ++i) {
                int Nmos = mos.get(i);
                int Nmoe = moe.get(i);
                if (ocs <= Nmos && oce >= Nmoe) {
                    ismo = -2;
                    continue;
                }
                if (ocs < Nmos || oce > Nmoe) continue;
                ismo = i;
            }
        }
        return ismo;
    }

    public void saveResultToFile() {
        try {
            int i;
            FileWriter fstream = new FileWriter(this.outputFile);
            BufferedWriter out = new BufferedWriter(fstream);
            if (this.outputSingleEvents) {
                for (i = 0; i < this.freF1.size(); ++i) {
                    int utility = this.EventCount[this.freF1.get(i)];
                    if (!((double)utility >= this.minUtility * (double)this.totalUtilityinAllSequence)) continue;
                    out.write(this.freF1.get(i) + " -1 #UTIL: " + utility);
                    out.newLine();
                    ++this.numberOfSingleEvents;
                }
            }
            for (i = 0; i < this.FreEP.size(); ++i) {
                if (!((double)this.EPCount.get(i).intValue() >= this.minUtility * (double)this.totalUtilityinAllSequence)) continue;
                String episodeName = this.FreEP.get(i);
                episodeName = episodeName.replaceAll(",", " -1 ");
                out.write(episodeName);
                out.write(" -1 #UTIL: " + this.EPCount.get(i));
                out.newLine();
                ++this.numberOfEpisodes;
            }
            out.close();
        }
        catch (IOException e) {
            System.out.println("\u00ef\u00bf\u00bdg\u00ef\u00bf\u00bd\u00c9\u00b5o\u00ef\u00bf\u00bd\u00cd\u00bf\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd~:" + e);
        }
    }
}

