/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.DFIGrowth;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class AlgoDFIGrowth {
    static ArrayList<ArrayList<String>> data;
    static ArrayList<ArrayList<Integer>> Intdata;
    static ArrayList<ArrayList<String>> frequence;
    static ArrayList<LinkNode> subheaderTable;
    static boolean change_treenode;
    static long startTimestamp;
    static long endTime;
    static double current_memory;
    static double MaxMemory;
    static int transactionCount;
    static int itemsetCount;

    static void MemoryUsage() {
        current_memory = (double)(Runtime.getRuntime().totalMemory() / 1024L) / 1024.0 - (double)(Runtime.getRuntime().freeMemory() / 1024L) / 1024.0;
        if (current_memory > MaxMemory) {
            MaxMemory = current_memory;
        }
    }

    public void runAlgorithm(String input) throws IOException {
        AlgoDFIGrowth.MemoryUsage();
        startTimestamp = System.currentTimeMillis();
        AlgoDFIGrowth.readDB(input);
        frequence = AlgoDFIGrowth.filter(frequence);
        data = AlgoDFIGrowth.changeDatabase(data, frequence);
        subheaderTable = AlgoDFIGrowth.createHT(frequence);
        frequence = null;
        AlgoDFIGrowth.createFPT(subheaderTable, data);
        AlgoDFIGrowth.DFIgrowthReady(subheaderTable);
    }

    public static void readDB(String input) throws IOException {
        transactionCount = 0;
        String path = input;
        String line = "";
        boolean is_firsttime = true;
        boolean is_same = false;
        data = new ArrayList();
        frequence = new ArrayList();
        FileReader fl = new FileReader(path);
        BufferedReader br = new BufferedReader(fl);
        while ((line = br.readLine()) != null) {
            ++transactionCount;
            ArrayList<String> subdata = new ArrayList<String>();
            String[] token = line.split(" #SUP: ");
            String[] tokens = token[0].split(" ");
            for (int i = 0; i < tokens.length; ++i) {
                ArrayList<String> subfrequence;
                subdata.add(tokens[i]);
                if (is_firsttime) {
                    subfrequence = new ArrayList<String>();
                    subfrequence.add(tokens[i]);
                    subfrequence.add(token[1]);
                    frequence.add(subfrequence);
                    continue;
                }
                is_same = false;
                String s = tokens[i];
                for (int z = 0; z < frequence.size(); ++z) {
                    if (!frequence.get(z).get(0).equals(s)) continue;
                    int num = Integer.valueOf(frequence.get(z).get(1)) + Integer.valueOf(token[1]);
                    frequence.get(z).set(1, String.valueOf(num));
                    is_same = true;
                    break;
                }
                if (is_same) continue;
                subfrequence = new ArrayList();
                subfrequence.add(tokens[i]);
                subfrequence.add(token[1]);
                frequence.add(subfrequence);
            }
            subdata.add(token[1]);
            is_firsttime = false;
            data.add(subdata);
        }
        AlgoDFIGrowth.MemoryUsage();
        br.close();
        fl.close();
    }

    public static ArrayList<ArrayList<String>> filter(ArrayList<ArrayList<String>> freq) {
        Collections.sort(freq, new Comparator<ArrayList<String>>(){

            @Override
            public int compare(ArrayList<String> o1, ArrayList<String> o2) {
                if (Integer.parseInt(o1.get(1)) > Integer.parseInt(o2.get(1))) {
                    return -1;
                }
                if (Integer.parseInt(o1.get(1)) == Integer.parseInt(o2.get(1)) && Integer.parseInt(o1.get(0)) > Integer.parseInt(o2.get(0))) {
                    return -1;
                }
                return 1;
            }
        });
        AlgoDFIGrowth.MemoryUsage();
        return freq;
    }

    public static ArrayList<ArrayList<String>> changeDatabase(ArrayList<ArrayList<String>> predata, ArrayList<ArrayList<String>> frequent) throws IOException {
        ArrayList<ArrayList<String>> newdata = new ArrayList<ArrayList<String>>();
        for (int i = 0; i < predata.size(); ++i) {
            ArrayList<String> subnewdata = new ArrayList<String>();
            for (int j = 0; j < frequent.size(); ++j) {
                if (!predata.get(i).contains(frequent.get(j).get(0)) || predata.get(i).indexOf(frequent.get(j).get(0)) == predata.get(i).size() - 1) continue;
                subnewdata.add(frequent.get(j).get(0));
            }
            subnewdata.add(predata.get(i).get(predata.get(i).size() - 1));
            newdata.add(subnewdata);
        }
        AlgoDFIGrowth.MemoryUsage();
        return newdata;
    }

    public static ArrayList<LinkNode> createHT(ArrayList<ArrayList<String>> frequent) {
        ArrayList<LinkNode> newheaderTable = new ArrayList<LinkNode>();
        for (int i = 0; i < frequent.size(); ++i) {
            LinkNode headerNode = new LinkNode(frequent.get(i).get(0));
            newheaderTable.add(headerNode);
        }
        return newheaderTable;
    }

    public static void createFPT(ArrayList<LinkNode> newheaderTable, ArrayList<ArrayList<String>> datainfo) throws IOException {
        TreeNode root = new TreeNode();
        TreeNode Ttmp = null;
        for (int i = 0; i < datainfo.size(); ++i) {
            Ttmp = root;
            block1: for (int j = 0; j < datainfo.get(i).size() - 1; ++j) {
                change_treenode = true;
                TreeNode tnode = new TreeNode(datainfo.get(i).get(j), Integer.valueOf(datainfo.get(i).get(datainfo.get(i).size() - 1)));
                Ttmp = AlgoDFIGrowth.createTNode(Ttmp, tnode);
                if (!change_treenode) continue;
                for (int z = 0; z < newheaderTable.size(); ++z) {
                    if (!newheaderTable.get((int)z).hname.equals(Ttmp.name)) continue;
                    TreeNode tmp = Ttmp;
                    tmp.friend = newheaderTable.get((int)z).friend;
                    newheaderTable.get((int)z).friend = tmp;
                    continue block1;
                }
            }
        }
    }

    public static TreeNode createTNode(TreeNode begin, TreeNode tnode) {
        boolean is_havenode = false;
        if (begin.child.size() == 0) {
            tnode.parent = begin;
            begin.child.add(tnode);
            return tnode;
        }
        if (begin.child.size() != 0) {
            for (int i = 0; i < begin.child.size(); ++i) {
                if (!begin.child.get((int)i).name.equals(tnode.name)) continue;
                if (tnode.count > begin.child.get((int)i).count) {
                    begin.child.get((int)i).count = tnode.count;
                }
                change_treenode = false;
                is_havenode = true;
                return begin.child.get(i);
            }
            if (!is_havenode) {
                tnode.parent = begin;
                begin.child.add(tnode);
                return tnode;
            }
        }
        return null;
    }

    public static void DFIgrowthReady(ArrayList<LinkNode> linknode) throws IOException {
        data = null;
        Intdata = new ArrayList();
        boolean is_itself = true;
        boolean is_first = true;
        int repect_num = 0;
        int maxcount = 0;
        for (int i = linknode.size() - 1; i >= 0; --i) {
            maxcount = 0;
            TreeNode Hnode = linknode.get((int)i).friend;
            TreeNode Vnode = linknode.get((int)i).friend;
            ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
            while (Hnode != null) {
                if (Hnode.count > maxcount) {
                    maxcount = Hnode.count;
                }
                ArrayList<String> sublist = new ArrayList<String>();
                is_itself = true;
                is_first = true;
                repect_num = 0;
                while (Vnode.parent != null) {
                    if (is_itself) {
                        repect_num = Vnode.count;
                    }
                    if (!is_itself) {
                        if (is_first) {
                            sublist.add(Vnode.name);
                            is_first = false;
                        } else {
                            sublist.add(0, Vnode.name);
                        }
                    }
                    if (Vnode.parent == null) break;
                    Vnode = Vnode.parent;
                    is_itself = false;
                }
                if (sublist.size() != 0) {
                    sublist.add(String.valueOf(repect_num));
                    list.add(sublist);
                }
                Vnode = Hnode = Hnode.friend;
            }
            AlgoDFIGrowth.DFIgrowth(linknode.get((int)i).hname, maxcount, list);
        }
        AlgoDFIGrowth.MemoryUsage();
        endTime = System.currentTimeMillis();
    }

    public static void DFIgrowth(String strname, int hcount, ArrayList<ArrayList<String>> list) throws IOException {
        ArrayList<ArrayList<String>> frequ = new ArrayList<ArrayList<String>>();
        boolean is_firsttime = true;
        boolean is_same = false;
        if (list.size() == 0) {
            AlgoDFIGrowth.sortoutputS(strname, String.valueOf(hcount));
            return;
        }
        if (list.size() == 1) {
            ArrayList<ArrayList<String>> newlist = new ArrayList<ArrayList<String>>(list);
            newlist.get(0).remove(newlist.get(0).size() - 1);
            AlgoDFIGrowth.GenSubset(strname, hcount, newlist.get(0));
            return;
        }
        ArrayList<String> allitem = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            int countnum = Integer.parseInt(list.get(i).get(list.get(i).size() - 1));
            for (int j = 0; j < list.get(i).size() - 1; ++j) {
                ArrayList<String> subfrequ;
                if (is_firsttime) {
                    subfrequ = new ArrayList<String>();
                    subfrequ.add(list.get(i).get(j));
                    allitem.add(list.get(i).get(j));
                    subfrequ.add(String.valueOf(countnum));
                    frequ.add(subfrequ);
                    continue;
                }
                is_same = false;
                String s = list.get(i).get(j);
                for (int z = 0; z < frequ.size(); ++z) {
                    if (!frequ.get(z).get(0).equals(s)) continue;
                    int num = Integer.valueOf(frequ.get(z).get(1));
                    frequ.get(z).set(1, String.valueOf(num += countnum));
                    is_same = true;
                    break;
                }
                if (is_same) continue;
                subfrequ = new ArrayList();
                subfrequ.add(list.get(i).get(j));
                allitem.add(list.get(i).get(j));
                subfrequ.add(String.valueOf(countnum));
                frequ.add(subfrequ);
            }
            is_firsttime = false;
        }
        list = AlgoDFIGrowth.changeDatabase(list, frequ);
        ArrayList<LinkNode> newheaderTable = new ArrayList();
        newheaderTable = AlgoDFIGrowth.createHT(frequ);
        AlgoDFIGrowth.createFPT(newheaderTable, list);
        boolean is_itself = true;
        boolean is_first = true;
        int repect_num = 0;
        int maxcount = 0;
        String loopstr = "";
        for (int i = newheaderTable.size() - 1; i >= 0; --i) {
            TreeNode Hnode = newheaderTable.get((int)i).friend;
            TreeNode Vnode = newheaderTable.get((int)i).friend;
            ArrayList<ArrayList<String>> newlist = new ArrayList<ArrayList<String>>();
            while (Hnode != null) {
                if (Hnode.count > maxcount) {
                    maxcount = Hnode.count;
                }
                ArrayList<String> sublist = new ArrayList<String>();
                is_itself = true;
                is_first = true;
                repect_num = 0;
                while (Vnode.parent != null) {
                    if (is_itself) {
                        repect_num = Vnode.count;
                    }
                    if (!is_itself) {
                        if (is_first) {
                            sublist.add(Vnode.name);
                            is_first = false;
                        } else {
                            sublist.add(0, Vnode.name);
                        }
                    }
                    if (Vnode.parent == null) break;
                    Vnode = Vnode.parent;
                    is_itself = false;
                }
                if (sublist.size() != 0) {
                    sublist.add(String.valueOf(repect_num));
                    newlist.add(sublist);
                }
                Vnode = Hnode = Hnode.friend;
            }
            loopstr = strname + " " + newheaderTable.get((int)i).hname;
            AlgoDFIGrowth.DFIgrowth(loopstr, maxcount, newlist);
        }
        AlgoDFIGrowth.MemoryUsage();
        AlgoDFIGrowth.sortoutputS(strname, String.valueOf(hcount));
    }

    static void GenSubset(String name, int count, ArrayList<String> list) {
        AlgoDFIGrowth.sortoutputS(name, String.valueOf(count));
        for (int i = 0; i < list.size(); ++i) {
            String Name2 = name + " " + list.get(list.size() - 1);
            list.remove(list.size() - 1);
            --i;
            ArrayList<String> nlist = new ArrayList<String>(list);
            AlgoDFIGrowth.GenSubset(Name2, count, nlist);
        }
    }

    static void sortoutputS(String str, String num) {
        String[] token = str.split(" ");
        ArrayList<Integer> tmparr = new ArrayList<Integer>();
        ++itemsetCount;
        for (int i = 0; i < token.length; ++i) {
            tmparr.add(Integer.parseInt(token[i]));
        }
        Collections.sort(tmparr);
        AlgoDFIGrowth.MemoryUsage();
        tmparr.add(Integer.parseInt(num));
        Intdata.add(tmparr);
    }

    public void printStats() {
        System.out.println("=============  DFI-GROWTH v.2.34 - STATS =============");
        long temps = endTime - startTimestamp;
        System.out.println(" Transactions count from database : " + transactionCount);
        System.out.print(" Max memory usage: " + MaxMemory + " mb \n");
        System.out.println(" Frequent itemsets count : " + itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }

    public void writeOutPut(String output) throws IOException {
        FileWriter fw = new FileWriter(output);
        BufferedWriter bfw = new BufferedWriter(fw);
        for (int i = 0; i < Intdata.size(); ++i) {
            for (int j = 0; j < Intdata.get(i).size(); ++j) {
                if (j < Intdata.get(i).size() - 1) {
                    bfw.write(String.valueOf(Intdata.get(i).get(j) + " "));
                    continue;
                }
                bfw.write("#SUP: ");
                bfw.write(String.valueOf(Intdata.get(i).get(j)));
            }
            bfw.newLine();
        }
        bfw.flush();
        bfw.close();
        fw.close();
        Intdata = null;
    }

    static {
        change_treenode = true;
        current_memory = 0.0;
        MaxMemory = 0.0;
    }

    public static class LinkNode {
        String hname;
        TreeNode friend = null;

        public LinkNode(String n) {
            this.hname = n;
        }
    }

    public static class TreeNode {
        String name = "";
        int count = 0;
        ArrayList<TreeNode> child;
        TreeNode friend = null;
        TreeNode parent = null;

        public TreeNode() {
            this.child = new ArrayList();
        }

        public TreeNode(String n, int c) {
            this.name = n;
            this.count = c;
            this.child = new ArrayList();
        }
    }
}

