/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.DFIList;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Scanner;

public class AlgoDFIList {
    private static final String SUPCONSTANT = "#SUP: ";
    String storageAfterFCI = "SortFCI.txt";
    int itemMax = -1;
    int line = 0;
    int frequentItemsetCount = 0;
    long startTimestampSortFCI;
    long endTimeSortFCI;
    long startTimestampBuildCidList;
    long endTimeBuildCidList;
    long startTimestampDerive;
    long endTimeDerive;
    double currentMemory = 0.0;
    double maxMemory = 0.0;
    int max = 0;

    public void runAlgorithm(String input, String output) throws IOException {
        this.startTimestampSortFCI = System.currentTimeMillis();
        this.findMax(input);
        ++this.itemMax;
        String[] closedItemsets = this.readFCI(input);
        this.sortFCI(closedItemsets);
        this.endTimeSortFCI = System.currentTimeMillis();
        int[] s = this.supportCount(closedItemsets);
        closedItemsets = null;
        this.startTimestampBuildCidList = System.currentTimeMillis();
        List[] h = this.buildCIDList();
        this.endTimeBuildCidList = System.currentTimeMillis();
        Files.deleteIfExists(new File(this.storageAfterFCI).toPath());
        ArrayList newH = (ArrayList)h[1];
        h[1] = null;
        FileWriter fileWriter = new FileWriter(output);
        for (int i = 0; i < h[0].size(); ++i) {
            String z = String.valueOf(h[0].get(i));
            this.checkMemoryUsage();
            fileWriter.write("" + z + " #SUP: " + s[(Integer)((ArrayList)newH.get(i)).get(0)] + "\n");
        }
        String p = "";
        this.deriveFI(p, h[0], newH, s, fileWriter);
        fileWriter.close();
        this.endTimeDerive = System.currentTimeMillis();
    }

    private void deriveFI(String p, List<Integer> l, List<ArrayList<Integer>> h, int[] s, FileWriter fileWriter) throws IOException {
        for (int i = 0; i < h.size(); ++i) {
            this.checkMemoryUsage();
            String newP = p.equals("") ? p + l.get(i) : p + " " + l.get(i);
            ArrayList<Integer> newL = new ArrayList<Integer>();
            ArrayList<ArrayList<Integer>> newH = new ArrayList<ArrayList<Integer>>();
            for (int j = i + 1; j < h.size(); ++j) {
                String z = newP + " " + l.get(j);
                ArrayList<Integer> tempValue = AlgoDFIList.intersection(h.get(i), h.get(j));
                if (!tempValue.contains(-1)) {
                    newH.add(tempValue);
                    newL.add(l.get(j));
                    fileWriter.write("" + z + " #SUP: " + s[tempValue.get(0)] + System.lineSeparator());
                    ++this.frequentItemsetCount;
                }
                this.checkMemoryUsage();
            }
            h.remove(0);
            --i;
            l.remove(0);
            this.checkMemoryUsage();
            this.deriveFI(newP, newL, newH, s, fileWriter);
        }
    }

    void checkMemoryUsage() {
        this.currentMemory = (double)(Runtime.getRuntime().totalMemory() / 1024L) / 1024.0 - (double)(Runtime.getRuntime().freeMemory() / 1024L) / 1024.0;
        if (this.currentMemory > this.maxMemory) {
            this.maxMemory = this.currentMemory;
        }
    }

    String[] readFCI(String input) throws IOException {
        String[] closedItemset = new String[this.line];
        FileReader fr = new FileReader(input);
        BufferedReader br = new BufferedReader(fr);
        String record = "";
        int i = 0;
        while ((record = br.readLine()) != null) {
            closedItemset[i] = record;
            ++i;
        }
        br.close();
        fr.close();
        return closedItemset;
    }

    void sortFCI(String[] closedItemsets) throws IOException {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int ntemp2;
                String[] temp1 = o1.split(AlgoDFIList.SUPCONSTANT);
                String[] temp2 = o2.split(AlgoDFIList.SUPCONSTANT);
                int ntemp1 = Integer.parseInt(temp1[1]);
                if (ntemp1 < (ntemp2 = Integer.parseInt(temp2[1]))) {
                    return 1;
                }
                if (ntemp1 > ntemp2) {
                    return -1;
                }
                return 0;
            }
        };
        Arrays.sort(closedItemsets, comparator);
        FileWriter fw = null;
        fw = new FileWriter(this.storageAfterFCI);
        for (int i = 0; i < closedItemsets.length; ++i) {
            fw.write(closedItemsets[i] + System.lineSeparator());
        }
        fw.close();
    }

    int[] supportCount(String[] closedItemsets) {
        int[] s = new int[closedItemsets.length];
        for (int i = 0; i < closedItemsets.length; ++i) {
            this.checkMemoryUsage();
            s[i] = Integer.parseInt(closedItemsets[i].split(SUPCONSTANT)[1]);
        }
        return s;
    }

    List[] buildCIDList() throws FileNotFoundException {
        ArrayList<Integer> l = new ArrayList<Integer>();
        ArrayList<ArrayList<Integer>> cidList = new ArrayList<ArrayList<Integer>>();
        Scanner sc = new Scanner(new File(this.storageAfterFCI));
        int i = 0;
        while (sc.hasNextLine()) {
            String temp = sc.nextLine().split(SUPCONSTANT)[0];
            String[] splitTemp = temp.split(" ");
            for (int j = 0; j < splitTemp.length; ++j) {
                this.checkMemoryUsage();
                int index = Integer.parseInt(splitTemp[j]);
                if (l.contains(index)) {
                    cidList.get(l.indexOf(index)).add(i);
                    continue;
                }
                l.add(index);
                int size = cidList.size();
                cidList.add(new ArrayList());
                cidList.get(size).add(i);
                ++this.frequentItemsetCount;
            }
            ++i;
        }
        int[] specificSize = new int[cidList.size()];
        for (int j = 0; j < cidList.size(); ++j) {
            specificSize[j] = ((ArrayList)cidList.get(j)).size();
        }
        this.bubbleSort(specificSize, l, cidList);
        sc.close();
        return new List[]{l, cidList};
    }

    private void bubbleSort(int[] specific, ArrayList<Integer> l, ArrayList<ArrayList<Integer>> cidList) {
        for (int i = 0; i < specific.length - 1; ++i) {
            for (int j = i + 1; j < specific.length; ++j) {
                if (specific[i] <= specific[j]) continue;
                int temp = specific[j];
                ArrayList tempCidListValue = (ArrayList)cidList.get(j).clone();
                Integer tempLValue = l.get(j);
                specific[j] = specific[i];
                cidList.get(j).clear();
                cidList.get(j).addAll((Collection<Integer>)cidList.get(i));
                l.set(j, l.get(i));
                specific[i] = temp;
                cidList.get(i).clear();
                cidList.get(i).addAll((ArrayList)tempCidListValue.clone());
                l.set(i, tempLValue);
                tempCidListValue.clear();
            }
        }
    }

    static ArrayList<Integer> intersection(ArrayList<Integer> cidseq1, ArrayList<Integer> cidseq2) {
        int countSizeofCidSeq1 = 0;
        int countSizeofCidSeq2 = 0;
        ArrayList<Integer> intersectionResults = new ArrayList<Integer>();
        int count = 0;
        while (countSizeofCidSeq1 < cidseq1.size() && countSizeofCidSeq2 < cidseq2.size()) {
            if (cidseq1.get(countSizeofCidSeq1) > cidseq2.get(countSizeofCidSeq2)) {
                ++countSizeofCidSeq2;
                continue;
            }
            if (cidseq1.get(countSizeofCidSeq1) < cidseq2.get(countSizeofCidSeq2)) {
                ++countSizeofCidSeq1;
                continue;
            }
            ++count;
            intersectionResults.add(cidseq1.get(countSizeofCidSeq1));
            ++countSizeofCidSeq1;
            ++countSizeofCidSeq2;
        }
        if (count != 0) {
            return intersectionResults;
        }
        intersectionResults.add(-1);
        return intersectionResults;
    }

    void findMax(String input) throws IOException {
        FileReader fr = new FileReader(input);
        BufferedReader br = new BufferedReader(fr);
        String record = "";
        while ((record = br.readLine()) != null) {
            String[] temp = record.split(SUPCONSTANT)[0].split(" ");
            for (int i = 0; i < temp.length; ++i) {
                this.checkMemoryUsage();
                int t = Integer.parseInt(temp[i]);
                if (t <= this.itemMax) continue;
                this.itemMax = t;
            }
            ++this.line;
        }
        br.close();
        fr.close();
    }

    public void printStats() {
        long sortFCI = this.endTimeSortFCI - this.startTimestampSortFCI;
        long buildCidList = this.endTimeBuildCidList - this.startTimestampBuildCidList;
        long deriving = this.endTimeDerive - this.endTimeBuildCidList;
        long totaltime = this.endTimeDerive - this.startTimestampSortFCI;
        System.out.println("===================  DFI - STATS ==================");
        System.out.println(" Frequent itemsets count : " + this.frequentItemsetCount);
        System.out.println(" Max memory usage: " + this.maxMemory + " MB");
        System.out.println(" SortFCI time ~ " + sortFCI + " ms");
        System.out.println(" BuildCidList time ~ " + buildCidList + " ms");
        System.out.println(" Deriving time ~ " + deriving + " ms");
        System.out.println(" Total time ~ " + totaltime + " ms");
        System.out.println("===================================================");
    }
}

