/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.HUIM_BPSO_tree;

import ca.pfv.spmf.algorithms.frequentpatterns.HUIM_BPSO_tree.treeNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHUIM_BPSO_tree {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    final int pop_size = 20;
    final int iterations = 2000;
    final int c1 = 2;
    final int c2 = 2;
    final double w = 0.9;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToTWU0;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    Particle gBest = new Particle();
    List<Particle> pBest = new ArrayList<Particle>();
    List<Particle> population = new ArrayList<Particle>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<List<Double>> V = new ArrayList<List<Double>>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<List<Integer>> maximalPatterns = new ArrayList<List<Integer>>();
    treeNode orNorTree;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        int i;
        String[] items;
        String[] split;
        String thisLine;
        this.maxMemory = 0.0;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        this.mapItemToTWU0 = new HashMap<Integer, Integer>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i2 = 0; i2 < items.length; ++i2) {
                    Integer item = Integer.parseInt(items[i2]);
                    Integer twu = this.mapItemToTWU.get(item);
                    Integer twu0 = this.mapItemToTWU0.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    twu0 = twu0 == null ? transactionUtility : twu0 + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                    this.mapItemToTWU0.put(item, twu0);
                }
            }
        }
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                ArrayList<Integer> pattern = new ArrayList<Integer>();
                for (int i3 = 0; i3 < items.length; ++i3) {
                    Pair pair = new Pair();
                    pair.item = Integer.parseInt(items[i3]);
                    pair.utility = Integer.parseInt(utilityValues[i3]);
                    if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                        revisedTransaction.add(pair);
                        pattern.add(pair.item);
                        continue;
                    }
                    this.mapItemToTWU0.remove(pair.item);
                }
                this.database.add(revisedTransaction);
                this.maximalJudge(pattern);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU0.keySet());
        Collections.sort(this.twuPattern);
        for (i = 0; i < 20; ++i) {
            this.pBest.add(new Particle(this.twuPattern.size()));
        }
        this.gBest = new Particle(this.twuPattern.size());
        this.checkMemory();
        if (this.twuPattern.size() > 0) {
            this.orNorTree = this.initialTree(this.twuPattern);
            this.generatePop(minUtility);
            for (i = 0; i < 2000; ++i) {
                this.update(minUtility);
            }
        }
        this.writeOut();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void maximalJudge(List<Integer> pattern) {
        if (this.maximalPatterns.size() == 0) {
            this.maximalPatterns.add(pattern);
        } else {
            int i;
            for (i = 0; i < this.maximalPatterns.size(); ++i) {
                List<Integer> tempPattern = this.maximalPatterns.get(i);
                int j = 0;
                int k = 0;
                int temp = 0;
                while (j < pattern.size() && k < tempPattern.size()) {
                    if (pattern.get(j) < tempPattern.get(k)) {
                        ++j;
                        continue;
                    }
                    if (pattern.get(j) > tempPattern.get(k)) {
                        ++k;
                        continue;
                    }
                    ++j;
                    ++k;
                    ++temp;
                }
                if (temp != pattern.size() && temp != tempPattern.size()) continue;
                if (pattern.size() <= tempPattern.size()) break;
                this.maximalPatterns.remove(i);
                this.maximalPatterns.add(pattern);
                break;
            }
            if (i == this.maximalPatterns.size()) {
                this.maximalPatterns.add(pattern);
            }
        }
    }

    private treeNode initialTree(List<Integer> htwuiList) {
        treeNode root = new treeNode(htwuiList.get(0));
        for (int i = 0; i < this.maximalPatterns.size(); ++i) {
            treeNode currentNode = root;
            List<Integer> tempPattern = this.maximalPatterns.get(i);
            int j = 0;
            int k = 0;
            while (k < htwuiList.size()) {
                treeNode leafNode;
                if (j < tempPattern.size()) {
                    if (tempPattern.get(j) > htwuiList.get(k)) {
                        if (currentNode.NOR == null) {
                            leafNode = k + 1 < htwuiList.size() ? new treeNode(htwuiList.get(k + 1)) : new treeNode(-1);
                            currentNode.NOR = leafNode;
                        }
                        ++k;
                        currentNode = currentNode.NOR;
                        continue;
                    }
                    if (currentNode.OR == null) {
                        leafNode = k + 1 < htwuiList.size() ? new treeNode(htwuiList.get(k + 1)) : new treeNode(-1);
                        currentNode.OR = leafNode;
                    }
                    ++k;
                    ++j;
                    currentNode = currentNode.OR;
                    continue;
                }
                if (currentNode.NOR == null) {
                    leafNode = k + 1 < htwuiList.size() ? new treeNode(htwuiList.get(k + 1)) : new treeNode(-1);
                    currentNode.NOR = leafNode;
                }
                currentNode = currentNode.NOR;
                ++k;
            }
        }
        return root;
    }

    private void generatePop(int minUtility) {
        for (int i = 0; i < 20; ++i) {
            int j;
            Particle tempParticle = new Particle(this.twuPattern.size());
            tempParticle = this.particleInitial(tempParticle);
            int k = 0;
            for (j = 0; j < this.twuPattern.size(); ++j) {
                if (tempParticle.X.get(j) != 1) continue;
                ++k;
            }
            tempParticle.fitness = this.fitCalculate(tempParticle.X, k);
            this.population.add(i, tempParticle);
            this.pBest.get(i).copyParticle(tempParticle);
            if (this.population.get((int)i).fitness >= minUtility) {
                this.insert(this.population.get(i));
            }
            if (i == 0) {
                this.gBest.copyParticle(this.pBest.get(i));
            } else if (this.pBest.get((int)i).fitness > this.gBest.fitness) {
                this.gBest.copyParticle(this.pBest.get(i));
            }
            ArrayList<Double> tempV = new ArrayList<Double>();
            for (j = 0; j < this.twuPattern.size(); ++j) {
                tempV.add(j, Math.random());
            }
            this.V.add(i, tempV);
        }
    }

    private void update(int minUtility) {
        for (int i = 0; i < 20; ++i) {
            int j;
            int k = 0;
            double r1 = Math.random();
            double r2 = Math.random();
            for (j = 0; j < this.twuPattern.size(); ++j) {
                double temp = this.V.get(i).get(j) + r1 * (double)(this.pBest.get((int)i).X.get(j) - this.population.get((int)i).X.get(j)) + r2 * (double)(this.gBest.X.get(j) - this.population.get((int)i).X.get(j));
                this.V.get(i).set(j, temp);
                if (this.V.get(i).get(j) < -2.0) {
                    this.V.get(i).set(j, -2.0);
                    continue;
                }
                if (!(this.V.get(i).get(j) > 2.0)) continue;
                this.V.get(i).set(j, 2.0);
            }
            this.population.set(i, this.particleUpdate(this.population.get(i), i));
            for (j = 0; j < this.twuPattern.size(); ++j) {
                if (this.population.get((int)i).X.get(j) != 1) continue;
                ++k;
            }
            this.population.get((int)i).fitness = this.fitCalculate(this.population.get((int)i).X, k);
            if (this.population.get((int)i).fitness > this.pBest.get((int)i).fitness) {
                this.pBest.get(i).copyParticle(this.population.get(i));
                if (this.pBest.get((int)i).fitness > this.gBest.fitness) {
                    this.gBest.copyParticle(this.pBest.get(i));
                }
            }
            if (this.population.get((int)i).fitness < minUtility) continue;
            this.insert(this.population.get(i));
        }
    }

    private Particle particleInitial(Particle tempNode) {
        treeNode currentNode = this.orNorTree;
        for (int i = 0; i < this.twuPattern.size(); ++i) {
            boolean temp;
            boolean temp1;
            if (currentNode.OR == null) {
                tempNode.X.set(i, 0);
                currentNode = currentNode.NOR;
                continue;
            }
            if (currentNode.NOR == null) {
                boolean bl = temp1 = Math.random() > 0.5;
                if (temp1) {
                    tempNode.X.set(i, 1);
                    currentNode = currentNode.OR;
                    continue;
                }
                tempNode.X.set(i, 0);
                currentNode = currentNode.OR;
                continue;
            }
            boolean bl = temp = Math.random() > 0.5;
            if (temp) {
                boolean bl2 = temp1 = Math.random() > 0.5;
                if (temp1) {
                    tempNode.X.set(i, 1);
                    currentNode = currentNode.OR;
                    continue;
                }
                tempNode.X.set(i, 0);
                currentNode = currentNode.OR;
                continue;
            }
            tempNode.X.set(i, 0);
            currentNode = currentNode.NOR;
        }
        return tempNode;
    }

    private Particle particleUpdate(Particle tempParticle, int i) {
        treeNode currentParticle = this.orNorTree;
        for (int j = 0; j < this.twuPattern.size(); ++j) {
            boolean temp;
            double temp2;
            double temp1;
            if (currentParticle.OR == null) {
                tempParticle.X.set(j, 0);
                currentParticle = currentParticle.NOR;
                continue;
            }
            if (currentParticle.NOR == null) {
                temp1 = Math.random();
                if (temp1 < (temp2 = 1.0 / (1.0 + Math.exp(-this.V.get(i).get(j).doubleValue())))) {
                    tempParticle.X.set(j, 1);
                    currentParticle = currentParticle.OR;
                    continue;
                }
                tempParticle.X.set(j, 0);
                currentParticle = currentParticle.OR;
                continue;
            }
            boolean bl = temp = Math.random() > 0.5;
            if (temp) {
                temp1 = Math.random();
                if (temp1 < (temp2 = 1.0 / (1.0 + Math.exp(-this.V.get(i).get(j).doubleValue())))) {
                    tempParticle.X.set(j, 1);
                    currentParticle = currentParticle.OR;
                    continue;
                }
                tempParticle.X.set(j, 0);
                currentParticle = currentParticle.OR;
                continue;
            }
            tempParticle.X.set(j, 0);
            currentParticle = currentParticle.NOR;
        }
        return tempParticle;
    }

    private void insert(Particle tempParticle) {
        int i;
        StringBuilder temp = new StringBuilder();
        for (i = 0; i < this.twuPattern.size(); ++i) {
            if (tempParticle.X.get(i) != 1) continue;
            temp.append(this.twuPattern.get(i));
            temp.append(' ');
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
        } else {
            for (i = 0; i < this.huiSets.size() && !temp.toString().equals(this.huiSets.get((int)i).itemset); ++i) {
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
            }
        }
    }

    private int fitCalculate(List<Integer> tempParticle, int k) {
        if (k == 0) {
            return 0;
        }
        int fitness = 0;
        for (int p = 0; p < this.database.size(); ++p) {
            int i = 0;
            int j = 0;
            int q = 0;
            int temp = 0;
            int sum = 0;
            while (j < k && q < this.database.get(p).size() && i < tempParticle.size()) {
                if (tempParticle.get(i) == 1) {
                    if (this.database.get((int)p).get((int)q).item < this.twuPattern.get(i)) {
                        ++q;
                        continue;
                    }
                    if (this.database.get((int)p).get((int)q).item == this.twuPattern.get(i)) {
                        sum += this.database.get((int)p).get((int)q).utility;
                        ++j;
                        ++q;
                        ++temp;
                        ++i;
                        continue;
                    }
                    if (this.database.get((int)p).get((int)q).item <= this.twuPattern.get(i)) continue;
                    ++j;
                    ++i;
                    continue;
                }
                ++i;
            }
            if (temp != k) continue;
            fitness += sum;
        }
        return fitness;
    }

    private void writeOut() throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.huiSets.size(); ++i) {
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL: ");
            buffer.append(this.huiSets.get((int)i).fitness);
            buffer.append(System.lineSeparator());
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HUIM-BPSO-tree ALGORITHM v.2.11 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("===================================================");
    }

    class Particle {
        List<Integer> X = new ArrayList<Integer>();
        int fitness;

        public Particle() {
        }

        public Particle(int length) {
            for (int i = 0; i < length; ++i) {
                this.X.add(i, 0);
            }
        }

        public void copyParticle(Particle particle1) {
            for (int i = 0; i < particle1.X.size(); ++i) {
                this.X.set(i, (int)particle1.X.get(i));
            }
            this.fitness = particle1.fitness;
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }

    class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }
}

