/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.HUIM_GA_tree;

import ca.pfv.spmf.algorithms.frequentpatterns.HUIM_GA_tree.treeNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHUIM_GA_tree {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    final int pop_size = 20;
    final int iterations = 2000;
    Map<Integer, Integer> mapItemToTWU;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    List<ChroNode> population = new ArrayList<ChroNode>();
    List<ChroNode> subPopulation = new ArrayList<ChroNode>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<List<Integer>> maximalPatterns = new ArrayList<List<Integer>>();
    List<Double> percentage = new ArrayList<Double>();
    treeNode orNorTree;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        String[] items;
        String[] split;
        String thisLine;
        this.maxMemory = 0.0;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                }
            }
        }
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                ArrayList<Integer> pattern = new ArrayList<Integer>();
                for (int i = 0; i < items.length; ++i) {
                    Pair pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (this.mapItemToTWU.get(pair.item) < minUtility) continue;
                    revisedTransaction.add(pair);
                    pattern.add(pair.item);
                }
                this.database.add(revisedTransaction);
                this.maximalJudge(pattern);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU.keySet());
        Collections.sort(this.twuPattern);
        for (int i = 0; i < this.twuPattern.size(); ++i) {
            if (this.mapItemToTWU.get(this.twuPattern.get(i)) >= minUtility) continue;
            this.twuPattern.remove(i);
            --i;
        }
        this.checkMemory();
        if (this.twuPattern.size() > 0) {
            double pMax;
            double pMin;
            int m = this.database.size();
            int n = this.twuPattern.size();
            int temp1 = 0;
            int temp2 = 0;
            this.orNorTree = this.initialTree(this.twuPattern);
            this.generatePop(minUtility);
            if (m > n) {
                pMin = 1.0 / ((double)m + 0.0);
                pMax = 1.0 / ((double)n + 0.0);
            } else {
                pMin = 1.0 / ((double)n + 0.0);
                pMax = 1.0 / ((double)m + 0.0);
            }
            for (int i = 0; i < 2000; ++i) {
                this.calculateRfitness();
                while (this.subPopulation.size() < 20) {
                    temp1 = this.selectChromosome();
                    temp2 = this.selectChromosome();
                    while (temp1 == temp2) {
                        temp2 = this.selectChromosome();
                    }
                    this.crossover(temp1, temp2, minUtility);
                }
                this.subPopulation = this.rankedMutation(pMax, pMin, i, minUtility);
                this.subPopulation.addAll(this.population);
                this.rankData(this.subPopulation);
                for (int j = 0; j < this.population.size(); ++j) {
                    this.population.set(j, this.subPopulation.get(j));
                }
                this.subPopulation.clear();
            }
        }
        this.writeOut();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void maximalJudge(List<Integer> pattern) {
        if (this.maximalPatterns.size() == 0) {
            this.maximalPatterns.add(pattern);
        } else {
            int i;
            for (i = 0; i < this.maximalPatterns.size(); ++i) {
                List<Integer> tempPattern = this.maximalPatterns.get(i);
                int j = 0;
                int k = 0;
                int temp = 0;
                while (j < pattern.size() && k < tempPattern.size()) {
                    if (pattern.get(j) < tempPattern.get(k)) {
                        ++j;
                        continue;
                    }
                    if (pattern.get(j) > tempPattern.get(k)) {
                        ++k;
                        continue;
                    }
                    ++j;
                    ++k;
                    ++temp;
                }
                if (temp != pattern.size() && temp != tempPattern.size()) continue;
                if (pattern.size() <= tempPattern.size()) break;
                this.maximalPatterns.remove(i);
                this.maximalPatterns.add(pattern);
                break;
            }
            if (i == this.maximalPatterns.size()) {
                this.maximalPatterns.add(pattern);
            }
        }
    }

    private treeNode initialTree(List<Integer> htwuiList) {
        treeNode root = new treeNode(htwuiList.get(0));
        for (int i = 0; i < this.maximalPatterns.size(); ++i) {
            treeNode currentNode = root;
            List<Integer> tempPattern = this.maximalPatterns.get(i);
            int j = 0;
            int k = 0;
            while (k < htwuiList.size()) {
                treeNode leafNode;
                if (j < tempPattern.size()) {
                    if (tempPattern.get(j) > htwuiList.get(k)) {
                        if (currentNode.NOR == null) {
                            leafNode = k + 1 < htwuiList.size() ? new treeNode(htwuiList.get(k + 1)) : new treeNode(-1);
                            currentNode.NOR = leafNode;
                        }
                        ++k;
                        currentNode = currentNode.NOR;
                        continue;
                    }
                    if (currentNode.OR == null) {
                        leafNode = k + 1 < htwuiList.size() ? new treeNode(htwuiList.get(k + 1)) : new treeNode(-1);
                        currentNode.OR = leafNode;
                    }
                    ++k;
                    ++j;
                    currentNode = currentNode.OR;
                    continue;
                }
                if (currentNode.NOR == null) {
                    leafNode = k + 1 < htwuiList.size() ? new treeNode(htwuiList.get(k + 1)) : new treeNode(-1);
                    currentNode.NOR = leafNode;
                }
                currentNode = currentNode.NOR;
                ++k;
            }
        }
        return root;
    }

    private void generatePop(int minUtility) {
        for (int i = 0; i < 20; ++i) {
            ChroNode tempNode = new ChroNode(this.twuPattern.size());
            tempNode = this.chromosomeInitial(tempNode);
            int k = 0;
            for (int j = 0; j < this.twuPattern.size(); ++j) {
                if (tempNode.chromosome.get(j) != 1) continue;
                ++k;
            }
            tempNode.fitness = this.fitCalculate(tempNode.chromosome, k);
            tempNode.rank = 0;
            this.population.add(tempNode);
            if (tempNode.fitness < minUtility) continue;
            this.insert(tempNode);
        }
    }

    private void crossover(int temp1, int temp2, int minUtility) {
        int i = 0;
        int tempA = 0;
        int tempB = 0;
        ArrayList<Integer> temp1Chro = new ArrayList<Integer>();
        ArrayList<Integer> temp2Chro = new ArrayList<Integer>();
        ChroNode tempNode = new ChroNode();
        int position = (int)(Math.random() * (double)this.twuPattern.size());
        for (i = 0; i < this.twuPattern.size(); ++i) {
            if (i <= position) {
                temp1Chro.add(this.population.get((int)temp2).chromosome.get(i));
                if ((Integer)temp1Chro.get(i) == 1) {
                    ++tempA;
                }
                temp2Chro.add(this.population.get((int)temp1).chromosome.get(i));
                if ((Integer)temp2Chro.get(i) != 1) continue;
                ++tempB;
                continue;
            }
            temp1Chro.add(this.population.get((int)temp1).chromosome.get(i));
            if ((Integer)temp1Chro.get(i) == 1) {
                ++tempA;
            }
            temp2Chro.add(this.population.get((int)temp2).chromosome.get(i));
            if ((Integer)temp2Chro.get(i) != 1) continue;
            ++tempB;
        }
        tempNode.chromosome = temp1Chro;
        tempNode.fitness = this.fitCalculate(temp1Chro, tempA);
        tempNode.rank = 0;
        this.subPopulation.add(tempNode);
        if (tempNode.fitness >= minUtility) {
            this.insert(tempNode);
        }
        tempNode.chromosome = temp2Chro;
        tempNode.fitness = this.fitCalculate(temp2Chro, tempB);
        tempNode.rank = 0;
        this.subPopulation.add(tempNode);
        if (tempNode.fitness >= minUtility) {
            this.insert(tempNode);
        }
    }

    private void rankData(List<ChroNode> tempPop) {
        int i;
        for (i = 0; i < tempPop.size() - 1; ++i) {
            int p = i;
            for (int j = i + 1; j < tempPop.size(); ++j) {
                if (tempPop.get((int)p).fitness >= tempPop.get((int)j).fitness) continue;
                p = j;
            }
            if (i != p) {
                int temp = tempPop.get((int)i).fitness;
                tempPop.get((int)i).fitness = tempPop.get((int)p).fitness;
                tempPop.get((int)p).fitness = temp;
                for (int q = 0; q < this.twuPattern.size(); ++q) {
                    temp = tempPop.get((int)i).chromosome.get(q);
                    tempPop.get((int)i).chromosome.set(q, tempPop.get((int)p).chromosome.get(q));
                    tempPop.get((int)p).chromosome.set(q, temp);
                }
            }
            tempPop.get((int)i).rank = i + 1;
        }
        tempPop.get((int)i).rank = i + 1;
    }

    private List<Integer> getRank() {
        ArrayList<Integer> rank = new ArrayList<Integer>();
        for (int i = 0; i < this.subPopulation.size(); ++i) {
            int temp = 0;
            for (int j = 0; j < this.subPopulation.size(); ++j) {
                if (i == j || this.subPopulation.get((int)i).fitness > this.subPopulation.get((int)j).fitness) continue;
                ++temp;
            }
            rank.add(temp + 1);
        }
        return rank;
    }

    private List<ChroNode> rankedMutation(double pMax, double pMin, int currentIteration, int minUtility) {
        List<Integer> record = this.getRank();
        for (int i = 0; i < 20; ++i) {
            double pm = (pMax - (pMax - pMin) * (double)currentIteration / 2000.0) * (double)record.get(i).intValue() / (double)this.subPopulation.size();
            double rankNum = Math.random();
            if (!(rankNum < pm)) continue;
            int temp = (int)(Math.random() * (double)this.twuPattern.size());
            if (this.subPopulation.get((int)i).chromosome.get(temp) == 1) {
                this.subPopulation.get((int)i).chromosome.set(temp, 0);
            } else {
                this.subPopulation.get((int)i).chromosome.set(temp, 1);
            }
            int k = 0;
            for (int j = 0; j < this.twuPattern.size(); ++j) {
                if (this.subPopulation.get((int)i).chromosome.get(j) != 1) continue;
                ++k;
            }
            this.subPopulation.get((int)i).fitness = this.fitCalculate(this.subPopulation.get((int)i).chromosome, k);
            if (this.subPopulation.get((int)i).fitness < minUtility) continue;
            this.insert(this.subPopulation.get(i));
        }
        return this.subPopulation;
    }

    private ChroNode chromosomeInitial(ChroNode tempNode) {
        treeNode currentNode = this.orNorTree;
        for (int i = 0; i < this.twuPattern.size(); ++i) {
            boolean temp;
            boolean temp1;
            if (currentNode.OR == null) {
                tempNode.chromosome.set(i, 0);
                currentNode = currentNode.NOR;
                continue;
            }
            if (currentNode.NOR == null) {
                boolean bl = temp1 = Math.random() > 0.5;
                if (temp1) {
                    tempNode.chromosome.set(i, 1);
                    currentNode = currentNode.OR;
                    continue;
                }
                tempNode.chromosome.set(i, 0);
                currentNode = currentNode.OR;
                continue;
            }
            boolean bl = temp = Math.random() > 0.5;
            if (temp) {
                boolean bl2 = temp1 = Math.random() > 0.5;
                if (temp1) {
                    tempNode.chromosome.set(i, 1);
                    currentNode = currentNode.OR;
                    continue;
                }
                tempNode.chromosome.set(i, 0);
                currentNode = currentNode.OR;
                continue;
            }
            tempNode.chromosome.set(i, 0);
            currentNode = currentNode.NOR;
        }
        return tempNode;
    }

    private void insert(ChroNode tempChroNode) {
        int i;
        StringBuilder temp = new StringBuilder();
        for (i = 0; i < this.twuPattern.size(); ++i) {
            if (tempChroNode.chromosome.get(i) != 1) continue;
            temp.append(this.twuPattern.get(i));
            temp.append(' ');
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempChroNode.fitness));
        } else {
            for (i = 0; i < this.huiSets.size() && !temp.toString().equals(this.huiSets.get((int)i).itemset); ++i) {
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempChroNode.fitness));
            }
        }
    }

    private int fitCalculate(List<Integer> tempChroNode, int k) {
        if (k == 0) {
            return 0;
        }
        int fitness = 0;
        for (int p = 0; p < this.database.size(); ++p) {
            int i = 0;
            int j = 0;
            int q = 0;
            int temp = 0;
            int sum = 0;
            while (j < k && q < this.database.get(p).size() && i < tempChroNode.size()) {
                if (tempChroNode.get(i) == 1) {
                    if (this.database.get((int)p).get((int)q).item < this.twuPattern.get(i)) {
                        ++q;
                        continue;
                    }
                    if (this.database.get((int)p).get((int)q).item == this.twuPattern.get(i)) {
                        sum += this.database.get((int)p).get((int)q).utility;
                        ++j;
                        ++q;
                        ++temp;
                        ++i;
                        continue;
                    }
                    if (this.database.get((int)p).get((int)q).item <= this.twuPattern.get(i)) continue;
                    ++j;
                    ++i;
                    continue;
                }
                ++i;
            }
            if (temp != k) continue;
            fitness += sum;
        }
        return fitness;
    }

    public void calculateRfitness() {
        int i;
        int sum = 0;
        int temp = 0;
        for (i = 0; i < this.population.size(); ++i) {
            sum += this.population.get((int)i).fitness;
        }
        for (i = 0; i < this.population.size(); ++i) {
            this.population.get((int)i).rfitness = (double)(temp += this.population.get((int)i).fitness) / ((double)sum + 0.0);
        }
    }

    private int selectChromosome() {
        int temp = 0;
        double randNum = Math.random();
        for (int i = 0; i < this.population.size(); ++i) {
            if (i == 0) {
                if (!(randNum >= 0.0) || !(randNum <= this.population.get((int)0).rfitness)) continue;
                temp = 0;
                break;
            }
            if (!(randNum > this.population.get((int)(i - 1)).rfitness) || !(randNum <= this.population.get((int)i).rfitness)) continue;
            temp = i;
            break;
        }
        return temp;
    }

    private void writeOut() throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.huiSets.size(); ++i) {
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL: ");
            buffer.append(this.huiSets.get((int)i).fitness);
            buffer.append(System.lineSeparator());
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HUIM-GA-tree ALGORITHM v.2.11 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }

    class ChroNode {
        List<Integer> chromosome = new ArrayList<Integer>();
        int fitness;
        double rfitness;
        int rank;

        public ChroNode() {
        }

        public ChroNode(int length) {
            for (int i = 0; i < length; ++i) {
                this.chromosome.add(i, 0);
            }
        }

        public void deepCopy(ChroNode chroNode1) {
            for (int i = 0; i < chroNode1.chromosome.size(); ++i) {
                this.chromosome.set(i, (int)chroNode1.chromosome.get(i));
            }
            this.fitness = chroNode1.fitness;
        }
    }

    class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }
}

