/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.MRCPPS;

import ca.pfv.spmf.algorithms.frequentpatterns.MRCPPS.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.MRCPPS.Itemsets;
import ca.pfv.spmf.algorithms.frequentpatterns.MRCPPS.RCPPSlist;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoMRCPPS {
    protected long startTimestamp;
    protected long endTime;
    protected Itemsets patterns;
    BufferedWriter writer = null;
    protected int itemsetCount;
    final int BUFFERS_SIZE = 40000;
    private int[] itemsetBuffer = null;
    int maxItemsetSize = Integer.MAX_VALUE;
    private List<Integer> lenOfseqList;
    private int sizeOfseq;
    private int maxSup;
    private double maxStd;
    private double minBond;
    private double minRa;
    private boolean useLemma2;
    private boolean showDetails = true;
    private int groupNum;
    private boolean needGroup;

    public Itemsets runAlgorithm(String input, String output, int maxSup, double maxStd, double minBond, double minRa, boolean useLemma2, boolean needGroup, int groupNum) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        MemoryLogger.getInstance().reset();
        this.maxSup = maxSup;
        this.maxStd = maxStd;
        this.minBond = minBond;
        this.minRa = minRa;
        this.needGroup = needGroup;
        this.groupNum = groupNum;
        this.useLemma2 = useLemma2;
        this.lenOfseqList = new ArrayList<Integer>();
        this.sizeOfseq = 0;
        this.itemsetBuffer = new int[40000];
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("Correlated Rare Periodic Pattern in multiple Sequences");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        final Map<Integer, RCPPSlist> mapRCPPSlist = this.scanDatabaseToDeterminRCPPSlistOfSingleItems(input);
        ArrayList<Integer> candidates = new ArrayList<Integer>(mapRCPPSlist.keySet());
        Collections.sort(candidates, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return ((RCPPSlist)mapRCPPSlist.get(arg0)).getNumCand() - ((RCPPSlist)mapRCPPSlist.get(arg1)).getNumCand();
            }
        });
        if (this.maxItemsetSize >= 2) {
            for (int i = 0; i < candidates.size(); ++i) {
                int itemI = (Integer)candidates.get(i);
                RCPPSlist rcppsListI = mapRCPPSlist.get(itemI);
                ArrayList<Integer> equivalenceClassIitems = new ArrayList<Integer>();
                ArrayList<RCPPSlist> equivalenceClassIRCPPSlist = new ArrayList<RCPPSlist>();
                for (int j = i + 1; j < candidates.size(); ++j) {
                    int itemJ = (Integer)candidates.get(j);
                    RCPPSlist rcppsListJ = mapRCPPSlist.get(itemJ);
                    RCPPSlist rcppsListIJ = rcppsListI.genRCPPSlistOfCandidate(rcppsListJ, this.minBond);
                    double boundRa = (double)rcppsListIJ.getNumCand() / (double)this.sizeOfseq;
                    if (boundRa == 0.0 || !(boundRa >= minRa)) continue;
                    equivalenceClassIitems.add(itemJ);
                    equivalenceClassIRCPPSlist.add(rcppsListIJ);
                }
                if (equivalenceClassIitems.size() <= 0) continue;
                this.itemsetBuffer[0] = itemI;
                this.processEquivalenceClass(this.itemsetBuffer, 1, equivalenceClassIitems, equivalenceClassIRCPPSlist);
            }
        }
        MemoryLogger.getInstance().checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        return this.patterns;
    }

    private void processEquivalenceClass(int[] prefix, int prefixLength, List<Integer> equivalenceClassItems, List<RCPPSlist> equivalenceClassIRCPPSlist) throws IOException {
        if (equivalenceClassItems.size() == 1) {
            int itemI = equivalenceClassItems.get(0);
            RCPPSlist rcppsListI = equivalenceClassIRCPPSlist.get(0);
            double ra = (double)rcppsListI.getNumSeq(this.maxSup, this.maxStd, this.lenOfseqList, this.useLemma2) / (double)this.sizeOfseq;
            if (ra != 0.0 && ra >= this.minRa) {
                this.save(prefix, prefixLength, itemI, ra, rcppsListI);
            }
            return;
        }
        if (equivalenceClassItems.size() == 2) {
            RCPPSlist rcppsListIJ;
            double raIJ;
            int itemI = equivalenceClassItems.get(0);
            RCPPSlist rcppsListI = equivalenceClassIRCPPSlist.get(0);
            double raI = (double)rcppsListI.getNumSeq(this.maxSup, this.maxStd, this.lenOfseqList, this.useLemma2) / (double)this.sizeOfseq;
            int itemJ = equivalenceClassItems.get(1);
            RCPPSlist rcppsListJ = equivalenceClassIRCPPSlist.get(1);
            double raJ = (double)rcppsListJ.getNumSeq(this.maxSup, this.maxStd, this.lenOfseqList, this.useLemma2) / (double)this.sizeOfseq;
            if (raI != 0.0 && raI >= this.minRa) {
                this.save(prefix, prefixLength, itemI, raI, rcppsListI);
            }
            if (raJ != 0.0 && raJ >= this.minRa) {
                this.save(prefix, prefixLength, itemJ, raJ, rcppsListJ);
            }
            if (prefixLength + 2 <= this.maxItemsetSize && (raIJ = (double)(rcppsListIJ = rcppsListI.genRCPPSlistOfCandidate(rcppsListJ, this.minBond)).getNumSeq(this.maxSup, this.maxStd, this.lenOfseqList, this.useLemma2) / (double)this.sizeOfseq) != 0.0 && raIJ >= this.minRa) {
                int newPrefixLength = prefixLength + 1;
                prefix[prefixLength] = itemI;
                this.save(prefix, newPrefixLength, itemJ, raIJ, rcppsListIJ);
            }
            MemoryLogger.getInstance().checkMemory();
            return;
        }
        for (int i = 0; i < equivalenceClassItems.size(); ++i) {
            int suffixI = equivalenceClassItems.get(i);
            RCPPSlist rcppsListI = equivalenceClassIRCPPSlist.get(i);
            double raI = (double)rcppsListI.getNumSeq(this.maxSup, this.maxStd, this.lenOfseqList, this.useLemma2) / (double)this.sizeOfseq;
            if (raI != 0.0 && raI >= this.minRa) {
                this.save(prefix, prefixLength, suffixI, raI, rcppsListI);
            }
            if (prefixLength + 2 > this.maxItemsetSize) continue;
            ArrayList<Integer> equivalenceClassISuffixItems = new ArrayList<Integer>();
            ArrayList<RCPPSlist> equivalenceClassISuffixRCPPSlist = new ArrayList<RCPPSlist>();
            for (int j = i + 1; j < equivalenceClassItems.size(); ++j) {
                int suffixJ = equivalenceClassItems.get(j);
                RCPPSlist rcppsListJ = equivalenceClassIRCPPSlist.get(j);
                RCPPSlist rcppsListIJ = rcppsListI.genRCPPSlistOfCandidate(rcppsListJ, this.minBond);
                double boundRa = (double)rcppsListIJ.getNumCand() / (double)this.sizeOfseq;
                if (boundRa == 0.0 || !(boundRa >= this.minRa)) continue;
                equivalenceClassISuffixItems.add(suffixJ);
                equivalenceClassISuffixRCPPSlist.add(rcppsListIJ);
            }
            if (equivalenceClassISuffixItems.size() <= 0) continue;
            prefix[prefixLength] = suffixI;
            int newPrefixLength = prefixLength + 1;
            this.processEquivalenceClass(prefix, newPrefixLength, equivalenceClassISuffixItems, equivalenceClassISuffixRCPPSlist);
        }
    }

    private Map<Integer, RCPPSlist> scanDatabaseToDeterminRCPPSlistOfSingleItems(String input) throws IOException {
        String line;
        HashMap<Integer, RCPPSlist> mapRCPPSlist = new HashMap<Integer, RCPPSlist>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        int sid = 0;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int tid = 1;
            int groupCount = 0;
            for (String token : lineSplited) {
                Integer item = Integer.parseInt(token);
                if (item > 0) {
                    RCPPSlist itemRCPPSlist = (RCPPSlist)mapRCPPSlist.get(item);
                    if (itemRCPPSlist == null) {
                        itemRCPPSlist = new RCPPSlist();
                        mapRCPPSlist.put(item, itemRCPPSlist);
                    }
                    itemRCPPSlist.addSID(sid);
                    itemRCPPSlist.addTID(tid);
                    continue;
                }
                if (item != -1) continue;
                if (this.needGroup) {
                    if (++groupCount != this.groupNum) continue;
                    groupCount = 0;
                    ++tid;
                    continue;
                }
                ++tid;
            }
            if (groupCount > 0) {
                this.lenOfseqList.add(tid);
            } else {
                this.lenOfseqList.add(tid - 1);
            }
            ++sid;
        }
        this.sizeOfseq = sid;
        reader.close();
        Iterator it = mapRCPPSlist.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Integer item = (Integer)entry.getKey();
            RCPPSlist itemRCPPSlist = (RCPPSlist)entry.getValue();
            double boundRa = (double)itemRCPPSlist.getNumCand() / (double)this.sizeOfseq;
            if (boundRa < this.minRa) {
                it.remove();
                continue;
            }
            double ra = (double)itemRCPPSlist.getNumSeq(this.maxSup, this.maxStd, this.lenOfseqList, this.useLemma2) / (double)this.sizeOfseq;
            if (ra == 0.0 || !(ra >= this.minRa)) continue;
            this.saveSingleItem(item, ra, itemRCPPSlist);
        }
        return mapRCPPSlist;
    }

    void saveSingleItem(int item, double ra, RCPPSlist itemRCPPSlist) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            Itemset itemset2 = new Itemset(item, ra);
            this.patterns.addItemset(itemset2, itemset2.size());
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append(item);
            buffer.append(" #RA: ");
            buffer.append(ra);
            if (this.showDetails) {
                buffer.append(itemRCPPSlist.getDetails(this.lenOfseqList, this.minBond, this.maxSup, this.maxStd));
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    void save(int[] prefix, int prefixLength, int suffixItem, double ra, RCPPSlist itemRCPPSlist) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            int[] itemsetArray = new int[prefixLength + 1];
            System.arraycopy(prefix, 0, itemsetArray, 0, prefixLength);
            itemsetArray[prefixLength] = suffixItem;
            Itemset itemset2 = new Itemset(itemsetArray, ra);
            this.patterns.addItemset(itemset2, itemset2.size());
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < prefixLength; ++i) {
                int item = prefix[i];
                buffer.append(item);
                buffer.append(" ");
            }
            buffer.append(suffixItem);
            buffer.append(" #RA: ");
            buffer.append(ra);
            if (this.showDetails) {
                buffer.append(itemRCPPSlist.getDetails(this.lenOfseqList, this.minBond, this.maxSup, this.maxStd));
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("=============  MRCPPS - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Sequence count from SDB : " + this.sizeOfseq);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" RCPPS count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        int maxLen = 0;
        int minLength = Integer.MAX_VALUE;
        double avgLen = 0.0;
        for (int len : this.lenOfseqList) {
            if (len > maxLen) {
                maxLen = len;
            }
            if (len < minLength) {
                minLength = len;
            }
            avgLen += (double)len;
        }
        System.out.println(" maximum sequence length : " + maxLen + "   minimum sequence length : " + minLength + "   average sequence length : " + (avgLen /= (double)this.lenOfseqList.size()));
        System.out.println("===================================================");
    }
}

