/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.MRCPPS;

import java.util.ArrayList;
import java.util.List;

public class RCPPSlist {
    private List<Integer> sidList;
    private List<List<Integer>> listConTIDlist = new ArrayList<List<Integer>>();
    private List<List<Integer>> listDisTIDlist;

    RCPPSlist() {
        this.sidList = new ArrayList<Integer>();
        this.listDisTIDlist = new ArrayList<List<Integer>>();
    }

    public int getSizeOfSIDlist() {
        return this.sidList.size();
    }

    public void addSID(int sid) {
        if (this.sidList.size() > 0 && this.sidList.get(this.sidList.size() - 1) == sid) {
            return;
        }
        this.sidList.add(sid);
        this.listConTIDlist.add(new ArrayList());
        this.listDisTIDlist.add(new ArrayList());
    }

    public void addTID(int tid) {
        int lastIndex = this.listConTIDlist.get(this.getSizeOfSIDlist() - 1).size() - 1;
        if (lastIndex > 0 && this.listConTIDlist.get(this.getSizeOfSIDlist() - 1).get(lastIndex) == tid) {
            return;
        }
        this.listConTIDlist.get(this.getSizeOfSIDlist() - 1).add(tid);
        this.listDisTIDlist.get(this.getSizeOfSIDlist() - 1).add(tid);
    }

    public RCPPSlist genRCPPSlistOfCandidate(RCPPSlist alpha, double minBond) {
        RCPPSlist candidate = new RCPPSlist();
        int i = 0;
        int j = 0;
        while (i < this.sidList.size() && j < alpha.sidList.size()) {
            List<Integer> jThOfconTIDlist;
            if (this.sidList.get(i) < alpha.sidList.get(j)) {
                ++i;
                continue;
            }
            if (this.sidList.get(i) > alpha.sidList.get(j)) {
                ++j;
                continue;
            }
            int currentSID = this.sidList.get(i);
            List<Integer> iThOfconTIDlist = this.listDisTIDlist.get(i);
            List<Integer> conTIDlistOfCandidate = this.getConjunctiveList(iThOfconTIDlist, jThOfconTIDlist = alpha.getListConTIDlist().get(j));
            if (conTIDlistOfCandidate != null && conTIDlistOfCandidate.size() > 0) {
                List<Integer> iThOfdisTIDlist = this.listDisTIDlist.get(i);
                List<Integer> jThOfdisTIDlist = alpha.getListDisTIDlist().get(j);
                List<Integer> disTIDlistOfCandidate = this.getDisconjunctiveList(iThOfdisTIDlist, jThOfdisTIDlist);
                double bond = (double)conTIDlistOfCandidate.size() / (double)disTIDlistOfCandidate.size();
                if (bond >= minBond) {
                    candidate.getSIDlist().add(currentSID);
                    candidate.getListConTIDlist().add(conTIDlistOfCandidate);
                    candidate.getListDisTIDlist().add(disTIDlistOfCandidate);
                }
            }
            ++i;
            ++j;
        }
        return candidate;
    }

    public List<Integer> getDisconjunctiveList(List<Integer> a, List<Integer> b) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (a == null && b == null) {
            return res;
        }
        if (a == null) {
            res.addAll(b);
            return res;
        }
        if (b == null) {
            res.addAll(a);
            return res;
        }
        int ai = 0;
        int bi = 0;
        while (ai < a.size() && bi < b.size()) {
            if (a.get(ai) < b.get(bi)) {
                res.add(a.get(ai));
                ++ai;
                continue;
            }
            if (a.get(ai) > b.get(bi)) {
                res.add(b.get(bi));
                ++bi;
                continue;
            }
            res.add(a.get(ai));
            ++ai;
            ++bi;
        }
        if (ai < a.size()) {
            while (ai < a.size()) {
                res.add(a.get(ai));
                ++ai;
            }
        }
        if (bi < a.size()) {
            while (bi < b.size()) {
                res.add(b.get(bi));
                ++bi;
            }
        }
        return res;
    }

    public List<Integer> getConjunctiveList(List<Integer> a, List<Integer> b) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (a == null || b == null || a.size() <= 0 || b.size() <= 0) {
            return res;
        }
        int ai = 0;
        int bi = 0;
        while (ai < a.size() && bi < b.size()) {
            if (a.get(ai) < b.get(bi)) {
                ++ai;
                continue;
            }
            if (a.get(ai) > b.get(bi)) {
                ++bi;
                continue;
            }
            res.add(a.get(ai));
            ++ai;
            ++bi;
        }
        return res;
    }

    public int getNumSeq(double maxSup, double maxStd, List<Integer> lenOfseqList, boolean useLemma2) {
        int numSeq = 0;
        for (int i = 0; i < this.sidList.size(); ++i) {
            int sid = this.sidList.get(i);
            List<Integer> conTIDlist = this.listConTIDlist.get(i);
            int lengthOfCurrentSequence = lenOfseqList.get(sid);
            double stanDev = this.getStanDevFromTIDlist(conTIDlist, lengthOfCurrentSequence, useLemma2);
            int sup = conTIDlist.size();
            if (!((double)sup <= maxSup) || !(stanDev <= maxStd)) continue;
            ++numSeq;
        }
        return numSeq;
    }

    public int getNumCand() {
        return this.sidList.size();
    }

    public double getStanDevFromTIDlist(List<Integer> conTIDlist, int lengthOfCurrentSequence, boolean useLemma2) {
        double stanDev = 0.0;
        int preTID = 0;
        if (useLemma2) {
            for (int i = 0; i < conTIDlist.size(); ++i) {
                int perI = conTIDlist.get(i) - preTID;
                stanDev += Math.pow(perI, 2.0);
                preTID = conTIDlist.get(i);
            }
            stanDev += Math.pow(lengthOfCurrentSequence - preTID, 2.0);
            stanDev /= (double)(conTIDlist.size() + 1);
            stanDev -= Math.pow((double)lengthOfCurrentSequence / (double)(conTIDlist.size() + 1), 2.0);
            stanDev = Math.sqrt(stanDev);
        } else {
            int perI;
            int i;
            double avgPer = 0.0;
            for (i = 0; i < conTIDlist.size(); ++i) {
                perI = conTIDlist.get(i) - preTID;
                avgPer += (double)perI;
                preTID = conTIDlist.get(i);
            }
            avgPer = avgPer + (double)lengthOfCurrentSequence - (double)preTID;
            avgPer /= (double)(conTIDlist.size() + 1);
            preTID = 0;
            for (i = 0; i < conTIDlist.size(); ++i) {
                perI = conTIDlist.get(i) - preTID;
                stanDev += Math.pow((double)perI - avgPer, 2.0);
                preTID = conTIDlist.get(i);
            }
            stanDev += Math.pow((double)(lengthOfCurrentSequence - preTID) - avgPer, 2.0);
            stanDev /= (double)(conTIDlist.size() + 1);
            stanDev = Math.sqrt(stanDev);
        }
        return stanDev;
    }

    public List<List<Integer>> getListConTIDlist() {
        return this.listConTIDlist;
    }

    public List<List<Integer>> getListDisTIDlist() {
        return this.listDisTIDlist;
    }

    public List<Integer> getSIDlist() {
        return this.sidList;
    }

    public String getDetails(List<Integer> lenOfseqList, double minBond, double maxSup, double maxStd) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(" #SIDOCC: ");
        for (int z = 0; z < this.sidList.size(); ++z) {
            int sid = this.sidList.get(z);
            int lenOfs = lenOfseqList.get(sid);
            List<Integer> conTIDlist = this.listConTIDlist.get(z);
            List<Integer> disTIDlist = this.listDisTIDlist.get(z);
            int sup = conTIDlist.size();
            double bond = (double)sup / (double)disTIDlist.size();
            double stanDev = 0.0;
            int preTID = 0;
            for (int i = 0; i < conTIDlist.size(); ++i) {
                int perI = conTIDlist.get(i) - preTID;
                stanDev += Math.pow(perI, 2.0);
                preTID = conTIDlist.get(i);
            }
            stanDev += Math.pow(lenOfs - preTID, 2.0);
            stanDev /= (double)(conTIDlist.size() + 1);
            stanDev -= Math.pow((double)lenOfs / (double)(conTIDlist.size() + 1), 2.0);
            stanDev = Math.sqrt(stanDev);
            if (!(bond >= minBond) || !((double)sup <= maxSup) || !(stanDev <= maxStd)) continue;
            buffer.append(sid);
            for (Integer tid : conTIDlist) {
                buffer.append('[');
                buffer.append(tid - 1);
                buffer.append("] ");
            }
        }
        return buffer.toString();
    }
}

