/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.MSApriori;

import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoMSApriori {
    protected int k;
    int[] MIS;
    protected long startTimestamp;
    protected long endTimestamp;
    private int itemsetCount;
    private int LSRelative;
    private List<Integer[]> database = null;
    final Comparator<Integer> itemComparator;
    BufferedWriter writer = null;
    int maxItemsetSize = Integer.MAX_VALUE;

    public AlgoMSApriori() {
        this.itemComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int compare = AlgoMSApriori.this.MIS[o1] - AlgoMSApriori.this.MIS[o2];
                if (compare == 0) {
                    return o1 - o2;
                }
                return compare;
            }
        };
    }

    public void runAlgorithm(String input, String output, double beta, double LS) throws IOException {
        Object item;
        int i;
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.itemsetCount = 0;
        MemoryLogger.getInstance().reset();
        int maxItemID = -1;
        int transactionCount = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        this.database = new ArrayList<Integer[]>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            Integer[] transaction = new Integer[lineSplited.length];
            for (int j = 0; j < lineSplited.length; ++j) {
                Integer item2 = Integer.parseInt(lineSplited[j]);
                transaction[j] = item2;
                Integer count = (Integer)mapItemCount.get(item2);
                if (count == null) {
                    mapItemCount.put(item2, 1);
                    if (item2 <= maxItemID) continue;
                    maxItemID = item2;
                    continue;
                }
                count = count + 1;
                mapItemCount.put(item2, count);
            }
            this.database.add(transaction);
            ++transactionCount;
        }
        reader.close();
        this.MIS = new int[maxItemID + 1];
        this.LSRelative = (int)Math.ceil(LS * (double)transactionCount);
        this.k = 1;
        ArrayList<Integer> M = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            M.add((Integer)entry.getKey());
            this.MIS[((Integer)entry.getKey()).intValue()] = (int)(beta * (double)((Integer)entry.getValue()).intValue());
            if (this.MIS[(Integer)entry.getKey()] < this.LSRelative) {
                this.MIS[((Integer)entry.getKey()).intValue()] = this.LSRelative;
            }
            if ((Integer)entry.getValue() < this.MIS[(Integer)entry.getKey()] || this.maxItemsetSize < 1) continue;
            this.saveItemsetToFile((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        Collections.sort(M, this.itemComparator);
        if (this.itemsetCount == 0) {
            return;
        }
        ArrayList<Integer> F = new ArrayList<Integer>();
        double d = -1.0;
        for (i = 0; i < M.size(); ++i) {
            item = (Integer)M.get(i);
            if ((Integer)mapItemCount.get(item) < this.MIS[(Integer)item]) continue;
            F.add((Integer)item);
            d = this.MIS[(Integer)item];
            break;
        }
        ++i;
        while (i < M.size()) {
            item = (Integer)M.get(i);
            if ((double)((Integer)mapItemCount.get(item)).intValue() >= d) {
                F.add((Integer)item);
            }
            ++i;
        }
        for (Integer[] transaction : this.database) {
            Arrays.sort(transaction, this.itemComparator);
        }
        if (this.maxItemsetSize > 1) {
            ArrayList<Itemset> level = null;
            this.k = 2;
            do {
                MemoryLogger.getInstance().checkMemory();
                List<Itemset> candidatesK = this.k == 2 ? this.generateCandidate2(F, mapItemCount) : this.generateCandidateSizeK(level);
                for (Integer[] transaction : this.database) {
                    block8: for (Itemset candidate : candidatesK) {
                        int pos = 0;
                        Integer[] integerArray = transaction;
                        int n = integerArray.length;
                        for (int j = 0; j < n; ++j) {
                            int item3 = integerArray[j];
                            if (item3 == candidate.get(pos)) {
                                if (++pos != candidate.size()) continue;
                                candidate.increaseTransactionCount();
                                continue block8;
                            }
                            if (this.itemComparator.compare(item3, candidate.get(pos)) > 0) continue block8;
                        }
                    }
                }
                level = new ArrayList<Itemset>();
                for (Itemset candidate : candidatesK) {
                    if (candidate.getAbsoluteSupport() < this.MIS[candidate.get(0)]) continue;
                    level.add(candidate);
                    this.saveItemsetToFile(candidate);
                }
                ++this.k;
            } while (!level.isEmpty() && this.k <= this.maxItemsetSize);
        }
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
    }

    private List<Itemset> generateCandidate2(List<Integer> frequent1, Map<Integer, Integer> mapItemCount) {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        for (int i = 0; i < frequent1.size(); ++i) {
            Integer item1 = frequent1.get(i);
            for (int j = i + 1; j < frequent1.size(); ++j) {
                Integer item2 = frequent1.get(j);
                candidates.add(new Itemset(new int[]{item1, item2}));
            }
        }
        return candidates;
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1) {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        block0: for (int i = 0; i < levelK_1.size(); ++i) {
            int[] itemset1 = levelK_1.get(i).getItems();
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                int[] itemset2 = levelK_1.get(j).getItems();
                for (int k = 0; k < itemset1.length; ++k) {
                    if (k == itemset1.length - 1) {
                        if (this.itemComparator.compare(itemset1[k], itemset2[k]) <= 0) continue;
                        continue block0;
                    }
                    if (itemset1[k] == itemset2[k]) continue;
                    if (this.itemComparator.compare(itemset1[k], itemset2[k]) < 0) continue block1;
                    if (this.itemComparator.compare(itemset1[k], itemset2[k]) > 0) continue block0;
                }
                int[] newItemset = new int[itemset1.length + 1];
                System.arraycopy(itemset1, 0, newItemset, 0, itemset1.length);
                newItemset[itemset1.length] = itemset2[itemset2.length - 1];
                if (!this.allSubsetsOfSizeK_1AreFrequent(newItemset, levelK_1)) continue;
                candidates.add(new Itemset(newItemset));
            }
        }
        return candidates;
    }

    protected boolean allSubsetsOfSizeK_1AreFrequent(int[] c, List<Itemset> levelK_1) {
        for (int posRemoved = 0; posRemoved < c.length; ++posRemoved) {
            if (posRemoved == 0 && this.MIS[c[0]] != this.MIS[c[1]]) continue;
            int first = 0;
            int last = levelK_1.size() - 1;
            boolean found = false;
            while (first <= last) {
                int middle = first + last >>> 1;
                if (this.sameAs(levelK_1.get(middle), c, posRemoved) < 0) {
                    first = middle + 1;
                    continue;
                }
                if (this.sameAs(levelK_1.get(middle), c, posRemoved) > 0) {
                    last = middle - 1;
                    continue;
                }
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private int sameAs(Itemset itemset2, int[] candidate, int posRemoved) {
        int j = 0;
        for (int i = 0; i < itemset2.size(); ++i) {
            if (j == posRemoved) {
                ++j;
            }
            if (itemset2.get(i) == candidate[j]) {
                ++j;
                continue;
            }
            return this.itemComparator.compare(itemset2.get(i), candidate[j]);
        }
        return 0;
    }

    private void saveItemsetToFile(Itemset itemset2) throws IOException {
        this.writer.write(itemset2.toString() + " #SUP: " + itemset2.getAbsoluteSupport());
        this.writer.newLine();
        ++this.itemsetCount;
    }

    private void saveItemsetToFile(Integer item, Integer support) throws IOException {
        this.writer.write(item + " #SUP: " + support);
        this.writer.newLine();
        ++this.itemsetCount;
    }

    public void printStats() {
        System.out.println("=============  MSAPRIORI - STATS =============");
        System.out.println(" The algorithm stopped at level " + (this.k - 1) + ", because there is no candidate");
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    public void setMaximumPatternLength(int length) {
        this.maxItemsetSize = length;
    }
}

