/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.UFH;

import ca.pfv.spmf.algorithms.frequentpatterns.UFH.EFIM_UP_Tree_Transaction_SPMF;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EFIM_UP_Tree_Dataset_SPMF {
    List<EFIM_UP_Tree_Transaction_SPMF> transactions = new ArrayList<EFIM_UP_Tree_Transaction_SPMF>();
    private int maxItem = 0;

    public EFIM_UP_Tree_Dataset_SPMF(String datasetPath) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(datasetPath));
        int i = 0;
        while ((line = br.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            ++i;
            this.transactions.add(this.createTransaction(line));
        }
        br.close();
    }

    private EFIM_UP_Tree_Transaction_SPMF createTransaction(String line) {
        String[] split = line.split(":");
        int transactionUtility = Integer.parseInt(split[1]);
        String[] itemsString = split[0].split(" ");
        String[] itemsUtilitiesString = split[2].split(" ");
        int[] items = new int[itemsString.length];
        int[] utilities = new int[itemsString.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = Integer.parseInt(itemsString[i]);
            utilities[i] = Integer.parseInt(itemsUtilitiesString[i]);
            if (items[i] <= this.maxItem) continue;
            this.maxItem = items[i];
        }
        return new EFIM_UP_Tree_Transaction_SPMF(items, utilities, transactionUtility);
    }

    public List<EFIM_UP_Tree_Transaction_SPMF> getTransactions() {
        return this.transactions;
    }

    public int getMaxItem() {
        return this.maxItem;
    }

    public String toString() {
        StringBuilder datasetContent = new StringBuilder();
        for (EFIM_UP_Tree_Transaction_SPMF transaction : this.transactions) {
            datasetContent.append(transaction.toString());
            datasetContent.append("\n");
        }
        return datasetContent.toString();
    }
}

