/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.apriori;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoApriori {
    protected int k;
    protected int totalCandidateCount = 0;
    protected long startTimestamp;
    protected long endTimestamp;
    private int itemsetCount;
    private int databaseSize;
    private int minsupRelative;
    private List<int[]> database = null;
    protected Itemsets patterns = null;
    BufferedWriter writer = null;
    private int maxPatternLength = 10000;

    public Itemsets runAlgorithm(double minsup, String input, String output) throws IOException {
        String line;
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        this.totalCandidateCount = 0;
        MemoryLogger.getInstance().reset();
        this.databaseSize = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        this.database = new ArrayList<int[]>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            Object transaction = new int[lineSplited.length];
            for (int i = 0; i < lineSplited.length; ++i) {
                Integer item = Integer.parseInt(lineSplited[i]);
                transaction[i] = item;
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                    continue;
                }
                count = count + 1;
                mapItemCount.put(item, count);
            }
            this.database.add((int[])transaction);
            ++this.databaseSize;
        }
        reader.close();
        this.minsupRelative = (int)Math.ceil(minsup * (double)this.databaseSize);
        this.k = 1;
        ArrayList<Integer> frequent1 = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minsupRelative) continue;
            frequent1.add((Integer)entry.getKey());
            this.saveItemsetToFile((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        mapItemCount = null;
        Collections.sort(frequent1, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 - o2;
            }
        });
        if (frequent1.size() == 0 || this.maxPatternLength <= 1) {
            this.endTimestamp = System.currentTimeMillis();
            MemoryLogger.getInstance().checkMemory();
            if (this.writer != null) {
                this.writer.close();
            }
            return this.patterns;
        }
        this.totalCandidateCount += frequent1.size();
        ArrayList<Itemset> level = null;
        this.k = 2;
        do {
            MemoryLogger.getInstance().checkMemory();
            List<Itemset> candidatesK = this.k == 2 ? this.generateCandidate2(frequent1) : this.generateCandidateSizeK(level);
            this.totalCandidateCount += candidatesK.size();
            for (int[] transaction : this.database) {
                if (transaction.length < this.k) continue;
                block5: for (Itemset candidate : candidatesK) {
                    int pos = 0;
                    for (int item : transaction) {
                        if (item == candidate.itemset[pos]) {
                            if (++pos != candidate.itemset.length) continue;
                            ++candidate.support;
                            continue block5;
                        }
                        if (item > candidate.itemset[pos]) continue block5;
                    }
                }
            }
            level = new ArrayList<Itemset>();
            if (this.k < this.maxPatternLength + 1) {
                for (Itemset candidate : candidatesK) {
                    if (candidate.getAbsoluteSupport() < this.minsupRelative) continue;
                    level.add(candidate);
                    this.saveItemset(candidate);
                }
            }
            ++this.k;
        } while (!level.isEmpty());
        this.endTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
        return this.patterns;
    }

    public int getDatabaseSize() {
        return this.databaseSize;
    }

    private List<Itemset> generateCandidate2(List<Integer> frequent1) {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        for (int i = 0; i < frequent1.size(); ++i) {
            Integer item1 = frequent1.get(i);
            for (int j = i + 1; j < frequent1.size(); ++j) {
                Integer item2 = frequent1.get(j);
                candidates.add(new Itemset(new int[]{item1, item2}));
            }
        }
        return candidates;
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1) {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        block0: for (int i = 0; i < levelK_1.size(); ++i) {
            int[] itemset1 = levelK_1.get((int)i).itemset;
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                int[] itemset2 = levelK_1.get((int)j).itemset;
                for (int k = 0; k < itemset1.length; ++k) {
                    if (k == itemset1.length - 1) {
                        if (itemset1[k] < itemset2[k]) continue;
                        continue block0;
                    }
                    if (itemset1[k] < itemset2[k]) continue block1;
                    if (itemset1[k] > itemset2[k]) continue block0;
                }
                int[] newItemset = new int[itemset1.length + 1];
                System.arraycopy(itemset1, 0, newItemset, 0, itemset1.length);
                newItemset[itemset1.length] = itemset2[itemset2.length - 1];
                if (!this.allSubsetsOfSizeK_1AreFrequent(newItemset, levelK_1)) continue;
                candidates.add(new Itemset(newItemset));
            }
        }
        return candidates;
    }

    protected boolean allSubsetsOfSizeK_1AreFrequent(int[] candidate, List<Itemset> levelK_1) {
        for (int posRemoved = 0; posRemoved < candidate.length; ++posRemoved) {
            int first = 0;
            int last = levelK_1.size() - 1;
            boolean found = false;
            while (first <= last) {
                int middle = first + last >> 1;
                int comparison = ArraysAlgos.sameAs(levelK_1.get(middle).getItems(), candidate, posRemoved);
                if (comparison < 0) {
                    first = middle + 1;
                    continue;
                }
                if (comparison > 0) {
                    last = middle - 1;
                    continue;
                }
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    void saveItemset(Itemset itemset2) throws IOException {
        ++this.itemsetCount;
        if (this.writer != null) {
            this.writer.write(itemset2.toString() + " #SUP: " + itemset2.getAbsoluteSupport());
            this.writer.newLine();
        } else {
            this.patterns.addItemset(itemset2, itemset2.size());
        }
    }

    void saveItemsetToFile(Integer item, Integer support) throws IOException {
        ++this.itemsetCount;
        if (this.writer != null) {
            this.writer.write(item + " #SUP: " + support);
            this.writer.newLine();
        } else {
            Itemset itemset2 = new Itemset(item);
            itemset2.setAbsoluteSupport(support);
            this.patterns.addItemset(itemset2, 1);
        }
    }

    public void printStats() {
        System.out.println("=============  APRIORI - STATS =============");
        System.out.println(" Candidates count : " + this.totalCandidateCount);
        System.out.println(" The algorithm stopped at size " + (this.k - 1));
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    public void setMaximumPatternLength(int length) {
        this.maxPatternLength = length;
    }
}

