/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.aprioriTID_inverse;

import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoAprioriTIDInverse {
    protected int k;
    Map<Integer, Set<Integer>> mapItemTIDS = new HashMap<Integer, Set<Integer>>();
    int minSuppRelative;
    int maxSuppRelative;
    int maxItemsetSize = Integer.MAX_VALUE;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    BufferedWriter writer = null;
    protected Itemsets patterns = null;
    private int itemsetCount = 0;
    private int databaseSize = 0;
    private TransactionDatabase database = null;
    private boolean emptySetIsRequired = false;
    boolean showTransactionIdentifiers = false;

    public Itemsets runAlgorithm(TransactionDatabase database, double minsup, double maxsup) throws NumberFormatException, IOException {
        this.database = database;
        Itemsets result = this.runAlgorithm(null, null, minsup, maxsup);
        this.database = null;
        return result;
    }

    public Itemsets runAlgorithm(String input, String output, double minsup, double maxsup) throws NumberFormatException, IOException {
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("FREQUENT ITEMSETS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.mapItemTIDS = new HashMap<Integer, Set<Integer>>();
        this.databaseSize = 0;
        if (this.database != null) {
            for (List<Integer> transaction : this.database.getTransactions()) {
                for (int item : transaction) {
                    Set<Integer> tids = this.mapItemTIDS.get(item);
                    if (tids == null) {
                        tids = new HashSet<Integer>();
                        this.mapItemTIDS.put(item, tids);
                    }
                    tids.add(this.databaseSize);
                }
                ++this.databaseSize;
            }
        } else {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(input));
            while ((line = reader.readLine()) != null) {
                String[] lineSplited;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                for (String token : lineSplited = line.split(" ")) {
                    int item = Integer.parseInt(token);
                    Set<Integer> tids = this.mapItemTIDS.get(item);
                    if (tids == null) {
                        tids = new HashSet<Integer>();
                        this.mapItemTIDS.put(item, tids);
                    }
                    tids.add(this.databaseSize);
                }
                ++this.databaseSize;
            }
            reader.close();
        }
        if (this.emptySetIsRequired) {
            this.patterns.addItemset(new Itemset(new int[0]), 0);
        }
        this.minSuppRelative = (int)Math.ceil(minsup * (double)this.databaseSize);
        this.maxSuppRelative = (int)Math.ceil(maxsup * (double)this.databaseSize);
        this.k = 1;
        List<Itemset> level = new ArrayList<Itemset>();
        Iterator<Map.Entry<Integer, Set<Integer>>> iterator = this.mapItemTIDS.entrySet().iterator();
        while (iterator.hasNext()) {
            MemoryLogger.getInstance().checkMemory();
            Map.Entry<Integer, Set<Integer>> entry = iterator.next();
            if (entry.getValue().size() >= this.minSuppRelative && entry.getValue().size() <= this.maxSuppRelative) {
                Integer item = entry.getKey();
                Itemset itemset2 = new Itemset(item);
                itemset2.setTIDs(this.mapItemTIDS.get(item));
                level.add(itemset2);
                this.saveItemset(itemset2);
                continue;
            }
            iterator.remove();
        }
        Collections.sort(level, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset o1, Itemset o2) {
                return o1.get(0) - o2.get(0);
            }
        });
        this.k = 2;
        while (!level.isEmpty() && this.k <= this.maxItemsetSize) {
            level = this.generateCandidateSizeK(level);
            ++this.k;
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTimeStamp = System.currentTimeMillis();
        return this.patterns;
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1) throws IOException {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        block0: for (int i = 0; i < levelK_1.size(); ++i) {
            Itemset itemset1 = levelK_1.get(i);
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                Itemset itemset2 = levelK_1.get(j);
                for (int k = 0; k < itemset1.size(); ++k) {
                    if (k == itemset1.size() - 1) {
                        if (itemset1.getItems()[k] < itemset2.get(k)) continue;
                        continue block0;
                    }
                    if (itemset1.getItems()[k] < itemset2.getItems()[k]) continue block1;
                    if (itemset1.getItems()[k] > itemset2.getItems()[k]) continue block0;
                }
                HashSet<Integer> list = new HashSet<Integer>();
                for (Integer val1 : itemset1.getTransactionsIds()) {
                    if (!itemset2.getTransactionsIds().contains(val1)) continue;
                    list.add(val1);
                }
                if (list.size() < this.minSuppRelative) continue;
                int[] newItemset = new int[itemset1.size() + 1];
                System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                newItemset[itemset1.size()] = itemset2.getItems()[itemset2.size() - 1];
                Itemset candidate = new Itemset(newItemset);
                candidate.setTIDs(list);
                candidates.add(candidate);
                this.saveItemset(candidate);
            }
        }
        return candidates;
    }

    public void setMaxItemsetSize(int maxItemsetSize) {
        this.maxItemsetSize = maxItemsetSize;
    }

    void saveItemset(Itemset itemset2) throws IOException {
        ++this.itemsetCount;
        if (this.writer != null) {
            this.writer.write(itemset2.toString() + " #SUP: " + itemset2.getTransactionsIds().size());
            if (this.showTransactionIdentifiers) {
                this.writer.append(" #TID:");
                for (Integer tid : itemset2.getTransactionsIds()) {
                    this.writer.append(" " + tid);
                }
            }
            this.writer.newLine();
        } else {
            this.patterns.addItemset(itemset2, itemset2.size());
        }
    }

    public void setEmptySetIsRequired(boolean emptySetIsRequired) {
        this.emptySetIsRequired = emptySetIsRequired;
    }

    public void setShowTransactionIdentifiers(boolean showTransactionIdentifiers) {
        this.showTransactionIdentifiers = showTransactionIdentifiers;
    }

    public void printStats() {
        System.out.println("=============  APRIORI INVERSE TID v2.18 - STATS =============");
        System.out.println(" Transactions count from database : " + this.databaseSize);
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }

    public int getDatabaseSize() {
        return this.databaseSize;
    }
}

