/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.biohuif;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoBio_HUIF_GA {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int transactionCount = 0;
    final int pop_size = 100;
    final int max_iter = 2000;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToTWU0;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    List<Double> percentHUIChroNode;
    List<ChroNode> huiBA = new ArrayList<ChroNode>();
    List<ChroNode> population = new ArrayList<ChroNode>();
    List<ChroNode> subPopulation = new ArrayList<ChroNode>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<Double> percentage = new ArrayList<Double>();
    List<Item> Items;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        String[] items;
        String[] split;
        String thisLine;
        this.maxMemory = 0.0;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        this.mapItemToTWU0 = new HashMap<Integer, Integer>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer twu = this.mapItemToTWU.get(item);
                    Integer twu0 = this.mapItemToTWU0.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    twu0 = twu0 == null ? transactionUtility : twu0 + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                    this.mapItemToTWU0.put(item, twu0);
                }
            }
        }
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                ArrayList<Integer> pattern = new ArrayList<Integer>();
                for (int i = 0; i < items.length; ++i) {
                    Pair pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                        revisedTransaction.add(pair);
                        pattern.add(pair.item);
                        continue;
                    }
                    this.mapItemToTWU0.remove(pair.item);
                }
                this.database.add(revisedTransaction);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU0.keySet());
        Collections.sort(this.twuPattern);
        this.Items = new ArrayList<Item>();
        for (Integer tempitem : this.twuPattern) {
            this.Items.add(new Item(tempitem));
        }
        for (int i = 0; i < this.database.size(); ++i) {
            for (int j = 0; j < this.Items.size(); ++j) {
                for (int k = 0; k < this.database.get(i).size(); ++k) {
                    if (this.Items.get((int)j).item != this.database.get((int)i).get((int)k).item) continue;
                    this.Items.get((int)j).TIDS.set(i);
                }
            }
        }
        this.checkMemory();
        if (this.twuPattern.size() > 0) {
            double pMax;
            double pMin;
            int m = this.database.size();
            int n = this.twuPattern.size();
            int temp1 = 0;
            int temp2 = 0;
            this.pop_Init(minUtility);
            if (m > n) {
                pMin = 1.0 / ((double)m + 0.0);
                pMax = 1.0 / ((double)n + 0.0);
            } else {
                pMin = 1.0 / ((double)n + 0.0);
                pMax = 1.0 / ((double)m + 0.0);
            }
            for (int i = 0; i < 2000; ++i) {
                if (this.huiBA.size() > 2) {
                    this.percentHUIChroNode = this.roulettePercentHUIBA();
                    int num1 = this.rouletteSelectHUIBA(this.percentHUIChroNode);
                    int num2 = this.rouletteSelectHUIBA(this.percentHUIChroNode);
                    int tempA = (int)(Math.random() * 100.0);
                    int tempB = (int)(Math.random() * 100.0);
                    this.population.get(tempA).deepcopy(this.huiBA.get(num1));
                    this.population.get(tempB).deepcopy(this.huiBA.get(num2));
                }
                this.calculateRfitness();
                while (this.subPopulation.size() < 100) {
                    temp1 = this.selectChromosome();
                    temp2 = this.selectChromosome();
                    while (temp1 == temp2) {
                        temp2 = (temp2 + (int)(Math.random() * 1000.0)) % 100;
                    }
                    this.crossover(temp1, temp2, minUtility);
                }
                this.subPopulation = this.rankedMutation(pMax, pMin, i, minUtility);
                this.subPopulation.addAll(this.population);
                this.rankData(this.subPopulation);
                for (int j = 0; j < this.population.size(); ++j) {
                    this.population.set(j, this.subPopulation.get(j));
                }
                this.subPopulation.clear();
                if (i % 200 != 0) continue;
                System.out.println(i + "-update end. HUIs No. is " + this.huiSets.size());
            }
        }
        this.writeOut();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void pop_Init(int minUtility) {
        this.percentage = this.roulettePercent();
        for (int i = 0; i < 100; ++i) {
            ChroNode tempNode = new ChroNode(this.twuPattern.size());
            int j = 0;
            int k = (int)(Math.random() * (double)this.twuPattern.size());
            while (j < k) {
                int temp = this.select(this.percentage);
                if (tempNode.chromosome.get(temp)) continue;
                ++j;
                tempNode.chromosome.set(temp);
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.pev_Check(tempNode, transList);
            tempNode.calculateFitness(k, transList);
            tempNode.rank = 0;
            this.population.add(tempNode);
            if (tempNode.fitness < minUtility || tempNode.chromosome.cardinality() <= 0) continue;
            this.insert(tempNode);
            this.addHuiBA(tempNode);
        }
    }

    public boolean pev_Check(ChroNode tempBAIndividual, List<Integer> list) {
        ArrayList<Integer> templist = new ArrayList<Integer>();
        for (int i = 0; i < tempBAIndividual.chromosome.length(); ++i) {
            if (!tempBAIndividual.chromosome.get(i)) continue;
            templist.add(i);
        }
        if (templist.size() == 0) {
            return false;
        }
        BitSet tempBitSet = new BitSet(this.database.size());
        BitSet midBitSet = new BitSet(this.database.size());
        tempBitSet = (BitSet)this.Items.get((int)((Integer)templist.get((int)0)).intValue()).TIDS.clone();
        midBitSet = (BitSet)tempBitSet.clone();
        for (int i = 1; i < templist.size(); ++i) {
            tempBitSet.and(this.Items.get((int)((Integer)templist.get((int)i)).intValue()).TIDS);
            if (tempBitSet.cardinality() != 0) {
                midBitSet = (BitSet)tempBitSet.clone();
                continue;
            }
            tempBitSet = (BitSet)midBitSet.clone();
            tempBAIndividual.chromosome.clear((Integer)templist.get(i));
        }
        if (tempBitSet.cardinality() == 0) {
            return false;
        }
        for (int m = 0; m < tempBitSet.length(); ++m) {
            if (!tempBitSet.get(m)) continue;
            list.add(m);
        }
        return true;
    }

    public void calculateRfitness() {
        int i;
        int sum = 0;
        int temp = 0;
        for (i = 0; i < this.population.size(); ++i) {
            sum += this.population.get((int)i).fitness;
        }
        for (i = 0; i < this.population.size(); ++i) {
            this.population.get((int)i).rfitness = (double)(temp += this.population.get((int)i).fitness) / ((double)sum + 0.0);
        }
    }

    private int selectChromosome() {
        int temp = 0;
        double randNum = Math.random();
        for (int i = 0; i < this.population.size(); ++i) {
            if (i == 0) {
                if (!(randNum >= 0.0) || !(randNum <= this.population.get((int)0).rfitness)) continue;
                temp = 0;
                break;
            }
            if (!(randNum > this.population.get((int)(i - 1)).rfitness) || !(randNum <= this.population.get((int)i).rfitness)) continue;
            temp = i;
            break;
        }
        return temp;
    }

    private void crossover(int temp1, int temp2, int minUtility) {
        int tempA = 0;
        int tempB = 0;
        ChroNode temp1Node = new ChroNode();
        ChroNode temp2Node = new ChroNode();
        temp1Node.deepcopy(this.population.get(temp1));
        temp2Node.deepcopy(this.population.get(temp2));
        List<Integer> disList = this.bitDiff(temp1Node, temp2Node);
        int num1 = (int)((double)disList.size() * Math.random()) + 1;
        int num2 = (int)((double)disList.size() * Math.random()) + 1;
        if (disList.size() > 0) {
            int changeBit;
            int m;
            for (m = 0; m < num1; ++m) {
                changeBit = (int)((double)disList.size() * Math.random());
                if (temp1Node.chromosome.get(disList.get(changeBit))) {
                    temp1Node.chromosome.clear(disList.get(changeBit));
                    continue;
                }
                temp1Node.chromosome.set(disList.get(changeBit));
            }
            for (m = 0; m < num2; ++m) {
                changeBit = (int)((double)disList.size() * Math.random());
                if (temp2Node.chromosome.get(disList.get(changeBit))) {
                    temp2Node.chromosome.clear(disList.get(changeBit));
                    continue;
                }
                temp2Node.chromosome.set(disList.get(changeBit));
            }
        }
        ArrayList<Integer> transList = new ArrayList<Integer>();
        this.pev_Check(temp1Node, transList);
        tempA = temp1Node.chromosome.cardinality();
        temp1Node.calculateFitness(tempA, transList);
        temp1Node.rank = 0;
        temp1Node.rfitness = 0.0;
        this.subPopulation.add(temp1Node);
        if (temp1Node.fitness >= minUtility && temp1Node.chromosome.cardinality() > 0) {
            this.insert(temp1Node);
            this.addHuiBA(temp1Node);
        }
        transList = new ArrayList();
        this.pev_Check(temp2Node, transList);
        tempB = temp2Node.chromosome.cardinality();
        temp2Node.calculateFitness(tempB, transList);
        temp2Node.rank = 0;
        temp2Node.rfitness = 0.0;
        this.subPopulation.add(temp2Node);
        if (temp2Node.fitness >= minUtility && temp2Node.chromosome.cardinality() > 0) {
            this.insert(temp2Node);
            this.addHuiBA(temp2Node);
        }
    }

    private List<ChroNode> rankedMutation(double pMax, double pMin, int currentIteration, int minUtility) {
        List<Integer> record = this.getRank(this.subPopulation);
        for (int i = 0; i < 100; ++i) {
            double pm = (pMax - (pMax - pMin) * (double)currentIteration / 2000.0) * (double)record.get(i).intValue() / (double)this.subPopulation.size();
            double rankNum = Math.random();
            int temp = (int)(Math.random() * (double)this.twuPattern.size());
            if (this.subPopulation.get((int)i).chromosome.get(temp)) {
                this.subPopulation.get((int)i).chromosome.clear(temp);
            } else {
                this.subPopulation.get((int)i).chromosome.set(temp);
            }
            int k = this.subPopulation.get((int)i).chromosome.cardinality();
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.pev_Check(this.subPopulation.get(i), transList);
            this.subPopulation.get(i).calculateFitness(k, transList);
            if (this.subPopulation.get((int)i).fitness < minUtility || this.subPopulation.get((int)i).chromosome.cardinality() <= 0) continue;
            this.insert(this.subPopulation.get(i));
            this.addHuiBA(this.subPopulation.get(i));
        }
        return this.subPopulation;
    }

    private void rankData(List<ChroNode> tempPop) {
        Collections.sort(tempPop);
        for (int i = 0; i < tempPop.size() - 1; ++i) {
            tempPop.get((int)i).rank = i + 1;
        }
    }

    private List<Integer> getRank(List<ChroNode> tempPop) {
        Collections.sort(tempPop);
        ArrayList<Integer> rank = new ArrayList<Integer>();
        for (int i = 0; i < this.subPopulation.size(); ++i) {
            rank.add(i + 1);
        }
        return rank;
    }

    private List<Integer> bitDiff(ChroNode gBest, ChroNode tempBAIndividual) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        BitSet tmpBitSet = (BitSet)gBest.chromosome.clone();
        tmpBitSet.xor(tempBAIndividual.chromosome);
        for (int i = 0; i < tmpBitSet.length(); ++i) {
            if (!tmpBitSet.get(i)) continue;
            list.add(i);
        }
        return list;
    }

    private List<Double> roulettePercentHUIBA() {
        int i;
        double sum = 0.0;
        double tempsum = 0.0;
        double percent = 0.0;
        ArrayList<Double> percentHUIBA = new ArrayList<Double>();
        for (i = 0; i < this.huiBA.size(); ++i) {
            sum += (double)this.huiBA.get((int)i).fitness;
        }
        for (i = 0; i < this.huiBA.size(); ++i) {
            percent = (tempsum += (double)this.huiBA.get((int)i).fitness) / sum;
            percentHUIBA.add(percent);
        }
        return percentHUIBA;
    }

    private int rouletteSelectHUIBA(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        for (int i = 0; i < percentage.size(); ++i) {
            if (i == 0) {
                if (!(randNum >= 0.0) || !(randNum <= percentage.get(0))) continue;
                temp = 0;
                break;
            }
            if (!(randNum > percentage.get(i - 1)) || !(randNum <= percentage.get(i))) continue;
            temp = i;
            break;
        }
        return temp;
    }

    private List<Double> roulettePercent() {
        int i;
        double sum = 0.0;
        double tempSum = 0.0;
        for (i = 0; i < this.twuPattern.size(); ++i) {
            sum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue();
        }
        for (i = 0; i < this.twuPattern.size(); ++i) {
            double tempPercent = (tempSum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue()) / (sum + 0.0);
            this.percentage.add(tempPercent);
        }
        return this.percentage;
    }

    private int select(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        for (int i = 0; i < percentage.size(); ++i) {
            if (i == 0) {
                if (!(randNum >= 0.0) || !(randNum <= percentage.get(0))) continue;
                temp = 0;
                break;
            }
            if (!(randNum > percentage.get(i - 1)) || !(randNum <= percentage.get(i))) continue;
            temp = i;
            break;
        }
        return temp;
    }

    private void insert(ChroNode tempChroNode) {
        int i;
        StringBuilder temp = new StringBuilder();
        for (i = 0; i < this.twuPattern.size(); ++i) {
            if (!tempChroNode.chromosome.get(i)) continue;
            temp.append(this.twuPattern.get(i));
            temp.append(' ');
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempChroNode.fitness));
        } else {
            for (i = 0; i < this.huiSets.size() && !temp.toString().equals(this.huiSets.get((int)i).itemset); ++i) {
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempChroNode.fitness));
            }
        }
    }

    private void addHuiBA(ChroNode tempBAIndividual) {
        ChroNode tmpBAIndividual = new ChroNode();
        tmpBAIndividual.deepcopy(tempBAIndividual);
        if (this.huiBA.size() != 0) {
            for (int i = 0; i < this.huiBA.size(); ++i) {
                BitSet tmpBitSet = (BitSet)tmpBAIndividual.chromosome.clone();
                tmpBitSet.xor(this.huiBA.get((int)i).chromosome);
                if (tmpBitSet.cardinality() != 0) continue;
                return;
            }
        }
        this.huiBA.add(tmpBAIndividual);
    }

    private void writeOut() throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.huiSets.size(); ++i) {
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL: ");
            buffer.append(this.huiSets.get((int)i).fitness);
            if (i == this.huiSets.size() - 1) continue;
            buffer.append(System.lineSeparator());
        }
        this.writer.write(buffer.toString());
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HUIF-GA ALGORITHM v.2.36 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }

    class Item {
        int item;
        BitSet TIDS;

        public Item() {
            this.TIDS = new BitSet(AlgoBio_HUIF_GA.this.database.size());
        }

        public Item(int item) {
            this.TIDS = new BitSet(AlgoBio_HUIF_GA.this.database.size());
            this.item = item;
        }
    }

    class ChroNode
    implements Comparable {
        BitSet chromosome;
        int fitness;
        double rfitness;
        int rank;

        public ChroNode() {
            this.chromosome = new BitSet();
        }

        public ChroNode(int length) {
            this.chromosome = new BitSet(length);
        }

        public void deepcopy(ChroNode tempChroNode) {
            this.chromosome = (BitSet)tempChroNode.chromosome.clone();
            this.fitness = tempChroNode.fitness;
            this.rfitness = tempChroNode.rfitness;
            this.rank = tempChroNode.rank;
        }

        public void calculateFitness(int k, List<Integer> templist) {
            if (k == 0) {
                return;
            }
            int fitness = 0;
            for (int m = 0; m < templist.size(); ++m) {
                int p = templist.get(m);
                int i = 0;
                boolean j = false;
                int q = 0;
                int temp = 0;
                int sum = 0;
                while (q < AlgoBio_HUIF_GA.this.database.get(p).size() && i < this.chromosome.length()) {
                    if (this.chromosome.get(i)) {
                        if (AlgoBio_HUIF_GA.this.database.get((int)p).get((int)q).item == AlgoBio_HUIF_GA.this.twuPattern.get(i)) {
                            sum += AlgoBio_HUIF_GA.this.database.get((int)p).get((int)q).utility;
                            ++i;
                            ++q;
                            ++temp;
                            continue;
                        }
                        ++q;
                        continue;
                    }
                    ++i;
                }
                if (temp != k) continue;
                fitness += sum;
            }
            this.fitness = fitness;
        }

        public int compareTo(Object o) {
            return -(this.fitness - ((ChroNode)o).fitness);
        }
    }

    class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }
}

