/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.biohuif;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoBio_HUIF_PSO {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    final int pop_size = 100;
    final int max_iter = 2000;
    int transactionCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToTWU0;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    Particle gBest;
    List<Particle> pBest = new ArrayList<Particle>();
    List<Particle> population = new ArrayList<Particle>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<Double> percentage = new ArrayList<Double>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<Item> Items;
    List<Particle> huiBA = new ArrayList<Particle>();
    List<Double> percentHUIBA;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        int i;
        String[] items;
        String[] split;
        String thisLine;
        this.maxMemory = 0.0;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        this.mapItemToTWU0 = new HashMap<Integer, Integer>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                ++this.transactionCount;
                split = thisLine.split(":");
                items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i2 = 0; i2 < items.length; ++i2) {
                    Integer item = Integer.parseInt(items[i2]);
                    Integer twu = this.mapItemToTWU.get(item);
                    Integer twu0 = this.mapItemToTWU0.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    twu0 = twu0 == null ? transactionUtility : twu0 + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                    this.mapItemToTWU0.put(item, twu0);
                }
            }
        }
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                ArrayList<Integer> pattern = new ArrayList<Integer>();
                for (int i3 = 0; i3 < items.length; ++i3) {
                    Pair pair = new Pair();
                    pair.item = Integer.parseInt(items[i3]);
                    pair.utility = Integer.parseInt(utilityValues[i3]);
                    if (this.mapItemToTWU.get(pair.item) >= minUtility) {
                        revisedTransaction.add(pair);
                        pattern.add(pair.item);
                        continue;
                    }
                    this.mapItemToTWU0.remove(pair.item);
                }
                this.database.add(revisedTransaction);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.twuPattern = new ArrayList<Integer>(this.mapItemToTWU0.keySet());
        Collections.sort(this.twuPattern);
        System.out.println("twuPattern:" + this.twuPattern.size());
        System.out.println(this.twuPattern);
        this.Items = new ArrayList<Item>();
        for (Integer tempitem : this.twuPattern) {
            this.Items.add(new Item(tempitem));
        }
        for (i = 0; i < this.database.size(); ++i) {
            for (int j = 0; j < this.Items.size(); ++j) {
                for (int k = 0; k < this.database.get(i).size(); ++k) {
                    if (this.Items.get((int)j).item != this.database.get((int)i).get((int)k).item) continue;
                    this.Items.get((int)j).TIDS.set(i);
                }
            }
        }
        for (i = 0; i < 100; ++i) {
            this.pBest.add(new Particle(this.twuPattern.size()));
        }
        this.gBest = new Particle(this.twuPattern.size());
        this.checkMemory();
        if (this.twuPattern.size() > 0) {
            this.pop_Init(minUtility);
            for (i = 0; i < 2000; ++i) {
                this.next_Gen_PA(minUtility);
                if (this.huiBA.size() != 0) {
                    this.percentHUIBA = this.roulettePercentHUIBA();
                    int num = this.rouletteSelectHUIBA(this.percentHUIBA);
                    this.gBest.copyParticle(this.huiBA.get(num));
                }
                if (i % 200 != 0) continue;
                System.out.println(i + "-update end. HUIs No. is " + this.huiSets.size());
            }
        }
        this.writeOut();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void pop_Init(int minUtility) {
        this.percentage = this.roulettePercent();
        System.out.println(this.percentage);
        for (int i = 0; i < 100; ++i) {
            Particle tempParticle = new Particle(this.twuPattern.size());
            int j = 0;
            int k = (int)(Math.random() * (double)this.twuPattern.size());
            while (j < k) {
                int temp = this.rouletteSelect(this.percentage);
                if (tempParticle.X.get(temp)) continue;
                ++j;
                tempParticle.X.set(temp);
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.pev_Check(tempParticle, transList);
            tempParticle.calculateFitness(k, transList);
            this.population.add(i, tempParticle);
            this.pBest.get(i).copyParticle(tempParticle);
            if (this.population.get((int)i).fitness >= minUtility) {
                this.insert(this.population.get(i));
                this.addHuiBA(this.population.get(i));
            }
            if (i == 0) {
                this.gBest.copyParticle(this.pBest.get(i));
                continue;
            }
            if (this.pBest.get((int)i).fitness <= this.gBest.fitness) continue;
            this.gBest.copyParticle(this.pBest.get(i));
        }
    }

    private void next_Gen_PA(int minUtility) {
        for (int i = 0; i < 100; ++i) {
            int changeBit;
            int m;
            List<Integer> disList = this.bitDiff(this.pBest.get(i), this.population.get(i));
            int num = (int)((double)disList.size() * Math.random()) + 1;
            if (disList.size() > 0) {
                for (m = 0; m < num; ++m) {
                    changeBit = (int)((double)disList.size() * Math.random());
                    if (this.population.get((int)i).X.get(disList.get(changeBit))) {
                        this.population.get((int)i).X.clear(disList.get(changeBit));
                        continue;
                    }
                    this.population.get((int)i).X.set(disList.get(changeBit));
                }
            }
            disList = this.bitDiff(this.gBest, this.population.get(i));
            num = (int)((double)disList.size() * Math.random()) + 1;
            if (disList.size() > 0) {
                for (m = 0; m < num; ++m) {
                    changeBit = (int)((double)disList.size() * Math.random());
                    if (this.population.get((int)i).X.get(disList.get(changeBit))) {
                        this.population.get((int)i).X.clear(disList.get(changeBit));
                        continue;
                    }
                    this.population.get((int)i).X.set(disList.get(changeBit));
                }
            }
            for (m = 0; m < 1; ++m) {
                changeBit = (int)((double)this.twuPattern.size() * Math.random());
                if (this.population.get((int)i).X.get(changeBit)) {
                    this.population.get((int)i).X.clear(changeBit);
                    continue;
                }
                this.population.get((int)i).X.set(changeBit);
            }
            int k = this.population.get((int)i).X.cardinality();
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.pev_Check(this.population.get(i), transList);
            this.population.get(i).calculateFitness(k, transList);
            if (this.population.get((int)i).fitness > this.pBest.get((int)i).fitness) {
                this.pBest.get(i).copyParticle(this.population.get(i));
                if (this.pBest.get((int)i).fitness > this.gBest.fitness) {
                    this.gBest.copyParticle(this.pBest.get(i));
                }
            }
            if (this.population.get((int)i).fitness < minUtility) continue;
            this.insert(this.population.get(i));
            this.addHuiBA(this.population.get(i));
        }
    }

    boolean pev_Check(Particle tempBAIndividual, List<Integer> list) {
        ArrayList<Integer> templist = new ArrayList<Integer>();
        for (int i = 0; i < tempBAIndividual.X.length(); ++i) {
            if (!tempBAIndividual.X.get(i)) continue;
            templist.add(i);
        }
        if (templist.size() == 0) {
            return false;
        }
        BitSet tempBitSet = new BitSet(this.transactionCount);
        BitSet midBitSet = new BitSet(this.transactionCount);
        tempBitSet = (BitSet)this.Items.get((int)((Integer)templist.get((int)0)).intValue()).TIDS.clone();
        midBitSet = (BitSet)tempBitSet.clone();
        for (int i = 1; i < templist.size(); ++i) {
            tempBitSet.and(this.Items.get((int)((Integer)templist.get((int)i)).intValue()).TIDS);
            if (tempBitSet.cardinality() != 0) {
                midBitSet = (BitSet)tempBitSet.clone();
                continue;
            }
            tempBitSet = (BitSet)midBitSet.clone();
            tempBAIndividual.X.clear((Integer)templist.get(i));
        }
        if (tempBitSet.cardinality() == 0) {
            return false;
        }
        for (int m = 0; m < tempBitSet.length(); ++m) {
            if (!tempBitSet.get(m)) continue;
            list.add(m);
        }
        return true;
    }

    private List<Integer> bitDiff(Particle gBest, Particle tempBAIndividual) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        BitSet tmpBitSet = (BitSet)gBest.X.clone();
        tmpBitSet.xor(tempBAIndividual.X);
        for (int i = 0; i < tmpBitSet.length(); ++i) {
            if (!tmpBitSet.get(i)) continue;
            list.add(i);
        }
        return list;
    }

    private void addHuiBA(Particle tempBAIndividual) {
        Particle tmpBAIndividual = new Particle();
        tmpBAIndividual.copyParticle(tempBAIndividual);
        if (this.huiBA.size() != 0) {
            for (int i = 0; i < this.huiBA.size(); ++i) {
                BitSet tmpBitSet = (BitSet)tmpBAIndividual.X.clone();
                tmpBitSet.xor(this.huiBA.get((int)i).X);
                if (tmpBitSet.cardinality() != 0) continue;
                return;
            }
        }
        this.huiBA.add(tmpBAIndividual);
    }

    private List<Double> roulettePercentHUIBA() {
        int i;
        double sum = 0.0;
        double tempsum = 0.0;
        double percent = 0.0;
        ArrayList<Double> percentHUIBA = new ArrayList<Double>();
        for (i = 0; i < this.huiBA.size(); ++i) {
            sum += (double)this.huiBA.get((int)i).fitness;
        }
        for (i = 0; i < this.huiBA.size(); ++i) {
            percent = (tempsum += (double)this.huiBA.get((int)i).fitness) / sum;
            percentHUIBA.add(percent);
        }
        return percentHUIBA;
    }

    private int rouletteSelectHUIBA(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        for (int i = 0; i < percentage.size(); ++i) {
            if (i == 0) {
                if (!(randNum >= 0.0) || !(randNum <= percentage.get(0))) continue;
                temp = 0;
                break;
            }
            if (!(randNum > percentage.get(i - 1)) || !(randNum <= percentage.get(i))) continue;
            temp = i;
            break;
        }
        return temp;
    }

    private void insert(Particle tempParticle) {
        int i;
        StringBuilder temp = new StringBuilder();
        for (i = 0; i < this.twuPattern.size(); ++i) {
            if (!tempParticle.X.get(i)) continue;
            temp.append(this.twuPattern.get(i));
            temp.append(' ');
        }
        if (temp.length() == 0) {
            return;
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
        } else {
            for (i = 0; i < this.huiSets.size() && !temp.toString().equals(this.huiSets.get((int)i).itemset); ++i) {
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
            }
        }
    }

    private List<Double> roulettePercent() {
        int i;
        double sum = 0.0;
        double tempSum = 0.0;
        for (i = 0; i < this.twuPattern.size(); ++i) {
            sum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue();
        }
        for (i = 0; i < this.twuPattern.size(); ++i) {
            double tempPercent = (tempSum += (double)this.mapItemToTWU.get(this.twuPattern.get(i)).intValue()) / (sum + 0.0);
            this.percentage.add(tempPercent);
        }
        return this.percentage;
    }

    private int rouletteSelect(List<Double> percentage) {
        int temp = 0;
        double randNum = Math.random();
        for (int i = 0; i < percentage.size(); ++i) {
            if (i == 0) {
                if (!(randNum >= 0.0) || !(randNum <= percentage.get(0))) continue;
                temp = 0;
                break;
            }
            if (!(randNum > percentage.get(i - 1)) || !(randNum <= percentage.get(i))) continue;
            temp = i;
            break;
        }
        return temp;
    }

    private void writeOut() throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.huiSets.size(); ++i) {
            buffer.append(this.huiSets.get((int)i).itemset);
            buffer.append("#UTIL: ");
            buffer.append(this.huiSets.get((int)i).fitness);
            if (i == this.huiSets.size() - 1) continue;
            buffer.append(System.lineSeparator());
        }
        this.writer.write(buffer.toString());
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HUIF-PSO ALGORITHM v.2.11 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiSets.size());
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }

    class Item {
        int item;
        BitSet TIDS;

        public Item() {
            this.TIDS = new BitSet(AlgoBio_HUIF_PSO.this.database.size());
        }

        public Item(int item) {
            this.TIDS = new BitSet(AlgoBio_HUIF_PSO.this.database.size());
            this.item = item;
        }
    }

    class Particle {
        BitSet X;
        int fitness;

        Particle() {
            this.X = new BitSet(AlgoBio_HUIF_PSO.this.twuPattern.size());
            this.fitness = 0;
        }

        Particle(int length) {
            this.X = new BitSet(length);
            this.fitness = 0;
        }

        void copyParticle(Particle particle1) {
            this.X = (BitSet)particle1.X.clone();
            this.fitness = particle1.fitness;
        }

        void calculateFitness(int k, List<Integer> templist) {
            if (k == 0) {
                return;
            }
            int fitness = 0;
            for (int m = 0; m < templist.size(); ++m) {
                int p = templist.get(m);
                int i = 0;
                int q = 0;
                int temp = 0;
                int sum = 0;
                while (q < AlgoBio_HUIF_PSO.this.database.get(p).size() && i < this.X.length()) {
                    if (this.X.get(i)) {
                        if (AlgoBio_HUIF_PSO.this.database.get((int)p).get((int)q).item == AlgoBio_HUIF_PSO.this.twuPattern.get(i)) {
                            sum += AlgoBio_HUIF_PSO.this.database.get((int)p).get((int)q).utility;
                            ++i;
                            ++q;
                            ++temp;
                            continue;
                        }
                        ++q;
                        continue;
                    }
                    ++i;
                }
                if (temp != k) continue;
                fitness += sum;
            }
            this.fitness = fitness;
        }
    }

    class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }
}

