/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.chud;

import ca.pfv.spmf.algorithms.frequentpatterns.chud.AlgoCHUD_Phase1;
import ca.pfv.spmf.algorithms.frequentpatterns.chud.AlgoCHUD_Phase2;
import ca.pfv.spmf.algorithms.frequentpatterns.chud.AlgoConvertToVerticalDatabase;
import java.io.File;
import java.io.IOException;

public class AlgoCHUD {
    private int maximumNumberOfTransactions = Integer.MAX_VALUE;
    private double totalTime = 0.0;
    private double patternCount = 0.0;
    private double totalMemory = 0.0;
    private boolean DEBUG = false;

    public void runAlgorithm(String dataset, String output, int minUtility) throws IOException {
        File out2;
        String vertical = dataset + "_vertical.txt";
        String vertical2 = dataset + "_vertical2.txt";
        String vertical3 = dataset + "_vertical3.txt";
        File file = new File(vertical);
        if (!file.exists()) {
            AlgoConvertToVerticalDatabase converter = new AlgoConvertToVerticalDatabase();
            converter.setMaxNumberOfTransactions(this.maximumNumberOfTransactions);
            converter.run(dataset, vertical, vertical2, vertical3);
            if (this.DEBUG) {
                System.out.println("FINISHED CONVERTING DATABASE TO VERTICAL FORMAT");
                System.out.println("Time conversion: " + converter.totaltime / 1000L + "s   (" + converter.totaltime + " ms)");
            }
        }
        String outputPhase1 = output + "_phase1.txt";
        File out1 = new File(outputPhase1);
        out1.delete();
        long startTime = System.currentTimeMillis();
        if (this.DEBUG) {
            System.out.println("PHASE 1 of CHUD");
        }
        AlgoCHUD_Phase1 phase1 = new AlgoCHUD_Phase1();
        phase1.runAlgorithm(minUtility, vertical, vertical2, vertical3, outputPhase1);
        if (this.DEBUG) {
            System.out.println("Number of transactions : " + this.maximumNumberOfTransactions);
            System.out.println("Time phase1: " + phase1.totaltime / 1000L + "s   (" + phase1.totaltime + " ms)");
            System.out.println("Closed candidates : " + phase1.closedCount);
            System.out.println("Max memory : " + phase1.maxMemory);
            System.out.println("-------------------------");
        }
        if (this.DEBUG) {
            System.out.println("PHASE 2 of CHUD");
        }
        for (int i = 1; i < 100 && (out2 = new File("L" + i + ".txt")).exists(); ++i) {
            out2.delete();
        }
        AlgoCHUD_Phase2 phase2 = new AlgoCHUD_Phase2();
        phase2.setMaxNumberOfTransactions(this.maximumNumberOfTransactions);
        phase2.runAlgorithm(dataset, outputPhase1, output, minUtility, true);
        if (this.DEBUG) {
            System.out.println("Time phase2: " + phase2.totaltime / 1000L + "s   (" + phase2.totaltime + " ms)");
            System.out.println("Closed HUI: " + phase2.huiCount);
            System.out.println("Max memory : " + phase2.maxMemory);
            System.out.println("-------------------------");
            System.out.println("=========== CHUD RESULTS========");
        }
        this.totalMemory = phase1.maxMemory > phase2.maxMemory ? phase1.maxMemory : phase2.maxMemory;
        this.totalTime = System.currentTimeMillis() - startTime;
        this.patternCount = phase2.huiCount;
        file = new File(vertical);
        file.delete();
        file = new File(vertical2);
        file.delete();
        file = new File(vertical3);
        file.delete();
        file = new File(outputPhase1);
        file.delete();
    }

    public void setMaxNumberOfTransactions(int maximumNumberOfTransactions) {
        this.maximumNumberOfTransactions = maximumNumberOfTransactions;
    }

    public void printStats() {
        System.out.println("=============  CHUD v.2.26 - STATS =============");
        System.out.println("Total execution time : " + this.totalTime);
        System.out.println("Max memory usage: " + this.totalMemory + " MB");
        System.out.println("Closed high utility itemset count: " + this.patternCount);
        System.out.println("===================================================");
    }
}

