/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.chud;

import ca.pfv.spmf.algorithms.frequentpatterns.chud.TransactionTP;
import ca.pfv.spmf.algorithms.frequentpatterns.chud.UtilityTransactionDatabaseTP;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;

class AlgoCHUD_Phase2 {
    private long startTimestamp = 0L;
    protected long totaltime = 0L;
    protected int huiCount = 0;
    protected double maxMemory = 0.0;
    private int maximumNumberOfTransactions = Integer.MAX_VALUE;

    public void runAlgorithm(String path, String filePathPhase1, String filePathOutput, int minUtility, boolean phase2SaveHUIsInOneFile) throws IOException {
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        UtilityTransactionDatabaseTP db = new UtilityTransactionDatabaseTP();
        db.loadFile(path);
        BufferedReader reader = new BufferedReader(new FileReader(filePathPhase1));
        boolean level = true;
        BufferedWriter writer = new BufferedWriter(new FileWriter(filePathOutput));
        String line = reader.readLine();
        int tidcount = 0;
        while (line != null && line.length() > 2) {
            String[] lineSplited = line.split(":");
            String[] itemsetStr = lineSplited[0].split(" ");
            int[] itemset2 = new int[itemsetStr.length];
            for (int i = 0; i < itemsetStr.length; ++i) {
                itemset2[i] = Integer.parseInt(itemsetStr[i]);
            }
            String[] tidsetStr = lineSplited[1].split(" ");
            int utility = 0;
            Arrays.sort(itemset2);
            for (int i = 0; i < tidsetStr.length; ++i) {
                int tid = Integer.parseInt(tidsetStr[i]);
                TransactionTP transaction = db.getTransactions().get(tid);
                int pos = 0;
                for (int j = 0; j < itemset2.length; ++j) {
                    while (itemset2[j] != transaction.getItems().get(pos)) {
                        ++pos;
                    }
                    utility += transaction.getItemsUtilities().get(pos).intValue();
                    ++pos;
                }
            }
            line = reader.readLine();
            if (utility >= minUtility) {
                ++this.huiCount;
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < itemset2.length; ++i) {
                    buffer.append(itemset2[i]);
                    if (i == itemset2.length - 1) continue;
                    buffer.append(' ');
                }
                buffer.append(" #UTIL: ");
                buffer.append(utility);
                writer.write(buffer.toString());
                if (line != null) {
                    writer.newLine();
                }
            }
            MemoryLogger.getInstance().checkMemory();
            if (++tidcount != this.maximumNumberOfTransactions) continue;
            break;
        }
        reader.close();
        writer.close();
        this.totaltime = System.currentTimeMillis() - this.startTimestamp;
        this.maxMemory = MemoryLogger.getInstance().getMaxMemory();
    }

    public void setMaxNumberOfTransactions(int maximumNumberOfTransactions) {
        this.maximumNumberOfTransactions = maximumNumberOfTransactions;
    }
}

