/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.chud;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class AlgoConvertToVerticalDatabase {
    protected long totaltime = 0L;
    private int maximumNumberOfTransactions = Integer.MAX_VALUE;

    public void run(String input, String vertical, String vertical2, String vertical3) throws IOException {
        String line;
        this.totaltime = System.currentTimeMillis();
        int maxItem = -1;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, ItemStructure> mapStructures = new HashMap<Integer, ItemStructure>();
        HashMap<Integer, Integer> mapTidTU = new HashMap<Integer, Integer>();
        int tidcount = 0;
        while ((line = reader.readLine()) != null) {
            String[] lineSplited = line.split(":");
            int transactionUtility = Integer.parseInt(lineSplited[1]);
            mapTidTU.put(tidcount, transactionUtility);
            String[] transactionItems = lineSplited[0].split(" ");
            String[] transactionItemsUtility = lineSplited[2].split(" ");
            for (int i = 0; i < transactionItems.length; ++i) {
                int itemValue = Integer.parseInt(transactionItems[i]);
                ItemStructure structure = (ItemStructure)mapStructures.get(itemValue);
                if (structure == null) {
                    structure = new ItemStructure();
                    structure.item = itemValue;
                    if (itemValue > maxItem) {
                        maxItem = itemValue;
                    }
                    mapStructures.put(itemValue, structure);
                }
                structure.tidset.add(tidcount);
                structure.utilitiesForEachTid.add(Integer.parseInt(transactionItemsUtility[i]));
            }
            if (++tidcount != this.maximumNumberOfTransactions) continue;
            break;
        }
        reader.close();
        ArrayList listItems = new ArrayList(mapStructures.keySet());
        Collections.sort(listItems);
        BufferedWriter writer = new BufferedWriter(new FileWriter(vertical));
        for (Integer item : listItems) {
            ItemStructure structure = (ItemStructure)mapStructures.get(item);
            StringBuilder buffer = new StringBuilder();
            buffer.append(structure.item);
            buffer.append(":");
            Iterator<Integer> iterTIDS = structure.tidset.iterator();
            while (iterTIDS.hasNext()) {
                buffer.append(iterTIDS.next());
                if (!iterTIDS.hasNext()) break;
                buffer.append(' ');
            }
            buffer.append(":");
            Iterator<Integer> iterTIDUtility = structure.utilitiesForEachTid.iterator();
            while (iterTIDUtility.hasNext()) {
                buffer.append(iterTIDUtility.next());
                if (!iterTIDUtility.hasNext()) break;
                buffer.append(' ');
            }
            writer.write(buffer.toString());
            writer.newLine();
        }
        writer.flush();
        writer.close();
        BufferedWriter writer2 = new BufferedWriter(new FileWriter(vertical2));
        Iterator iterEntries = mapTidTU.entrySet().iterator();
        while (iterEntries.hasNext()) {
            Map.Entry entry = iterEntries.next();
            if (iterEntries.hasNext()) {
                writer2.write(entry.getKey() + ":" + entry.getValue());
                writer2.newLine();
                continue;
            }
            writer2.write(entry.getKey() + ":" + entry.getValue());
            break;
        }
        writer2.close();
        BufferedWriter writer3 = new BufferedWriter(new FileWriter(vertical3));
        writer3.write(tidcount + "\n");
        writer3.write(maxItem + "\n");
        writer3.write(mapStructures.keySet().size() + "\n");
        writer3.close();
        this.totaltime = System.currentTimeMillis() - this.totaltime;
    }

    public void setMaxNumberOfTransactions(int maximumNumberOfTransactions) {
        this.maximumNumberOfTransactions = maximumNumberOfTransactions;
    }

    static class ItemStructure {
        public int item = 0;
        public List<Integer> tidset = new ArrayList<Integer>();
        public List<Integer> utilitiesForEachTid = new ArrayList<Integer>();

        ItemStructure() {
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            ItemStructure itemS2 = (ItemStructure)obj;
            if (itemS2.item == this.item) {
                return true;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            String hash = "" + this.item;
            return hash.hashCode();
        }
    }
}

