/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.d2hup;

import ca.pfv.spmf.algorithms.ItemNameConverter;
import ca.pfv.spmf.algorithms.frequentpatterns.d2hup.Cell;
import ca.pfv.spmf.algorithms.frequentpatterns.d2hup.Pointer;
import ca.pfv.spmf.algorithms.frequentpatterns.d2hup.Row;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoD2HUP {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int huiCount = 0;
    int case1count = 0;
    int case2count = 0;
    BufferedWriter writer = null;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    boolean DEBUG = false;
    Cell[] cells;
    int minUtility = 0;
    private Map<Integer, Row> mapItemRow;
    ItemNameConverter nameConverter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.itemsetBuffer = new int[200];
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.minUtility = minUtility;
        final HashMap<Integer, Integer> mapItemToTWU = new HashMap<Integer, Integer>();
        this.case1count = 0;
        this.case2count = 0;
        BufferedReader myInput = null;
        int itemOccurrencesCount = 0;
        int transactionCount = 0;
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer twu = (Integer)mapItemToTWU.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    mapItemToTWU.put(item, twu);
                    ++itemOccurrencesCount;
                }
                ++transactionCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        ArrayList<Row> rowList = new ArrayList<Row>();
        this.mapItemRow = new HashMap<Integer, Row>();
        this.cells = new Cell[transactionCount + itemOccurrencesCount];
        for (Integer item : mapItemToTWU.keySet()) {
            int twu = (Integer)mapItemToTWU.get(item);
            if (twu < minUtility) continue;
            Row rowItem = new Row(item);
            rowItem.ltwu = twu;
            rowList.add(rowItem);
            this.mapItemRow.put(item, rowItem);
        }
        Collections.sort(rowList, new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                int compare = (Integer)mapItemToTWU.get(o1.item) - (Integer)mapItemToTWU.get(o2.item);
                return compare == 0 ? o1.item - o2.item : compare;
            }
        });
        this.nameConverter = new ItemNameConverter(rowList.size());
        for (Row row : rowList) {
            row.item = this.nameConverter.assignNewName(row.item);
        }
        this.cells[0] = null;
        int currentCellIndex = 0;
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                Cell cell;
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                int remainingUtility = 0;
                int transactionBegin = currentCellIndex;
                for (int i = 0; i < items.length; ++i) {
                    int item = Integer.parseInt(items[i]);
                    if ((Integer)mapItemToTWU.get(item) < minUtility) continue;
                    cell = new Cell();
                    cell.utility = Integer.parseInt(utilityValues[i]);
                    cell.item = this.nameConverter.toNewName(item);
                    this.cells[currentCellIndex++] = cell;
                    remainingUtility += cell.utility;
                }
                int transactionEnd = currentCellIndex - 1;
                Arrays.sort(this.cells, transactionBegin, transactionEnd + 1, new Comparator<Cell>(){

                    @Override
                    public int compare(Cell o1, Cell o2) {
                        return o1.item - o2.item;
                    }
                });
                this.cells[currentCellIndex++] = null;
                for (int i = transactionBegin; i <= transactionEnd; ++i) {
                    cell = this.cells[i];
                    Row row = this.mapItemRow.get(this.nameConverter.toOldName(cell.item));
                    ++row.support;
                    row.utility += cell.utility;
                    row.rutil += (remainingUtility -= cell.utility);
                    row.pointers.add(new Pointer(0, i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        if (this.DEBUG) {
            System.out.println("------ INITIAL CAUL -----");
            System.out.println("The cell list:");
            for (int i = 1; i < this.cells.length; ++i) {
                Cell cell = this.cells[i];
                if (cell == null) {
                    System.out.println("|");
                    continue;
                }
                System.out.print(cell);
            }
            System.out.println("The table:");
            for (Row row : rowList) {
                System.out.print(row);
                System.out.print("[the items:");
                for (Pointer pointer : row.pointers) {
                    System.out.print(this.cells[pointer.pos].item + " ");
                }
                System.out.println();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.d2hup(this.itemsetBuffer, 0, rowList, transactionCount, 0);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    private void d2hup(int[] prefix, int prefixLength, List<Row> rowList, int prefixSupport, int prefixUtility) throws IOException {
        if (this.DEBUG) {
            System.out.print(" prefix : ");
            for (int i = 0; i < prefixLength; ++i) {
                System.out.print(" " + prefix[i]);
            }
            System.out.println();
        }
        boolean allPromisingItemsHaveSameSupportAsPrefix = true;
        boolean allPromisingItemAreHighUtility = true;
        for (Row row : rowList) {
            if (row.utility >= this.minUtility) continue;
            allPromisingItemAreHighUtility = false;
            break;
        }
        for (Row row : rowList) {
            if (row.support == prefixSupport) continue;
            allPromisingItemsHaveSameSupportAsPrefix = false;
            break;
        }
        if (allPromisingItemsHaveSameSupportAsPrefix && allPromisingItemAreHighUtility) {
            long l = 1 << rowList.size();
            for (long i = 1L; i < l; ++i) {
                int n = prefixLength;
                int utility = prefixUtility;
                for (int j = 0; j < rowList.size(); ++j) {
                    int isSet = (int)i & 1 << j;
                    if (isSet <= 0) continue;
                    this.itemsetBuffer[n++] = rowList.get((int)j).item;
                    utility += rowList.get((int)j).utility - prefixUtility;
                }
                this.writeOut(prefix, n, utility);
            }
            ++this.case1count;
            return;
        }
        if (allPromisingItemsHaveSameSupportAsPrefix) {
            void var9_17;
            int delta = Integer.MAX_VALUE;
            for (Row row : rowList) {
                int subtraction = row.utility - prefixUtility;
                if (subtraction >= delta) continue;
                delta = subtraction;
            }
            int n = prefixUtility;
            for (Row row : rowList) {
                var9_17 += row.utility - prefixUtility;
            }
            if (this.minUtility <= var9_17 && var9_17 < this.minUtility + delta) {
                void var10_23;
                ++this.case2count;
                int n2 = prefixLength;
                for (Row row : rowList) {
                    prefix[++var10_23] = row.item;
                }
                this.writeOut(prefix, (int)var10_23, (int)var9_17);
                return;
            }
        }
        for (Row row : rowList) {
            if (row.utility >= this.minUtility) {
                this.writeOut(prefix, prefixLength, row.item, row.utility);
            }
            if (row.utility + row.rutil < this.minUtility) continue;
            ArrayList<Row> arrayList = new ArrayList<Row>();
            this.mapItemRow.clear();
            for (Pointer pointer : row.pointers) {
                int transactionBegin = pointer.pos;
                int newPrefixRowUtility = pointer.prefixUtility + this.cells[pointer.pos].utility;
                if (this.cells[++transactionBegin] == null) continue;
                int transactionEnd = -1;
                int rtwu = 0;
                int pos = transactionBegin;
                while (true) {
                    if (this.cells[pos] == null) break;
                    rtwu += this.cells[pos].utility;
                    ++pos;
                }
                transactionEnd = pos - 1;
                int remainingUtility = rtwu;
                for (int pos2 = transactionBegin; pos2 <= transactionEnd; ++pos2) {
                    Cell cell = this.cells[pos2];
                    Row rowItem = this.mapItemRow.get(cell.item);
                    if (rowItem == null) {
                        rowItem = new Row(cell.item);
                        this.mapItemRow.put(cell.item, rowItem);
                    }
                    ++rowItem.support;
                    rowItem.utility += newPrefixRowUtility + cell.utility;
                    rowItem.ltwu += rtwu;
                    Pointer newPointer = new Pointer(newPrefixRowUtility, pos2);
                    rowItem.pointers.add(newPointer);
                    rowItem.rutil += (remainingUtility -= cell.utility);
                }
            }
            for (Map.Entry entry : this.mapItemRow.entrySet()) {
                Row currentRow = (Row)entry.getValue();
                if (row.utility + currentRow.ltwu < this.minUtility) continue;
                arrayList.add(currentRow);
            }
            Collections.sort(arrayList, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    return o1.item - o2.item;
                }
            });
            this.itemsetBuffer[prefixLength] = row.item;
            this.d2hup(this.itemsetBuffer, prefixLength + 1, arrayList, row.support, row.utility);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void writeOut(int[] prefix, int prefixLength, int item, int utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            buffer.append(this.nameConverter.toOldName(prefix[i]));
            buffer.append(' ');
        }
        buffer.append(this.nameConverter.toOldName(item));
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void writeOut(int[] prefix, int prefixLength, int utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            buffer.append(this.nameConverter.toOldName(prefix[i]));
            buffer.append(' ');
        }
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  D2HUP ALGORITHM v97- STATS =============");
        System.out.println(" Case1 count: " + this.case1count + " | Case2 count: " + this.case2count);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println("===================================================");
    }
}

