/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.eclat;

import ca.pfv.spmf.algorithms.frequentpatterns.eclat.AlgoEclat_Bitset;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.util.BitSet;
import java.util.Map;

public class AlgoDEclat_Bitset
extends AlgoEclat_Bitset {
    @Override
    public void printStats() {
        System.out.println("=============  DECLAT vALTERNATE-Bitset v0.96r18- STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Frequent itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }

    @Override
    int calculateSupportSingleItems(TransactionDatabase database, Map<Integer, AlgoEclat_Bitset.BitSetSupport> mapItemTIDS) {
        int maxItemId = 0;
        for (int i = 0; i < database.size(); ++i) {
            for (Integer item : database.getTransactions().get(i)) {
                AlgoEclat_Bitset.BitSetSupport tids = mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new AlgoEclat_Bitset.BitSetSupport(this);
                    tids.bitset.set(0, database.size(), true);
                    mapItemTIDS.put(item, tids);
                    if (item > maxItemId) {
                        maxItemId = item;
                    }
                }
                tids.bitset.set(i, false);
                ++tids.support;
            }
        }
        return maxItemId;
    }

    @Override
    AlgoEclat_Bitset.BitSetSupport performAND(AlgoEclat_Bitset.BitSetSupport tidsetI, AlgoEclat_Bitset.BitSetSupport tidsetJ) {
        AlgoEclat_Bitset.BitSetSupport bitsetSupportIJ = new AlgoEclat_Bitset.BitSetSupport(this);
        bitsetSupportIJ.bitset = (BitSet)tidsetJ.bitset.clone();
        bitsetSupportIJ.bitset.andNot(tidsetI.bitset);
        bitsetSupportIJ.support = tidsetI.support - bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }

    @Override
    AlgoEclat_Bitset.BitSetSupport performANDFirstTime(AlgoEclat_Bitset.BitSetSupport tidsetI, AlgoEclat_Bitset.BitSetSupport tidsetJ, int supportIJ) {
        AlgoEclat_Bitset.BitSetSupport bitsetSupportIJ = new AlgoEclat_Bitset.BitSetSupport(this);
        bitsetSupportIJ.bitset = (BitSet)tidsetJ.bitset.clone();
        bitsetSupportIJ.bitset.andNot(tidsetI.bitset);
        bitsetSupportIJ.support = tidsetI.support - bitsetSupportIJ.bitset.cardinality();
        return bitsetSupportIJ;
    }
}

