/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.efim;

import ca.pfv.spmf.algorithms.frequentpatterns.efim.Transaction;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Dataset {
    List<Transaction> transactions = new ArrayList<Transaction>();
    private int maxItem = 0;

    public Dataset(String datasetPath, int maximumTransactionCount) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(datasetPath));
        int i = 0;
        while ((line = br.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            this.transactions.add(this.createTransaction(line));
            if (++i != maximumTransactionCount) continue;
        }
        System.out.println("Transaction count :" + this.transactions.size());
        br.close();
    }

    private Transaction createTransaction(String line) {
        String[] split = line.split(":");
        int transactionUtility = Integer.parseInt(split[1]);
        String[] itemsString = split[0].split(" ");
        String[] itemsUtilitiesString = split[2].split(" ");
        int[] items = new int[itemsString.length];
        int[] utilities = new int[itemsString.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = Integer.parseInt(itemsString[i]);
            utilities[i] = Integer.parseInt(itemsUtilitiesString[i]);
            if (items[i] <= this.maxItem) continue;
            this.maxItem = items[i];
        }
        return new Transaction(items, utilities, transactionUtility);
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public int getMaxItem() {
        return this.maxItem;
    }

    public String toString() {
        StringBuilder datasetContent = new StringBuilder();
        for (Transaction transaction : this.transactions) {
            datasetContent.append(transaction.toString());
            datasetContent.append("\n");
        }
        return datasetContent.toString();
    }
}

