/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.efim;

public class Transaction {
    public static int[] tempItems = new int[2000];
    public static int[] tempUtilities = new int[2000];
    int offset;
    int[] items;
    int[] utilities;
    int transactionUtility;
    int prefixUtility;

    public Transaction(int[] items, int[] utilities, int transactionUtility) {
        this.items = items;
        this.utilities = utilities;
        this.transactionUtility = transactionUtility;
        this.offset = 0;
        this.prefixUtility = 0;
    }

    public Transaction(Transaction transaction, int offsetE) {
        this.items = transaction.getItems();
        this.utilities = transaction.getUtilities();
        int utilityE = this.utilities[offsetE];
        this.prefixUtility = transaction.prefixUtility + utilityE;
        this.transactionUtility = transaction.transactionUtility - utilityE;
        for (int i = transaction.offset; i < offsetE; ++i) {
            this.transactionUtility -= transaction.utilities[i];
        }
        this.offset = offsetE + 1;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = this.offset; i < this.items.length; ++i) {
            buffer.append(this.items[i]);
            buffer.append("[");
            buffer.append(this.utilities[i]);
            buffer.append("] ");
        }
        buffer.append(" Remaining Utility:" + this.transactionUtility);
        buffer.append(" Prefix Utility:" + this.prefixUtility);
        return buffer.toString();
    }

    public int[] getItems() {
        return this.items;
    }

    public int[] getUtilities() {
        return this.utilities;
    }

    public int getLastPosition() {
        return this.items.length - 1;
    }

    public void removeUnpromisingItems(int[] oldNamesToNewNames) {
        int i = 0;
        for (int j = 0; j < this.items.length; ++j) {
            int item = this.items[j];
            int newName = oldNamesToNewNames[item];
            if (newName != 0) {
                Transaction.tempItems[i] = newName;
                Transaction.tempUtilities[i] = this.utilities[j];
                ++i;
                continue;
            }
            this.transactionUtility -= this.utilities[j];
        }
        this.items = new int[i];
        System.arraycopy(tempItems, 0, this.items, 0, i);
        this.utilities = new int[i];
        System.arraycopy(tempUtilities, 0, this.utilities, 0, i);
        Transaction.insertionSort(this.items, this.utilities);
    }

    public static void insertionSort(int[] items, int[] utitilies) {
        for (int j = 1; j < items.length; ++j) {
            int itemJ = items[j];
            int utilityJ = utitilies[j];
            for (int i = j - 1; i >= 0 && items[i] > itemJ; --i) {
                items[i + 1] = items[i];
                utitilies[i + 1] = utitilies[i];
            }
            items[i + 1] = itemJ;
            utitilies[i + 1] = utilityJ;
        }
    }
}

