/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.efim_closed;

import ca.pfv.spmf.algorithms.frequentpatterns.efim_closed.Dataset;
import ca.pfv.spmf.algorithms.frequentpatterns.efim_closed.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.efim_closed.Itemsets;
import ca.pfv.spmf.algorithms.frequentpatterns.efim_closed.Transaction;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AlgoEFIMClosed {
    private Itemsets highUtilityItemsets;
    BufferedWriter writer = null;
    private int patternCount;
    long startTimestamp;
    long endTimestamp;
    int minUtil;
    final boolean DEBUG = false;
    private int[] utilityBinArraySU;
    private int[] utilityBinArrayLU;
    private int[] utilityBinArraySupport;
    private int[] temp = new int[500];
    int[] oldNameToNewNames;
    int[] newNamesToOldNames;
    int newItemCount;
    boolean activateTransactionMerging;
    final int MAXIMUM_SIZE_MERGING = 1000;
    long transactionReadingCount;
    long mergeCount;
    private long candidateCount;
    private boolean activateSubtreeUtilityPruning;
    private boolean activateClosedPatternJumping;

    public Itemsets runAlgorithm(int minUtil, String inputPath, String outputPath, boolean activateTransactionMerging, int maximumTransactionCount, boolean activateSubtreeUtilityPruning, boolean activateClosedPatternJump) throws IOException {
        this.mergeCount = 0L;
        this.transactionReadingCount = 0L;
        this.activateTransactionMerging = activateTransactionMerging;
        this.activateSubtreeUtilityPruning = activateSubtreeUtilityPruning;
        this.activateClosedPatternJumping = activateClosedPatternJump;
        this.startTimestamp = System.currentTimeMillis();
        Dataset dataset = new Dataset(inputPath, maximumTransactionCount);
        this.minUtil = minUtil;
        if (outputPath != null) {
            this.writer = new BufferedWriter(new FileWriter(outputPath));
        } else {
            this.writer = null;
            this.highUtilityItemsets = new Itemsets("Itemsets");
        }
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.useUtilityBinArrayToCalculateLocalUtilityFirstTime(dataset);
        ArrayList<Integer> itemsToKeep = new ArrayList<Integer>();
        for (int j = 1; j < this.utilityBinArrayLU.length; ++j) {
            if (this.utilityBinArrayLU[j] < minUtil) continue;
            itemsToKeep.add(j);
        }
        AlgoEFIMClosed.insertionSort(itemsToKeep, this.utilityBinArrayLU);
        this.oldNameToNewNames = new int[dataset.getMaxItem() + 1];
        this.newNamesToOldNames = new int[dataset.getMaxItem() + 1];
        int currentName = 1;
        for (int j = 0; j < itemsToKeep.size(); ++j) {
            int item = (Integer)itemsToKeep.get(j);
            this.oldNameToNewNames[item] = currentName;
            this.newNamesToOldNames[currentName] = item;
            itemsToKeep.set(j, currentName);
            ++currentName;
        }
        this.newItemCount = itemsToKeep.size();
        this.utilityBinArraySU = new int[this.newItemCount + 1];
        if (activateClosedPatternJump) {
            this.utilityBinArraySupport = new int[this.newItemCount + 1];
        }
        for (int i = 0; i < dataset.getTransactions().size(); ++i) {
            Transaction transaction = dataset.getTransactions().get(i);
            transaction.removeUnpromisingItems(this.oldNameToNewNames);
        }
        if (activateTransactionMerging) {
            Collections.sort(dataset.getTransactions(), new Comparator<Transaction>(){

                @Override
                public int compare(Transaction t1, Transaction t2) {
                    int pos2;
                    int pos1 = t1.items.length - 1;
                    if (t1.items.length < t2.items.length) {
                        while (pos1 >= 0) {
                            int subtraction = t2.items[pos2] - t1.items[pos1];
                            if (subtraction != 0) {
                                return subtraction;
                            }
                            --pos1;
                            --pos2;
                        }
                        return -1;
                    }
                    if (t1.items.length > t2.items.length) {
                        for (pos2 = t2.items.length - 1; pos2 >= 0; --pos2) {
                            int subtraction = t2.items[pos2] - t1.items[pos1];
                            if (subtraction != 0) {
                                return subtraction;
                            }
                            --pos1;
                        }
                        return 1;
                    }
                    while (pos2 >= 0) {
                        int subtraction = t2.items[pos2] - t1.items[pos1];
                        if (subtraction != 0) {
                            return subtraction;
                        }
                        --pos1;
                        --pos2;
                    }
                    return 0;
                }
            });
            int emptyTransactionCount = 0;
            for (int i = 0; i < dataset.getTransactions().size(); ++i) {
                Transaction transaction = dataset.getTransactions().get(i);
                if (transaction.items.length != 0) continue;
                ++emptyTransactionCount;
            }
            dataset.transactions = dataset.transactions.subList(emptyTransactionCount, dataset.transactions.size());
        }
        this.useUtilityBinArrayToCalculateSubtreeUtilityFirstTime(dataset);
        ArrayList<Integer> itemsToExplore = new ArrayList<Integer>();
        if (activateSubtreeUtilityPruning) {
            for (Integer item : itemsToKeep) {
                if (this.utilityBinArraySU[item] < minUtil) continue;
                itemsToExplore.add(item);
            }
        }
        if (activateSubtreeUtilityPruning) {
            this.backtrackingEFIM(dataset.getTransactions(), itemsToKeep, itemsToExplore, 0);
        } else {
            this.backtrackingEFIM(dataset.getTransactions(), itemsToKeep, itemsToKeep, 0);
        }
        this.endTimestamp = System.currentTimeMillis();
        if (this.writer != null) {
            this.writer.close();
        }
        MemoryLogger.getInstance().checkMemory();
        return this.highUtilityItemsets;
    }

    public static void insertionSort(List<Integer> items, int[] utilityBinArrayTWU) {
        for (int j = 1; j < items.size(); ++j) {
            Integer itemJ = items.get(j);
            int i = j - 1;
            Integer itemI = items.get(i);
            int comparison = utilityBinArrayTWU[itemI] - utilityBinArrayTWU[itemJ];
            if (comparison == 0) {
                comparison = itemI - itemJ;
            }
            while (comparison > 0) {
                items.set(i + 1, itemI);
                if (--i < 0) break;
                itemI = items.get(i);
                comparison = utilityBinArrayTWU[itemI] - utilityBinArrayTWU[itemJ];
                if (comparison != 0) continue;
                comparison = itemI - itemJ;
            }
            items.set(i + 1, itemJ);
        }
    }

    private int backtrackingEFIM(List<Transaction> transactionsOfP, List<Integer> itemsToKeep, List<Integer> itemsToExplore, int prefixLength) throws IOException {
        int maxSupport = 0;
        for (int j = 0; j < itemsToExplore.size(); ++j) {
            boolean hasNoForwardExtension;
            Integer e = itemsToExplore.get(j);
            ArrayList<Transaction> transactionsPe = new ArrayList<Transaction>();
            int utilityPe = 0;
            int supportPe = 0;
            ArrayList<Transaction> nowEmptyTransactionsPe = new ArrayList<Transaction>();
            Transaction previousTransaction = null;
            int consecutiveMergeCount = 0;
            for (Transaction transaction : transactionsOfP) {
                ++this.transactionReadingCount;
                int positionE = -1;
                int low = transaction.offset;
                int high = transaction.items.length - 1;
                while (high >= low) {
                    int middle = low + high >>> 1;
                    if (transaction.items[middle] < e) {
                        low = middle + 1;
                        continue;
                    }
                    if (transaction.items[middle] == e) {
                        positionE = middle;
                        break;
                    }
                    high = middle - 1;
                }
                if (positionE > -1) {
                    supportPe += transaction.originalTransactions.length;
                    if (transaction.getLastPosition() == positionE) {
                        utilityPe += transaction.utilities[positionE] + transaction.prefixUtility;
                        nowEmptyTransactionsPe.add(transaction);
                    } else if (this.activateTransactionMerging && 1000 >= transaction.items.length - positionE) {
                        Transaction projectedTransaction = new Transaction(transaction, positionE);
                        utilityPe += projectedTransaction.prefixUtility;
                        if (previousTransaction == null) {
                            previousTransaction = projectedTransaction;
                        } else if (this.isEqualTo(projectedTransaction, previousTransaction)) {
                            ++this.mergeCount;
                            if (consecutiveMergeCount == 0) {
                                int itemsCount = previousTransaction.items.length - previousTransaction.offset;
                                int[] items = new int[itemsCount];
                                System.arraycopy(previousTransaction.items, previousTransaction.offset, items, 0, itemsCount);
                                int[] utilities = new int[itemsCount];
                                System.arraycopy(previousTransaction.utilities, previousTransaction.offset, utilities, 0, itemsCount);
                                int positionPrevious = 0;
                                int positionProjection = projectedTransaction.offset;
                                while (positionPrevious < itemsCount) {
                                    int n = positionPrevious++;
                                    utilities[n] = utilities[n] + projectedTransaction.utilities[positionProjection];
                                    ++positionProjection;
                                }
                                int sumUtilities = previousTransaction.prefixUtility += projectedTransaction.prefixUtility;
                                int[][] mergeOriginalTransactions = this.mergeOriginalTransactions(previousTransaction, projectedTransaction);
                                previousTransaction = new Transaction(items, utilities, previousTransaction.transactionUtility + projectedTransaction.transactionUtility, mergeOriginalTransactions);
                                previousTransaction.prefixUtility = sumUtilities;
                            } else {
                                int positionPrevious = 0;
                                int positionProjected = projectedTransaction.offset;
                                int itemsCount = previousTransaction.items.length;
                                while (positionPrevious < itemsCount) {
                                    int n = positionPrevious++;
                                    previousTransaction.utilities[n] = previousTransaction.utilities[n] + projectedTransaction.utilities[positionProjected];
                                    ++positionProjected;
                                }
                                int[][] mergeOriginalTransactions = this.mergeOriginalTransactions(previousTransaction, projectedTransaction);
                                previousTransaction.transactionUtility += projectedTransaction.transactionUtility;
                                previousTransaction.prefixUtility += projectedTransaction.prefixUtility;
                                previousTransaction.originalTransactions = mergeOriginalTransactions;
                            }
                            ++consecutiveMergeCount;
                        } else {
                            transactionsPe.add(previousTransaction);
                            previousTransaction = projectedTransaction;
                            consecutiveMergeCount = 0;
                        }
                    } else {
                        Transaction projectedTransaction = new Transaction(transaction, positionE);
                        utilityPe += projectedTransaction.prefixUtility;
                        transactionsPe.add(projectedTransaction);
                    }
                    transaction.offset = positionE;
                    continue;
                }
                transaction.offset = low;
            }
            if (previousTransaction != null) {
                transactionsPe.add(previousTransaction);
            }
            if (!this.hasNoBackwardExtension(this.temp, prefixLength, transactionsPe, nowEmptyTransactionsPe, e)) continue;
            this.temp[prefixLength] = e;
            if (supportPe > maxSupport) {
                maxSupport = supportPe;
            }
            int utilityOfRemainingItemsJumpingClosure = this.useUtilityBinArraysToCalculateUpperBounds(transactionsPe, j, itemsToKeep);
            boolean shouldJumpToClosure = false;
            int utilityOfJumpingClosure = utilityPe + utilityOfRemainingItemsJumpingClosure;
            if (this.activateClosedPatternJumping && utilityOfJumpingClosure >= this.minUtil) {
                shouldJumpToClosure = true;
                for (int i = j + 1; i < itemsToKeep.size(); ++i) {
                    int item = itemsToKeep.get(i);
                    if (this.utilityBinArraySupport[item] == supportPe) continue;
                    shouldJumpToClosure = false;
                    break;
                }
            }
            if (shouldJumpToClosure) {
                int newLength = prefixLength + 1;
                for (int i = j + 1; i < itemsToKeep.size(); ++i) {
                    this.temp[newLength++] = itemsToKeep.get(i);
                }
                this.output(newLength - 1, utilityOfJumpingClosure);
                ++this.candidateCount;
                continue;
            }
            ArrayList<Integer> newItemsToKeep = new ArrayList<Integer>();
            ArrayList<Integer> newItemsToExplore = new ArrayList<Integer>();
            for (int k = j + 1; k < itemsToKeep.size(); ++k) {
                Integer itemk = itemsToKeep.get(k);
                if (this.utilityBinArraySU[itemk] >= this.minUtil) {
                    if (this.activateSubtreeUtilityPruning) {
                        newItemsToExplore.add(itemk);
                    }
                    newItemsToKeep.add(itemk);
                    continue;
                }
                if (this.utilityBinArrayLU[itemk] < this.minUtil) continue;
                newItemsToKeep.add(itemk);
            }
            int recursiveSupport = 0;
            recursiveSupport = this.activateSubtreeUtilityPruning ? this.backtrackingEFIM(transactionsPe, newItemsToKeep, newItemsToExplore, prefixLength + 1) : this.backtrackingEFIM(transactionsPe, newItemsToKeep, newItemsToKeep, prefixLength + 1);
            boolean bl = hasNoForwardExtension = supportPe > recursiveSupport;
            if (!hasNoForwardExtension || utilityPe < this.minUtil) continue;
            ++this.candidateCount;
            this.output(prefixLength, utilityPe);
        }
        MemoryLogger.getInstance().checkMemory();
        return maxSupport;
    }

    private int[][] mergeOriginalTransactions(Transaction transaction1, Transaction transaction2) {
        int OriginalTransactionsCount = transaction1.originalTransactions.length + transaction2.originalTransactions.length;
        int[][] mergeOriginalTransactions = new int[OriginalTransactionsCount][];
        System.arraycopy(transaction1.originalTransactions, 0, mergeOriginalTransactions, 0, transaction1.originalTransactions.length);
        System.arraycopy(transaction2.originalTransactions, 0, mergeOriginalTransactions, transaction1.originalTransactions.length, transaction2.originalTransactions.length);
        return mergeOriginalTransactions;
    }

    private boolean hasNoBackwardExtension(int[] prefix, int prefixLength, List<Transaction> transactionsPe, List<Transaction> nowEmptyTransactions, Integer e) {
        int[] firstTrans = transactionsPe.size() == 0 ? nowEmptyTransactions.get((int)0).originalTransactions[0] : transactionsPe.get((int)0).originalTransactions[0];
        for (int item : firstTrans) {
            if (item == e) break;
            if (this.containsByBinarySearch(prefix, prefixLength, item) || !this.isItemInAllTransactions(transactionsPe, item) || !this.isItemInAllTransactions(nowEmptyTransactions, item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsByBinarySearch(int[] items, int itemsLength, int item) {
        if (itemsLength == 0 || item > items[itemsLength - 1]) {
            return false;
        }
        int low = 0;
        int high = itemsLength - 1;
        while (high >= low) {
            int middle = low + high >>> 1;
            if (items[middle] == item) {
                return true;
            }
            if (items[middle] < item) {
                low = middle + 1;
            }
            if (items[middle] <= item) continue;
            high = middle - 1;
        }
        return false;
    }

    private boolean isItemInAllTransactions(List<Transaction> transactionsPe, int item) {
        for (Transaction mergedTransaction : transactionsPe) {
            for (int[] trans : mergedTransaction.originalTransactions) {
                if (this.containsByBinarySearch(trans, trans.length, item)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isEqualTo(Transaction t1, Transaction t2) {
        int length1 = t1.items.length - t1.offset;
        int length2 = t2.items.length - t2.offset;
        if (length1 != length2) {
            return false;
        }
        int position1 = t1.offset;
        int position2 = t2.offset;
        while (position1 < t1.items.length) {
            if (t1.items[position1] != t2.items[position2]) {
                return false;
            }
            ++position1;
            ++position2;
        }
        return true;
    }

    public void useUtilityBinArrayToCalculateLocalUtilityFirstTime(Dataset dataset) {
        this.utilityBinArrayLU = new int[dataset.getMaxItem() + 1];
        for (Transaction transaction : dataset.getTransactions()) {
            int[] nArray = transaction.getItems();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer item = nArray[i];
                int n2 = item;
                this.utilityBinArrayLU[n2] = this.utilityBinArrayLU[n2] + transaction.transactionUtility;
            }
        }
    }

    public void useUtilityBinArrayToCalculateSubtreeUtilityFirstTime(Dataset dataset) {
        for (Transaction transaction : dataset.getTransactions()) {
            int sumSU = 0;
            for (int i = transaction.getItems().length - 1; i >= 0; --i) {
                Integer item = transaction.getItems()[i];
                int n = item;
                this.utilityBinArraySU[n] = this.utilityBinArraySU[n] + (sumSU += transaction.getUtilities()[i]);
            }
        }
    }

    private int useUtilityBinArraysToCalculateUpperBounds(List<Transaction> transactionsPe, int j, List<Integer> itemsToKeep) {
        int utilityOfRemainingItemsJumpingClosure = 0;
        long initialTime = System.currentTimeMillis();
        for (int i = j + 1; i < itemsToKeep.size(); ++i) {
            int item = itemsToKeep.get(i);
            this.utilityBinArraySU[item] = 0;
            this.utilityBinArrayLU[item] = 0;
            if (!this.activateClosedPatternJumping) continue;
            this.utilityBinArraySupport[item] = 0;
        }
        for (Transaction transaction : transactionsPe) {
            ++this.transactionReadingCount;
            int sumRemainingUtility = 0;
            int high = itemsToKeep.size() - 1;
            for (int i = transaction.getItems().length - 1; i >= transaction.offset; --i) {
                int item = transaction.getItems()[i];
                boolean contains = false;
                int low = 0;
                while (high >= low) {
                    int middle = low + high >>> 1;
                    int itemMiddle = itemsToKeep.get(middle);
                    if (itemMiddle == item) {
                        contains = true;
                        break;
                    }
                    if (itemMiddle < item) {
                        low = middle + 1;
                        continue;
                    }
                    high = middle - 1;
                }
                if (!contains) continue;
                int n = item;
                this.utilityBinArraySU[n] = this.utilityBinArraySU[n] + ((sumRemainingUtility += transaction.getUtilities()[i]) + transaction.prefixUtility);
                int n2 = item;
                this.utilityBinArrayLU[n2] = this.utilityBinArrayLU[n2] + (transaction.transactionUtility + transaction.prefixUtility);
                if (!this.activateClosedPatternJumping) continue;
                int n3 = item;
                this.utilityBinArraySupport[n3] = this.utilityBinArraySupport[n3] + transaction.originalTransactions.length;
                utilityOfRemainingItemsJumpingClosure += transaction.getUtilities()[i];
            }
        }
        return utilityOfRemainingItemsJumpingClosure;
    }

    private void output(int tempPosition, int utility) throws IOException {
        ++this.patternCount;
        if (this.writer == null) {
            int[] copy = new int[tempPosition + 1];
            for (int i = 0; i <= tempPosition; ++i) {
                copy[i] = this.newNamesToOldNames[this.temp[i]];
            }
            this.highUtilityItemsets.addItemset(new Itemset(copy, (double)utility), copy.length);
        } else {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i <= tempPosition; ++i) {
                buffer.append(this.newNamesToOldNames[this.temp[i]]);
                if (i == tempPosition) continue;
                buffer.append(' ');
            }
            buffer.append("#UTIL: ");
            buffer.append(utility);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("========== EFIM-Closed - STATS ============");
        System.out.println(" minUtil = " + this.minUtil);
        System.out.println(" Closed High utility itemsets count: " + this.patternCount);
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory());
        System.out.println(" Visited node count : " + this.candidateCount);
        System.out.println("=====================================");
    }
}

