/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.ehaupm;

import ca.pfv.spmf.algorithms.frequentpatterns.ehaupm.MAUEntry;
import ca.pfv.spmf.algorithms.frequentpatterns.ehaupm.MAUList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoEHAUPM {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int nhauis = 0;
    public long joinCount = 0L;
    Map<Integer, Long> items2auub;
    Map<Integer, Map<Integer, Integer>> EAUCM;
    int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    BufferedWriter writer = null;
    MemoryUpdateRunnable memRecorder = new MemoryUpdateRunnable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String dbPath, String HAUIsFile, int delta) throws IOException {
        String curTran;
        this.startTimestamp = System.currentTimeMillis();
        Thread timeThread = new Thread(this.memRecorder);
        this.memRecorder.isTestMem = true;
        timeThread.start();
        this.itemsetBuffer = new int[this.BUFFERS_SIZE];
        this.EAUCM = new HashMap<Integer, Map<Integer, Integer>>();
        if (HAUIsFile != null && !HAUIsFile.equalsIgnoreCase("null")) {
            this.writer = new BufferedWriter(new FileWriter(HAUIsFile));
        }
        this.items2auub = new HashMap<Integer, Long>();
        long minUtility = 0L;
        try (BufferedReader dbReader = null;){
            dbReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(dbPath))));
            while ((curTran = dbReader.readLine()) != null) {
                int i;
                if (curTran.isEmpty() || curTran.charAt(0) == '#' || curTran.charAt(0) == '%' || curTran.charAt(0) == '@') continue;
                String[] split = curTran.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                Integer transactionMUtility = Integer.MIN_VALUE;
                for (i = 0; i < utilityValues.length; ++i) {
                    if (transactionMUtility >= Integer.parseInt(utilityValues[i])) continue;
                    transactionMUtility = Integer.parseInt(utilityValues[i]);
                }
                for (i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Long auub = this.items2auub.get(item);
                    auub = auub == null ? (long)transactionMUtility.intValue() : auub + (long)transactionMUtility.intValue();
                    this.items2auub.put(item, auub);
                }
            }
            minUtility = delta;
        }
        ArrayList<MAUList> listOfMAULists = new ArrayList<MAUList>();
        HashMap<Integer, MAUList> mapItemToUtilityList = new HashMap<Integer, MAUList>();
        for (Map.Entry<Integer, Long> entry : this.items2auub.entrySet()) {
            Integer item = entry.getKey();
            if (this.items2auub.get(item) < minUtility) continue;
            MAUList uList = new MAUList(item);
            mapItemToUtilityList.put(item, uList);
            listOfMAULists.add(uList);
        }
        Collections.sort(listOfMAULists, new Comparator<MAUList>(){

            @Override
            public int compare(MAUList o1, MAUList o2) {
                return AlgoEHAUPM.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            dbReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(dbPath))));
            int tid = 0;
            while ((curTran = dbReader.readLine()) != null) {
                Pair pair;
                int i;
                if (curTran.isEmpty() || curTran.charAt(0) == '#' || curTran.charAt(0) == '%' || curTran.charAt(0) == '@') continue;
                String[] split = curTran.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                int maxUtilityOfCurTrans = 0;
                for (int i2 = 0; i2 < items.length; ++i2) {
                    Pair pair2 = new Pair();
                    pair2.item = Integer.parseInt(items[i2]);
                    pair2.utility = Integer.parseInt(utilityValues[i2]);
                    if (this.items2auub.get(pair2.item) < minUtility) continue;
                    revisedTransaction.add(pair2);
                    if (maxUtilityOfCurTrans >= pair2.utility) continue;
                    maxUtilityOfCurTrans = pair2.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoEHAUPM.this.compareItems(o1.item, o2.item);
                    }
                });
                int remu = 0;
                int rmu = 0;
                for (i = revisedTransaction.size() - 1; i >= 0; --i) {
                    pair = (Pair)revisedTransaction.get(i);
                    rmu = rmu < pair.utility ? pair.utility : rmu;
                    MAUList MAUListOfItem = (MAUList)mapItemToUtilityList.get(pair.item);
                    MAUEntry MAUEntry2 = new MAUEntry(tid, pair.utility, rmu, remu);
                    MAUListOfItem.addElement(MAUEntry2);
                    remu = remu < pair.utility ? pair.utility : remu;
                }
                for (i = 0; i < revisedTransaction.size(); ++i) {
                    pair = (Pair)revisedTransaction.get(i);
                    Map<Integer, Integer> subEAUCS = this.EAUCM.get(pair.item);
                    if (subEAUCS == null) {
                        subEAUCS = new HashMap<Integer, Integer>();
                        this.EAUCM.put(pair.item, subEAUCS);
                    }
                    for (int j = i + 1; j < revisedTransaction.size(); ++j) {
                        Pair pairAfter = (Pair)revisedTransaction.get(j);
                        Integer auubSum = subEAUCS.get(pairAfter.item);
                        if (auubSum == null) {
                            subEAUCS.put(pairAfter.item, maxUtilityOfCurTrans);
                            continue;
                        }
                        subEAUCS.put(pairAfter.item, auubSum + maxUtilityOfCurTrans);
                    }
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dbReader != null) {
                dbReader.close();
            }
        }
        this.search(this.itemsetBuffer, 0, null, listOfMAULists, minUtility);
        this.memRecorder.isTestMem = false;
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = (int)(this.items2auub.get(item1) - this.items2auub.get(item2));
        return compare == 0 ? item1 - item2 : compare;
    }

    private void search(int[] prefix, int prefixLength, MAUList ULOfPxy, List<MAUList> ULs, long minUtility) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            MAUList X = ULs.get(i);
            if ((double)X.sumutils / (double)(prefixLength + 1) >= (double)minUtility) {
                ++this.nhauis;
                if (this.writer != null) {
                    this.writeOut(prefix, prefixLength, X.item, (double)X.sumutils / (double)(prefixLength + 1));
                }
            }
            if ((double)X.sumutils / (double)(prefixLength + 1) + (double)X.sumOfRemu < (double)minUtility || X.sumOfRmu < minUtility) continue;
            ArrayList<MAUList> extensionOfPx = new ArrayList<MAUList>();
            for (int j = i + 1; j < ULs.size(); ++j) {
                Integer auub2;
                MAUList Y = ULs.get(j);
                Map<Integer, Integer> auub1 = this.EAUCM.get(X.item);
                if (auub1 != null && ((auub2 = auub1.get(Y.item)) == null || (long)auub2.intValue() < minUtility)) continue;
                ++this.joinCount;
                MAUList pxy = this.construct_opt(prefixLength + 1, ULOfPxy, X, Y, minUtility);
                if (pxy == null) continue;
                extensionOfPx.add(pxy);
            }
            if (prefixLength == this.BUFFERS_SIZE) {
                this.BUFFERS_SIZE += this.BUFFERS_SIZE / 2;
                int[] tmp = new int[this.BUFFERS_SIZE];
                System.arraycopy(tmp, 0, this.itemsetBuffer, 0, prefixLength);
                this.itemsetBuffer = tmp;
            }
            this.itemsetBuffer[prefixLength] = X.item;
            this.search(this.itemsetBuffer, prefixLength + 1, X, extensionOfPx, minUtility);
        }
    }

    private MAUList construct_opt(int prefixLen, MAUList P, MAUList Px, MAUList Py, long minUtility) {
        MAUList pxyUL = new MAUList(Py.item);
        long sumOfRmu = Px.sumOfRmu;
        long sumOfRemu = (long)((double)Px.sumutils / (double)prefixLen + (double)Px.sumOfRemu);
        int idxPx = 0;
        int idxPy = 0;
        while (idxPx < Px.CAUEntries.size() && idxPy < Py.CAUEntries.size()) {
            MAUEntry ex = Px.CAUEntries.get(idxPx);
            MAUEntry ey = Py.CAUEntries.get(idxPy);
            if (ex.tid == ey.tid) {
                if (P != null) {
                    MAUEntry e = this.findElementWithTID(P, ex.tid);
                    if (e != null) {
                        MAUEntry eXY = new MAUEntry(ex.tid, ex.utility + ey.utility - e.utility, ex.rmu, ey.remu);
                        pxyUL.addElement(eXY);
                    }
                } else {
                    MAUEntry eXY = new MAUEntry(ex.tid, ex.utility + ey.utility, ex.rmu, ey.remu);
                    pxyUL.addElement(eXY);
                }
                ++idxPx;
                ++idxPy;
                continue;
            }
            if (ex.tid > ey.tid) {
                ++idxPy;
                continue;
            }
            ++idxPx;
            if (Math.min(sumOfRmu -= (long)ex.rmu, sumOfRemu = (long)((double)sumOfRemu - ((double)ex.utility / (double)prefixLen + (double)ex.remu))) >= minUtility) continue;
            return null;
        }
        return pxyUL;
    }

    private MAUEntry findElementWithTID(MAUList ulist, int tid) {
        List<MAUEntry> list = ulist.CAUEntries;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, double utility) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(item);
        buffer.append(" #AUTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
    }

    public void printStats() {
        System.out.println("=============  EHAUPM ALGORITHM v.2.22 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.memRecorder.maxConsumationMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.nhauis);
        System.out.println("===================================================");
    }

    class MemoryUpdateRunnable
    implements Runnable {
        boolean isTestMem;
        double maxConsumationMemory;

        MemoryUpdateRunnable() {
        }

        @Override
        public void run() {
            while (this.isTestMem) {
                double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
                if (currentMemory > this.maxConsumationMemory) {
                    this.maxConsumationMemory = currentMemory;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

