/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.estDec;

import ca.pfv.spmf.algorithms.frequentpatterns.estDec.CPTree;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;

public class Algo_estDecPlus {
    CPTree tree;
    int transactionCount = 0;
    private long miningTime = 0L;
    double sumTransactionInsertionTime = 0.0;

    public Algo_estDecPlus(double mins, double d, double minSigValue, double deltaValue, double minMergeValue) {
        MemoryLogger.getInstance().reset();
        this.tree = new CPTree(d, mins, minSigValue, deltaValue, minMergeValue);
        System.out.println(" Parameters  : minsup: " + mins + " minSig:  " + minSigValue + " minmerge:  " + minMergeValue + " delta:  " + deltaValue);
    }

    public void setDecayRate(double b, double h) {
        this.tree.setDecayRate(b, h);
    }

    public void processTransactionFromFile(String input) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited = line.split(" ");
            int[] transaction = new int[lineSplited.length];
            for (int i = 0; i < lineSplited.length; ++i) {
                transaction[i] = Integer.parseInt(lineSplited[i]);
            }
            this.processTransaction(transaction);
        }
        reader.close();
    }

    public void processTransactionFromFile(String input, int numberOfLines) throws FileNotFoundException, IOException {
        String line;
        int n;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        for (n = 0; (line = reader.readLine()) != null && n < numberOfLines; ++n) {
            String[] lineSplited = line.split(" ");
            int[] transaction = new int[lineSplited.length];
            for (int i = 0; i < lineSplited.length; ++i) {
                transaction[i] = Integer.parseInt(lineSplited[i]);
            }
            this.processTransaction(transaction);
        }
        System.out.println(n);
        reader.close();
    }

    public void performMining_saveResultToFile(String outputPath) throws IOException {
        long startMiningTimeStamp = System.currentTimeMillis();
        this.tree.patternMining_saveToFile(outputPath);
        System.gc();
        MemoryLogger.getInstance().checkMemory();
        this.miningTime = System.currentTimeMillis() - startMiningTimeStamp;
    }

    public Hashtable<int[], Double> performMining_saveResultToMemory() throws IOException {
        System.gc();
        MemoryLogger.getInstance().checkMemory();
        long startMiningTimeStamp = System.currentTimeMillis();
        Hashtable<int[], Double> patterns = this.tree.patternMining_saveToMemory();
        this.miningTime = System.currentTimeMillis() - startMiningTimeStamp;
        System.gc();
        MemoryLogger.getInstance().checkMemory();
        return patterns;
    }

    public void processTransaction(int[] transaction) {
        double startCTimestamp = System.currentTimeMillis();
        this.tree.updateParams();
        for (int i = 0; i < this.tree.root.children.size(); ++i) {
            this.tree.traverse(this.tree.root.children.get(i), this.tree.root, -1, transaction);
        }
        this.tree.insertItemset(transaction);
        ++this.transactionCount;
        if (this.transactionCount % 1000 == 0) {
            this.tree.forcePruning(this.tree.root);
        }
        this.tree.forcePruning(this.tree.root);
        this.sumTransactionInsertionTime += (double)System.currentTimeMillis() - startCTimestamp;
    }

    public void showTreeForDebugging() {
        System.out.println(this.tree.toString());
    }

    public void printStats() {
        System.out.println("===========  estDecPlus - STATS ===========");
        System.out.println(" Number of nodes : " + this.tree.nodeCount(this.tree.root));
        System.out.println(" Frequent itemsets count : " + this.tree.patternCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Number of transactions: " + this.transactionCount);
        System.out.println(" Total insertion time ~ " + this.sumTransactionInsertionTime);
        System.out.println(" Insertion time per transaction ~ " + this.sumTransactionInsertionTime / (double)this.transactionCount + " ms");
        System.out.println(" Mining time ~ " + this.miningTime + " ms");
        System.out.println("============================================");
    }
}

