/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.estDec;

import ca.pfv.spmf.algorithms.frequentpatterns.estDec.ParentNode;
import java.util.ArrayList;
import java.util.List;

public class CPTreeNode {
    List<Integer> itemIDList = new ArrayList<Integer>();
    List<ParentNode> parents;
    double counter1;
    double counter2;
    List<CPTreeNode> children;

    CPTreeNode(Integer item, CPTreeNode parent, short parentInd, double count) {
        this.itemIDList.add(item);
        this.parents = new ArrayList<ParentNode>();
        this.parents.add(new ParentNode(parent, parentInd));
        this.counter1 = count;
        this.counter2 = count;
        this.children = new ArrayList<CPTreeNode>();
    }

    CPTreeNode() {
        this.parents = new ArrayList<ParentNode>();
        this.counter1 = 1.0;
        this.counter2 = 1.0;
        this.children = new ArrayList<CPTreeNode>();
    }

    public short getInnerIndexWithID(int id, CPTreeNode parentNode, short parentInd) {
        for (short i = (short)(parentInd + 1); i < this.itemIDList.size(); i = (short)(i + 1)) {
            if (this.itemIDList.get(i) != id || this.parents.get((int)i).pNode != parentNode || this.parents.get((int)i).pInd != parentInd) continue;
            return i;
        }
        return -1;
    }

    public CPTreeNode getChildWithID(int id, int q) {
        if (this.children == null) {
            return null;
        }
        for (CPTreeNode child : this.children) {
            if (child.itemIDList.get(0) != id || child.parents.get((int)0).pInd != q) continue;
            return child;
        }
        return null;
    }

    public int getLevel(int j) {
        int level = 0;
        while (true) {
            ++level;
            if (j == 0) break;
            j = this.parents.get((int)j).pInd;
        }
        return level;
    }

    public int getLongestLevel() {
        int level = 1;
        ArrayList<Integer> p = new ArrayList<Integer>();
        p.add(0);
        while (p.size() != 0) {
            ++level;
            ArrayList<Integer> p2 = new ArrayList<Integer>();
            for (int j = 1; j < this.itemIDList.size(); ++j) {
                short x = this.parents.get((int)j).pInd;
                if (!p.contains(x)) continue;
                p2.add(j);
            }
            p = p2;
        }
        return level - 1;
    }

    public Boolean isLeafLevel(int id) {
        for (int i = id + 1; i < this.itemIDList.size(); ++i) {
            if (this.parents.get((int)i).pNode != this || this.parents.get((int)i).pInd != id) continue;
            return false;
        }
        return true;
    }

    public void update(double d) {
        this.counter1 = this.counter1 * d + 1.0;
    }

    public double computeSupport(double N, int level) {
        int maxL = this.getLongestLevel();
        return this.estimateMergeCount(level, maxL) / N;
    }

    public double estimateMergeCount(int level, int longestL) {
        if (level == 1) {
            return this.counter1;
        }
        if (level == longestL) {
            return this.counter2;
        }
        double x = 0.0;
        for (int l = 1; l <= longestL - 1; ++l) {
            x += 1.0 / (double)l;
        }
        double s = 0.0;
        for (int l = 1; l <= level - 1; ++l) {
            s += 1.0 / (double)l;
        }
        return this.counter1 - (this.counter1 - this.counter2) * s / x;
    }

    public String toString(String indent) {
        StringBuilder output = new StringBuilder();
        output.append("ID=" + super.toString());
        output.append(" Counter1=" + this.counter1);
        output.append(" Counter2=" + this.counter2);
        output.append(" ItemIDList=");
        for (Integer item : this.itemIDList) {
            output.append(item + ",");
        }
        output.append(" Parents=");
        for (ParentNode parent : this.parents) {
            output.append("(pind=" + parent.pInd + ",node=" + parent.pNode.toString() + ")");
        }
        output.append("\n");
        String newIndent = indent + "   ";
        for (CPTreeNode child : this.children) {
            output.append(newIndent + child.toString(newIndent));
        }
        return output.toString();
    }
}

