/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.estDec;

import ca.pfv.spmf.algorithms.frequentpatterns.estDec.estNode;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class estTree {
    double N;
    double d;
    int k;
    int patternCount = 0;
    Hashtable<int[], Double> patterns;
    BufferedWriter writer;
    double minsup;
    double minsig;
    estNode root;
    int[] itemsetBuffer = new int[500];

    estTree(double mins, double minSigValue) {
        this.setDecayRate(2.0, 10000.0);
        this.N = 0.0;
        this.k = 0;
        this.minsup = mins;
        this.minsig = minSigValue;
        System.out.println(" " + this.minsup + " " + this.minsig);
        this.root = new estNode();
    }

    void setDecayRate(double b, double h) {
        this.d = Math.pow(b, -1.0 / h);
    }

    void updateParams(int[] transaction) {
        this.N = this.N * this.d + 1.0;
        ++this.k;
        this.updateNodes(this.root, transaction, 0);
    }

    void updateNodes(estNode currentNode, int[] transaction, int ind) {
        if (ind >= transaction.length) {
            return;
        }
        int item = transaction[ind];
        estNode child = currentNode.getChildWithID(item);
        if (child != null) {
            child.update(this.k, 1, this.d);
            if (child.computeSupport(this.N) >= this.minsig) {
                this.updateNodes(child, transaction, ind + 1);
            }
        }
        this.updateNodes(currentNode, transaction, ind + 1);
    }

    void insertItem(Integer it) {
        double c = 0.0;
        this.root.children.add(new estNode(it, c, this.k));
    }

    void insertItemset(int[] transaction) {
        ArrayList<Integer> transaction2 = new ArrayList<Integer>();
        for (int it : transaction) {
            estNode child = this.root.getChildWithID(it);
            if (child == null) {
                this.insertItem(it);
                continue;
            }
            if (!(child.computeSupport(this.N) >= this.minsig)) continue;
            transaction2.add(it);
        }
        for (int i = 0; i < transaction2.size(); ++i) {
            this.itemsetBuffer[0] = (Integer)transaction2.get(i);
            this.insert_n_itemsets3(this.root.getChildWithID((Integer)transaction2.get(i)), transaction2, i + 1, this.itemsetBuffer, 1);
        }
    }

    double getN(int k) {
        return (1.0 - Math.pow(this.d, k)) / (1.0 - this.d);
    }

    double getCountOfItemsetWithoutItemAtPosition(int[] itemset2, int length, int pos) {
        estNode currentNode = this.root;
        for (int i = 0; i < length; ++i) {
            if (i == pos) continue;
            int item = itemset2[i];
            estNode child = currentNode.getChildWithID(item);
            if (child == null) {
                return 0.0;
            }
            currentNode = child;
        }
        return currentNode.counter;
    }

    double estimateCount(int[] itemset2, int length) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            double c = this.getCountOfItemsetWithoutItemAtPosition(itemset2, length, i);
            if (!(c < min)) continue;
            min = c;
        }
        double C_upper = this.minsig * this.getN(this.k - (length - 1)) * Math.pow(this.d, length - 1) + (1.0 - Math.pow(this.d, length - 1)) / (1.0 - this.d);
        if (min > C_upper) {
            min = C_upper;
        }
        return min;
    }

    public void insert_n_itemsets(estNode currentNode, List<Integer> transaction, int ind, int[] itemset2) {
        if (ind >= transaction.size()) {
            return;
        }
        Integer item = transaction.get(ind);
        estNode child = currentNode.getChildWithID(item);
        int[] itemset22 = new int[itemset2.length + 1];
        System.arraycopy(itemset2, 0, itemset22, 0, itemset2.length);
        itemset22[itemset22.length - 1] = item;
        if (child == null) {
            double c = this.estimateCount(itemset22, itemset22.length);
            if (c / this.N >= this.minsig) {
                child = new estNode(item, c, this.k);
                currentNode.children.add(child);
            }
        } else if (child.counter / this.N < this.minsig) {
            if (currentNode.itemID != -1) {
                currentNode.children.remove(currentNode.getChildIndexWithID(item));
            }
        } else {
            this.insert_n_itemsets(child, transaction, ind + 1, itemset22);
        }
        this.insert_n_itemsets(currentNode, transaction, ind + 1, itemset2);
    }

    public void insert_n_itemsets2(estNode currentNode, List<Integer> transaction, int ind, int[] itemset2) {
        if (ind >= transaction.size()) {
            return;
        }
        int[] itemset22 = new int[itemset2.length + 1];
        System.arraycopy(itemset2, 0, itemset22, 0, itemset2.length);
        for (int i = ind; i < transaction.size(); ++i) {
            int item;
            itemset22[itemset22.length - 1] = item = transaction.get(i).intValue();
            estNode child = currentNode.getChildWithID(item);
            if (child == null) {
                double c = this.estimateCount(itemset22, itemset22.length);
                if (!(c / this.N >= this.minsig)) continue;
                child = new estNode(item, c, this.k);
                currentNode.children.add(child);
                continue;
            }
            if (child.counter / this.N < this.minsig) {
                if (currentNode.itemID == -1) continue;
                currentNode.children.remove(currentNode.getChildIndexWithID(item));
                continue;
            }
            this.insert_n_itemsets2(child, transaction, i + 1, itemset22);
        }
    }

    public void insert_n_itemsets3(estNode currentNode, List<Integer> transaction, int ind, int[] itemset2, int length) {
        if (ind >= transaction.size()) {
            return;
        }
        for (int i = ind; i < transaction.size(); ++i) {
            int item;
            itemset2[length] = item = transaction.get(i).intValue();
            estNode child = currentNode.getChildWithID(item);
            if (child == null) {
                double c = this.estimateCount(itemset2, length + 1);
                if (!(c / this.N >= this.minsig)) continue;
                child = new estNode(item, c, this.k);
                currentNode.children.add(child);
                continue;
            }
            if (child.counter / this.N < this.minsig) {
                if (currentNode.itemID == -1) continue;
                currentNode.children.remove(currentNode.getChildIndexWithID(item));
                continue;
            }
            this.insert_n_itemsets3(child, transaction, i + 1, itemset2, length + 1);
        }
    }

    void forcePruning(estNode root) {
        for (int i = 0; i < root.children.size(); ++i) {
            estNode node = root.children.get(i);
            node.update(this.k, 0, this.d);
            if (node.computeSupport(this.N) < this.minsig && root.itemID != -1) {
                root.children.remove(i--);
                continue;
            }
            this.forcePruning(node);
        }
    }

    void patternMining(estNode root, int[] pattern, int patternLength) throws IOException {
        int newPatternLength = patternLength + 1;
        for (estNode node : root.children) {
            node.update(this.k, 0, this.d);
            double s = node.computeSupport(this.N);
            if (!(s > this.minsup)) continue;
            pattern[patternLength] = node.itemID;
            ++this.patternCount;
            if (this.patterns == null) {
                this.writeItemset(pattern, newPatternLength, s);
            } else {
                int[] patt2 = new int[patternLength + 1];
                System.arraycopy(pattern, 0, patt2, 0, newPatternLength);
                this.patterns.put(patt2, s);
            }
            this.patternMining(node, pattern, newPatternLength);
        }
    }

    Hashtable<int[], Double> patternMining_saveToMemory() throws IOException {
        this.patterns = new Hashtable();
        this.patternCount = 0;
        this.patternMining(this.root, this.itemsetBuffer, 0);
        return this.patterns;
    }

    void patternMining_saveToFile(String outputPath) throws IOException {
        this.patterns = null;
        this.writer = new BufferedWriter(new FileWriter(outputPath));
        this.patternCount = 0;
        this.patternMining(this.root, this.itemsetBuffer, 0);
        this.writer.close();
    }

    void writeItemset(int[] itemset2, int patternLength, double support) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < patternLength; ++i) {
            buffer.append(itemset2[i]);
            buffer.append(" ");
        }
        buffer.append("#SUP: ");
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    int getK() {
        return this.k;
    }

    int nodeCount(estNode currentNode) {
        int s = 1;
        for (estNode child : currentNode.children) {
            s += this.nodeCount(child);
        }
        return s;
    }
}

