/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fhmds.naive;

import ca.pfv.spmf.algorithms.frequentpatterns.fhmds.naive.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.fhmds.naive.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.fhmds.naive.UtilityList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoFHMDS_Naive {
    public double maxMemory = 0.0;
    public long startTimestamp = 0L;
    public long startTimestamp2 = 0L;
    public long endTimestamp2 = 0L;
    public long endTimestamp = 0L;
    public long construct_time = 0L;
    public long fhm_time = 0L;
    public int huiCount = 0;
    public long min_supp = 0L;
    public long max_supp = 0L;
    public long avg_supp = 0L;
    public int candidateCount = 0;
    public int construct_calls = 0;
    int processedBatchCount;
    static Map<Integer, Float> mapItemToTWU = new HashMap<Integer, Float>();
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Float>> mapFMAP;
    public int k;
    public int win_size;
    public int number_of_transactions_batch;
    public int win_number;
    static float min_top_k_utility_current_window = 0.0f;
    static ArrayList<ArrayList<String>> window = new ArrayList();
    private static List<Itemset> top_k_hui = new ArrayList<Itemset>();
    static List<UtilityList> listOfUtilityLists = new ArrayList<UtilityList>();
    static Map<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
    boolean debug = false;
    long total = 0L;
    long hui = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String transactionFile, int k, int win_size, int number_of_transactions_batch, String resultFile) throws IOException {
        this.processedBatchCount = 0;
        this.k = k;
        this.win_size = win_size;
        this.number_of_transactions_batch = number_of_transactions_batch;
        this.startTimestamp = System.currentTimeMillis();
        BufferedReader myInput = null;
        int iterateBatch = 0;
        int iterateWindow = 0;
        int windowCount = 0;
        int batchNumber = 0;
        ArrayList<String> batchTransaction = new ArrayList<String>();
        try {
            String thisLine;
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(transactionFile))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                if (++iterateBatch <= this.number_of_transactions_batch) {
                    batchTransaction.add(thisLine);
                }
                if (iterateBatch != this.number_of_transactions_batch) continue;
                iterateBatch = 0;
                ++batchNumber;
                window.add(new ArrayList(batchTransaction));
                batchTransaction.clear();
                if (++iterateWindow < this.win_size) continue;
                this.initial_call_FHM(window, ++windowCount, resultFile);
                this.writeResultTofile(resultFile, batchNumber == 1);
                window.remove(0);
            }
            if (iterateBatch > 0 && iterateBatch < this.number_of_transactions_batch) {
                ++batchNumber;
                window.add(batchTransaction);
                this.initial_call_FHM(window, ++windowCount, resultFile);
                this.writeResultTofile(resultFile, true);
                batchTransaction.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
            batchTransaction.clear();
            window.clear();
            String thisLine = "";
        }
        this.endTimestamp = System.currentTimeMillis();
    }

    void initial_call_FHM(ArrayList<ArrayList<String>> window, int windowCount, String resultFile) {
        top_k_hui.clear();
        mapItemToTWU = new HashMap<Integer, Float>();
        this.mapFMAP = new HashMap<Integer, Map<Integer, Float>>();
        listOfUtilityLists = new ArrayList<UtilityList>();
        mapItemToUtilityList = new HashMap<Integer, UtilityList>();
        this.startTimestamp2 = System.currentTimeMillis();
        this.win_number = windowCount;
        for (ArrayList<String> arrayList : window) {
            for (String string : arrayList) {
                String[] split = string.split(":");
                String[] items = split[0].split(" ");
                float transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Float twu = mapItemToTWU.get(item);
                    twu = Float.valueOf(twu == null ? transactionUtility : twu.floatValue() + transactionUtility);
                    mapItemToTWU.put(item, twu);
                }
            }
        }
        for (Integer n : mapItemToTWU.keySet()) {
            if (!(mapItemToTWU.get(n).floatValue() >= min_top_k_utility_current_window)) continue;
            UtilityList utilityList = new UtilityList(n, this.win_size, windowCount);
            mapItemToUtilityList.put(n, utilityList);
            listOfUtilityLists.add(utilityList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

            @Override
            public int compare(UtilityList o1, UtilityList o2) {
                return AlgoFHMDS_Naive.this.compareItems(o1.item, o2.item);
            }
        });
        if (this.debug) {
            System.out.println("Window: " + windowCount);
        }
        int tid = (windowCount - 1) * this.number_of_transactions_batch;
        for (ArrayList<String> arrayList : window) {
            for (String thisLine : arrayList) {
                Pair pair;
                int i;
                ++tid;
                float remainingUtility = 0.0f;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                for (i = 0; i < items.length; ++i) {
                    pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (!(mapItemToTWU.get(pair.item).floatValue() >= min_top_k_utility_current_window)) continue;
                    revisedTransaction.add(pair);
                    remainingUtility += pair.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoFHMDS_Naive.this.compareItems(o1.item, o2.item);
                    }
                });
                for (i = 0; i < revisedTransaction.size(); ++i) {
                    pair = (Pair)revisedTransaction.get(i);
                    UtilityList utilityListOfItem = mapItemToUtilityList.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                    utilityListOfItem.addElement(element, this.win_size, this.number_of_transactions_batch);
                }
            }
        }
        for (UtilityList utilityList : listOfUtilityLists) {
            int[] nArray = new int[]{utilityList.item};
            Itemset i = new Itemset(nArray, Float.valueOf(utilityList.sumIutils));
            i.last_batch_utility = utilityList.batches.containsKey(this.win_number) ? Float.valueOf(utilityList.sumIutils - utilityList.batches.get((Object)Collections.min(utilityList.batches.keySet())).sum_batch_iutils) : Float.valueOf(utilityList.sumIutils);
            top_k_hui.add(i);
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
            Collections.sort(top_k_hui, new Comparator<Itemset>(){

                @Override
                public int compare(Itemset o1, Itemset o2) {
                    return (int)(o2.getExactUtility().floatValue() - o1.getExactUtility().floatValue());
                }
            });
            if (top_k_hui.size() <= this.k) continue;
            int lastindex = top_k_hui.size() - 1;
            Itemset set = top_k_hui.get(lastindex);
            top_k_hui.remove(lastindex);
            if (!(set.getExactUtility().floatValue() > min_top_k_utility_current_window)) continue;
            min_top_k_utility_current_window = set.getExactUtility().floatValue();
        }
        if (top_k_hui.size() >= this.k) {
            min_top_k_utility_current_window = top_k_hui.get(top_k_hui.size() - 1).getExactUtility().floatValue();
        }
        if (this.debug) {
            System.out.println("Single item threshold: " + min_top_k_utility_current_window + " size: " + top_k_hui.size());
        }
        long l = System.currentTimeMillis();
        try {
            this.fhm(new int[0], null, listOfUtilityLists);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.fhm_time = System.currentTimeMillis() - l;
        if (this.debug) {
            System.out.println("Top k utility: " + top_k_hui.get(top_k_hui.size() - 1).getExactUtility());
        }
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        Collections.sort(top_k_hui, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset o1, Itemset o2) {
                return (int)(o2.last_batch_utility.floatValue() - o1.last_batch_utility.floatValue());
            }
        });
        min_top_k_utility_current_window = top_k_hui.size() >= this.k ? AlgoFHMDS_Naive.top_k_hui.get((int)(AlgoFHMDS_Naive.top_k_hui.size() - 1)).last_batch_utility.floatValue() : 0.0f;
        System.out.println("Threshold for next window: " + min_top_k_utility_current_window + " size: " + top_k_hui.size());
        System.out.println("Total: " + this.total);
        mapItemToTWU.clear();
        mapItemToUtilityList.clear();
        listOfUtilityLists.clear();
        this.mapFMAP.clear();
        this.endTimestamp2 = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        if (mapItemToTWU.get(item1).floatValue() > mapItemToTWU.get(item2).floatValue()) {
            return 1;
        }
        if (mapItemToTWU.get(item1).floatValue() < mapItemToTWU.get(item2).floatValue()) {
            return -1;
        }
        if (item1 > item2) {
            return 1;
        }
        return -1;
    }

    private void fhm(int[] prefix, UtilityList pUL, List<UtilityList> ULs) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityList X = ULs.get(i);
            if (X.sumIutils >= min_top_k_utility_current_window && prefix.length > 0 && X.sumIutils != 0.0f) {
                ++this.huiCount;
                ++this.hui;
                int[] itemset2 = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, itemset2, 0, prefix.length);
                itemset2[prefix.length] = X.item;
                Itemset item_set = new Itemset(itemset2, Float.valueOf(X.sumIutils));
                item_set.last_batch_utility = X.batches.containsKey(this.win_number) ? Float.valueOf(X.sumIutils - X.batches.get((Object)Collections.min(X.batches.keySet())).sum_batch_iutils) : Float.valueOf(X.sumIutils);
                top_k_hui.add(item_set);
                System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
                Collections.sort(top_k_hui, new Comparator<Itemset>(){

                    @Override
                    public int compare(Itemset o1, Itemset o2) {
                        return (int)(o2.getExactUtility().floatValue() - o1.getExactUtility().floatValue());
                    }
                });
                if (top_k_hui.size() > this.k) {
                    int lastindex = top_k_hui.size() - 1;
                    Itemset set = top_k_hui.get(lastindex);
                    top_k_hui.remove(lastindex);
                    if (set.getExactUtility().floatValue() > min_top_k_utility_current_window) {
                        min_top_k_utility_current_window = set.getExactUtility().floatValue();
                    }
                }
                if (top_k_hui.size() >= this.k) {
                    min_top_k_utility_current_window = top_k_hui.get(top_k_hui.size() - 1).getExactUtility().floatValue();
                }
            }
            if (!(X.sumIutils + X.sumRutils >= min_top_k_utility_current_window) || X.sumIutils + X.sumRutils == 0.0f) continue;
            ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
            for (int j = i + 1; j < ULs.size(); ++j) {
                UtilityList Y = ULs.get(j);
                ++this.candidateCount;
                ++this.total;
                UtilityList temp = this.construct(pUL, X, Y);
                exULs.add(temp);
            }
            int[] newPrefix = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
            newPrefix[prefix.length] = X.item;
            this.fhm(newPrefix, X, exULs);
        }
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py) {
        ++this.construct_calls;
        long temp = System.currentTimeMillis();
        UtilityList pxyUL = new UtilityList(py.item, this.win_size, this.win_number);
        HashSet<Integer> common_batches = new HashSet<Integer>();
        common_batches.addAll(px.batches.keySet());
        common_batches.retainAll(py.batches.keySet());
        Iterator iterator = common_batches.iterator();
        while (iterator.hasNext()) {
            int batch = (Integer)iterator.next();
            for (Element ex : px.batches.get((Object)Integer.valueOf((int)batch)).elements) {
                Element ey = this.findElementWithTID(py.batches.get((Object)Integer.valueOf((int)batch)).elements, ex.tid);
                if (ey == null) continue;
                if (P == null) {
                    Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                    pxyUL.addElement(eXY, this.win_size, this.number_of_transactions_batch);
                    continue;
                }
                Element e = this.findElementWithTID(P.batches.get((Object)Integer.valueOf((int)batch)).elements, ex.tid);
                if (e == null) continue;
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
                pxyUL.addElement(eXY, this.win_size, this.number_of_transactions_batch);
            }
        }
        this.construct_time += System.currentTimeMillis() - temp;
        return pxyUL;
    }

    private Element findElementWithTID(List<Element> elements, int tid) {
        List<Element> list = elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    public void writeResultTofile(String path, boolean appendToFile) throws IOException {
        ++this.processedBatchCount;
        BufferedWriter writer = new BufferedWriter(new FileWriter(path, appendToFile));
        if (appendToFile) {
            writer.newLine();
            writer.write("@NEXT_BATCH");
            writer.newLine();
        }
        Iterator<Itemset> iter = top_k_hui.iterator();
        while (iter.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            Itemset itemset2 = iter.next();
            for (int i = 0; i < itemset2.itemset.length; ++i) {
                buffer.append(itemset2.itemset[i]);
                buffer.append(' ');
            }
            buffer.append(" #UTIL: ");
            buffer.append(itemset2.getExactUtility());
            writer.write(buffer.toString());
            if (!iter.hasNext()) continue;
            writer.newLine();
        }
        writer.close();
    }

    public void printStats() throws IOException {
        System.out.println("=============  FHMDS-Naive ALGORITHM v.2.34 Stats =============");
        if (this.debug) {
            System.out.println("k " + this.k + " Transaction count per batch:" + this.number_of_transactions_batch + " win size: " + this.win_size);
        }
        System.out.println(" Processed batch count: " + this.processedBatchCount);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Candidate count: " + this.total);
        System.out.println("======================================================");
    }

    class Pair {
        int item = 0;
        float utility = 0.0f;

        Pair() {
        }

        public String toString() {
            return "[" + this.item + "," + this.utility + "]";
        }
    }
}

