/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fin_prepost;

import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class FIN {
    long startTimestamp;
    long endTimestamp;
    int outputCount = 0;
    BufferedWriter writer = null;
    public int[][] bf;
    public int bf_cursor;
    public int bf_size;
    public int bf_col;
    public int bf_currentSize;
    public int numOfFItem;
    public int minSupport;
    public Item[] item;
    public int[] result;
    public int resultLen = 0;
    public int resultCount = 0;
    public int nlLenSum = 0;
    public PPCTreeNode ppcRoot;
    public NodeListTreeNode nlRoot;
    public int[] itemsetCount;
    public int[] nlistBegin;
    public int nlistCol;
    public int[] nlistLen;
    public int firstNlistBegin;
    public int PPCNodeCount;
    public int[] SupportDict;
    public int[] sameItems;
    public int nlNodeCount;
    static Comparator<Item> comp = new Comparator<Item>(){

        @Override
        public int compare(Item a, Item b) {
            return b.num - a.num;
        }
    };
    private int numOfTrans;

    public void runAlgorithm(String filename, double minsup, String output) throws IOException {
        this.ppcRoot = new PPCTreeNode();
        this.nlRoot = new NodeListTreeNode();
        this.nlNodeCount = 0;
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.startTimestamp = System.currentTimeMillis();
        this.bf_size = 1000000;
        this.bf = new int[100000][];
        this.bf_currentSize = this.bf_size * 10;
        this.bf[0] = new int[this.bf_currentSize];
        this.bf_cursor = 0;
        this.bf_col = 0;
        this.getData(filename, minsup);
        this.resultLen = 0;
        this.result = new int[this.numOfFItem];
        this.buildTree(filename);
        this.nlRoot.label = this.numOfFItem;
        this.nlRoot.firstChild = null;
        this.nlRoot.next = null;
        this.initializeTree();
        this.sameItems = new int[this.numOfFItem];
        int from_cursor = this.bf_cursor;
        int from_col = this.bf_col;
        int from_size = this.bf_currentSize;
        NodeListTreeNode curNode = this.nlRoot.firstChild;
        NodeListTreeNode next = null;
        while (curNode != null) {
            next = curNode.next;
            this.traverse(curNode, this.nlRoot, 1, 0);
            for (int c = this.bf_col; c > from_col; --c) {
                this.bf[c] = null;
            }
            this.bf_col = from_col;
            this.bf_cursor = from_cursor;
            this.bf_currentSize = from_size;
            curNode = next;
        }
        this.writer.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    void buildTree(String filename) throws IOException {
        String line;
        this.PPCNodeCount = 0;
        this.ppcRoot.label = -1;
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        Item[] transaction = new Item[1000];
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            int tLen = 0;
            block1: for (String itemString : lineSplited) {
                int itemX = Integer.parseInt(itemString);
                for (int j = 0; j < this.numOfFItem; ++j) {
                    if (itemX != this.item[j].index) continue;
                    transaction[tLen] = new Item();
                    transaction[tLen].index = itemX;
                    transaction[tLen].num = 0 - j;
                    ++tLen;
                    continue block1;
                }
            }
            Arrays.sort(transaction, 0, tLen, comp);
            int curPos = 0;
            PPCTreeNode curRoot = this.ppcRoot;
            PPCTreeNode rightSibling = null;
            while (curPos != tLen) {
                PPCTreeNode child = curRoot.firstChild;
                while (child != null) {
                    if (child.label == 0 - transaction[curPos].num) {
                        ++curPos;
                        ++child.count;
                        curRoot = child;
                        break;
                    }
                    if (child.rightSibling == null) {
                        rightSibling = child;
                        child = null;
                        break;
                    }
                    child = child.rightSibling;
                }
                if (child != null) continue;
                break;
            }
            for (int j = curPos; j < tLen; ++j) {
                PPCTreeNode ppcNode = new PPCTreeNode();
                ppcNode.label = 0 - transaction[j].num;
                if (rightSibling != null) {
                    rightSibling.rightSibling = ppcNode;
                    rightSibling = null;
                } else {
                    curRoot.firstChild = ppcNode;
                }
                ppcNode.rightSibling = null;
                ppcNode.firstChild = null;
                ppcNode.father = curRoot;
                ppcNode.count = 1;
                curRoot = ppcNode;
                ++this.PPCNodeCount;
            }
        }
        reader.close();
        PPCTreeNode root = this.ppcRoot.firstChild;
        int pre = 0;
        this.itemsetCount = new int[(this.numOfFItem - 1) * this.numOfFItem / 2];
        this.nlistBegin = new int[(this.numOfFItem - 1) * this.numOfFItem / 2];
        this.nlistLen = new int[(this.numOfFItem - 1) * this.numOfFItem / 2];
        this.SupportDict = new int[this.PPCNodeCount + 1];
        block6: while (root != null) {
            root.foreIndex = pre;
            this.SupportDict[pre] = root.count;
            ++pre;
            PPCTreeNode temp = root.father;
            while (temp.label != -1) {
                int n = root.label * (root.label - 1) / 2 + temp.label;
                this.itemsetCount[n] = this.itemsetCount[n] + root.count;
                int n2 = root.label * (root.label - 1) / 2 + temp.label;
                this.nlistLen[n2] = this.nlistLen[n2] + 1;
                temp = temp.father;
            }
            if (root.firstChild != null) {
                root = root.firstChild;
                continue;
            }
            if (root.rightSibling != null) {
                root = root.rightSibling;
                continue;
            }
            root = root.father;
            while (root != null) {
                if (root.rightSibling != null) {
                    root = root.rightSibling;
                    continue block6;
                }
                root = root.father;
            }
        }
        int sum = 0;
        for (int i = 0; i < (this.numOfFItem - 1) * this.numOfFItem / 2; ++i) {
            if (this.itemsetCount[i] < this.minSupport) continue;
            this.nlistBegin[i] = sum;
            sum += this.nlistLen[i];
        }
        if ((double)(this.bf_cursor + sum) > (double)this.bf_currentSize * 0.85) {
            ++this.bf_col;
            this.bf_cursor = 0;
            this.bf_currentSize = sum + 1000;
            this.bf[this.bf_col] = new int[this.bf_currentSize];
        }
        this.nlistCol = this.bf_col;
        this.firstNlistBegin = this.bf_cursor;
        root = this.ppcRoot.firstChild;
        this.bf_cursor += sum;
        block10: while (root != null) {
            PPCTreeNode temp = root.father;
            while (temp.label != -1) {
                if (this.itemsetCount[root.label * (root.label - 1) / 2 + temp.label] >= this.minSupport) {
                    int cursor = this.nlistBegin[root.label * (root.label - 1) / 2 + temp.label] + this.firstNlistBegin;
                    this.bf[this.nlistCol][cursor] = root.foreIndex;
                    int n = root.label * (root.label - 1) / 2 + temp.label;
                    this.nlistBegin[n] = this.nlistBegin[n] + 1;
                }
                temp = temp.father;
            }
            if (root.firstChild != null) {
                root = root.firstChild;
                continue;
            }
            if (root.rightSibling != null) {
                root = root.rightSibling;
                continue;
            }
            root = root.father;
            while (root != null) {
                if (root.rightSibling != null) {
                    root = root.rightSibling;
                    continue block10;
                }
                root = root.father;
            }
        }
        for (int i = 0; i < this.numOfFItem * (this.numOfFItem - 1) / 2; ++i) {
            if (this.itemsetCount[i] < this.minSupport) continue;
            this.nlistBegin[i] = this.nlistBegin[i] - this.nlistLen[i];
        }
    }

    void initializeTree() {
        NodeListTreeNode lastChild = null;
        for (int t = this.numOfFItem - 1; t >= 0; --t) {
            NodeListTreeNode nlNode = new NodeListTreeNode();
            nlNode.label = t;
            nlNode.support = 0;
            nlNode.NLStartinBf = this.bf_cursor;
            nlNode.NLLength = 0;
            nlNode.NLCol = this.bf_col;
            nlNode.firstChild = null;
            nlNode.next = null;
            nlNode.support = this.item[t].num;
            if (this.nlRoot.firstChild == null) {
                this.nlRoot.firstChild = nlNode;
                lastChild = nlNode;
                continue;
            }
            lastChild.next = nlNode;
            lastChild = nlNode;
        }
    }

    void getData(String filename, double minSupport) throws IOException {
        String line;
        this.numOfTrans = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            ++this.numOfTrans;
            for (String itemString : lineSplited = line.split(" ")) {
                Integer item = Integer.parseInt(itemString);
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                    continue;
                }
                count = count + 1;
                mapItemCount.put(item, count);
            }
        }
        reader.close();
        this.minSupport = (int)Math.ceil(minSupport * (double)this.numOfTrans);
        this.numOfFItem = mapItemCount.size();
        Item[] tempItems = new Item[this.numOfFItem];
        int i = 0;
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if (!((double)((Integer)entry.getValue()).intValue() >= minSupport)) continue;
            tempItems[i] = new Item();
            tempItems[i].index = (Integer)entry.getKey();
            tempItems[i].num = (Integer)entry.getValue();
            ++i;
        }
        this.item = new Item[i];
        System.arraycopy(tempItems, 0, this.item, 0, i);
        this.numOfFItem = this.item.length;
        Arrays.sort(this.item, comp);
    }

    NodeListTreeNode iskItemSetFreq(NodeListTreeNode ni, NodeListTreeNode nj, int level, NodeListTreeNode lastChild, IntegerByRef sameCountRef) {
        if (this.bf_cursor + ni.NLLength > this.bf_currentSize) {
            ++this.bf_col;
            this.bf_cursor = 0;
            this.bf_currentSize = this.bf_size > ni.NLLength * 1000 ? this.bf_size : ni.NLLength * 1000;
            this.bf[this.bf_col] = new int[this.bf_currentSize];
        }
        NodeListTreeNode nlNode = new NodeListTreeNode();
        nlNode.support = 0;
        nlNode.NLStartinBf = this.bf_cursor;
        nlNode.NLCol = this.bf_col;
        nlNode.NLLength = 0;
        int cursor_i = ni.NLStartinBf;
        int cursor_j = nj.NLStartinBf;
        int col_i = ni.NLCol;
        int col_j = nj.NLCol;
        while (cursor_i < ni.NLStartinBf + ni.NLLength && cursor_j < nj.NLStartinBf + nj.NLLength) {
            if (this.bf[col_i][cursor_i] == this.bf[col_j][cursor_j]) {
                this.bf[this.bf_col][this.bf_cursor++] = this.bf[col_j][cursor_j];
                ++nlNode.NLLength;
                nlNode.support += this.SupportDict[this.bf[col_i][cursor_i]];
                ++cursor_i;
                ++cursor_j;
                continue;
            }
            if (this.bf[col_i][cursor_i] < this.bf[col_j][cursor_j]) {
                ++cursor_i;
                continue;
            }
            ++cursor_j;
        }
        if (nlNode.support >= this.minSupport) {
            if (ni.support == nlNode.support) {
                this.sameItems[sameCountRef.count++] = nj.label;
            } else {
                nlNode.label = nj.label;
                nlNode.firstChild = null;
                nlNode.next = null;
                if (ni.firstChild == null) {
                    ni.firstChild = nlNode;
                    lastChild = nlNode;
                } else {
                    lastChild.next = nlNode;
                    lastChild = nlNode;
                }
            }
            return lastChild;
        }
        this.bf_cursor = nlNode.NLStartinBf;
        return lastChild;
    }

    public void traverse(NodeListTreeNode curNode, NodeListTreeNode curRoot, int level, int sameCount) throws IOException {
        MemoryLogger.getInstance().checkMemory();
        NodeListTreeNode sibling = curNode.next;
        NodeListTreeNode lastChild = null;
        while (sibling != null) {
            IntegerByRef sameCountTemp;
            if (level == 1 && this.itemsetCount[(curNode.label - 1) * curNode.label / 2 + sibling.label] >= this.minSupport) {
                sameCountTemp = new IntegerByRef();
                sameCountTemp.count = sameCount;
                lastChild = this.is2_itemSetValid(curNode, sibling, level, lastChild, sameCountTemp);
                sameCount = sameCountTemp.count;
            } else if (level > 1) {
                sameCountTemp = new IntegerByRef();
                sameCountTemp.count = sameCount;
                lastChild = this.iskItemSetFreq(curNode, sibling, level, lastChild, sameCountTemp);
                sameCount = sameCountTemp.count;
            }
            sibling = sibling.next;
        }
        this.resultCount = (int)((double)this.resultCount + Math.pow(2.0, sameCount));
        this.nlLenSum = (int)((double)this.nlLenSum + Math.pow(2.0, sameCount) * (double)curNode.NLLength);
        this.result[this.resultLen++] = curNode.label;
        this.writeItemsetsToFile(curNode, sameCount);
        ++this.nlNodeCount;
        int from_cursor = this.bf_cursor;
        int from_col = this.bf_col;
        int from_size = this.bf_currentSize;
        NodeListTreeNode child = curNode.firstChild;
        NodeListTreeNode next = null;
        while (child != null) {
            next = child.next;
            this.traverse(child, curNode, level + 1, sameCount);
            for (int c = this.bf_col; c > from_col; --c) {
                this.bf[c] = null;
            }
            this.bf_col = from_col;
            this.bf_cursor = from_cursor;
            this.bf_currentSize = from_size;
            child = next;
        }
        --this.resultLen;
    }

    NodeListTreeNode is2_itemSetValid(NodeListTreeNode ni, NodeListTreeNode nj, int level, NodeListTreeNode lastChild, IntegerByRef sameCount) {
        int i = ni.label;
        int j = nj.label;
        if (ni.support == this.itemsetCount[(i - 1) * i / 2 + j]) {
            this.sameItems[sameCount.count++] = nj.label;
        } else {
            NodeListTreeNode nlNode = new NodeListTreeNode();
            nlNode.label = j;
            nlNode.NLCol = this.nlistCol;
            nlNode.NLStartinBf = this.nlistBegin[(i - 1) * i / 2 + j];
            nlNode.NLLength = this.nlistLen[(i - 1) * i / 2 + j];
            nlNode.support = this.itemsetCount[(i - 1) * i / 2 + j];
            nlNode.firstChild = null;
            nlNode.next = null;
            if (ni.firstChild == null) {
                ni.firstChild = nlNode;
                lastChild = nlNode;
            } else {
                lastChild.next = nlNode;
                lastChild = nlNode;
            }
        }
        return lastChild;
    }

    private void writeItemsetsToFile(NodeListTreeNode curNode, int sameCount) throws IOException {
        StringBuilder buffer = new StringBuilder();
        if (curNode.support >= this.minSupport) {
            ++this.outputCount;
            for (int i = 0; i < this.resultLen; ++i) {
                buffer.append(this.item[this.result[i]].index);
                buffer.append(' ');
            }
            buffer.append("#SUP: ");
            buffer.append(curNode.support);
            buffer.append("\n");
        }
        if (sameCount > 0) {
            long max = 1 << sameCount;
            for (long i = 1L; i < max; ++i) {
                for (int k = 0; k < this.resultLen; ++k) {
                    buffer.append(this.item[this.result[k]].index);
                    buffer.append(' ');
                }
                for (int j = 0; j < sameCount; ++j) {
                    int isSet = (int)i & 1 << j;
                    if (isSet <= 0) continue;
                    buffer.append(this.item[this.sameItems[j]].index);
                    buffer.append(' ');
                }
                buffer.append("#SUP: ");
                buffer.append(curNode.support);
                buffer.append("\n");
                ++this.outputCount;
            }
        }
        this.writer.write(buffer.toString());
    }

    public void printStats() {
        System.out.println("========== FIN - STATS ============");
        System.out.println(" Minsup = " + this.minSupport + "\n Number of transactions: " + this.numOfTrans);
        System.out.println(" Number of frequent  itemsets: " + this.outputCount);
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================");
    }

    class PPCTreeNode {
        public int label;
        public PPCTreeNode firstChild;
        public PPCTreeNode rightSibling;
        public PPCTreeNode father;
        public int count;
        public int foreIndex;

        PPCTreeNode() {
        }
    }

    class NodeListTreeNode {
        public int label;
        public NodeListTreeNode firstChild;
        public NodeListTreeNode next;
        public int support;
        public int NLStartinBf;
        public int NLLength;
        public int NLCol;

        NodeListTreeNode() {
        }
    }

    class Item {
        public int index;
        public int num;

        Item() {
        }
    }

    class IntegerByRef {
        int count;

        IntegerByRef() {
        }
    }
}

