/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.foshu;

import ca.pfv.spmf.algorithms.frequentpatterns.foshu.ElementFOSHU;
import ca.pfv.spmf.algorithms.frequentpatterns.foshu.UtilityListFOSHU;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoFOSHU {
    public double maxMemory = 0.0;
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int joinCount = 0;
    public String input;
    Map<Integer, Integer> mapItemToTWU;
    int[] transactionsTU;
    BufferedWriter writer = null;
    boolean debug = false;
    public int maxSEQUENCECOUNT = Integer.MAX_VALUE;
    Set<Integer> negativeItems = null;
    double minUtilityRatio = 0.0;
    List<Integer> periodUtilities = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, double minUtilityRatio) throws IOException {
        int period;
        String thisLine;
        this.maxMemory = 0.0;
        this.input = input;
        this.minUtilityRatio = minUtilityRatio;
        this.startTimestamp = System.currentTimeMillis();
        this.negativeItems = new HashSet<Integer>();
        this.periodUtilities = new ArrayList<Integer>();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        int transactionCount = 0;
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null && transactionCount <= this.maxSEQUENCECOUNT) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                ++transactionCount;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                int[] utilityValuesInt = new int[utilityValues.length];
                int transactionUtilityWithNegativeAndPositive = 0;
                int transactionUtilityWithPositive = 0;
                for (int j = 0; j < utilityValues.length; ++j) {
                    utilityValuesInt[j] = Integer.parseInt(utilityValues[j]);
                    transactionUtilityWithNegativeAndPositive += utilityValuesInt[j];
                    if (utilityValuesInt[j] <= 0) continue;
                    transactionUtilityWithPositive += utilityValuesInt[j];
                }
                period = Integer.parseInt(split[3]);
                int transactionUtility = transactionUtilityWithPositive;
                for (int i = 0; i < items.length; ++i) {
                    Integer twu;
                    Integer item = Integer.parseInt(items[i]);
                    Integer itemUtility = utilityValuesInt[i];
                    if (itemUtility < 0) {
                        this.negativeItems.add(item);
                    }
                    twu = (twu = this.mapItemToTWU.get(item)) == null ? transactionUtility : twu + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                }
                this.incrementPeriodUtility(period, transactionUtilityWithNegativeAndPositive);
            }
        }
        ArrayList<UtilityListFOSHU> listOfUtilityLists = new ArrayList<UtilityListFOSHU>();
        HashMap<Integer, UtilityListFOSHU> mapItemToUtilityList = new HashMap<Integer, UtilityListFOSHU>();
        this.transactionsTU = new int[transactionCount];
        for (Map.Entry<Integer, Integer> entryItemEUtility : this.mapItemToTWU.entrySet()) {
            int item = entryItemEUtility.getKey();
            UtilityListFOSHU uList = new UtilityListFOSHU(item, this.periodUtilities.size());
            mapItemToUtilityList.put(item, uList);
            listOfUtilityLists.add(uList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityListFOSHU>(){

            @Override
            public int compare(UtilityListFOSHU o1, UtilityListFOSHU o2) {
                return AlgoFOSHU.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null && tid <= this.maxSEQUENCECOUNT) {
                Pair pair;
                int i;
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                period = Integer.parseInt(split[3]);
                int remainingUtility = 0;
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                for (i = 0; i < items.length; ++i) {
                    pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    revisedTransaction.add(pair);
                    if (this.negativeItems.contains(pair.item)) continue;
                    remainingUtility += pair.utility;
                }
                this.transactionsTU[tid] = remainingUtility;
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoFOSHU.this.compareItems(o1.item, o2.item);
                    }
                });
                for (i = 0; i < revisedTransaction.size(); ++i) {
                    ElementFOSHU element;
                    pair = (Pair)revisedTransaction.get(i);
                    if (remainingUtility != 0) {
                        remainingUtility -= pair.utility;
                    }
                    UtilityListFOSHU utilityListOfItem = (UtilityListFOSHU)mapItemToUtilityList.get(pair.item);
                    if (pair.utility > 0) {
                        element = new ElementFOSHU(tid, pair.utility, 0, remainingUtility);
                        utilityListOfItem.addElement(element, period);
                        continue;
                    }
                    element = new ElementFOSHU(tid, 0, pair.utility, remainingUtility);
                    utilityListOfItem.addElement(element, period);
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        Iterator iter = listOfUtilityLists.iterator();
        while (iter.hasNext()) {
            UtilityListFOSHU X = (UtilityListFOSHU)iter.next();
            boolean isPromisingInAtLeastAPeriod = false;
            for (int z = 0; z < this.periodUtilities.size(); ++z) {
                if (!X.appearsInPeriod(z)) continue;
                int twuX = 0;
                for (ElementFOSHU element : X.getElementsOfPeriod(z)) {
                    twuX += this.transactionsTU[element.tid];
                }
                if (!(this.calculateRelativeUtilityInPeriod(z, twuX) >= minUtilityRatio)) continue;
                isPromisingInAtLeastAPeriod = true;
                break;
            }
            if (isPromisingInAtLeastAPeriod) continue;
            iter.remove();
        }
        this.foshu(new int[0], null, listOfUtilityLists);
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private double calculateRelativeUtilityInPeriod(int z, double utility) {
        double x = Math.abs((double)this.periodUtilities.get(z).intValue());
        if (x == 0.0) {
            return 0.0;
        }
        return utility / Math.abs((double)this.periodUtilities.get(z).intValue());
    }

    private double calculateRelativeUtility(int sumPeriodUtility, double utility) {
        if (sumPeriodUtility == 0) {
            return 0.0;
        }
        return utility / (double)Math.abs(sumPeriodUtility);
    }

    private int compareItems(int item1, int item2) {
        Boolean item1IsNegative = this.negativeItems.contains(item1);
        Boolean item2IsNegative = this.negativeItems.contains(item2);
        if (!item1IsNegative.booleanValue() && item2IsNegative.booleanValue()) {
            return -1;
        }
        if (item1IsNegative.booleanValue() && !item2IsNegative.booleanValue()) {
            return 1;
        }
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void foshu(int[] prefix, UtilityListFOSHU pUL, List<UtilityListFOSHU> ULs) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityListFOSHU X = ULs.get(i);
            int sumPeriodUtility = 0;
            boolean isPromisingInAtLeastOnePeriod = false;
            for (int z = 0; z < this.periodUtilities.size(); ++z) {
                if (!X.appearsInPeriod(z)) continue;
                sumPeriodUtility += this.periodUtilities.get(z).intValue();
                if (!(this.calculateRelativeUtilityInPeriod(z, X.getSumIRUtilsInPeriod(z)) >= this.minUtilityRatio)) continue;
                isPromisingInAtLeastOnePeriod = true;
            }
            double ru = this.calculateRelativeUtility(sumPeriodUtility, X.sumIutilP + X.sumIutilN);
            if (ru >= this.minUtilityRatio) {
                this.writeOut(prefix, X.item, X.sumIutilP + X.sumIutilN, ru);
            }
            if (!isPromisingInAtLeastOnePeriod) continue;
            ArrayList<UtilityListFOSHU> exULs = new ArrayList<UtilityListFOSHU>();
            int[] newPrefix = new int[prefix.length + 1];
            System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
            newPrefix[prefix.length] = X.item;
            for (int j = i + 1; j < ULs.size(); ++j) {
                UtilityListFOSHU Y = ULs.get(j);
                ++this.joinCount;
                UtilityListFOSHU pXY = new UtilityListFOSHU(this.periodUtilities.size(), pUL, X, Y);
                boolean isPromisingInAtLeastAPeriod = false;
                for (int z = 0; z < this.periodUtilities.size(); ++z) {
                    if (!pXY.appearsInPeriod(z)) continue;
                    int twuXY = 0;
                    for (ElementFOSHU element : pXY.getElementsOfPeriod(z)) {
                        twuXY += this.transactionsTU[element.tid];
                    }
                    if (!(this.calculateRelativeUtilityInPeriod(z, twuXY) >= this.minUtilityRatio)) continue;
                    isPromisingInAtLeastAPeriod = true;
                    break;
                }
                if (!isPromisingInAtLeastAPeriod) continue;
                exULs.add(pXY);
            }
            this.foshu(newPrefix, X, exULs);
        }
    }

    private void writeOut(int[] prefix, int item, int utility, double relativeUtility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefix.length; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        buffer.append(" #RUTIL: ");
        buffer.append(relativeUtility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    private void incrementPeriodUtility(int period, int transactionUtility) {
        boolean notSeenBefore;
        boolean bl = notSeenBefore = this.periodUtilities.size() < period + 1;
        if (notSeenBefore) {
            while (this.periodUtilities.size() < period) {
                this.periodUtilities.add(0);
            }
            this.periodUtilities.add(transactionUtility);
        } else {
            int sumUtility = this.periodUtilities.get(period) + transactionUtility;
            this.periodUtilities.set(period, sumUtility);
        }
    }

    public void printStats() throws IOException {
        System.out.println("=============  FOSHU ALGORITHM v2.02 - STATS =============");
        System.out.println("Dataset : " + this.input);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" HOU count : " + this.huiCount);
        System.out.println(" Join count : " + this.joinCount);
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }

        public String toString() {
            return "[" + this.item + "," + this.utility + "]";
        }
    }
}

