/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.foshu;

import ca.pfv.spmf.algorithms.frequentpatterns.foshu.ElementFOSHU;
import java.util.ArrayList;
import java.util.List;

public class UtilityListFOSHU {
    public Integer item;
    public int sumIutilP = 0;
    public int sumIutilN = 0;
    private List<ElementFOSHU>[] periodsElements;
    private int[] periodsSumIutilRutil;

    public UtilityListFOSHU(Integer item, int periodCount) {
        this.item = item;
        this.periodsElements = new ArrayList[periodCount];
        this.periodsSumIutilRutil = new int[periodCount];
    }

    public UtilityListFOSHU(int periodCount, UtilityListFOSHU pUL, UtilityListFOSHU x, UtilityListFOSHU y) {
        this.item = y.item;
        this.periodsElements = new ArrayList[periodCount];
        this.periodsSumIutilRutil = new int[periodCount];
        if (pUL == null) {
            for (int i = 0; i < periodCount; ++i) {
                if (x.periodsElements[i] == null || y.periodsElements[i] == null) continue;
                this.construct(i, x.periodsElements[i], y.periodsElements[i]);
            }
        } else {
            for (int i = 0; i < periodCount; ++i) {
                if (x.periodsElements[i] == null || y.periodsElements[i] == null) continue;
                this.construct(i, pUL.periodsElements[i], x.periodsElements[i], y.periodsElements[i]);
            }
        }
    }

    public void addElement(ElementFOSHU element, int period) {
        if (this.periodsElements[period] == null) {
            this.periodsElements[period] = new ArrayList<ElementFOSHU>();
        }
        this.periodsElements[period].add(element);
        this.sumIutilP += element.iputils;
        this.sumIutilN += element.inutils;
        int n = period;
        this.periodsSumIutilRutil[n] = this.periodsSumIutilRutil[n] + (element.iputils + element.rutils);
    }

    private void construct(int period, List<ElementFOSHU> pElements, List<ElementFOSHU> pXElements, List<ElementFOSHU> pYElements) {
        this.periodsElements[period] = new ArrayList<ElementFOSHU>();
        for (ElementFOSHU ex : pXElements) {
            ElementFOSHU e;
            ElementFOSHU ey = this.findElementWithTID(pYElements, ex.tid);
            if (ey == null || (e = this.findElementWithTID(pElements, ex.tid)) == null) continue;
            ElementFOSHU eXY = new ElementFOSHU(ex.tid, ex.iputils + ey.iputils - e.iputils, ex.inutils + ey.inutils - e.inutils, ey.rutils);
            this.addElement(eXY, period);
        }
    }

    private void construct(int period, List<ElementFOSHU> pXElements, List<ElementFOSHU> pYElements) {
        this.periodsElements[period] = new ArrayList<ElementFOSHU>();
        for (ElementFOSHU ex : pXElements) {
            ElementFOSHU ey = this.findElementWithTID(pYElements, ex.tid);
            if (ey == null) continue;
            ElementFOSHU eXY = new ElementFOSHU(ex.tid, ex.iputils + ey.iputils, ex.inutils + ey.inutils, ey.rutils);
            this.addElement(eXY, period);
        }
    }

    private ElementFOSHU findElementWithTID(List<ElementFOSHU> list, int tid) {
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    public double getSumIRUtilsInPeriod(int period) {
        return this.periodsSumIutilRutil[period];
    }

    public boolean appearsInPeriod(int period) {
        return this.periodsElements[period] != null && this.periodsElements[period].size() != 0;
    }

    public List<ElementFOSHU> getElementsOfPeriod(int period) {
        return this.periodsElements[period];
    }
}

