/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.CFINode;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class CFITree {
    Map<Integer, CFINode> mapItemNodes = new HashMap<Integer, CFINode>();
    Map<Integer, CFINode> mapItemLastNode = new HashMap<Integer, CFINode>();
    CFINode root = new CFINode();
    CFINode lastAddedItemsetNode = null;
    Comparator<Integer> comparatorOriginalOrder = null;

    private void fixNodeLinks(Integer item, CFINode newNode) {
        CFINode lastNode = this.mapItemLastNode.get(item);
        if (lastNode != null) {
            lastNode.nodeLink = newNode;
        }
        this.mapItemLastNode.put(item, newNode);
        CFINode headernode = this.mapItemNodes.get(item);
        if (headernode == null) {
            this.mapItemNodes.put(item, newNode);
        }
    }

    public void addCFI(int[] itemset2, int itemsetLength, int support) {
        CFINode currentNode = this.root;
        for (int i = 0; i < itemsetLength; ++i) {
            int item = itemset2[i];
            CFINode child = currentNode.getChildWithID(item);
            if (child == null) {
                CFINode newNode = new CFINode();
                newNode.itemID = item;
                newNode.parent = currentNode;
                newNode.level = i + 1;
                newNode.counter = support;
                currentNode.childs.add(newNode);
                currentNode = newNode;
                this.fixNodeLinks(item, newNode);
                continue;
            }
            child.counter = Math.max(support, child.counter);
            currentNode = child;
        }
        this.lastAddedItemsetNode = currentNode;
    }

    public boolean passSubsetChecking(int[] headWithP, int headWithPLength, int headWithPSupport) {
        boolean isSubset;
        if (this.lastAddedItemsetNode != null && this.lastAddedItemsetNode.counter == headWithPSupport && (isSubset = this.issASubsetOfPrefixPath(headWithP, headWithPLength, this.lastAddedItemsetNode))) {
            return false;
        }
        Integer firstITem = headWithP[headWithP.length - 1];
        CFINode node = this.mapItemNodes.get(firstITem);
        if (node == null) {
            return true;
        }
        do {
            boolean isSubset2;
            boolean bl = isSubset2 = node.counter == headWithPSupport && this.issASubsetOfPrefixPath(headWithP, headWithPLength, node);
            if (!isSubset2) continue;
            return false;
        } while ((node = node.nodeLink) != null);
        return true;
    }

    private boolean issASubsetOfPrefixPath(int[] headWithP, int headWithPLength, CFINode node) {
        if (node.level >= headWithPLength) {
            CFINode nodeToCheck = node;
            int positionInItemset = headWithP.length - 1;
            int itemToLookFor = headWithP[positionInItemset];
            do {
                if (nodeToCheck.itemID != itemToLookFor) continue;
                if (--positionInItemset < 0) {
                    return true;
                }
                itemToLookFor = headWithP[positionInItemset];
            } while ((nodeToCheck = nodeToCheck.parent) != null);
        }
        return false;
    }

    public String toString() {
        return "M" + this.root.toString("");
    }

    public int calculateSupport(int[] itemset2) {
        this.sortOriginalOrder(itemset2, itemset2.length);
        Integer firstITem = itemset2[itemset2.length - 1];
        CFINode node = this.mapItemNodes.get(firstITem);
        int maxSupport = -1;
        do {
            if (!this.issASubsetOfPrefixPath(itemset2, itemset2.length, node) || node.counter <= maxSupport) continue;
            maxSupport = node.counter;
        } while ((node = node.nodeLink) != null);
        if (maxSupport != -1) {
            return maxSupport;
        }
        throw new Error("CFI-Tree: itemset not found. This should not happen");
    }

    public void setComparator(Comparator<Integer> comparatorOriginalOrder) {
        this.comparatorOriginalOrder = comparatorOriginalOrder;
    }

    public void sortOriginalOrder(int[] a, int length) {
        for (int i = 0; i < length; ++i) {
            for (int j = length - 1; j >= i + 1; --j) {
                boolean test;
                boolean bl = test = this.comparatorOriginalOrder.compare(a[j], a[j - 1]) < 0;
                if (!test) continue;
                int temp = a[j];
                a[j] = a[j - 1];
                a[j - 1] = temp;
            }
        }
    }
}

