/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.MFINode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MFITree {
    Map<Integer, MFINode> mapItemNodes = new HashMap<Integer, MFINode>();
    Map<Integer, MFINode> mapItemLastNode = new HashMap<Integer, MFINode>();
    MFINode root = new MFINode();
    MFINode lastAddedItemsetNode = null;

    private void fixNodeLinks(Integer item, MFINode newNode) {
        MFINode lastNode = this.mapItemLastNode.get(item);
        if (lastNode != null) {
            lastNode.nodeLink = newNode;
        }
        this.mapItemLastNode.put(item, newNode);
        MFINode headernode = this.mapItemNodes.get(item);
        if (headernode == null) {
            this.mapItemNodes.put(item, newNode);
        }
    }

    public void addMFI(int[] itemset2, int itemsetLength, int support) {
        MFINode currentNode = this.root;
        for (int i = 0; i < itemsetLength; ++i) {
            int item = itemset2[i];
            MFINode child = currentNode.getChildWithID(item);
            if (child == null) {
                MFINode newNode = new MFINode();
                newNode.itemID = item;
                newNode.parent = currentNode;
                newNode.level = i + 1;
                currentNode.childs.add(newNode);
                currentNode = newNode;
                this.fixNodeLinks(item, newNode);
                continue;
            }
            currentNode = child;
        }
        this.lastAddedItemsetNode = currentNode;
    }

    public boolean passSubsetChecking(List<Integer> headWithP) {
        boolean isSubset;
        Integer lastItem = headWithP.get(headWithP.size() - 1);
        if (this.lastAddedItemsetNode != null && (isSubset = this.issASubsetOfPrefixPath(headWithP, this.lastAddedItemsetNode))) {
            return false;
        }
        MFINode node = this.mapItemNodes.get(lastItem);
        if (node == null) {
            return true;
        }
        do {
            boolean isSubset2;
            if (!(isSubset2 = this.issASubsetOfPrefixPath(headWithP, node))) continue;
            return false;
        } while ((node = node.nodeLink) != null);
        return true;
    }

    private boolean issASubsetOfPrefixPath(List<Integer> headWithP, MFINode node) {
        if (node.level >= headWithP.size()) {
            MFINode nodeToCheck = node;
            int positionInItemset = headWithP.size() - 1;
            int itemToLookFor = headWithP.get(positionInItemset);
            do {
                if (nodeToCheck.itemID != itemToLookFor) continue;
                if (--positionInItemset < 0) {
                    return true;
                }
                itemToLookFor = headWithP.get(positionInItemset);
            } while ((nodeToCheck = nodeToCheck.parent) != null);
        }
        return false;
    }

    public String toString() {
        return "M" + this.root.toString("");
    }
}

