/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.haui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.haui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_miner.UtilityList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoHAUIMiner {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int huiCount = 0;
    Map<Integer, Integer> mapItemToAUUB;
    BufferedWriter writer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minAUtility) throws IOException {
        String thisLine;
        this.maxMemory = 0.0;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToAUUB = new HashMap<Integer, Integer>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                int i;
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                Integer transactionMUtility = Integer.MIN_VALUE;
                for (i = 0; i < utilityValues.length; ++i) {
                    if (transactionMUtility >= Integer.parseInt(utilityValues[i])) continue;
                    transactionMUtility = Integer.parseInt(utilityValues[i]);
                }
                for (i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer auub = this.mapItemToAUUB.get(item);
                    auub = auub == null ? transactionMUtility : auub + transactionMUtility;
                    this.mapItemToAUUB.put(item, auub);
                }
            }
        }
        ArrayList<Integer> ltemLists = new ArrayList<Integer>();
        for (Integer item : this.mapItemToAUUB.keySet()) {
            if (this.mapItemToAUUB.get(item) < minAUtility) continue;
            ltemLists.add(item);
        }
        Collections.sort(ltemLists, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return AlgoHAUIMiner.this.compareItems(o1, o2);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            ArrayList<List<Pair>> reviesdDatabase = new ArrayList<List<Pair>>();
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                for (int i = 0; i < items.length; ++i) {
                    Pair pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (this.mapItemToAUUB.get(pair.item) < minAUtility) continue;
                    revisedTransaction.add(pair);
                }
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoHAUIMiner.this.compareItems(o1.item, o2.item);
                    }
                });
                reviesdDatabase.add(revisedTransaction);
            }
            for (Integer item : ltemLists) {
                this.initialUtilityList(minAUtility, reviesdDatabase, item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void initialUtilityList(int minAUtility, List<List<Pair>> revisedDatabase, int item) throws IOException {
        Pair pair;
        int j;
        int i;
        int tid;
        HashMap<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
        HashMap<Integer, Integer> mapItemToAuubList = new HashMap<Integer, Integer>();
        for (tid = 0; tid < revisedDatabase.size(); ++tid) {
            for (i = 0; i < revisedDatabase.get(tid).size(); ++i) {
                if (revisedDatabase.get((int)tid).get((int)i).item != item) continue;
                int transactionMaxUtility = Integer.MIN_VALUE;
                for (j = i; j < revisedDatabase.get(tid).size(); ++j) {
                    pair = revisedDatabase.get(tid).get(j);
                    if (pair.utility <= transactionMaxUtility) continue;
                    transactionMaxUtility = pair.utility;
                }
                for (j = i; j < revisedDatabase.get(tid).size(); ++j) {
                    pair = revisedDatabase.get(tid).get(j);
                    Integer auub = (Integer)mapItemToAuubList.get(pair.item);
                    auub = auub == null ? transactionMaxUtility : auub + transactionMaxUtility;
                    mapItemToAuubList.put(pair.item, auub);
                }
            }
        }
        block4: for (tid = 0; tid < revisedDatabase.size(); ++tid) {
            for (i = 0; i < revisedDatabase.get(tid).size(); ++i) {
                if (revisedDatabase.get((int)tid).get((int)i).item != item) continue;
                int maxUtility = Integer.MIN_VALUE;
                for (j = i; j < revisedDatabase.get(tid).size(); ++j) {
                    pair = revisedDatabase.get(tid).get(j);
                    if ((Integer)mapItemToAuubList.get(pair.item) < minAUtility || pair.utility <= maxUtility) continue;
                    maxUtility = pair.utility;
                }
                for (j = i; j < revisedDatabase.get(tid).size(); ++j) {
                    UtilityList utilityListOfItem;
                    pair = revisedDatabase.get(tid).get(j);
                    Element element = new Element(tid, pair.utility, maxUtility);
                    if ((Integer)mapItemToAuubList.get(pair.item) < minAUtility) continue;
                    if (mapItemToUtilityList.containsKey(pair.item)) {
                        utilityListOfItem = (UtilityList)mapItemToUtilityList.get(pair.item);
                        utilityListOfItem.addElement(element);
                        continue;
                    }
                    utilityListOfItem = new UtilityList(pair.item);
                    utilityListOfItem.addElement(element);
                    mapItemToUtilityList.put(pair.item, utilityListOfItem);
                }
                continue block4;
            }
        }
        ArrayList<UtilityList> listOfUtilityLists = new ArrayList<UtilityList>();
        for (Integer mapItem : mapItemToUtilityList.keySet()) {
            UtilityList auList = (UtilityList)mapItemToUtilityList.get(mapItem);
            if (auList.sumMutils < minAUtility) continue;
            listOfUtilityLists.add(auList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

            @Override
            public int compare(UtilityList o1, UtilityList o2) {
                return AlgoHAUIMiner.this.compareItems(o1.item, o2.item);
            }
        });
        this.huiMiner(new int[0], null, listOfUtilityLists, minAUtility, 1.0);
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToAUUB.get(item1) - this.mapItemToAUUB.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void huiMiner(int[] prefix, UtilityList pUL, List<UtilityList> ULs, int minAUtility, double length) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityList X = ULs.get(i);
            if ((double)X.sumIutils / length >= (double)minAUtility) {
                this.writeOut(prefix, X.item, (double)X.sumIutils / length);
            }
            if (X.sumMutils >= minAUtility) {
                ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
                for (int j = i + 1; j < ULs.size(); ++j) {
                    UtilityList Y = ULs.get(j);
                    exULs.add(this.construct(pUL, X, Y));
                }
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = X.item;
                this.huiMiner(newPrefix, X, exULs, minAUtility, length + 1.0);
            }
            if (length == 1.0) break;
        }
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py) {
        UtilityList pxyUL = new UtilityList(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.mutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.mutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int item, double autility) throws IOException {
        ++this.huiCount;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < prefix.length; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(item);
        buffer.append(" #AUTIL: ");
        buffer.append(autility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  HAUI-MINER ALGORITHM v.2.15 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

