/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau;

import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.ItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.ItemsetTP;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.ItemsetsTP;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.TransactionTP;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.UtilityTransactionDatabaseTP;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoHAUIMMAU {
    private ItemsetsTP highAUtilityItemsets = null;
    protected UtilityTransactionDatabaseTP database;
    Map<Integer, Integer> minAUtility = new HashMap<Integer, Integer>();
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    private int candidatesCount;

    public ItemsetsTP runAlgorithm(UtilityTransactionDatabaseTP database, Map<Integer, Integer> mutipleMinUtilities, int GLMAU) {
        int candidateCount;
        int i;
        this.database = database;
        this.minAUtility = mutipleMinUtilities;
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.highAUtilityItemsets = new ItemsetsTP("HIGH AVERAGE UTILITY ITEMSETS WITH MULTIPLE MINIMUM THRESHOLDS");
        HashMap<List<Integer>, Integer> HAUIMap = new HashMap<List<Integer>, Integer>();
        HashMap<List<Integer>, Integer> candidateHAUIMap = new HashMap<List<Integer>, Integer>();
        this.candidatesCount = 0;
        ArrayList<ItemsetTP> candidatesSize1 = new ArrayList<ItemsetTP>();
        HashMap<Integer, HashSet<Integer>> mapItemTidsets = new HashMap<Integer, HashSet<Integer>>();
        HashMap<Integer, Integer> mapItemAUUB = new HashMap<Integer, Integer>();
        int maxItem = Integer.MIN_VALUE;
        for (i = 0; i < database.size(); ++i) {
            TransactionTP transaction = database.getTransactions().get(i);
            for (int j = 0; j < transaction.getItems().size(); ++j) {
                HashSet<Integer> tidset2;
                ItemUtility itemUtilityObj = transaction.getItems().get(j);
                int item = itemUtilityObj.item;
                if (item > maxItem) {
                    maxItem = item;
                }
                if ((tidset2 = (HashSet<Integer>)mapItemTidsets.get(item)) == null) {
                    tidset2 = new HashSet<Integer>();
                    mapItemTidsets.put(item, tidset2);
                }
                tidset2.add(i);
                Integer sumUtility = (Integer)mapItemAUUB.get(item);
                if (sumUtility == null) {
                    sumUtility = 0;
                }
                sumUtility = sumUtility + transaction.getTransactionUtility();
                mapItemAUUB.put(item, sumUtility);
            }
        }
        for (int item = 0; item <= maxItem; ++item) {
            Integer estimatedUtility = (Integer)mapItemAUUB.get(item);
            if (estimatedUtility == null || estimatedUtility < database.getLMAU(GLMAU)) continue;
            ItemsetTP itemset2 = new ItemsetTP();
            itemset2.addItem(item);
            itemset2.setTIDset((Set)mapItemTidsets.get(item));
            candidateHAUIMap.put(itemset2.getItems(), estimatedUtility);
            candidatesSize1.add(itemset2);
            this.highAUtilityItemsets.addItemset(itemset2, itemset2.size());
        }
        for (i = 0; i < candidatesSize1.size(); ++i) {
            for (int j = candidatesSize1.size() - 1; j > 0; --j) {
                if (mutipleMinUtilities.get(((ItemsetTP)candidatesSize1.get(j - 1)).getItems().get(0)) <= mutipleMinUtilities.get(((ItemsetTP)candidatesSize1.get(j)).getItems().get(0))) continue;
                Collections.swap(candidatesSize1, j, j - 1);
            }
        }
        List<ItemsetTP> currentLevel = candidatesSize1;
        do {
            candidateCount = this.highAUtilityItemsets.getItemsetsCount();
            currentLevel = this.generateCandidateSizeK(currentLevel, this.highAUtilityItemsets, candidateHAUIMap, mutipleMinUtilities, GLMAU);
        } while (candidateCount != this.highAUtilityItemsets.getItemsetsCount());
        MemoryLogger.getInstance().checkMemory();
        for (List<ItemsetTP> level : this.highAUtilityItemsets.getLevels()) {
            this.candidatesCount += level.size();
            Iterator<ItemsetTP> iterItemset = level.iterator();
            while (iterItemset.hasNext()) {
                ItemsetTP candidate = iterItemset.next();
                if (!AlgoHAUIMMAU.judge(candidate.getItems(), HAUIMap, true)) {
                    iterItemset.remove();
                    this.highAUtilityItemsets.decreaseCount();
                    continue;
                }
                for (TransactionTP transaction : database.getTransactions()) {
                    int transactionUtility = 0;
                    int matchesCount = 0;
                    for (int i2 = 0; i2 < transaction.size(); ++i2) {
                        if (!candidate.getItems().contains(transaction.get((int)i2).item)) continue;
                        transactionUtility += transaction.getItemsUtilities().get((int)i2).utility;
                        ++matchesCount;
                    }
                    if (matchesCount != candidate.size()) continue;
                    candidate.incrementUtility(transactionUtility);
                }
                if ((float)candidate.getAUtility() >= candidate.getItemsetMau(mutipleMinUtilities, GLMAU)) {
                    HAUIMap.put(candidate.getItems(), candidate.getAUtility());
                }
                if (!((float)candidate.getAUtility() < candidate.getItemsetMau(mutipleMinUtilities, GLMAU))) continue;
                iterItemset.remove();
                this.highAUtilityItemsets.decreaseCount();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        return this.highAUtilityItemsets;
    }

    protected static boolean judge(List<Integer> items, Map<List<Integer>, Integer> HAUIMap, boolean mark) {
        int i;
        boolean temp = true;
        if (items.size() == 1) {
            return true;
        }
        ArrayList subset = new ArrayList();
        ArrayList<Integer> set = new ArrayList<Integer>();
        set.add(items.get(0));
        subset.add(set);
        for (i = 1; i < items.size() - 1; ++i) {
            ArrayList<Integer> setadd;
            int k = subset.size();
            for (int j = 0; j < k; ++j) {
                setadd = new ArrayList<Integer>();
                setadd.addAll((Collection)subset.get(j));
                setadd.add(items.get(i));
                subset.add(setadd);
            }
            setadd = new ArrayList();
            setadd.add(items.get(i));
            subset.add(setadd);
        }
        for (i = 0; i < subset.size(); ++i) {
            if (mark) {
                if (HAUIMap.containsKey(subset.get(i)) || HAUIMap.containsKey(AlgoHAUIMMAU.subtraction(items, (List)subset.get(i)))) continue;
                temp = false;
                break;
            }
            if (HAUIMap.containsKey(subset.get(i)) && HAUIMap.containsKey(AlgoHAUIMMAU.subtraction(items, (List)subset.get(i)))) continue;
            temp = false;
            break;
        }
        return temp;
    }

    protected static List<Integer> subtraction(List<Integer> items, List<Integer> subitems) {
        ArrayList<Integer> remainitems = new ArrayList<Integer>();
        for (int i = 0; i < items.size(); ++i) {
            boolean temp = true;
            for (int j = 0; j < subitems.size(); ++j) {
                if (items.get(i) != subitems.get(j)) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            remainitems.add(items.get(i));
        }
        return remainitems;
    }

    protected List<ItemsetTP> generateCandidateSizeK(List<ItemsetTP> levelK_1, ItemsetsTP candidatesHAUUBI, Map<List<Integer>, Integer> candidateHAUIMap, Map<Integer, Integer> mutipleMinUtilities, int GLMAU) {
        for (int i = 0; i < levelK_1.size(); ++i) {
            ItemsetTP itemset1 = levelK_1.get(i);
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                ItemsetTP itemset2 = levelK_1.get(j);
                for (int k = 0; k < itemset1.size() - 1; ++k) {
                    if (itemset1.getItems().get(k) != itemset2.get(k)) continue block1;
                }
                Integer missing = itemset2.get(itemset2.size() - 1);
                ItemsetTP candidate = new ItemsetTP();
                for (int k = 0; k < itemset1.size(); ++k) {
                    candidate.addItem(itemset1.get(k));
                }
                candidate.addItem(missing);
                if (!AlgoHAUIMMAU.judge(candidate.getItems(), candidateHAUIMap, false)) continue;
                HashSet<Integer> tidset2 = new HashSet<Integer>();
                for (Integer val1 : itemset1.getTIDset()) {
                    if (!itemset2.getTIDset().contains(val1)) continue;
                    tidset2.add(val1);
                }
                int AUUB = 0;
                for (Integer tid : tidset2) {
                    AUUB += this.database.getTransactions().get(tid).getTransactionUtility();
                }
                if (!((float)AUUB >= candidate.getItemsetMau(mutipleMinUtilities, GLMAU))) continue;
                candidate.setTIDset(tidset2);
                candidatesHAUUBI.addItemset(candidate, candidate.size());
                candidateHAUIMap.put(candidate.getItems(), candidate.getAUtility());
            }
        }
        return candidatesHAUUBI.getLevels().get(candidatesHAUUBI.getLevels().size() - 1);
    }

    public void printStats() throws IOException {
        System.out.println("=============  HAUIMMAU  ALGORITHM v. 2.15 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory: " + MemoryLogger.getInstance().getMaxMemory() + "MB");
        System.out.println(" High avergae-utility itemsets count : " + this.highAUtilityItemsets.getItemsetsCount());
        System.out.println(" Candidates count : " + this.candidatesCount);
        System.out.println("===================================================");
    }
}

