/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ItemsetTP {
    private final List<Integer> items = new ArrayList<Integer>();
    private int utility = 0;
    private Set<Integer> transactionsIds = null;
    private int mau = 0;

    public double getRelativeSupport(int nbObject) {
        return (double)this.transactionsIds.size() / (double)nbObject;
    }

    public String getRelativeSupportAsString(int nbObject) {
        double frequence = (double)this.transactionsIds.size() / (double)nbObject;
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(4);
        return format.format(frequence);
    }

    public int getAbsoluteSupport() {
        return this.transactionsIds.size();
    }

    public void addItem(Integer value) {
        this.items.add(value);
    }

    public List<Integer> getItems() {
        return this.items;
    }

    public Integer get(int index) {
        return this.items.get(index);
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Integer attribute : this.items) {
            r.append(attribute.toString());
            r.append(' ');
        }
        return r.toString();
    }

    public void setTIDset(Set<Integer> listTransactionIds) {
        this.transactionsIds = listTransactionIds;
    }

    public int size() {
        return this.items.size();
    }

    public float getItemsetMau(Map<Integer, Integer> mutipleMinUtilities, int GLMAU) {
        float sumMau = 0.0f;
        for (int i = 0; i < this.items.size(); ++i) {
            if (GLMAU > mutipleMinUtilities.get(this.items.get(i))) {
                sumMau += (float)GLMAU;
                continue;
            }
            sumMau += (float)mutipleMinUtilities.get(this.items.get(i)).intValue();
        }
        return sumMau / (float)this.items.size();
    }

    public Set<Integer> getTIDset() {
        return this.transactionsIds;
    }

    public int getAUtility() {
        return this.utility / this.items.size();
    }

    public void incrementUtility(int increment) {
        this.utility += increment;
    }
}

