/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau;

import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.ItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.haui_mmau.TransactionTP;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UtilityTransactionDatabaseTP {
    private final Set<Integer> allItems = new HashSet<Integer>();
    private final List<TransactionTP> transactions = new ArrayList<TransactionTP>();
    public Map<Integer, Integer> mutipleMinUtilities = new HashMap<Integer, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path, String minutilityPath) throws IOException {
        String thisLine;
        FileInputStream fin;
        try (BufferedReader myInput = null;){
            fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.processTransaction(thisLine.split(":"));
            }
        }
        try {
            fin = new FileInputStream(new File(minutilityPath));
            myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] items = thisLine.split(" ");
                this.mutipleMinUtilities.put(Integer.parseInt(items[0]), Integer.parseInt(items[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
    }

    private void processTransaction(String[] line) {
        String[] items = line[0].split(" ");
        String[] utilities = line[2].split(" ");
        int transactionUtility = 0;
        ArrayList<ItemUtility> itemUtilityObjects = new ArrayList<ItemUtility>();
        for (int i = 0; i < items.length; ++i) {
            itemUtilityObjects.add(new ItemUtility(Integer.parseInt(items[i]), Integer.parseInt(utilities[i])));
            if (Integer.parseInt(utilities[i]) <= transactionUtility) continue;
            transactionUtility = Integer.parseInt(utilities[i]);
        }
        this.transactions.add(new TransactionTP(itemUtilityObjects, transactionUtility));
    }

    public void printDatabase() {
        System.out.println("===================  Database ===================");
        int count = 0;
        for (TransactionTP itemset2 : this.transactions) {
            System.out.print("0" + count + ":  ");
            itemset2.print();
            System.out.println("");
            ++count;
        }
    }

    public int size() {
        return this.transactions.size();
    }

    public int getLMAU(int glmau) {
        int lmau = Integer.MAX_VALUE;
        for (Map.Entry<Integer, Integer> entry : this.mutipleMinUtilities.entrySet()) {
            if (entry.getValue() >= lmau) continue;
            lmau = entry.getValue();
        }
        if (lmau < glmau) {
            lmau = glmau;
        }
        return lmau;
    }

    public List<TransactionTP> getTransactions() {
        return this.transactions;
    }

    public Set<Integer> getAllItems() {
        return this.allItems;
    }
}

