/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.PairItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoCHUIMinerMax {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int mhuiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    BufferedWriter writer = null;
    List<Itemset> mhuis = null;
    int minUtility = 0;
    Map<Integer, Map<Integer, Integer>> mapFMAP;
    boolean useEUCPstrategy;
    int nextMID = 0;
    Map<Integer, List<Integer>> mapItemToMIDs = null;

    public AlgoCHUIMinerMax(boolean useEUCPstrategy) {
        this.useEUCPstrategy = useEUCPstrategy;
    }

    public List<Integer> getMIDList(int item) {
        return this.mapItemToMIDs.get(item);
    }

    private void addMIDtoMIDListOfItem(int mid, int item) {
        this.getMIDList(item).add(mid);
    }

    public List<Integer> intersectTwoMIDLists(List<Integer> midlist1, List<Integer> midlist2) {
        int newArraySize = midlist1.size() < midlist2.size() ? midlist1.size() : midlist2.size();
        ArrayList<Integer> intersection = new ArrayList<Integer>(newArraySize);
        int pos1 = 0;
        int pos2 = 0;
        while (pos1 < midlist1.size() && pos2 < midlist2.size()) {
            if (midlist1.get(pos1) < midlist2.get(pos2)) {
                ++pos1;
                continue;
            }
            if (midlist2.get(pos2) < midlist1.get(pos1)) {
                ++pos2;
                continue;
            }
            intersection.add(midlist1.get(pos1));
            ++pos1;
            ++pos2;
        }
        return intersection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Itemset> runAlgorithm(String input, int minUtility, String output) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.minUtility = minUtility;
        this.nextMID = 0;
        this.mapItemToMIDs = new HashMap<Integer, List<Integer>>();
        if (output != null) {
            this.writer = new BufferedWriter(new FileWriter(output));
        } else {
            this.mhuis = new ArrayList<Itemset>();
        }
        if (this.useEUCPstrategy) {
            this.mapFMAP = new HashMap<Integer, Map<Integer, Integer>>();
        }
        this.startTimestamp = System.currentTimeMillis();
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                }
            }
        }
        ArrayList<UtilityList> listOfUtilityLists = new ArrayList<UtilityList>();
        HashMap<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
        for (Integer item : this.mapItemToTWU.keySet()) {
            if (this.mapItemToTWU.get(item) < minUtility) continue;
            UtilityList uList = new UtilityList(item);
            mapItemToUtilityList.put(item, uList);
            listOfUtilityLists.add(uList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

            @Override
            public int compare(UtilityList o1, UtilityList o2) {
                return AlgoCHUIMinerMax.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                int newTU = 0;
                ArrayList<PairItemUtility> revisedTransaction = new ArrayList<PairItemUtility>();
                for (int i = 0; i < items.length; ++i) {
                    PairItemUtility pair = new PairItemUtility();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (this.mapItemToTWU.get(pair.item) < minUtility) continue;
                    revisedTransaction.add(pair);
                    newTU += pair.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<PairItemUtility>(){

                    @Override
                    public int compare(PairItemUtility o1, PairItemUtility o2) {
                        return AlgoCHUIMinerMax.this.compareItems(o1.item, o2.item);
                    }
                });
                int remainingUtility = newTU;
                for (int i = 0; i < revisedTransaction.size(); ++i) {
                    PairItemUtility pair = (PairItemUtility)revisedTransaction.get(i);
                    UtilityList utilityListOfItem = (UtilityList)mapItemToUtilityList.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                    utilityListOfItem.addElement(element);
                    if (!this.useEUCPstrategy) continue;
                    Map<Integer, Integer> mapFMAPItem = this.mapFMAP.get(pair.item);
                    if (mapFMAPItem == null) {
                        mapFMAPItem = new HashMap<Integer, Integer>();
                        this.mapFMAP.put(pair.item, mapFMAPItem);
                    }
                    for (int j = i + 1; j < revisedTransaction.size(); ++j) {
                        PairItemUtility pairAfter = (PairItemUtility)revisedTransaction.get(j);
                        Integer twuSum = mapFMAPItem.get(pairAfter.item);
                        if (twuSum == null) {
                            mapFMAPItem.put(pairAfter.item, newTU);
                            continue;
                        }
                        mapFMAPItem.put(pairAfter.item, twuSum + newTU);
                    }
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        for (UtilityList ulist : listOfUtilityLists) {
            this.mapItemToMIDs.put(ulist.item, new ArrayList());
        }
        MemoryLogger.getInstance().checkMemory();
        this.chuimineMAX_eucp(true, new int[0], new ArrayList<Integer>(), null, new ArrayList<UtilityList>(), listOfUtilityLists);
        MemoryLogger.getInstance().checkMemory();
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTimestamp = System.currentTimeMillis();
        return this.mhuis;
    }

    private boolean chuimineMAX_eucp(boolean firstTime, int[] closedSet, List<Integer> closedsetMIDs, UtilityList closedSetUL, List<UtilityList> preset, List<UtilityList> postset) throws IOException {
        boolean foundOneMHUI = false;
        for (UtilityList iUL : postset) {
            List<Integer> newgen_MIDs;
            UtilityList newgen_TIDs;
            if (firstTime) {
                newgen_TIDs = iUL;
                newgen_MIDs = this.getMIDList(iUL.item);
            } else {
                newgen_TIDs = this.construct(closedSetUL, iUL);
                newgen_MIDs = this.intersectTwoMIDLists(closedsetMIDs, this.getMIDList(iUL.item));
            }
            if (!this.isPassingHUIPruning(newgen_TIDs)) continue;
            int[] newGen = this.appendItem(closedSet, iUL.item);
            if (this.is_dup(newgen_TIDs, preset)) continue;
            int[] closedSetNew = newGen;
            UtilityList closedsetNewTIDs = newgen_TIDs;
            List<Integer> closedsetNewMIDs = newgen_MIDs;
            ArrayList<UtilityList> postsetNew = new ArrayList<UtilityList>();
            boolean passedHUIPruning = true;
            for (UtilityList jUL : postset) {
                boolean shouldPrune;
                if (jUL.item == iUL.item || this.compareItems(jUL.item, iUL.item) < 0) continue;
                boolean bl = shouldPrune = this.useEUCPstrategy && this.checkEUCPStrategy(iUL.item, jUL.item);
                if (shouldPrune) continue;
                ++this.candidateCount;
                if (this.containsAllTIDS(jUL, newgen_TIDs)) {
                    closedSetNew = this.appendItem(closedSetNew, jUL.item);
                    closedsetNewTIDs = this.construct(closedsetNewTIDs, jUL);
                    closedsetNewMIDs = this.intersectTwoMIDLists(closedsetNewMIDs, this.getMIDList(jUL.item));
                    if (this.isPassingHUIPruning(closedsetNewTIDs)) continue;
                    passedHUIPruning = false;
                    break;
                }
                postsetNew.add(jUL);
            }
            if (passedHUIPruning) {
                ArrayList<UtilityList> presetNew;
                boolean hasSupersetMHUI;
                if (postsetNew.size() > 0) {
                    List<Integer> zMIDs = this.intersectTwoMIDLists(closedsetNewMIDs, this.getMIDList(((UtilityList)postsetNew.get((int)0)).item));
                    for (int i = 1; i < postsetNew.size() && zMIDs.size() != 0; ++i) {
                        zMIDs = this.intersectTwoMIDLists(zMIDs, this.getMIDList(((UtilityList)postsetNew.get((int)i)).item));
                    }
                    if (zMIDs.size() > 0) break;
                }
                if (!(hasSupersetMHUI = this.chuimineMAX_eucp(false, closedSetNew, closedsetNewMIDs, closedsetNewTIDs, presetNew = new ArrayList<UtilityList>(preset), postsetNew)) && closedsetNewMIDs.size() == 0 && closedsetNewTIDs.sumIutils >= (long)this.minUtility) {
                    foundOneMHUI = true;
                    ++this.nextMID;
                    for (int i = 0; i < closedSetNew.length; ++i) {
                        int mid;
                        this.addMIDtoMIDListOfItem(mid, closedSetNew[i]);
                    }
                    this.saveMHUI(closedSetNew, closedsetNewTIDs.sumIutils, closedsetNewTIDs.elements.size());
                }
                foundOneMHUI = foundOneMHUI || hasSupersetMHUI;
            }
            preset.add(iUL);
        }
        return foundOneMHUI;
    }

    private boolean isPassingHUIPruning(UtilityList utilitylist) {
        return utilitylist.sumIutils + utilitylist.sumRutils >= (long)this.minUtility;
    }

    private boolean containsAllTIDS(UtilityList ul1, UtilityList ul2) {
        for (Element elmX : ul2.elements) {
            Element elmE = this.findElementWithTID(ul1, elmX.tid);
            if (elmE != null) continue;
            return false;
        }
        return true;
    }

    private boolean checkEUCPStrategy(int itemX, int itemY) {
        Integer twuF;
        Map<Integer, Integer> mapTWUF = this.mapFMAP.get(itemX);
        return mapTWUF != null && (twuF = mapTWUF.get(itemY)) != null && twuF < this.minUtility;
    }

    private int[] appendItem(int[] itemset2, int item) {
        int[] newgen = new int[itemset2.length + 1];
        System.arraycopy(itemset2, 0, newgen, 0, itemset2.length);
        newgen[itemset2.length] = item;
        return newgen;
    }

    private boolean is_dup(UtilityList newgenTIDs, List<UtilityList> preset) {
        for (UtilityList j : preset) {
            boolean containsAll = true;
            for (Element elmX : newgenTIDs.elements) {
                Element elmE = this.findElementWithTID(j, elmX.tid);
                if (elmE != null) continue;
                containsAll = false;
                break;
            }
            if (!containsAll) continue;
            return true;
        }
        return false;
    }

    private UtilityList construct(UtilityList uX, UtilityList uE) {
        UtilityList uXE = new UtilityList(uE.item);
        for (Element elmX : uX.elements) {
            Element elmE = this.findElementWithTID(uE, elmX.tid);
            if (elmE == null) continue;
            Element elmXe = new Element(elmX.tid, elmX.iutils + elmE.iutils, elmX.rutils - elmE.iutils);
            uXE.addElement(elmXe);
        }
        return uXE;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void saveMHUI(int[] itemset2, long utility, int support) throws IOException {
        ++this.mhuiCount;
        if (this.writer == null) {
            this.mhuis.add(new Itemset(itemset2, utility, support));
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < itemset2.length; ++i) {
                buffer.append(itemset2[i]);
                buffer.append(' ');
            }
            buffer.append(" #SUP: ");
            buffer.append(support);
            buffer.append(" #UTIL: ");
            buffer.append(utility);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() throws IOException {
        if (this.useEUCPstrategy) {
            System.out.println("=============  CHUIMine(max)_EUCP ALGORITHM - STATS =============");
        } else {
            System.out.println("=============  CHUIMine(max) ALGORITHM - STATS =============");
        }
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" MHUI count : " + this.mhuiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        System.out.println("=====================================================");
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }
}

