/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListEIHI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoEIHI {
    public double maxMemory = 0.0;
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public long totalTimeForAllRuns = 0L;
    public int totalCandidateCountForAllRuns = 0;
    public int transactionCount;
    public int candidateCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToRank;
    Map<Integer, Map<Integer, Integer>> mapEUCS;
    boolean debug = false;
    private Map<Integer, UtilityListEIHI> mapItemToUtilityList;
    List<UtilityListEIHI> listOfUtilityLists;
    int totalDBUtility = 0;
    int minUtility;
    int firstLine;
    private int[] itemsetBuffer = null;
    final int BUFFERS_SIZE = 400;
    List<Node> singleItemsNodes;
    int middle = -1;

    public int getRealHUICount() {
        return this.getRealHUICount(this.singleItemsNodes);
    }

    public int getRealHUICount(List<Node> list) {
        int count = 0;
        for (Node node : list) {
            if (node.utility >= this.minUtility) {
                ++count;
            }
            count += this.getRealHUICount(node.childs);
        }
        return count;
    }

    public void printHUIs() {
        this.printHUIs(this.singleItemsNodes, "");
    }

    public void printHUIs(List<Node> list, String prefix) {
        for (Node node : list) {
            String itemset2 = prefix + " " + node.item;
            if (node.utility >= this.minUtility) {
                System.out.println(itemset2 + "  #UTIL: " + node.utility);
            }
            this.printHUIs(node.childs, itemset2);
        }
    }

    public void writeHUIsToFile(String output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        this.writeHUIsToFile(this.singleItemsNodes, "", writer);
        writer.close();
    }

    public void writeHUIsToFile(List<Node> list, String prefix, BufferedWriter writer) throws IOException {
        for (Node node : list) {
            String itemset2 = prefix + " " + node.item;
            if (node.utility >= this.minUtility) {
                writer.write(itemset2 + "  #UTIL: " + node.utility + "\n");
            }
            this.writeHUIsToFile(node.childs, itemset2, writer);
        }
    }

    public void printTrie() {
        System.out.println("==== trie ====");
        this.printTrie(this.singleItemsNodes, "");
    }

    public void printTrie(List<Node> list, String indent) {
        for (Node node : list) {
            String itemset2 = indent + node.item;
            System.out.println(itemset2 + "  (" + node.utility + ")");
            this.printTrie(node.childs, indent + "\t");
        }
    }

    public boolean purgeTrie(List<Node> list) {
        boolean hasChildInHUI = false;
        Iterator<Node> iter = list.iterator();
        while (iter.hasNext()) {
            Node node = iter.next();
            if (node.utility >= this.minUtility) {
                hasChildInHUI = true;
                continue;
            }
            boolean nodeHasChildInAHUI = this.purgeTrie(node.childs);
            if (!nodeHasChildInAHUI) {
                iter.remove();
                continue;
            }
            hasChildInHUI = true;
        }
        return hasChildInHUI;
    }

    public void insertHUIinTrie(int[] prefix, int prefixLength, int lastitem, int utility) {
        List<Node> listNodes = this.singleItemsNodes;
        Node currentNode = null;
        for (int i = 0; i < prefixLength; ++i) {
            int item = prefix[i];
            currentNode = this.binarySearchForItem(listNodes, item);
            if (currentNode == null) {
                currentNode = new Node(item);
                listNodes.add(this.middle, currentNode);
                listNodes = currentNode.childs;
                continue;
            }
            listNodes = currentNode.childs;
        }
        currentNode = this.binarySearchForItem(listNodes, lastitem);
        if (currentNode == null) {
            currentNode = new Node(lastitem, utility);
            listNodes.add(this.middle, currentNode);
            ++this.huiCount;
        } else {
            if (currentNode.utility == -1) {
                ++this.huiCount;
            }
            currentNode.utility = utility;
        }
    }

    public Node binarySearchForItem(List<Node> list, int item) {
        this.middle = 0;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            this.middle = first + last >>> 1;
            if (this.compareItemsByRank(item, list.get((int)this.middle).item) > 0) {
                first = this.middle + 1;
                continue;
            }
            if (this.compareItemsByRank(item, list.get((int)this.middle).item) < 0) {
                last = this.middle - 1;
                continue;
            }
            return list.get(this.middle);
        }
        this.middle = first;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, Integer minUtil, int firstLine, int lastLine) throws IOException {
        String[] items;
        String[] split;
        String thisLine;
        boolean firstTime;
        this.maxMemory = 0.0;
        this.candidateCount = 0;
        this.huiCount = 0;
        this.itemsetBuffer = new int[400];
        this.firstLine = firstLine;
        boolean bl = firstTime = this.mapEUCS == null;
        if (firstTime) {
            this.mapEUCS = new HashMap<Integer, Map<Integer, Integer>>();
            this.listOfUtilityLists = new ArrayList<UtilityListEIHI>();
            this.mapItemToRank = new HashMap<Integer, Integer>();
            this.mapItemToUtilityList = new HashMap<Integer, UtilityListEIHI>();
            this.singleItemsNodes = new ArrayList<Node>(100);
            this.totalDBUtility = 0;
        } else {
            for (UtilityListEIHI ulist : this.listOfUtilityLists) {
                ulist.switchDPtoD();
            }
        }
        this.startTimestamp = System.currentTimeMillis();
        ArrayList<UtilityListEIHI> newItemsUtilityLists = new ArrayList<UtilityListEIHI>();
        if (this.mapItemToTWU == null) {
            this.mapItemToTWU = new HashMap<Integer, Integer>();
        }
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null && tid < lastLine) {
                if (tid >= firstLine) {
                    if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                    split = thisLine.split(":");
                    items = split[0].split(" ");
                    int transactionUtility = Integer.parseInt(split[1]);
                    for (int i = 0; i < items.length; ++i) {
                        Integer item = Integer.parseInt(items[i]);
                        Integer twu = this.mapItemToTWU.get(item);
                        if (twu == null) {
                            UtilityListEIHI uList = new UtilityListEIHI(item);
                            this.mapItemToUtilityList.put(item, uList);
                            newItemsUtilityLists.add(uList);
                            twu = transactionUtility;
                        } else {
                            twu = twu + transactionUtility;
                        }
                        this.mapItemToTWU.put(item, twu);
                    }
                    this.totalDBUtility += transactionUtility;
                }
                ++tid;
            }
        }
        this.minUtility = minUtil;
        Collections.sort(newItemsUtilityLists, new Comparator<UtilityListEIHI>(){

            @Override
            public int compare(UtilityListEIHI o1, UtilityListEIHI o2) {
                return AlgoEIHI.this.compareItems(o1.item, o2.item);
            }
        });
        for (UtilityListEIHI list : newItemsUtilityLists) {
            this.mapItemToRank.put(list.item, this.mapItemToRank.size() + 1);
        }
        this.listOfUtilityLists.addAll(newItemsUtilityLists);
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null && tid < lastLine) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                if (tid >= firstLine) {
                    Pair pair;
                    int i;
                    ++this.transactionCount;
                    split = thisLine.split(":");
                    items = split[0].split(" ");
                    String[] utilityValues = split[2].split(" ");
                    int remainingUtility = 0;
                    int newTWU = 0;
                    ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                    for (i = 0; i < items.length; ++i) {
                        pair = new Pair();
                        pair.item = Integer.parseInt(items[i]);
                        pair.utility = Integer.parseInt(utilityValues[i]);
                        revisedTransaction.add(pair);
                        remainingUtility += pair.utility;
                        newTWU += pair.utility;
                    }
                    Collections.sort(revisedTransaction, new Comparator<Pair>(){

                        @Override
                        public int compare(Pair o1, Pair o2) {
                            return AlgoEIHI.this.compareItemsByRank(o1.item, o2.item);
                        }
                    });
                    for (i = 0; i < revisedTransaction.size(); ++i) {
                        pair = (Pair)revisedTransaction.get(i);
                        UtilityListEIHI utilityListOfItem = this.mapItemToUtilityList.get(pair.item);
                        Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                        utilityListOfItem.addElementDP(element);
                        Map<Integer, Integer> mapFMAPItem = this.mapEUCS.get(pair.item);
                        if (mapFMAPItem == null) {
                            mapFMAPItem = new HashMap<Integer, Integer>();
                            this.mapEUCS.put(pair.item, mapFMAPItem);
                        }
                        for (int j = i + 1; j < revisedTransaction.size(); ++j) {
                            Pair pairAfter = (Pair)revisedTransaction.get(j);
                            Integer twuSum = mapFMAPItem.get(pairAfter.item);
                            if (twuSum == null) {
                                mapFMAPItem.put(pairAfter.item, newTWU);
                                continue;
                            }
                            mapFMAPItem.put(pairAfter.item, twuSum + newTWU);
                        }
                    }
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        ArrayList<UtilityListEIHI> listULForRecursion = new ArrayList<UtilityListEIHI>(this.listOfUtilityLists.size());
        for (UtilityListEIHI ul : this.listOfUtilityLists) {
            if (ul.sumIutilsDP == 0) continue;
            listULForRecursion.add(ul);
        }
        this.incFHM(this.itemsetBuffer, 0, null, listULForRecursion);
        this.checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        this.totalTimeForAllRuns += this.endTimestamp - this.startTimestamp;
        this.totalCandidateCountForAllRuns += this.candidateCount;
    }

    private void incFHM(int[] prefix, int prefixLength, UtilityListEIHI pUL, List<UtilityListEIHI> ULs) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityListEIHI X = ULs.get(i);
            int utilityOfX = X.sumIutilsD + X.sumIutilsDP;
            if (utilityOfX >= this.minUtility) {
                this.insertHUIinTrie(prefix, prefixLength, X.item, utilityOfX);
            }
            if (X.sumIutilsDP + X.sumRutilsDP + X.sumIutilsD + X.sumRutilsD < this.minUtility) continue;
            ArrayList<UtilityListEIHI> exULs = new ArrayList<UtilityListEIHI>();
            for (int j = i + 1; j < ULs.size(); ++j) {
                Integer twuF;
                Map<Integer, Integer> mapTWUF;
                UtilityListEIHI Y = ULs.get(j);
                if (Y.sumIutilsDP == 0 || (mapTWUF = this.mapEUCS.get(X.item)) != null && ((twuF = mapTWUF.get(Y.item)) == null || twuF < this.minUtility)) continue;
                ++this.candidateCount;
                UtilityListEIHI temp = this.construct(pUL, X, Y);
                if (temp == null) continue;
                exULs.add(temp);
            }
            this.itemsetBuffer[prefixLength] = X.item;
            this.incFHM(this.itemsetBuffer, prefixLength + 1, X, exULs);
        }
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private int compareItemsByRank(int item1, int item2) {
        int compare = this.mapItemToRank.get(item1) - this.mapItemToRank.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private UtilityListEIHI construct(UtilityListEIHI P, UtilityListEIHI px, UtilityListEIHI py) {
        Element eXY;
        Element e;
        Element eXY2;
        Element ey;
        Element ex;
        int i;
        long totalUtility = px.sumIutilsD + px.sumRutilsD + px.sumIutilsDP + px.sumRutilsDP;
        UtilityListEIHI pxyUL = new UtilityListEIHI(py.item);
        for (i = px.elementsDP.size() - 1; i >= 0; --i) {
            ex = px.elementsDP.get(i);
            ey = this.findElementWithTID(py.elementsDP, ex.tid);
            if (ey == null) {
                if ((totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)this.minUtility) continue;
                return null;
            }
            if (P == null) {
                eXY2 = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElementDP(eXY2);
                continue;
            }
            e = this.findElementWithTID(P.elementsDP, ex.tid);
            if (e == null) continue;
            eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElementDP(eXY);
        }
        if (pxyUL.elementsDP.size() == 0) {
            return null;
        }
        for (i = 0; i < px.elementsD.size(); ++i) {
            ex = px.elementsD.get(i);
            ey = this.findElementWithTID(py.elementsD, ex.tid);
            if (ey == null) {
                if ((totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)this.minUtility) continue;
                return null;
            }
            if (P == null) {
                eXY2 = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElementD(eXY2);
                continue;
            }
            e = this.findElementWithTID(P.elementsD, ex.tid);
            if (e == null) continue;
            eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElementD(eXY);
        }
        Collections.reverse(pxyUL.elementsDP);
        return pxyUL;
    }

    private Element findElementWithTID(List<Element> list, int tid) {
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() throws IOException {
        System.out.println("=============  EIHI ALGORITHM - SPMF 0.97e - STATS =============");
        System.out.println(" Number of transactions processed " + this.transactionCount);
        System.out.println(" Execution time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" New High-utility itemsets found : " + this.huiCount);
        System.out.println(" Total high-utility itemsets count : " + this.getRealHUICount());
        System.out.println(" Candidate count : " + this.candidateCount);
        System.out.println(" minutil : " + this.minUtility);
        System.out.println("===================================================");
        System.out.println("TOTAL DB Utility: " + this.totalDBUtility);
        System.out.println("TOTAL CANDIDATEs FOR ALL RUNS:" + this.totalCandidateCountForAllRuns + " candidates");
        System.out.println("TOTAL TIME FOR ALL RUNS: " + this.totalTimeForAllRuns + " ms");
        System.out.println("===================================================");
    }

    public class Node {
        int item;
        List<Node> childs = new ArrayList<Node>(3);
        int utility = -1;

        public Node(int item) {
            this.item = item;
        }

        public Node(int item, int utility) {
            this.item = item;
            this.utility = utility;
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }

        public String toString() {
            return "[" + this.item + "," + this.utility + "]";
        }
    }
}

