/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListFCHM_all_confidence;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFCHM_all_confidence {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Long> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Long>> mapFMAP;
    boolean ENABLE_LA_PRUNE = true;
    boolean DEBUG = false;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility, double minAllconfidence) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.huiCount = 0;
        this.itemsetBuffer = new int[200];
        this.mapFMAP = new HashMap<Integer, Map<Integer, Long>>();
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Long>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Long twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? (long)transactionUtility : twu + (long)transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                }
            }
        }
        ArrayList<UtilityListFCHM_all_confidence> listOfUtilityListFCHM2s = new ArrayList<UtilityListFCHM_all_confidence>();
        HashMap<Integer, UtilityListFCHM_all_confidence> mapItemToUtilityListFCHM2 = new HashMap<Integer, UtilityListFCHM_all_confidence>();
        for (Integer item : this.mapItemToTWU.keySet()) {
            if (this.mapItemToTWU.get(item) < (long)minUtility) continue;
            UtilityListFCHM_all_confidence uList = new UtilityListFCHM_all_confidence(item);
            mapItemToUtilityListFCHM2.put(item, uList);
            listOfUtilityListFCHM2s.add(uList);
        }
        Collections.sort(listOfUtilityListFCHM2s, new Comparator<UtilityListFCHM_all_confidence>(){

            @Override
            public int compare(UtilityListFCHM_all_confidence o1, UtilityListFCHM_all_confidence o2) {
                return AlgoFCHM_all_confidence.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null) {
                Pair pair;
                int i;
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                int remainingUtility = 0;
                long newTWU = 0L;
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                for (i = 0; i < items.length; ++i) {
                    pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (this.mapItemToTWU.get(pair.item) < (long)minUtility) continue;
                    revisedTransaction.add(pair);
                    remainingUtility += pair.utility;
                    newTWU += (long)pair.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoFCHM_all_confidence.this.compareItems(o1.item, o2.item);
                    }
                });
                for (i = 0; i < revisedTransaction.size(); ++i) {
                    pair = (Pair)revisedTransaction.get(i);
                    UtilityListFCHM_all_confidence UtilityListFCHM2OfItem = (UtilityListFCHM_all_confidence)mapItemToUtilityListFCHM2.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                    UtilityListFCHM2OfItem.addElement(element);
                    Map<Integer, Long> mapFMAPItem = this.mapFMAP.get(pair.item);
                    if (mapFMAPItem == null) {
                        mapFMAPItem = new HashMap<Integer, Long>();
                        this.mapFMAP.put(pair.item, mapFMAPItem);
                    }
                    for (int j = i + 1; j < revisedTransaction.size(); ++j) {
                        Pair pairAfter = (Pair)revisedTransaction.get(j);
                        Long twuSum = mapFMAPItem.get(pairAfter.item);
                        if (twuSum == null) {
                            mapFMAPItem.put(pairAfter.item, newTWU);
                            continue;
                        }
                        mapFMAPItem.put(pairAfter.item, twuSum + newTWU);
                    }
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        for (int i = 0; i < listOfUtilityListFCHM2s.size(); ++i) {
            ((UtilityListFCHM_all_confidence)listOfUtilityListFCHM2s.get((int)i)).max_subset = ((UtilityListFCHM_all_confidence)listOfUtilityListFCHM2s.get((int)i)).elements.size();
        }
        MemoryLogger.getInstance().checkMemory();
        this.fchm(this.itemsetBuffer, 0, null, listOfUtilityListFCHM2s, minUtility, minAllconfidence);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = (int)(this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2));
        return compare == 0 ? item1 - item2 : compare;
    }

    private void fchm(int[] prefix, int prefixLength, UtilityListFCHM_all_confidence pUL, List<UtilityListFCHM_all_confidence> ULs, int minUtility, double minAll_confidence) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityListFCHM_all_confidence X = ULs.get(i);
            if (X.sumIutils >= (long)minUtility) {
                this.writeOut(prefix, prefixLength, X.item, X.sumIutils, X.getAll_confidence());
            }
            if (X.sumIutils + X.sumRutils < (long)minUtility) continue;
            ArrayList<UtilityListFCHM_all_confidence> exULs = new ArrayList<UtilityListFCHM_all_confidence>();
            for (int j = i + 1; j < ULs.size(); ++j) {
                Long twuF;
                UtilityListFCHM_all_confidence Y = ULs.get(j);
                Map<Integer, Long> mapTWUF = this.mapFMAP.get(X.item);
                if (mapTWUF != null && ((twuF = mapTWUF.get(Y.item)) == null || twuF < (long)minUtility)) continue;
                ++this.candidateCount;
                UtilityListFCHM_all_confidence temp = this.construct(pUL, X, Y, minUtility);
                if (temp == null || !(temp.getAll_confidence() >= minAll_confidence)) continue;
                exULs.add(temp);
            }
            this.itemsetBuffer[prefixLength] = X.item;
            this.fchm(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility, minAll_confidence);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private UtilityListFCHM_all_confidence construct(UtilityListFCHM_all_confidence P, UtilityListFCHM_all_confidence px, UtilityListFCHM_all_confidence py, int minUtility) {
        UtilityListFCHM_all_confidence pxyUL = new UtilityListFCHM_all_confidence(py.item);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (!this.ENABLE_LA_PRUNE || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
                return null;
            }
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        pxyUL.max_subset = px.max_subset > py.max_subset ? px.max_subset : py.max_subset;
        return pxyUL;
    }

    private Element findElementWithTID(UtilityListFCHM_all_confidence ulist, int tid) {
        List list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (((Element)list.get((int)middle)).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (((Element)list.get((int)middle)).tid > tid) {
                last = middle - 1;
                continue;
            }
            return (Element)list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long utility, double all_confidence) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        buffer.append(" #ALLCONF: ");
        buffer.append(all_confidence);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=============  FHM ALGORITHM - SPMF 0.97e - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        if (this.DEBUG) {
            int pairCount = 0;
            double maxMemory = this.getObjectSize(this.mapFMAP);
            for (Map.Entry<Integer, Map<Integer, Long>> entry : this.mapFMAP.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("CMAP size " + maxMemory + " MB");
            System.out.println("PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

