/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.ElementFHMPlus;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListFHMPlus;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFHMPlus {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Long> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Long>> mapFMAP;
    boolean ENABLE_LA_PRUNE = true;
    boolean DEBUG = false;
    public double totalExecutionTime = 0.0;
    public double maximumMemoryUsage = 0.0;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    boolean ENABLE_NEW_CONSTRUCT = true;
    boolean USE_ALPHABETICAL_ORDER = true;
    private int maximumLength = Integer.MAX_VALUE;
    private int minimumLength = 1;
    final int TRANSACTION_BUFFER = 3000;
    private int[] utilitiesBuffer = new int[3000];
    private Pair[] sortedPairsBuffer = new Pair[3000];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility, int minimumLength, int maximumLength) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.itemsetBuffer = new int[200];
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
        this.mapFMAP = new HashMap<Integer, Map<Integer, Long>>();
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Long>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                int i;
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int z = 0;
                for (String utilityValue : split[2].split(" ")) {
                    this.utilitiesBuffer[z++] = Integer.parseInt(utilityValue);
                }
                Arrays.sort(this.utilitiesBuffer, 0, items.length);
                int reducedTWU = 0;
                int startIndex = items.length - 1 - maximumLength;
                if (startIndex < 0) {
                    startIndex = 0;
                }
                for (i = items.length - 1; i >= startIndex; --i) {
                    reducedTWU += this.utilitiesBuffer[i];
                }
                for (i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Long twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? (long)reducedTWU : twu + (long)reducedTWU;
                    this.mapItemToTWU.put(item, twu);
                }
            }
        }
        ArrayList<UtilityListFHMPlus> listOfUtilityLists = new ArrayList<UtilityListFHMPlus>();
        HashMap<Integer, UtilityListFHMPlus> mapItemToUtilityList = new HashMap<Integer, UtilityListFHMPlus>();
        for (Integer item : this.mapItemToTWU.keySet()) {
            if (this.mapItemToTWU.get(item) < (long)minUtility) continue;
            UtilityListFHMPlus uList = new UtilityListFHMPlus(item);
            mapItemToUtilityList.put(item, uList);
            listOfUtilityLists.add(uList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityListFHMPlus>(){

            @Override
            public int compare(UtilityListFHMPlus o1, UtilityListFHMPlus o2) {
                return AlgoFHMPlus.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                int newItemCount = 0;
                for (int i = 0; i < items.length; ++i) {
                    int item = Integer.parseInt(items[i]);
                    if (this.mapItemToTWU.get(item) < (long)minUtility) continue;
                    Pair pair = new Pair();
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    pair.item = item;
                    this.sortedPairsBuffer[newItemCount] = pair;
                    ++newItemCount;
                }
                Arrays.sort(this.sortedPairsBuffer, 0, newItemCount, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        int compare = o2.utility - o1.utility;
                        if (compare == 0) {
                            compare = o2.item - o1.item;
                        }
                        return compare;
                    }
                });
                long newTWU = 0L;
                for (int z = 0; z < maximumLength && z < newItemCount; ++z) {
                    newTWU += (long)this.sortedPairsBuffer[z].utility;
                }
                for (int i = 0; i < newItemCount; ++i) {
                    Pair pair = this.sortedPairsBuffer[i];
                    UtilityListFHMPlus utilityListOfItem = (UtilityListFHMPlus)mapItemToUtilityList.get(pair.item);
                    ElementFHMPlus element = new ElementFHMPlus(tid, pair.utility);
                    int sizeRemainingArray = maximumLength - 1;
                    element.remainingArray = new int[sizeRemainingArray];
                    Map<Integer, Long> mapFMAPItem = this.mapFMAP.get(pair.item);
                    if (mapFMAPItem == null) {
                        mapFMAPItem = new HashMap<Integer, Long>();
                        this.mapFMAP.put(pair.item, mapFMAPItem);
                    }
                    int numberOfItemsCanExtendWhithinMaxLimit = 0;
                    for (int j = 0; j < newItemCount; ++j) {
                        Long twuSum;
                        Pair otherPair = this.sortedPairsBuffer[j];
                        if (this.compareItems(pair.item, otherPair.item) >= 0) continue;
                        if (numberOfItemsCanExtendWhithinMaxLimit != sizeRemainingArray) {
                            element.rutils += otherPair.utility;
                            element.remainingArray[numberOfItemsCanExtendWhithinMaxLimit] = otherPair.utility;
                            ++numberOfItemsCanExtendWhithinMaxLimit;
                        }
                        if ((twuSum = mapFMAPItem.get(otherPair.item)) == null) {
                            mapFMAPItem.put(otherPair.item, newTWU);
                            continue;
                        }
                        mapFMAPItem.put(otherPair.item, twuSum + newTWU);
                    }
                    utilityListOfItem.addElement(element);
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        for (UtilityListFHMPlus X : listOfUtilityLists) {
            if (X.sumIutils < (long)minUtility) continue;
            this.writeOut(this.itemsetBuffer, 0, X.item, X.sumIutils);
        }
        if (maximumLength > 1) {
            this.fhm(this.itemsetBuffer, 0, null, listOfUtilityLists, minUtility);
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
        this.maximumMemoryUsage = MemoryLogger.getInstance().getMaxMemory();
        this.totalExecutionTime = this.endTimestamp - this.startTimestamp;
    }

    private int compareItems(int item1, int item2) {
        if (!this.USE_ALPHABETICAL_ORDER) {
            int compare = (int)(this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2));
            return compare == 0 ? item1 - item2 : compare;
        }
        return item1 - item2;
    }

    private void fhm(int[] prefix, int prefixLength, UtilityListFHMPlus pUL, List<UtilityListFHMPlus> ULs, int minUtility) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityListFHMPlus X = ULs.get(i);
            if (X.sumIutils + X.sumRutils < (long)minUtility) continue;
            this.itemsetBuffer[prefixLength] = X.item;
            ArrayList<UtilityListFHMPlus> exULs = new ArrayList<UtilityListFHMPlus>();
            for (int j = i + 1; j < ULs.size(); ++j) {
                Long twuF;
                UtilityListFHMPlus Y = ULs.get(j);
                Map<Integer, Long> mapTWUF = this.mapFMAP.get(X.item);
                if (mapTWUF != null && ((twuF = mapTWUF.get(Y.item)) == null || twuF < (long)minUtility)) continue;
                ++this.candidateCount;
                UtilityListFHMPlus temp = this.ENABLE_NEW_CONSTRUCT ? this.construct(pUL, X, Y, minUtility, prefixLength + 2) : this.oldConstruct(pUL, X, Y, minUtility, prefixLength + 2);
                if (temp == null) continue;
                if (temp.sumIutils >= (long)minUtility) {
                    this.writeOut(this.itemsetBuffer, prefixLength + 1, temp.item, temp.sumIutils);
                }
                if (prefixLength + 2 == this.maximumLength) continue;
                exULs.add(temp);
            }
            if (prefixLength + 2 == this.maximumLength) continue;
            this.fhm(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private UtilityListFHMPlus construct(UtilityListFHMPlus P, UtilityListFHMPlus px, UtilityListFHMPlus py, int minUtility, int pxyLength) {
        UtilityListFHMPlus pxyUL = new UtilityListFHMPlus(py.item);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (ElementFHMPlus ex : px.elements) {
            ElementFHMPlus ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (!this.ENABLE_LA_PRUNE || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
                return null;
            }
            ElementFHMPlus eXY = null;
            if (P == null) {
                eXY = new ElementFHMPlus(ex.tid, ex.iutils + ey.iutils);
                int newRemainingArraySize = 0;
                for (int z = 0; z < ey.remainingArray.length && ey.remainingArray[z] != 0; ++z) {
                    ++newRemainingArraySize;
                }
                if (newRemainingArraySize + pxyLength > this.maximumLength && --newRemainingArraySize == -1) {
                    newRemainingArraySize = 0;
                }
                eXY.remainingArray = new int[newRemainingArraySize];
                for (int i = 0; i < newRemainingArraySize && ey.remainingArray[i] != 0; ++i) {
                    eXY.remainingArray[i] = ey.remainingArray[i];
                    eXY.rutils += ey.remainingArray[i];
                }
            } else {
                ElementFHMPlus e = this.findElementWithTID(P, ex.tid);
                if (e != null) {
                    eXY = new ElementFHMPlus(ex.tid, ex.iutils + ey.iutils - e.iutils);
                    int newRemainingArraySize = ey.remainingArray.length;
                    if (newRemainingArraySize + pxyLength > this.maximumLength && --newRemainingArraySize == -1) {
                        newRemainingArraySize = 0;
                    }
                    eXY.remainingArray = new int[newRemainingArraySize];
                    for (int i = 0; i < newRemainingArraySize && ey.remainingArray[i] != 0; ++i) {
                        eXY.remainingArray[i] = ey.remainingArray[i];
                        eXY.rutils += ey.remainingArray[i];
                    }
                }
            }
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private UtilityListFHMPlus oldConstruct(UtilityListFHMPlus P, UtilityListFHMPlus px, UtilityListFHMPlus py, int minUtility, int pxyLength) {
        UtilityListFHMPlus pxyUL = new UtilityListFHMPlus(py.item);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (ElementFHMPlus ex : px.elements) {
            ElementFHMPlus ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (!this.ENABLE_LA_PRUNE || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
                return null;
            }
            if (P == null) {
                ElementFHMPlus eXY = new ElementFHMPlus(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            ElementFHMPlus e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            ElementFHMPlus eXY = new ElementFHMPlus(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private ElementFHMPlus findElementWithTID(UtilityListFHMPlus ulist, int tid) {
        List<ElementFHMPlus> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long utility) throws IOException {
        if (prefixLength + 1 < this.minimumLength) {
            return;
        }
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=============  FHM+ ALGORITHM - SPMF 0.99c - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        if (this.DEBUG) {
            int pairCount = 0;
            double maxMemory = this.getObjectSize(this.mapFMAP);
            for (Map.Entry<Integer, Map<Integer, Long>> entry : this.mapFMAP.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("CMAP size " + maxMemory + " MB");
            System.out.println("PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

