/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.PairItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityList;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListWithCriticalObjects;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoGHUIMINER {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public long ghuiCount = 0L;
    public long candidateCount = 0L;
    public long candidateAvoidedbyFHM = 0L;
    public long closureRetrievals = 0L;
    public long generatorChecks = 0L;
    public long partiallyAvoidedOrAvoidedGeneratorChecks = 0L;
    Map<Integer, Integer> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Integer>> mapFMAP;
    private int transactionCount = 0;
    boolean debug = false;
    private Map<Integer, UtilityListWithCriticalObjects> mapItemToUtilityList;
    private List<UtilityListWithCriticalObjects> listOfUtilityLists;
    boolean emptySetIsGHUIs = false;
    int minUtility = 0;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    boolean enableLAPrune = true;
    List<List<Itemset>> closedItemsetsBySize = null;

    public Itemset getClosure(int[] itemsetX, int prefixLength, int support) {
        ++this.closureRetrievals;
        block0: for (int i = prefixLength; i < this.closedItemsetsBySize.size(); ++i) {
            List<Itemset> list = this.closedItemsetsBySize.get(i);
            if (list == null) continue;
            for (Itemset itemsetInList : list) {
                if (support < itemsetInList.support) continue block0;
                if (support != itemsetInList.support || !ArraysAlgos.includedIn(itemsetX, prefixLength, itemsetInList.itemset)) continue;
                return itemsetInList;
            }
        }
        return null;
    }

    public boolean isSubsetOfACHUI(int[] itemsetX, int prefixLength, int support, boolean strictSubsetCheck) {
        int minSize = strictSubsetCheck ? prefixLength + 1 : prefixLength;
        block0: for (int i = this.closedItemsetsBySize.size() - 1; i >= minSize; --i) {
            List<Itemset> list = this.closedItemsetsBySize.get(i);
            if (list == null) continue;
            for (Itemset itemsetInList : list) {
                if (support < itemsetInList.support) continue block0;
                if (!ArraysAlgos.includedIn(itemsetX, prefixLength, itemsetInList.itemset)) continue;
                return true;
            }
        }
        return false;
    }

    private void sortClosedItemsets() {
        for (List<Itemset> itemsetsBySize : this.closedItemsetsBySize) {
            Collections.sort(itemsetsBySize, new Comparator<Itemset>(){

                @Override
                public int compare(Itemset o1, Itemset o2) {
                    return o1.support - o2.support;
                }
            });
        }
    }

    private void sortItemsInAllCHUIsByTWU() {
        for (List<Itemset> itemsetsBySize : this.closedItemsetsBySize) {
            for (Itemset itemset2 : itemsetsBySize) {
                if (itemset2.support == this.transactionCount) {
                    this.emptySetIsGHUIs = true;
                }
                this.insertionSort(itemset2.itemset);
            }
        }
    }

    public void insertionSort(int[] a) {
        for (int j = 1; j < a.length; ++j) {
            int key = a[j];
            for (int i = j - 1; i >= 0 && this.compareItems(a[i], key) > 0; --i) {
                a[i + 1] = a[i];
            }
            a[i + 1] = key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility, List<List<Itemset>> closedItemsets, Set<Integer> itemsInClosedItemsets) throws IOException {
        String thisLine;
        this.closureRetrievals = 0L;
        this.itemsetBuffer = new int[200];
        this.mapFMAP = new HashMap<Integer, Map<Integer, Integer>>();
        this.minUtility = minUtility;
        this.startTimestamp = System.currentTimeMillis();
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        long totalUtility = 0L;
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    if (!itemsInClosedItemsets.contains(item)) continue;
                    Integer twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                }
                ++this.transactionCount;
                totalUtility += (long)transactionUtility;
            }
        }
        this.listOfUtilityLists = new ArrayList<UtilityListWithCriticalObjects>();
        this.mapItemToUtilityList = new HashMap<Integer, UtilityListWithCriticalObjects>();
        for (Integer item : this.mapItemToTWU.keySet()) {
            if (this.mapItemToTWU.get(item) < minUtility) continue;
            UtilityListWithCriticalObjects uList = new UtilityListWithCriticalObjects(item);
            this.mapItemToUtilityList.put(item, uList);
            this.listOfUtilityLists.add(uList);
        }
        Collections.sort(this.listOfUtilityLists, new Comparator<UtilityListWithCriticalObjects>(){

            @Override
            public int compare(UtilityListWithCriticalObjects o1, UtilityListWithCriticalObjects o2) {
                return AlgoGHUIMINER.this.compareItems(o1.item, o2.item);
            }
        });
        this.closedItemsetsBySize = closedItemsets;
        this.sortClosedItemsets();
        this.sortItemsInAllCHUIsByTWU();
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null) {
                PairItemUtility pair;
                int i;
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                int newTU = 0;
                ArrayList<PairItemUtility> revisedTransaction = new ArrayList<PairItemUtility>();
                for (i = 0; i < items.length; ++i) {
                    pair = new PairItemUtility();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    Integer utility = this.mapItemToTWU.get(pair.item);
                    if (utility != null && this.mapItemToTWU.get(pair.item) >= minUtility) {
                        revisedTransaction.add(pair);
                        newTU += pair.utility;
                        continue;
                    }
                    transactionUtility -= pair.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<PairItemUtility>(){

                    @Override
                    public int compare(PairItemUtility o1, PairItemUtility o2) {
                        return AlgoGHUIMINER.this.compareItems(o1.item, o2.item);
                    }
                });
                for (i = 0; i < revisedTransaction.size(); ++i) {
                    pair = (PairItemUtility)revisedTransaction.get(i);
                    int remainingUtility = transactionUtility - pair.utility;
                    UtilityListWithCriticalObjects utilityListOfItem = this.mapItemToUtilityList.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility);
                    utilityListOfItem.addElement(element);
                    Map<Integer, Integer> mapFMAPItem = this.mapFMAP.get(pair.item);
                    if (mapFMAPItem == null) {
                        mapFMAPItem = new HashMap<Integer, Integer>();
                        this.mapFMAP.put(pair.item, mapFMAPItem);
                    }
                    for (int j = i + 1; j < revisedTransaction.size(); ++j) {
                        PairItemUtility pairAfter = (PairItemUtility)revisedTransaction.get(j);
                        Integer twuSum = mapFMAPItem.get(pairAfter.item);
                        if (twuSum == null) {
                            mapFMAPItem.put(pairAfter.item, newTU);
                            continue;
                        }
                        mapFMAPItem.put(pairAfter.item, twuSum + newTU);
                    }
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        BitSet tidsetEmptySet = new BitSet(this.transactionCount);
        tidsetEmptySet.set(1, this.transactionCount);
        UtilityListWithCriticalObjects emptyUL = new UtilityListWithCriticalObjects(null);
        emptyUL.tidset = tidsetEmptySet;
        emptyUL.crit = new BitSet[0];
        int[] emptySet = new int[]{};
        Iterator<UtilityListWithCriticalObjects> iter = this.listOfUtilityLists.iterator();
        while (iter.hasNext()) {
            UtilityListWithCriticalObjects ul = iter.next();
            int[] itemset2 = new int[]{ul.item};
            int support = ul.elements.size();
            this.checkIfGeneratorSingleItem(emptyUL, ul);
            if (ul.crit == null || ul.sumIutils + ul.sumRutils < (long)minUtility) {
                iter.remove();
                continue;
            }
            if (ul.sumIutils >= (long)minUtility) {
                this.writeOut(emptySet, 0, ul.item, ul.sumIutils, ul.elements.size());
                if (this.isSubsetOfACHUI(itemset2, 1, support, true)) continue;
                iter.remove();
                continue;
            }
            if (this.getClosure(itemset2, 1, support) == null) continue;
            this.writeOut(emptySet, 0, ul.item, ul.sumIutils, ul.elements.size());
        }
        if (this.closedItemsetsBySize.size() > 0) {
            if (this.emptySetIsGHUIs) {
                this.writeOutEmptySet(totalUtility);
            }
            this.ghuiMinerE(this.itemsetBuffer, 0, emptyUL, this.listOfUtilityLists);
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void ghuiMinerE(int[] prefixP, int prefixLength, UtilityListWithCriticalObjects p_UL, List<UtilityListWithCriticalObjects> extensionsULs) throws IOException {
        MemoryLogger.getInstance().checkMemory();
        for (int i = 0; i < extensionsULs.size(); ++i) {
            UtilityListWithCriticalObjects pX_UL = extensionsULs.get(i);
            if (pX_UL.sumIutils + pX_UL.sumRutils < (long)this.minUtility) continue;
            this.itemsetBuffer[prefixLength] = pX_UL.item;
            ArrayList<UtilityListWithCriticalObjects> extensionsOfPX = new ArrayList<UtilityListWithCriticalObjects>();
            for (int j = i + 1; j < extensionsULs.size(); ++j) {
                boolean isGenerator;
                UtilityListWithCriticalObjects pXYUL;
                UtilityListWithCriticalObjects pY_UL = extensionsULs.get(j);
                boolean shouldPrune = this.checkEUCPStrategy(this.minUtility, pX_UL.item, pY_UL.item);
                if (shouldPrune) continue;
                ++this.candidateCount;
                UtilityListWithCriticalObjects utilityListWithCriticalObjects = pXYUL = p_UL.item == null ? this.construct(pX_UL, pY_UL, this.minUtility) : this.construct(pX_UL, pY_UL, this.minUtility);
                if (pXYUL == null || pXYUL.elements.isEmpty()) continue;
                if (pXYUL.elements.size() == pX_UL.elements.size() || pXYUL.elements.size() == pY_UL.elements.size()) {
                    ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
                    continue;
                }
                this.itemsetBuffer[prefixLength + 1] = pY_UL.item;
                if (!this.isSubsetOfACHUI(this.itemsetBuffer, prefixLength + 2, pXYUL.elements.size(), false) || pXYUL.sumIutils + pXYUL.sumRutils < (long)this.minUtility || !(isGenerator = this.checkIfGenerator(pX_UL, pXYUL, prefixLength + 1))) continue;
                if (pXYUL.sumIutils >= (long)this.minUtility) {
                    this.writeOut(this.itemsetBuffer, prefixLength + 1, pXYUL.item, pXYUL.sumIutils, pXYUL.elements.size());
                } else if (this.getClosure(this.itemsetBuffer, prefixLength + 2, pXYUL.elements.size()) != null) {
                    this.writeOut(this.itemsetBuffer, prefixLength + 1, pXYUL.item, pXYUL.sumIutils, pXYUL.elements.size());
                }
                extensionsOfPX.add(pXYUL);
            }
            if (extensionsOfPX.size() <= 1) continue;
            this.ghuiMinerE(this.itemsetBuffer, prefixLength + 1, pX_UL, extensionsOfPX);
        }
    }

    private boolean checkEUCPStrategy(int minUtility, int itemX, int itemY) {
        Integer twuF;
        Map<Integer, Integer> mapTWUF = this.mapFMAP.get(itemX);
        if (mapTWUF != null && ((twuF = mapTWUF.get(itemY)) == null || twuF < minUtility)) {
            ++this.candidateAvoidedbyFHM;
            return true;
        }
        return false;
    }

    public boolean contains(int[] list, int integer) {
        for (int item : list) {
            if (item != integer) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfGenerator(UtilityListWithCriticalObjects p_UL, UtilityListWithCriticalObjects pX_UL, int prefixSize) {
        ++this.generatorChecks;
        BitSet tidsetE = this.mapItemToUtilityList.get((Object)pX_UL.item).tidset;
        pX_UL.crit = new BitSet[prefixSize + 1];
        BitSet critE = (BitSet)p_UL.tidset.clone();
        critE.andNot(tidsetE);
        pX_UL.crit[pX_UL.crit.length - 1] = critE;
        if (critE.cardinality() == 0) {
            ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
            return false;
        }
        for (int j = 0; j < prefixSize; ++j) {
            pX_UL.crit[j] = (BitSet)p_UL.crit[j].clone();
            pX_UL.crit[j].and(tidsetE);
            int cardinality = pX_UL.crit[j].cardinality();
            if (cardinality != 0) continue;
            if (j < prefixSize - 1) {
                ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
            }
            return false;
        }
        return true;
    }

    private void checkIfGeneratorSingleItem(UtilityListWithCriticalObjects emptySet_UL, UtilityListWithCriticalObjects X_UL) {
        if (this.transactionCount == X_UL.elements.size()) {
            ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
            return;
        }
        ++this.generatorChecks;
        BitSet tidsetE = this.mapItemToUtilityList.get((Object)X_UL.item).tidset;
        BitSet crit = (BitSet)emptySet_UL.tidset.clone();
        crit.andNot(tidsetE);
        X_UL.crit = new BitSet[]{crit};
    }

    private UtilityListWithCriticalObjects construct(UtilityListWithCriticalObjects px, UtilityListWithCriticalObjects py, int minUtility) {
        UtilityListWithCriticalObjects pxyUL = new UtilityListWithCriticalObjects(py.item);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey != null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ex.rutils - ey.iutils);
                pxyUL.addElement(eXY);
                continue;
            }
            if (!this.enableLAPrune || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
            return null;
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOutEmptySet(long totalUtility) throws IOException {
        ++this.ghuiCount;
        this.writer.write("#SUP: " + this.transactionCount + " #UTIL: " + totalUtility);
        this.writer.newLine();
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long sumIutils, int support) throws IOException {
        ++this.ghuiCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(item);
        buffer.append(" #SUP: ");
        buffer.append(support);
        buffer.append(" #UTIL: ");
        buffer.append(sumIutils);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=============  GHUI-MINER - SPMF 0.97e - STATS =============");
        System.out.println("   Candidate count : " + this.candidateCount + "     (avoided by FHM : " + this.candidateAvoidedbyFHM + ")\n   Closure retrievals : " + this.closureRetrievals + " \n   Genenerator checks: " + this.generatorChecks + "   (partially avoided : " + this.partiallyAvoidedOrAvoidedGeneratorChecks + ")");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" GHUI count : " + this.ghuiCount);
        System.out.println("===================================================");
    }
}

