/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.PairItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListWithCriticalObjects;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoHUGMiner {
    public double maxMemory = 0.0;
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int hugsCount = 0;
    public long candidateCount = 0L;
    public long candidateAvoidedbyFHMPruning = 0L;
    public long generatorChecks = 0L;
    public long partiallyAvoidedOrAvoidedGeneratorChecks = 0L;
    Map<Integer, Integer> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Integer>> mapFMAP;
    private int transactionCount = 0;
    boolean debug = false;
    private Map<Integer, UtilityListWithCriticalObjects> mapItemToUtilityList;
    private int[] itemsetBuffer = null;
    final int BUFFERS_SIZE = 200;
    boolean enableLAPrune = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        String thisLine;
        this.maxMemory = 0.0;
        this.itemsetBuffer = new int[200];
        this.mapFMAP = new HashMap<Integer, Map<Integer, Integer>>();
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        long totalUtility = 0L;
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                }
                ++this.transactionCount;
                totalUtility += (long)transactionUtility;
            }
        }
        ArrayList<UtilityListWithCriticalObjects> listOfUtilityLists = new ArrayList<UtilityListWithCriticalObjects>();
        this.mapItemToUtilityList = new HashMap<Integer, UtilityListWithCriticalObjects>();
        for (Integer item : this.mapItemToTWU.keySet()) {
            if (this.mapItemToTWU.get(item) < minUtility) continue;
            UtilityListWithCriticalObjects uList = new UtilityListWithCriticalObjects(item);
            this.mapItemToUtilityList.put(item, uList);
            listOfUtilityLists.add(uList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityListWithCriticalObjects>(){

            @Override
            public int compare(UtilityListWithCriticalObjects o1, UtilityListWithCriticalObjects o2) {
                return AlgoHUGMiner.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                int newTU = 0;
                ArrayList<PairItemUtility> revisedTransaction = new ArrayList<PairItemUtility>();
                for (int i = 0; i < items.length; ++i) {
                    PairItemUtility pair = new PairItemUtility();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (this.mapItemToTWU.get(pair.item) < minUtility) continue;
                    revisedTransaction.add(pair);
                    newTU += pair.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<PairItemUtility>(){

                    @Override
                    public int compare(PairItemUtility o1, PairItemUtility o2) {
                        return AlgoHUGMiner.this.compareItems(o1.item, o2.item);
                    }
                });
                int remainingUtility = newTU;
                for (int i = 0; i < revisedTransaction.size(); ++i) {
                    PairItemUtility pair = (PairItemUtility)revisedTransaction.get(i);
                    UtilityListWithCriticalObjects utilityListOfItem = this.mapItemToUtilityList.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                    utilityListOfItem.addElement(element);
                    Map<Integer, Integer> mapFMAPItem = this.mapFMAP.get(pair.item);
                    if (mapFMAPItem == null) {
                        mapFMAPItem = new HashMap<Integer, Integer>();
                        this.mapFMAP.put(pair.item, mapFMAPItem);
                    }
                    for (int j = i + 1; j < revisedTransaction.size(); ++j) {
                        PairItemUtility pairAfter = (PairItemUtility)revisedTransaction.get(j);
                        Integer twuSum = mapFMAPItem.get(pairAfter.item);
                        if (twuSum == null) {
                            mapFMAPItem.put(pairAfter.item, newTU);
                            continue;
                        }
                        mapFMAPItem.put(pairAfter.item, twuSum + newTU);
                    }
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        BitSet tidsetEmptySet = new BitSet(this.transactionCount);
        tidsetEmptySet.set(1, this.transactionCount);
        UtilityListWithCriticalObjects emptyUL = new UtilityListWithCriticalObjects(null);
        emptyUL.tidset = tidsetEmptySet;
        emptyUL.crit = new BitSet[0];
        int[] emptySet = new int[]{};
        Iterator iter = listOfUtilityLists.iterator();
        while (iter.hasNext()) {
            UtilityListWithCriticalObjects ul = (UtilityListWithCriticalObjects)iter.next();
            this.checkIfGeneratorSingleItem(emptyUL, ul);
            if (ul.crit == null || ul.sumIutils + ul.sumRutils < (long)minUtility) {
                iter.remove();
                continue;
            }
            if (ul.sumIutils < (long)minUtility) continue;
            this.writeOut(emptySet, 0, ul.item, ul.sumIutils, this.transactionCount);
        }
        if (totalUtility >= (long)minUtility) {
            this.hugminer(this.itemsetBuffer, 0, emptyUL, listOfUtilityLists, minUtility);
        }
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void hugminer(int[] prefixP, int prefixLength, UtilityListWithCriticalObjects p_UL, List<UtilityListWithCriticalObjects> extensionsULs, int minUtility) throws IOException {
        for (int i = 0; i < extensionsULs.size(); ++i) {
            UtilityListWithCriticalObjects pX_UL = extensionsULs.get(i);
            if (pX_UL.sumIutils + pX_UL.sumRutils < (long)minUtility) continue;
            this.itemsetBuffer[prefixLength] = pX_UL.item;
            ArrayList<UtilityListWithCriticalObjects> extensionsOfPX = new ArrayList<UtilityListWithCriticalObjects>();
            for (int j = i + 1; j < extensionsULs.size(); ++j) {
                boolean isGenerator;
                UtilityListWithCriticalObjects pXYUL;
                UtilityListWithCriticalObjects pY_UL = extensionsULs.get(j);
                boolean shouldPrune = this.checkEUCPStrategy(minUtility, pX_UL.item, pY_UL.item);
                if (shouldPrune) continue;
                ++this.candidateCount;
                UtilityListWithCriticalObjects utilityListWithCriticalObjects = pXYUL = p_UL.item == null ? this.construct(pX_UL, pY_UL, minUtility) : this.construct(p_UL, pX_UL, pY_UL, minUtility);
                if (pXYUL == null || pXYUL.elements.isEmpty() || pXYUL.elements.size() == pX_UL.elements.size() || pXYUL.elements.size() == pY_UL.elements.size() || pXYUL.sumIutils + pXYUL.sumRutils < (long)minUtility || !(isGenerator = this.checkIfGenerator(pX_UL, pXYUL, prefixLength + 1))) continue;
                if (pXYUL.sumIutils >= (long)minUtility) {
                    this.writeOut(this.itemsetBuffer, prefixLength + 1, pXYUL.item, pXYUL.sumIutils, pXYUL.elements.size());
                }
                extensionsOfPX.add(pXYUL);
            }
            if (extensionsOfPX.size() <= 1) continue;
            this.hugminer(this.itemsetBuffer, prefixLength + 1, pX_UL, extensionsOfPX, minUtility);
        }
    }

    private boolean checkEUCPStrategy(int minUtility, int itemX, int itemY) {
        Integer twuF;
        Map<Integer, Integer> mapTWUF = this.mapFMAP.get(itemX);
        if (mapTWUF != null && ((twuF = mapTWUF.get(itemY)) == null || twuF < minUtility)) {
            ++this.candidateAvoidedbyFHMPruning;
            return true;
        }
        return false;
    }

    public boolean contains(int[] list, int integer) {
        for (int item : list) {
            if (item != integer) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfGenerator(UtilityListWithCriticalObjects p_UL, UtilityListWithCriticalObjects pX_UL, int prefixSize) {
        ++this.generatorChecks;
        BitSet tidsetE = this.mapItemToUtilityList.get((Object)pX_UL.item).tidset;
        pX_UL.crit = new BitSet[prefixSize + 1];
        BitSet critE = (BitSet)p_UL.tidset.clone();
        critE.andNot(tidsetE);
        pX_UL.crit[pX_UL.crit.length - 1] = critE;
        if (critE.cardinality() == 0) {
            ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
            return false;
        }
        for (int j = 0; j < prefixSize; ++j) {
            pX_UL.crit[j] = (BitSet)p_UL.crit[j].clone();
            pX_UL.crit[j].and(tidsetE);
            if (pX_UL.crit[j].cardinality() != 0) continue;
            if (j < prefixSize - 1) {
                ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
            }
            return false;
        }
        return true;
    }

    private void checkIfGeneratorSingleItem(UtilityListWithCriticalObjects emptySet_UL, UtilityListWithCriticalObjects X_UL) {
        if (this.transactionCount == X_UL.elements.size()) {
            ++this.partiallyAvoidedOrAvoidedGeneratorChecks;
            return;
        }
        ++this.generatorChecks;
        BitSet tidsetE = this.mapItemToUtilityList.get((Object)X_UL.item).tidset;
        BitSet crit = (BitSet)emptySet_UL.tidset.clone();
        crit.andNot(tidsetE);
        X_UL.crit = new BitSet[]{crit};
    }

    private UtilityListWithCriticalObjects construct(UtilityListWithCriticalObjects P, UtilityListWithCriticalObjects px, UtilityListWithCriticalObjects py, int minUtility) {
        UtilityListWithCriticalObjects pxyUL = new UtilityListWithCriticalObjects(py.item);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (!this.enableLAPrune || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
                return null;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            int diff = ey.iutils - e.iutils;
            Element eXY = new Element(ex.tid, ex.iutils + diff, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private UtilityListWithCriticalObjects construct(UtilityListWithCriticalObjects x_UL, UtilityListWithCriticalObjects y_UL, int minUtility) {
        UtilityListWithCriticalObjects pxyUL = new UtilityListWithCriticalObjects(y_UL.item);
        long totalUtility = x_UL.sumIutils + x_UL.sumRutils;
        for (Element ex : x_UL.elements) {
            Element ey = this.findElementWithTID(y_UL, ex.tid);
            if (ey != null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            if (!this.enableLAPrune || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
            return null;
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityListWithCriticalObjects ulist, int tid) {
        List list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (((Element)list.get((int)middle)).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (((Element)list.get((int)middle)).tid > tid) {
                last = middle - 1;
                continue;
            }
            return (Element)list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long sumIutils, int support) throws IOException {
        ++this.hugsCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(item);
        buffer.append(" #SUP: ");
        buffer.append(support);
        buffer.append(" #UTIL: ");
        buffer.append(sumIutils);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() throws IOException {
        System.out.println("=============  HUG-Miner ALGORITHM - SPMF 0.97e - STATS =============");
        System.out.println("   Candidate count : " + this.candidateCount + "     (avoided by EUCP strategy : " + this.candidateAvoidedbyFHMPruning + ")\n   Genenerator checks: " + this.generatorChecks + "   (partially avoided : " + this.partiallyAvoidedOrAvoidedGeneratorChecks + ")");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max. Memory ~ " + this.maxMemory + " MB");
        System.out.println(" HUGs count : " + this.hugsCount);
        System.out.println("==============================================================");
    }
}

