/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoMinFHM {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Integer> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Integer>> mapFMAP;
    boolean debug = false;
    boolean ENABLE_LA_PRUNE = true;
    List<List<Itemset>> listItemsetsBySize = null;

    public boolean isSubsumingAFoundItemset(int[] itemset2) {
        if (itemset2.length == 2) {
            return false;
        }
        for (int i = 0; i < itemset2.length && i < this.listItemsetsBySize.size(); ++i) {
            List<Itemset> list = this.listItemsetsBySize.get(i);
            if (list.size() <= 0) continue;
            for (Itemset itemsetInList : list) {
                if (!ArraysAlgos.includedIn(itemsetInList.itemset, itemset2)) continue;
                return true;
            }
        }
        return false;
    }

    public void registerItemsetAndRemoveLarger(int[] itemset2, long utility, int support) {
        if (itemset2.length == 2) {
            this.mapFMAP.get(itemset2[0]).put(itemset2[1], 0);
        }
        if (itemset2.length >= this.listItemsetsBySize.size()) {
            for (int i = this.listItemsetsBySize.size(); i <= itemset2.length; ++i) {
                this.listItemsetsBySize.add(new ArrayList());
            }
        }
        List<Itemset> listToAdd = this.listItemsetsBySize.get(itemset2.length);
        listToAdd.add(new Itemset(itemset2, utility, support));
        for (int i = itemset2.length + 1; i < this.listItemsetsBySize.size(); ++i) {
            List<Itemset> list = this.listItemsetsBySize.get(i);
            if (list.size() <= 0) continue;
            Iterator<Itemset> iter = list.iterator();
            while (iter.hasNext()) {
                Itemset itemset22 = iter.next();
                if (!ArraysAlgos.includedIn(itemset2, itemset22.itemset)) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.mapFMAP = new HashMap<Integer, Map<Integer, Integer>>();
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mapItemToUtility = new HashMap<Integer, Integer>();
        this.listItemsetsBySize = new ArrayList<List<Itemset>>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                String[] stringArray = split[2].split(" ");
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Integer twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                    Integer utility = Integer.parseInt(stringArray[i]);
                    Integer totalUtilityOfItem = (Integer)mapItemToUtility.get(item);
                    totalUtilityOfItem = totalUtilityOfItem == null ? utility : utility + totalUtilityOfItem;
                    mapItemToUtility.put(item, totalUtilityOfItem);
                }
            }
        }
        ArrayList<UtilityList> listOfUtilityLists = new ArrayList<UtilityList>();
        HashMap<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
        for (Integer n : this.mapItemToTWU.keySet()) {
            if (this.mapItemToTWU.get(n) < minUtility || (Integer)mapItemToUtility.get(n) >= minUtility) continue;
            UtilityList uList = new UtilityList(n);
            mapItemToUtilityList.put(n, uList);
            listOfUtilityLists.add(uList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

            @Override
            public int compare(UtilityList o1, UtilityList o2) {
                return AlgoMinFHM.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null) {
                Pair pair;
                int i;
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] stringArray = thisLine.split(":");
                String[] items = stringArray[0].split(" ");
                String[] utilityValues = stringArray[2].split(" ");
                int remainingUtility = 0;
                int newTWU = 0;
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                for (i = 0; i < items.length; ++i) {
                    pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    if (this.mapItemToTWU.get(pair.item) < minUtility || (Integer)mapItemToUtility.get(pair.item) >= minUtility) continue;
                    revisedTransaction.add(pair);
                    remainingUtility += pair.utility;
                    newTWU += pair.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoMinFHM.this.compareItems(o1.item, o2.item);
                    }
                });
                for (i = 0; i < revisedTransaction.size(); ++i) {
                    pair = (Pair)revisedTransaction.get(i);
                    UtilityList utilityListOfItem = (UtilityList)mapItemToUtilityList.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                    utilityListOfItem.addElement(element);
                    Map<Integer, Integer> mapFMAPItem = this.mapFMAP.get(pair.item);
                    if (mapFMAPItem == null) {
                        mapFMAPItem = new HashMap<Integer, Integer>();
                        this.mapFMAP.put(pair.item, mapFMAPItem);
                    }
                    for (int j = i + 1; j < revisedTransaction.size(); ++j) {
                        Pair pairAfter = (Pair)revisedTransaction.get(j);
                        Integer twuSum = mapFMAPItem.get(pairAfter.item);
                        if (twuSum == null) {
                            mapFMAPItem.put(pairAfter.item, newTWU);
                            continue;
                        }
                        mapFMAPItem.put(pairAfter.item, twuSum + newTWU);
                    }
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        for (Map.Entry entry : mapItemToUtility.entrySet()) {
            if ((Integer)entry.getValue() < minUtility) continue;
            this.writeOutItemsetSize1((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        this.minfhm(new int[0], null, listOfUtilityLists, minUtility);
        for (List list : this.listItemsetsBySize) {
            for (Itemset itemset2 : list) {
                this.writeOut(itemset2);
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void minfhm(int[] prefix, UtilityList pUL, List<UtilityList> ULs, int minUtility) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityList X = ULs.get(i);
            if (X.sumIutils + X.sumRutils < (long)minUtility) continue;
            int[] newPrefix = ArraysAlgos.appendIntegerToArray(prefix, X.item);
            ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
            for (int j = i + 1; j < ULs.size(); ++j) {
                Integer twuF;
                UtilityList Y = ULs.get(j);
                Map<Integer, Integer> mapTWUF = this.mapFMAP.get(X.item);
                if (mapTWUF != null && ((twuF = mapTWUF.get(Y.item)) == null || twuF < minUtility)) continue;
                ++this.candidateCount;
                UtilityList pXY = this.construct(pUL, X, Y, minUtility);
                if (pXY == null) continue;
                int[] itemset2 = ArraysAlgos.appendIntegerToArray(newPrefix, Y.item);
                if (pXY.sumIutils >= (long)minUtility && !this.isSubsumingAFoundItemset(itemset2)) {
                    this.registerItemsetAndRemoveLarger(itemset2, pXY.sumIutils, pXY.elements.size());
                    continue;
                }
                if (this.isSubsumingAFoundItemset(itemset2)) continue;
                exULs.add(pXY);
            }
            if (exULs.size() <= 1) continue;
            this.minfhm(newPrefix, X, exULs, minUtility);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py, int minUtility) {
        UtilityList pxyUL = new UtilityList(py.item);
        long totalUtility = px.sumIutils + px.sumRutils;
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (!this.ENABLE_LA_PRUNE || (totalUtility -= (long)(ex.iutils + ex.rutils)) >= (long)minUtility) continue;
                return null;
            }
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(Itemset itemset2) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < itemset2.itemset.length; ++i) {
            buffer.append(itemset2.itemset[i]);
            if (i == itemset2.itemset.length - 1) continue;
            buffer.append(' ');
        }
        buffer.append(" #UTIL: ");
        buffer.append(itemset2.utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void writeOutItemsetSize1(int item, int utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=============  MinFHM ALGORITHM - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" MinHUIs count : " + this.huiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        if (this.debug) {
            int pairCount = 0;
            double maxMemory = this.getObjectSize(this.mapFMAP);
            for (Map.Entry<Integer, Map<Integer, Integer>> entry : this.mapFMAP.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Integer> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("CMAP size " + maxMemory + " MB");
            System.out.println("PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }

        public String toString() {
            return "[" + this.item + "," + this.utility + "]";
        }
    }
}

