/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.UtilityListPHM;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoPHM {
    public int phuiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Long> mapItemToTWU;
    Map<Integer, ItemInfo> mapItemToItemInfo;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Long>> mapEUCS = null;
    Map<Integer, Map<Integer, Long>> mapESCS = null;
    boolean ENABLE_LA_PRUNE = true;
    boolean ENABLE_EUCP = true;
    boolean ENABLE_ESCP = true;
    boolean DEBUG = false;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    int databaseSize = 0;
    int minPeriodicity;
    int maxPeriodicity;
    int minAveragePeriodicity;
    int maxAveragePeriodicity;
    int minimumLength = 0;
    int maximumLength = Integer.MAX_VALUE;
    double supportPruningThreshold = 0.0;
    public double totalExecutionTime = 0.0;
    public double maximumMemoryUsage = 0.0;
    public boolean findingIrregularItemsets = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, int minUtility, int minPeriodicity, int maxPeriodicity, int minAveragePeriodicity, int maxAveragePeriodicity) throws IOException {
        MemoryLogger.getInstance().reset();
        long startTimestamp = 0L;
        this.maxPeriodicity = maxPeriodicity;
        this.minPeriodicity = minPeriodicity;
        this.minAveragePeriodicity = minAveragePeriodicity;
        this.maxAveragePeriodicity = maxAveragePeriodicity;
        this.itemsetBuffer = new int[200];
        if (this.ENABLE_EUCP) {
            this.mapEUCS = new HashMap<Integer, Map<Integer, Long>>();
        }
        if (this.ENABLE_ESCP) {
            this.mapESCS = new HashMap<Integer, Map<Integer, Long>>();
        }
        startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Long>();
        this.mapItemToItemInfo = new HashMap<Integer, ItemInfo>();
        BufferedReader myInput = null;
        this.databaseSize = 0;
        String thisLine = null;
        long sumOfTransactionLength = 0L;
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                ++this.databaseSize;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                int transactionUtility = Integer.parseInt(split[1]);
                sumOfTransactionLength += (long)items.length;
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Long twu = this.mapItemToTWU.get(item);
                    twu = twu == null ? (long)transactionUtility : twu + (long)transactionUtility;
                    this.mapItemToTWU.put(item, twu);
                    ItemInfo itemInfo = this.mapItemToItemInfo.get(item);
                    if (itemInfo == null) {
                        itemInfo = new ItemInfo();
                        this.mapItemToItemInfo.put(item, itemInfo);
                    }
                    ++itemInfo.support;
                    int periodicity = this.databaseSize - itemInfo.lastSeenTransaction;
                    if (itemInfo.largestPeriodicity < periodicity) {
                        itemInfo.largestPeriodicity = periodicity;
                    }
                    itemInfo.lastSeenTransaction = this.databaseSize;
                    if (itemInfo.support == 1 || periodicity >= itemInfo.smallestPeriodicity) continue;
                    itemInfo.smallestPeriodicity = periodicity;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.supportPruningThreshold = (double)this.databaseSize / (double)maxAveragePeriodicity - 1.0;
        for (Map.Entry<Integer, ItemInfo> entry : this.mapItemToItemInfo.entrySet()) {
            ItemInfo itemInfo = entry.getValue();
            int periodicity = this.databaseSize - itemInfo.lastSeenTransaction;
            if (itemInfo.largestPeriodicity < periodicity) {
                itemInfo.largestPeriodicity = periodicity;
            }
            if (!this.DEBUG) continue;
            System.out.println(" item : " + entry.getKey() + "\tavgPer: " + (double)this.databaseSize / (double)(itemInfo.support + 1) + "\tminPer: " + itemInfo.smallestPeriodicity + "\tmaxPer: " + itemInfo.largestPeriodicity + "\tTWU: " + this.mapItemToTWU.get(entry.getKey()) + "\tsup.: " + itemInfo.support);
        }
        if (this.DEBUG) {
            System.out.println("Number of transactions : " + this.databaseSize);
            System.out.println("Average transaction length : " + (double)sumOfTransactionLength / (double)this.databaseSize);
            System.out.println("Number of items : " + this.mapItemToItemInfo.size());
            System.out.println("Average pruning threshold  (|D| / maxAvg $) - 1): " + this.supportPruningThreshold);
        }
        ArrayList<UtilityListPHM> listOfUtilityLists = new ArrayList<UtilityListPHM>();
        HashMap<Integer, UtilityListPHM> mapItemToUtilityList = new HashMap<Integer, UtilityListPHM>();
        for (Integer item : this.mapItemToTWU.keySet()) {
            ItemInfo itemInfo = this.mapItemToItemInfo.get(item);
            if (!((double)itemInfo.support >= this.supportPruningThreshold) || itemInfo.largestPeriodicity > maxPeriodicity || this.mapItemToTWU.get(item) < (long)minUtility) continue;
            UtilityListPHM uList = new UtilityListPHM(item);
            mapItemToUtilityList.put(item, uList);
            listOfUtilityLists.add(uList);
            uList.largestPeriodicity = itemInfo.largestPeriodicity;
            uList.smallestPeriodicity = itemInfo.smallestPeriodicity;
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityListPHM>(){

            @Override
            public int compare(UtilityListPHM o1, UtilityListPHM o2) {
                return AlgoPHM.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null) {
                Pair pair;
                int i;
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                int remainingUtility = 0;
                long newTWU = 0L;
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                for (i = 0; i < items.length; ++i) {
                    pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Integer.parseInt(utilityValues[i]);
                    ItemInfo itemInfo = this.mapItemToItemInfo.get(pair.item);
                    if (!((double)itemInfo.support >= this.supportPruningThreshold) || itemInfo.largestPeriodicity > maxPeriodicity || this.mapItemToTWU.get(pair.item) < (long)minUtility) continue;
                    revisedTransaction.add(pair);
                    remainingUtility += pair.utility;
                    newTWU += (long)pair.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoPHM.this.compareItems(o1.item, o2.item);
                    }
                });
                for (i = 0; i < revisedTransaction.size(); ++i) {
                    Pair pairAfter;
                    int j;
                    pair = (Pair)revisedTransaction.get(i);
                    UtilityListPHM utilityListOfItem = (UtilityListPHM)mapItemToUtilityList.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                    utilityListOfItem.addElement(element);
                    if (this.ENABLE_EUCP) {
                        Map<Integer, Long> mapFMAPItem = this.mapEUCS.get(pair.item);
                        if (mapFMAPItem == null) {
                            mapFMAPItem = new HashMap<Integer, Long>();
                            this.mapEUCS.put(pair.item, mapFMAPItem);
                        }
                        for (j = i + 1; j < revisedTransaction.size(); ++j) {
                            pairAfter = (Pair)revisedTransaction.get(j);
                            Long twuSum = mapFMAPItem.get(pairAfter.item);
                            if (twuSum == null) {
                                mapFMAPItem.put(pairAfter.item, newTWU);
                                continue;
                            }
                            mapFMAPItem.put(pairAfter.item, twuSum + newTWU);
                        }
                    }
                    if (!this.ENABLE_ESCP) continue;
                    Map<Integer, Long> mapESItem = this.mapESCS.get(pair.item);
                    if (mapESItem == null) {
                        mapESItem = new HashMap<Integer, Long>();
                        this.mapESCS.put(pair.item, mapESItem);
                    }
                    for (j = i + 1; j < revisedTransaction.size(); ++j) {
                        pairAfter = (Pair)revisedTransaction.get(j);
                        Long support = mapESItem.get(pairAfter.item);
                        if (support == null) {
                            mapESItem.put(pairAfter.item, 1L);
                            continue;
                        }
                        mapESItem.put(pairAfter.item, support + 1L);
                    }
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        this.mapItemToItemInfo = null;
        this.mapItemToTWU = null;
        mapItemToUtilityList = null;
        MemoryLogger.getInstance().checkMemory();
        this.phm(this.itemsetBuffer, 0, null, listOfUtilityLists, minUtility);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.totalExecutionTime = System.currentTimeMillis() - startTimestamp;
        this.maximumMemoryUsage = MemoryLogger.getInstance().getMaxMemory();
    }

    public void runAlgorithmIrregular(String input, String output, int minUtility, int regularityThreshold) throws IOException {
        this.findingIrregularItemsets = true;
        this.setEnableESCP(false);
        this.runAlgorithm(input, output, minUtility, regularityThreshold, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
    }

    private int compareItems(int item1, int item2) {
        int compare = (int)(this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2));
        return compare == 0 ? item1 - item2 : compare;
    }

    private void phm(int[] prefix, int prefixLength, UtilityListPHM pUL, List<UtilityListPHM> ULs, int minUtility) throws IOException {
        int patternSize = prefixLength + 1;
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityListPHM X = ULs.get(i);
            if (X.sumIutils + X.sumRutils < (long)minUtility) continue;
            double averagePeriodicity = (double)this.databaseSize / ((double)X.getSupport() + 1.0);
            if (X.sumIutils >= (long)minUtility && averagePeriodicity <= (double)this.maxAveragePeriodicity && averagePeriodicity >= (double)this.minAveragePeriodicity && X.smallestPeriodicity >= this.minPeriodicity && X.largestPeriodicity <= this.maxPeriodicity && patternSize >= this.minimumLength && patternSize <= this.maximumLength) {
                this.writeOut(prefix, prefixLength, X, averagePeriodicity);
            }
            if (patternSize >= this.maximumLength) continue;
            ArrayList<UtilityListPHM> exULs = new ArrayList<UtilityListPHM>();
            for (int j = i + 1; j < ULs.size(); ++j) {
                Long supportF;
                Map<Integer, Long> mapSUPF;
                Long twuF;
                Map<Integer, Long> mapTWUF;
                UtilityListPHM Y = ULs.get(j);
                if (this.ENABLE_EUCP && (mapTWUF = this.mapEUCS.get(X.item)) != null && ((twuF = mapTWUF.get(Y.item)) == null || twuF < (long)minUtility) || this.ENABLE_ESCP && (mapSUPF = this.mapESCS.get(X.item)) != null && (supportF = mapSUPF.get(Y.item)) != null && (double)supportF.longValue() < this.supportPruningThreshold) continue;
                ++this.candidateCount;
                UtilityListPHM temp = this.construct(pUL, X, Y, minUtility);
                if (temp == null) continue;
                exULs.add(temp);
            }
            this.itemsetBuffer[prefixLength] = X.item;
            this.phm(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private UtilityListPHM construct(UtilityListPHM P, UtilityListPHM px, UtilityListPHM py, int minUtility) {
        UtilityListPHM pxyUL = new UtilityListPHM(py.item);
        int lastTid = -1;
        long totalUtility = px.sumIutils + px.sumRutils;
        long totalSupport = px.getSupport();
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (!this.ENABLE_LA_PRUNE) continue;
                if ((totalUtility -= (long)(ex.iutils + ex.rutils)) < (long)minUtility) {
                    return null;
                }
                if (!((double)(--totalSupport) < this.supportPruningThreshold)) continue;
                return null;
            }
            if (P == null) {
                int periodicity = ex.tid - lastTid;
                if (periodicity > this.maxPeriodicity) {
                    return null;
                }
                if (periodicity >= pxyUL.largestPeriodicity) {
                    pxyUL.largestPeriodicity = periodicity;
                }
                lastTid = ex.tid;
                if (pxyUL.elements.size() > 0 && periodicity < pxyUL.smallestPeriodicity) {
                    pxyUL.smallestPeriodicity = periodicity;
                }
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            int periodicity = ex.tid - lastTid;
            if (periodicity > this.maxPeriodicity) {
                return null;
            }
            if (periodicity >= pxyUL.largestPeriodicity) {
                pxyUL.largestPeriodicity = periodicity;
            }
            lastTid = ex.tid;
            if (pxyUL.elements.size() > 0 && periodicity < pxyUL.smallestPeriodicity) {
                pxyUL.smallestPeriodicity = periodicity;
            }
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        int periodicity = this.databaseSize - 1 - lastTid;
        if (periodicity > this.maxPeriodicity) {
            return null;
        }
        if (periodicity >= pxyUL.largestPeriodicity) {
            pxyUL.largestPeriodicity = periodicity;
        }
        if ((double)pxyUL.getSupport() < this.supportPruningThreshold) {
            return null;
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityListPHM ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, UtilityListPHM utilityList, double averagePeriodicity) throws IOException {
        ++this.phuiCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(utilityList.item);
        buffer.append(" #UTIL: ");
        buffer.append(utilityList.sumIutils);
        if (this.findingIrregularItemsets) {
            buffer.append(" #REG: ");
            buffer.append(utilityList.largestPeriodicity);
        } else {
            buffer.append(" #SUP: ");
            buffer.append(utilityList.getSupport());
            buffer.append(" #MINPER: ");
            buffer.append(utilityList.smallestPeriodicity);
            buffer.append(" #MAXPER: ");
            buffer.append(utilityList.largestPeriodicity);
            buffer.append(" #AVGPER: ");
            buffer.append(averagePeriodicity);
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        double maxMemory;
        int pairCount;
        if (this.DEBUG && this.ENABLE_EUCP) {
            System.out.println("===== CONTENT OF EUCP =====");
            for (Map.Entry<Integer, Map<Integer, Long>> entry : this.mapEUCS.entrySet()) {
                System.out.print("Item:" + entry.getKey() + " -- ");
                for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                    System.out.print(entry2.getKey() + " (" + entry2.getValue() + ")  ");
                }
                System.out.println();
            }
        }
        if (this.DEBUG && this.ENABLE_ESCP) {
            System.out.println("===== CONTENT OF ESCS =====");
            for (Map.Entry<Integer, Map<Integer, Long>> entry : this.mapESCS.entrySet()) {
                System.out.print("Item:" + entry.getKey() + " -- ");
                for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                    System.out.print(entry2.getKey() + " (" + entry2.getValue() + ")  ");
                }
                System.out.println();
            }
        }
        String optimizationEUCP = this.ENABLE_EUCP ? " EUCP: true -" : " EUCP: false -";
        String optimizationESCP = this.ENABLE_ESCP ? " ESCP: true " : " ESCP: false ";
        String name = "PHM";
        String patternType = "Periodic";
        if (this.findingIrregularItemsets) {
            name = name + "_irregular";
            optimizationESCP = "";
            patternType = "Irregular";
        }
        System.out.println("=============  " + name + " v2.38" + optimizationEUCP + optimizationESCP + "=====");
        System.out.println(" Database size: " + this.databaseSize + " transactions");
        System.out.println(" Time : " + this.totalExecutionTime + " ms");
        System.out.println(" Memory ~ " + this.maximumMemoryUsage + " MB");
        System.out.println(" " + patternType + " High-utility itemsets count : " + this.phuiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        if (this.DEBUG && this.ENABLE_EUCP) {
            pairCount = 0;
            maxMemory = this.getObjectSize(this.mapEUCS);
            for (Map.Entry<Integer, Map<Integer, Long>> entry : this.mapEUCS.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("EUCS size " + maxMemory + " MB    PAIR COUNT " + pairCount);
        }
        if (this.DEBUG && this.ENABLE_ESCP) {
            pairCount = 0;
            maxMemory = this.getObjectSize(this.mapESCS);
            for (Map.Entry<Integer, Map<Integer, Long>> entry : this.mapESCS.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("ESCS size " + maxMemory + " MB    PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    public void setEnableEUCP(boolean enable) {
        this.ENABLE_EUCP = enable;
    }

    public void setEnableESCP(boolean enable) {
        this.ENABLE_ESCP = enable;
    }

    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    public void setMaximumLength(int maximumLength) {
        this.maximumLength = maximumLength;
    }

    class ItemInfo {
        int support = 0;
        int largestPeriodicity = 0;
        int smallestPeriodicity = Integer.MAX_VALUE;
        int lastSeenTransaction = 0;

        ItemInfo() {
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

