/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.hui_miner_float;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner_float.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner_float.UtilityList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoFHM_Float {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Float> mapItemToTWU;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Float>> mapFMAP;
    boolean ENABLE_LA_PRUNE = true;
    boolean DEBUG = false;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAlgorithm(String input, String output, float minUtility) throws IOException {
        String thisLine;
        MemoryLogger.getInstance().reset();
        this.itemsetBuffer = new int[200];
        this.mapFMAP = new HashMap<Integer, Map<Integer, Float>>();
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.mapItemToTWU = new HashMap<Integer, Float>();
        try (BufferedReader myInput = null;){
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                float transactionUtility = Float.parseFloat(split[1]);
                for (int i = 0; i < items.length; ++i) {
                    Integer item = Integer.parseInt(items[i]);
                    Float twu = this.mapItemToTWU.get(item);
                    twu = Float.valueOf(twu == null ? transactionUtility : twu.floatValue() + transactionUtility);
                    this.mapItemToTWU.put(item, twu);
                }
            }
        }
        ArrayList<UtilityList> listOfUtilityLists = new ArrayList<UtilityList>();
        HashMap<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
        for (Integer item : this.mapItemToTWU.keySet()) {
            if (!(this.mapItemToTWU.get(item).floatValue() >= minUtility)) continue;
            UtilityList uList = new UtilityList(item);
            mapItemToUtilityList.put(item, uList);
            listOfUtilityLists.add(uList);
        }
        Collections.sort(listOfUtilityLists, new Comparator<UtilityList>(){

            @Override
            public int compare(UtilityList o1, UtilityList o2) {
                return AlgoFHM_Float.this.compareItems(o1.item, o2.item);
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int tid = 0;
            while ((thisLine = myInput.readLine()) != null) {
                Pair pair;
                int i;
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] split = thisLine.split(":");
                String[] items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                float remainingUtility = 0.0f;
                float newTWU = 0.0f;
                ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                for (i = 0; i < items.length; ++i) {
                    pair = new Pair();
                    pair.item = Integer.parseInt(items[i]);
                    pair.utility = Float.parseFloat(utilityValues[i]);
                    if (!(this.mapItemToTWU.get(pair.item).floatValue() >= minUtility)) continue;
                    revisedTransaction.add(pair);
                    remainingUtility += pair.utility;
                    newTWU += pair.utility;
                }
                Collections.sort(revisedTransaction, new Comparator<Pair>(){

                    @Override
                    public int compare(Pair o1, Pair o2) {
                        return AlgoFHM_Float.this.compareItems(o1.item, o2.item);
                    }
                });
                for (i = 0; i < revisedTransaction.size(); ++i) {
                    pair = (Pair)revisedTransaction.get(i);
                    UtilityList utilityListOfItem = (UtilityList)mapItemToUtilityList.get(pair.item);
                    Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                    utilityListOfItem.addElement(element);
                    Map<Integer, Float> mapFMAPItem = this.mapFMAP.get(pair.item);
                    if (mapFMAPItem == null) {
                        mapFMAPItem = new HashMap<Integer, Float>();
                        this.mapFMAP.put(pair.item, mapFMAPItem);
                    }
                    for (int j = i + 1; j < revisedTransaction.size(); ++j) {
                        Pair pairAfter = (Pair)revisedTransaction.get(j);
                        Float twuSum = mapFMAPItem.get(pairAfter.item);
                        if (twuSum == null) {
                            mapFMAPItem.put(pairAfter.item, Float.valueOf(newTWU));
                            continue;
                        }
                        mapFMAPItem.put(pairAfter.item, Float.valueOf(twuSum.floatValue() + newTWU));
                    }
                }
                ++tid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.fhm(this.itemsetBuffer, 0, null, listOfUtilityLists, minUtility);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = (int)(this.mapItemToTWU.get(item1).floatValue() - this.mapItemToTWU.get(item2).floatValue());
        return compare == 0 ? item1 - item2 : compare;
    }

    private void fhm(int[] prefix, int prefixLength, UtilityList pUL, List<UtilityList> ULs, float minUtility) throws IOException {
        for (int i = 0; i < ULs.size(); ++i) {
            UtilityList X = ULs.get(i);
            if (X.sumIutils >= minUtility) {
                this.writeOut(prefix, prefixLength, X.item, X.sumIutils);
            }
            if (!(X.sumIutils + X.sumRutils >= minUtility)) continue;
            ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
            for (int j = i + 1; j < ULs.size(); ++j) {
                Float twuF;
                UtilityList Y = ULs.get(j);
                Map<Integer, Float> mapTWUF = this.mapFMAP.get(X.item);
                if (mapTWUF != null && ((twuF = mapTWUF.get(Y.item)) == null || twuF.floatValue() < minUtility)) continue;
                ++this.candidateCount;
                UtilityList temp = this.construct(pUL, X, Y, minUtility);
                if (temp == null) continue;
                exULs.add(temp);
            }
            this.itemsetBuffer[prefixLength] = X.item;
            this.fhm(this.itemsetBuffer, prefixLength + 1, X, exULs, minUtility);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py, float minUtility) {
        UtilityList pxyUL = new UtilityList(py.item);
        float totalUtility = px.sumIutils + px.sumRutils;
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) {
                if (!this.ENABLE_LA_PRUNE || !((totalUtility -= ex.iutils + ex.rutils) < minUtility)) continue;
                return null;
            }
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, float utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < prefixLength; ++i) {
            buffer.append(prefix[i]);
            buffer.append(' ');
        }
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=============  FHM ALGORITHM - SPMF 0.97e - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        if (this.DEBUG) {
            int pairCount = 0;
            double maxMemory = this.getObjectSize(this.mapFMAP);
            for (Map.Entry<Integer, Map<Integer, Float>> entry : this.mapFMAP.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Float> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("CMAP size " + maxMemory + " MB");
            System.out.println("PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    class Pair {
        int item = 0;
        float utility = 0.0f;

        Pair() {
        }
    }
}

