/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.ihaupm;

import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.IAUTree;
import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.IHAUPM;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class AlgoIHAUPM {
    public void runAlgorithm(String profitsFile, String dataFileName, int numOfTrancsInDB, double threshold, boolean isInsertMode, int numOfInsertedTransactions, int numOfInsert, String increResultFolder, String batchResultFolder, String writeMinedInfoFile) throws Exception {
        int numOfTrancsInEachStep;
        MemoryLogger.getInstance().reset();
        File increFolder = new File(increResultFolder);
        File batchFolder = new File(batchResultFolder);
        if (!increFolder.exists()) {
            increFolder.mkdir();
        }
        if (!batchFolder.exists()) {
            batchFolder.mkdir();
        }
        long start = System.currentTimeMillis();
        IAUTree tree = new IAUTree();
        tree.construct(dataFileName, profitsFile, threshold, numOfTrancsInDB, isInsertMode);
        IHAUPM m = null;
        String itemsetFile = null;
        BufferedWriter writeMinedInfo = null;
        if (writeMinedInfoFile != null) {
            writeMinedInfo = new BufferedWriter(new FileWriter(writeMinedInfoFile));
        }
        int[] minedInfo = new int[]{-1, -1};
        if (isInsertMode) {
            numOfTrancsInEachStep = numOfInsertedTransactions / numOfInsert;
            int numOfTrancsInLastStep = numOfInsertedTransactions;
            int numOfHasInsertTrancs = 0;
            for (int i = 0; i < numOfInsert - 1; ++i) {
                tree.insertNewDB(numOfTrancsInEachStep, false, dataFileName, numOfTrancsInDB + numOfHasInsertTrancs);
                m = new IHAUPM(tree);
                minedInfo = m.mine(itemsetFile);
                AlgoIHAUPM.write(writeMinedInfo, minedInfo, i + 1, start);
                numOfTrancsInLastStep -= numOfTrancsInEachStep;
                numOfHasInsertTrancs += numOfTrancsInEachStep;
            }
            tree.insertNewDB(numOfTrancsInLastStep, true, dataFileName, numOfTrancsInDB + numOfHasInsertTrancs);
            minedInfo = m.mine(itemsetFile);
            AlgoIHAUPM.write(writeMinedInfo, minedInfo, numOfInsert, start);
        } else {
            tree.clear();
            int acc = numOfTrancsInEachStep = numOfInsertedTransactions / numOfInsert;
            for (int i = 0; i < numOfInsert - 1; ++i) {
                tree.construct(dataFileName, profitsFile, threshold, numOfTrancsInDB + acc, false);
                m = new IHAUPM(tree);
                minedInfo = m.mine(itemsetFile);
                AlgoIHAUPM.write(writeMinedInfo, minedInfo, i + 1, start);
                tree.clear();
                acc += numOfTrancsInEachStep;
            }
            tree.construct(dataFileName, profitsFile, threshold, numOfTrancsInDB + numOfInsertedTransactions, false);
            minedInfo = m.mine(itemsetFile);
            AlgoIHAUPM.write(writeMinedInfo, minedInfo, numOfInsert, start);
        }
        if (writeMinedInfo != null) {
            writeMinedInfo.close();
        }
        long end = System.currentTimeMillis();
        System.out.println("candidateNum=" + minedInfo[0]);
        System.out.println("HAUIs=" + minedInfo[1]);
        System.out.println("Time(s)=" + (double)(end - start) / 1000.0);
        System.out.println("Memory(M)=" + MemoryLogger.getInstance().getMaxMemory());
    }

    private static void write(BufferedWriter out, int[] minedInfo, int j, long startTime) throws IOException {
        if (out == null) {
            return;
        }
        out.write("***********The running status of " + j + "-th insertion***************\n");
        StringBuilder wrtStr = new StringBuilder();
        for (int i = 0; i < minedInfo.length; ++i) {
            wrtStr.append(minedInfo[i] + " ");
        }
        wrtStr.append(System.currentTimeMillis() - startTime + " ");
        wrtStr.append(MemoryLogger.getInstance().getMaxMemory() + "\n");
        out.write(wrtStr.toString());
    }
}

