/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.ihaupm;

import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IAUNode {
    private int index;
    private Map<String, IAUNode> children = null;
    private ArrayList<IAUPair> quanAry = null;
    private long AUUB;
    private IAUNode parent = null;
    private IAUNode left = null;
    private IAUNode right = null;

    public String toString() {
        return this.getName() + ":" + this.AUUB;
    }

    public void removeQuantityAt(int index) {
        this.quanAry.remove(index);
    }

    public int quantityArySize() {
        return this.quanAry.size();
    }

    public void mergeQuanAry(IAUNode node) {
        ArrayList<IAUPair> qa = node.getQuanAry();
        for (int i = 0; i < qa.size(); ++i) {
            IAUPair p = qa.get(i);
            IAUPair ps = this.quanAry.get(i);
            ps.quan += p.quan;
        }
    }

    public void mergeAUUB(IAUNode node) {
        this.AUUB += node.AUUB;
    }

    public IAUNode getPareent() {
        return this.parent;
    }

    public void setParent(IAUNode parent) {
        this.parent = parent;
    }

    public IAUNode getLeft() {
        return this.left;
    }

    public void setLeft(IAUNode left) {
        this.left = left;
    }

    public IAUNode getRight() {
        return this.right;
    }

    public void setRight(IAUNode right) {
        this.right = right;
    }

    public Map<String, IAUNode> getChildren() {
        return this.children;
    }

    public IAUNode() {
    }

    public IAUNode(int auub, IAUNode parent) {
        this.AUUB = auub;
        this.parent = parent;
        this.children = new HashMap<String, IAUNode>();
        this.quanAry = new ArrayList();
    }

    public IAUNode(int auub, String name) {
        this.AUUB = auub;
        this.quanAry = new ArrayList();
        this.quanAry.add(new IAUPair(name, 0));
    }

    public String getName() {
        if (this.quanAry.size() != 0) {
            return this.quanAry.get((int)(this.quanAry.size() - 1)).name;
        }
        return null;
    }

    public void updateQuanBefor(int index, List<Item> quans) {
        for (int i = 0; i <= index; ++i) {
            IAUPair p = this.quanAry.get(i);
            p.quan += quans.get(i).getQuantity().intValue();
        }
    }

    public void addQuansBefor(int index, List<Item> quans) {
        for (int i = 0; i <= index; ++i) {
            Item item = quans.get(i);
            this.quanAry.add(new IAUPair(item.getName(), item.getQuantity()));
        }
    }

    public void putChild(String I, IAUNode child) {
        this.children.put(I, child);
    }

    public void removeChild(String name) {
        this.children.remove(name);
    }

    public IAUNode getChild(String name) {
        return this.children.get(name);
    }

    public void setChildren(Map<String, IAUNode> children) {
        this.children = children;
    }

    public long getAUUB() {
        return this.AUUB;
    }

    public void setAUUB(int aUUB) {
        this.AUUB = aUUB;
    }

    public void plusAUUB(int utility) {
        this.AUUB += (long)utility;
    }

    public ArrayList<IAUPair> getQuanAry() {
        return this.quanAry;
    }

    public void setQuanAry(ArrayList<IAUPair> quanAry) {
        this.quanAry = quanAry;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static class IAUPair {
        public String name;
        public int quan;

        public IAUPair(String i, int quan) {
            this.name = i;
            this.quan = quan;
        }

        public String toString() {
            return "*name:" + this.name + ",quantity:" + this.quan + "*";
        }
    }
}

