/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.ihaupm;

import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.IAUNode;
import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.TableNode;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IAUTree {
    static IAUNode root = new IAUNode(-1, (IAUNode)null);
    static Map<String, TableNode> headTableMap = null;
    static List<TableNode> headTable = null;
    static double threshold = 0.0;
    static double minautil = 0.0;
    static Map<String, Long> mapItemToAuub = null;
    static final Map<String, Map<String, Long>> EUCS = new HashMap<String, Map<String, Long>>();
    BufferedReader in = null;
    boolean isActiveEUCS = true;
    public Map<String, Integer> item2profits = null;

    public void clear() {
        mapItemToAuub.clear();
        if (this.isActiveEUCS) {
            EUCS.clear();
        }
        headTable.clear();
        headTableMap.clear();
        root = new IAUNode(-1, (IAUNode)null);
    }

    public void construct(String datafileName, String profitFileName, double threshold, long numOfTrancs, boolean isInsert) throws Exception {
        this.item2profits = this.readProfits(profitFileName);
        IAUTree.threshold = threshold;
        this.in = new BufferedReader(new FileReader(datafileName));
        String line = null;
        String[] items = null;
        mapItemToAuub = new HashMap<String, Long>();
        long totalUtility = 0L;
        int ii = 0;
        while ((line = this.in.readLine()) != null && (long)ii++ < numOfTrancs) {
            int i;
            items = line.split(" ");
            Integer maxItemUtility = -1;
            for (i = 0; i < items.length; i += 2) {
                int utility = Integer.parseInt(items[i + 1].trim()) * this.item2profits.get(items[i].trim());
                totalUtility += (long)utility;
                if (maxItemUtility >= utility) continue;
                maxItemUtility = utility;
            }
            for (i = 0; i < items.length; i += 2) {
                Long auub = mapItemToAuub.get(items[i]);
                auub = auub == null ? (long)maxItemUtility.intValue() : auub + (long)maxItemUtility.intValue();
                mapItemToAuub.put(items[i], auub);
            }
        }
        this.in.close();
        minautil = (double)totalUtility * IAUTree.threshold;
        Iterator<Map.Entry<String, Long>> iter = mapItemToAuub.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Long> entry = iter.next();
            if (!((double)entry.getValue().longValue() < minautil)) continue;
            iter.remove();
        }
        this.buildHeadTable(mapItemToAuub);
        this.in = new BufferedReader(new FileReader(datafileName));
        ii = 0;
        while ((line = this.in.readLine()) != null && (long)ii++ < numOfTrancs) {
            int i;
            items = line.split(" ");
            Itemset itemset2 = new Itemset();
            int maximalItemUtility = -1;
            for (i = 0; i < items.length; i += 2) {
                Long auub = mapItemToAuub.get(items[i]);
                if (auub == null) continue;
                if ((double)auub.longValue() < minautil) continue;
                itemset2.add(new Item(items[i], Integer.parseInt(items[i + 1])));
                int itemUtility = Integer.parseInt(items[i + 1]) * this.item2profits.get(items[i]);
                maximalItemUtility = maximalItemUtility < itemUtility ? itemUtility : maximalItemUtility;
            }
            itemset2.trimToSize();
            itemset2.maxItemUtility = maximalItemUtility;
            Collections.sort(itemset2, new Comparator<Item>(){

                @Override
                public int compare(Item a, Item b) {
                    int cmp = (int)(mapItemToAuub.get(b.name) - mapItemToAuub.get(a.name));
                    return cmp == 0 ? a.name.compareTo(b.name) : cmp;
                }
            });
            if (this.isActiveEUCS) {
                for (i = 0; i < itemset2.size(); ++i) {
                    Map<String, Long> subEUCS = EUCS.get(((Item)itemset2.get((int)i)).name);
                    if (subEUCS == null) {
                        subEUCS = new HashMap<String, Long>();
                        EUCS.put(((Item)itemset2.get((int)i)).name, subEUCS);
                    }
                    for (int j = i + 1; j < itemset2.size(); ++j) {
                        Long val = subEUCS.get(((Item)itemset2.get((int)j)).name);
                        val = val == null ? (long)itemset2.maxItemUtility : val + (long)itemset2.maxItemUtility;
                        subEUCS.put(((Item)itemset2.get((int)j)).name, val);
                    }
                }
            }
            this.insertOneTranc(itemset2, maximalItemUtility);
        }
        if (!isInsert) {
            this.in.close();
        }
    }

    private Map<String, Integer> readProfits(String fileName) throws IOException {
        HashMap<String, Integer> item2profits = new HashMap<String, Integer>();
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String line = null;
        String[] pair = null;
        while ((line = in.readLine()) != null) {
            pair = line.split(", ");
            item2profits.put(pair[0].trim(), Integer.parseInt(pair[1].trim()));
        }
        in.close();
        return item2profits;
    }

    private void insertOneTranc(Itemset itemset2, Set<String> rescanItems) {
        IAUNode tmpRoot = root;
        for (int j = 0; j < itemset2.size(); ++j) {
            Item item = (Item)itemset2.get(j);
            IAUNode child = tmpRoot.getChild(item.getName());
            if (child != null) {
                if (rescanItems != null) {
                    if (rescanItems.contains(item.getName())) {
                        child.plusAUUB(itemset2.maxItemUtility);
                        child.updateQuanBefor(j, itemset2.subList(0, j + 1));
                    }
                } else {
                    child.plusAUUB(itemset2.maxItemUtility);
                    child.updateQuanBefor(j, itemset2.subList(0, j + 1));
                }
            } else if (rescanItems != null) {
                if (!rescanItems.contains(item.getName())) continue;
                child = this.insertUnity(itemset2, tmpRoot, item, j);
            } else {
                child = this.insertUnity(itemset2, tmpRoot, item, j);
            }
            if (child == null) {
                System.out.println("item that leading to Null exception\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd" + item.name);
            }
            tmpRoot = child;
        }
    }

    private void insertOneTranc(Itemset itemset2, int maximalItemUtility) {
        IAUNode tmpRoot = root;
        for (int j = 0; j < itemset2.size(); ++j) {
            Item item = (Item)itemset2.get(j);
            IAUNode child = tmpRoot.getChild(item.getName());
            if (child != null) {
                child.plusAUUB(maximalItemUtility);
                child.updateQuanBefor(j, itemset2.subList(0, j + 1));
            } else {
                child = this.insertUnity(itemset2, tmpRoot, item, j);
            }
            tmpRoot = child;
        }
    }

    private IAUNode insertUnity(Itemset itemset2, IAUNode tmpRoot, Item item, int j) {
        IAUNode child = new IAUNode(itemset2.maxItemUtility, tmpRoot);
        tmpRoot.putChild(item.getName(), child);
        child.addQuansBefor(j, itemset2.subList(0, j + 1));
        TableNode p = headTableMap.get(item.getName());
        child.setRight(p.hlink);
        if (p.hlink != null) {
            p.hlink.setLeft(child);
        }
        p.hlink = child;
        child.setLeft(null);
        child.setParent(tmpRoot);
        return child;
    }

    private void buildHeadTable(final Map<String, Long> mapItemToAuub) {
        headTable = new ArrayList<TableNode>();
        headTableMap = new HashMap<String, TableNode>();
        for (Map.Entry<String, Long> entry : mapItemToAuub.entrySet()) {
            TableNode tn = new TableNode();
            headTable.add(tn);
            tn.name = entry.getKey();
            headTableMap.put(entry.getKey(), tn);
        }
        Collections.sort(headTable, new Comparator<TableNode>(){

            @Override
            public int compare(TableNode a, TableNode b) {
                int cmp = (int)((Long)mapItemToAuub.get(b.name) - (Long)mapItemToAuub.get(a.name));
                return cmp == 0 ? a.name.compareTo(b.name) : cmp;
            }
        });
    }

    public void insertNewDB(int numOfTrancEachInsert, boolean isCloseFid, String originalFile, int originalLinesNum) throws Exception {
        HashMap<String, Long> newMapItemToAuub = new HashMap<String, Long>();
        long newDBTotalUtility = 0L;
        String line = null;
        String[] lineItems = null;
        LinkedList<Itemset> insertDB = new LinkedList<Itemset>();
        int tid = 0;
        while ((line = this.in.readLine()) != null && tid++ < numOfTrancEachInsert) {
            int i;
            lineItems = line.split(", ");
            Integer maxItemUtility = -1;
            Itemset itemset2 = new Itemset(lineItems.length / 2);
            for (i = 0; i < lineItems.length; i += 2) {
                int utility = Integer.parseInt(lineItems[i].trim()) * this.item2profits.get(lineItems[i + 1].trim());
                newDBTotalUtility += (long)utility;
                if (maxItemUtility < utility) {
                    maxItemUtility = utility;
                }
                itemset2.add(new Item(lineItems[i], Integer.parseInt(lineItems[i + 1].trim())));
            }
            itemset2.maxItemUtility = maxItemUtility;
            insertDB.add(itemset2);
            for (i = 0; i < lineItems.length; i += 2) {
                Long auub = (Long)newMapItemToAuub.get(lineItems[i]);
                auub = auub == null ? (long)maxItemUtility.intValue() : auub + (long)maxItemUtility.intValue();
                newMapItemToAuub.put(lineItems[i], auub);
            }
        }
        if (isCloseFid) {
            this.in.close();
        }
        double localMinAutil = (double)newDBTotalUtility * threshold;
        minautil += localMinAutil;
        Set[] items = this.handleThreeCases(newMapItemToAuub, localMinAutil);
        Set rescanItems = items[1];
        final HashMap<String, Integer> mapToPriorityOfTable = new HashMap<String, Integer>();
        if (rescanItems.size() != 0) {
            BufferedReader in = new BufferedReader(new FileReader(originalFile));
            String thisLine = null;
            int ii = 0;
            HashMap<String, Long> rescanMapItemToAuub = new HashMap<String, Long>();
            while ((thisLine = in.readLine()) != null && ii++ < originalLinesNum) {
                int i;
                lineItems = thisLine.split(", ");
                int maxItemUtility = -1;
                for (i = 0; i < lineItems.length; i += 2) {
                    int utility = Integer.parseInt(lineItems[i + 1]) * this.item2profits.get(lineItems[i]);
                    if (maxItemUtility >= utility) continue;
                    maxItemUtility = utility;
                }
                for (i = 0; i < lineItems.length; i += 2) {
                    if (!rescanItems.contains(lineItems[i])) continue;
                    Long auub = (Long)rescanMapItemToAuub.get(lineItems[i]);
                    auub = auub == null ? (long)maxItemUtility : auub + (long)maxItemUtility;
                    rescanMapItemToAuub.put(lineItems[i], auub);
                }
            }
            in.close();
            LinkedList<Itemset> rescan_transactions = new LinkedList<Itemset>();
            in = new BufferedReader(new FileReader(originalFile));
            ii = 0;
            while ((thisLine = in.readLine()) != null && ii++ < originalLinesNum) {
                lineItems = thisLine.split(", ");
                boolean isIncluded = false;
                Itemset tranc = new Itemset(lineItems.length / 2);
                int maxItemUtility = -1;
                for (int i = 0; i < lineItems.length; i += 2) {
                    int quantity;
                    int utility;
                    if (rescanItems.contains(lineItems[i])) {
                        Long itemAuub = (Long)rescanMapItemToAuub.get(lineItems[i]);
                        Long ItemAuubInInsertDB = (Long)newMapItemToAuub.get(lineItems[i]);
                        if ((double)(itemAuub + ItemAuubInInsertDB) >= minautil) {
                            isIncluded = true;
                            mapItemToAuub.put(lineItems[i], itemAuub + ItemAuubInInsertDB);
                        } else {
                            rescanItems.remove(lineItems[i]);
                            newMapItemToAuub.remove(lineItems[i]);
                        }
                    }
                    if (maxItemUtility < (utility = (quantity = Integer.parseInt(lineItems[i + 1])) * this.item2profits.get(lineItems[i]))) {
                        maxItemUtility = utility;
                    }
                    Item item = new Item(lineItems[i], quantity);
                    tranc.add(item);
                }
                tranc.maxItemUtility = maxItemUtility;
                if (!isIncluded) continue;
                rescan_transactions.add(tranc);
            }
            in.close();
            rescanMapItemToAuub = null;
            Iterator iter = rescanItems.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (mapItemToAuub.get(name) != null) continue;
                Long localAubbVal = (Long)newMapItemToAuub.get(name);
                if ((double)localAubbVal.longValue() < minautil) {
                    iter.remove();
                    continue;
                }
                mapItemToAuub.put(name, localAubbVal);
            }
            Iterator<Map.Entry<String, Long>> it = mapItemToAuub.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Long> entry = it.next();
                if (!((double)entry.getValue().longValue() < minautil)) continue;
                it.remove();
                TableNode r = headTableMap.get(entry.getKey());
                this.removeItemFromTree(r, entry.getKey());
                r = headTableMap.remove(entry.getKey());
                headTable.remove(r);
            }
            newMapItemToAuub = null;
            this.updateHeadTable(rescanItems);
            int tableLen = headTable.size();
            for (int i = 0; i < tableLen; ++i) {
                mapToPriorityOfTable.put(IAUTree.headTable.get((int)i).name, tableLen - i);
            }
            for (Itemset itemset3 : rescan_transactions) {
                for (int i = 0; i < itemset3.size(); ++i) {
                    if (mapItemToAuub.get(((Item)itemset3.get((int)i)).name) != null) continue;
                    itemset3.remove(i);
                    --i;
                }
                boolean isInsert = false;
                for (Item item : itemset3) {
                    if (!rescanItems.contains(item.name)) continue;
                    isInsert = true;
                    break;
                }
                if (!isInsert) continue;
                Collections.sort(itemset3, new Comparator<Item>(){

                    @Override
                    public int compare(Item a, Item b) {
                        int cmp = (Integer)mapToPriorityOfTable.get(b.name) - (Integer)mapToPriorityOfTable.get(a.name);
                        return cmp == 0 ? a.name.compareTo(b.name) : cmp;
                    }
                });
                this.insertOneTranc(itemset3, rescanItems);
            }
        }
        if (mapToPriorityOfTable.size() == 0) {
            int tableLen = headTable.size();
            for (int i = 0; i < tableLen; ++i) {
                mapToPriorityOfTable.put(IAUTree.headTable.get((int)i).name, tableLen - i);
            }
        }
        for (Itemset itemset4 : insertDB) {
            int i;
            for (i = 0; i < itemset4.size(); ++i) {
                if (mapItemToAuub.get(((Item)itemset4.get((int)i)).name) != null) continue;
                itemset4.remove(i);
                --i;
            }
            if (itemset4.size() == 0) continue;
            Collections.sort(itemset4, new Comparator<Item>(){

                @Override
                public int compare(Item a, Item b) {
                    int cmp = (Integer)mapToPriorityOfTable.get(b.name) - (Integer)mapToPriorityOfTable.get(a.name);
                    return cmp == 0 ? a.name.compareTo(b.name) : cmp;
                }
            });
            if (this.isActiveEUCS) {
                for (i = 0; i < itemset4.size(); ++i) {
                    Map<String, Long> subEUCS = EUCS.get(((Item)itemset4.get((int)i)).name);
                    if (subEUCS == null) {
                        subEUCS = new HashMap<String, Long>();
                        EUCS.put(((Item)itemset4.get((int)i)).name, subEUCS);
                    }
                    for (int j = i + 1; j < itemset4.size(); ++j) {
                        Long val = subEUCS.get(((Item)itemset4.get((int)j)).name);
                        val = val == null ? (long)itemset4.maxItemUtility : val + (long)itemset4.maxItemUtility;
                        subEUCS.put(((Item)itemset4.get((int)j)).name, val);
                    }
                }
            }
            this.insertOneTranc(itemset4, itemset4.maxItemUtility);
        }
    }

    private Set[] handleThreeCases(Map<String, Long> newItem2auub, double instThreshold) {
        HashSet<String> rescanItems = new HashSet<String>();
        Iterator<Map.Entry<String, Long>> iter = newItem2auub.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Long> entry = iter.next();
            String name = entry.getKey();
            Long auub = entry.getValue();
            TableNode val = headTableMap.get(name);
            if (val != null) {
                Long valAuub = mapItemToAuub.get(val.name);
                if ((double)(valAuub + auub) >= minautil) {
                    mapItemToAuub.put(val.name, valAuub + auub);
                    continue;
                }
                TableNode r = headTableMap.get(name);
                this.removeItemFromTree(r, name);
                r = headTableMap.remove(name);
                headTable.remove(r);
                mapItemToAuub.remove(val.name);
                iter.remove();
                continue;
            }
            if (val == null && (double)auub.longValue() >= instThreshold) {
                rescanItems.add(name);
                continue;
            }
            iter.remove();
        }
        return new Set[]{null, rescanItems};
    }

    private void updateHeadTable(Set<String> rescanItems) {
        if (rescanItems.size() == 0) {
            return;
        }
        int len = headTable.size();
        for (String name : rescanItems) {
            TableNode tn = new TableNode();
            tn.name = name;
            headTableMap.put(tn.name, tn);
            headTable.add(tn);
        }
        List<TableNode> subList = headTable.subList(len, headTable.size());
        Collections.sort(subList, new Comparator<TableNode>(){

            @Override
            public int compare(TableNode a, TableNode b) {
                int cmp = (int)(mapItemToAuub.get(b.name) - mapItemToAuub.get(a.name));
                return cmp == 0 ? a.name.compareTo(b.name) : cmp;
            }
        });
    }

    private void removeItemFromTree(TableNode p, String name) {
        IAUNode next = p.hlink;
        while (next != null) {
            IAUNode parent = next.getPareent();
            Map<String, IAUNode> delNodeChildren = next.getChildren();
            Iterator<Map.Entry<String, IAUNode>> it = delNodeChildren.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, IAUNode> entry = it.next();
                String key = entry.getKey();
                IAUNode val = entry.getValue();
                this.deleteQuanAryAt(val, 2);
                this.union(key, val, parent, it);
            }
            IAUNode tmp = next;
            p.hlink = next = next.getRight();
            if (next != null) {
                next.setLeft(null);
            }
            tmp.setRight(null);
            tmp.setLeft(null);
            parent.removeChild(name);
            tmp.setParent(null);
        }
        p.hlink = null;
    }

    private void union(String name, IAUNode val, IAUNode grandParent, Iterator<Map.Entry<String, IAUNode>> iter) {
        IAUNode hasExist = grandParent.getChild(name);
        if (hasExist == null) {
            grandParent.putChild(name, val);
            val.setParent(grandParent);
        } else {
            hasExist.mergeQuanAry(val);
            hasExist.mergeAUUB(val);
            if (val.getLeft() == null) {
                TableNode tn = headTableMap.get(val.getName());
                tn.hlink = val.getRight();
            } else {
                val.getLeft().setRight(val.getRight());
            }
            if (val.getRight() != null) {
                val.getRight().setLeft(val.getLeft());
            }
            val.setRight(null);
            val.setLeft(null);
            val.setParent(null);
            iter.remove();
            Map<String, IAUNode> children = val.getChildren();
            Iterator<Map.Entry<String, IAUNode>> it = children.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, IAUNode> entry = it.next();
                IAUNode child = entry.getValue();
                String key = entry.getKey();
                this.union(key, child, hasExist, it);
            }
        }
    }

    private void deleteQuanAryAt(IAUNode cur, int index) {
        cur.removeQuantityAt(cur.quantityArySize() - index);
        Map<String, IAUNode> children = cur.getChildren();
        for (Map.Entry<String, IAUNode> entry : children.entrySet()) {
            IAUNode child = entry.getValue();
            this.deleteQuanAryAt(child, index + 1);
        }
    }

    boolean check() {
        for (Map.Entry<String, Long> entry : mapItemToAuub.entrySet()) {
            if (headTableMap.get(entry.getKey()) != null) continue;
            return false;
        }
        return true;
    }

    boolean check(Map<String, Integer> mapPriority) {
        for (Map.Entry<String, Long> entry : mapItemToAuub.entrySet()) {
            if (mapPriority.get(entry.getKey()) != null) continue;
            return false;
        }
        return true;
    }

    boolean check(Set<String> rescanItems) {
        for (Map.Entry<String, Long> entry : mapItemToAuub.entrySet()) {
            if (!rescanItems.contains(entry.getKey())) continue;
            return false;
        }
        return true;
    }
}

