/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.ihaupm;

import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.IAUNode;
import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.IAUTree;
import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.StackElement;
import ca.pfv.spmf.algorithms.frequentpatterns.ihaupm.TableNode;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IHAUPM {
    IAUTree tree = null;
    Map<String, Integer> item2profits;
    Map<String, Map<String, Long>> EUCS = null;
    public int numOfNodes = 0;

    public IHAUPM(IAUTree DBTree) {
        this.tree = DBTree;
        this.item2profits = DBTree.item2profits;
        this.EUCS = IAUTree.EUCS;
    }

    public int[] mine(String outfile) throws IOException {
        BufferedWriter out = null;
        if (outfile != null) {
            out = new BufferedWriter(new FileWriter(outfile));
        }
        int candidateNum = 0;
        int minedItemsetNum = 0;
        HashMap<String, Double> result = new HashMap<String, Double>();
        Iterator it = null;
        List<TableNode> headTableList = IAUTree.headTable;
        for (int i = headTableList.size() - 1; i >= 0; --i) {
            TableNode p = headTableList.get(i);
            IAUNode s = p.hlink;
            result.clear();
            List<List<IAUNode.IAUPair>> arys = this.collectIntoList(s);
            this.combine(arys);
            for (List<IAUNode.IAUPair> quanAry : arys) {
                List<IAUNode.IAUPair> sublist = quanAry.subList(0, quanAry.size() - 1);
                this.getCombination(sublist, result, quanAry.get(quanAry.size() - 1));
            }
            while (s != null) {
                ArrayList<IAUNode.IAUPair> quanAry = s.getQuanAry();
                List<IAUNode.IAUPair> sublist = quanAry.subList(0, quanAry.size() - 1);
                this.getCombination(sublist, result, (IAUNode.IAUPair)quanAry.get(quanAry.size() - 1));
                s = s.getRight();
            }
            it = result.entrySet().iterator();
            candidateNum += result.size();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String line = (String)entry.getKey();
                double averageUtility = (Double)entry.getValue() / (double)line.split(",").length;
                line = line + " #AUTIL: " + averageUtility;
                if (!(averageUtility >= IAUTree.minautil)) continue;
                if (out != null) {
                    out.write(line + "\n");
                }
                ++minedItemsetNum;
            }
        }
        if (out != null) {
            out.close();
        }
        return new int[]{candidateNum, minedItemsetNum};
    }

    private void getCombination(List<IAUNode.IAUPair> quanAry, Map<String, Double> result, IAUNode.IAUPair curNode) {
        ArrayList<StackElement> stack = new ArrayList<StackElement>();
        StackElement element = new StackElement();
        element.name = curNode.name;
        element.utility = curNode.quan * this.item2profits.get(curNode.name);
        element.location = quanAry.size();
        stack.add(element);
        while (stack.size() != 0) {
            StackElement ele = (StackElement)stack.remove(stack.size() - 1);
            if (!result.containsKey(ele.name)) {
                result.put(ele.name, ele.utility);
            } else {
                double u = result.get(ele.name);
                result.put(ele.name, u += ele.utility);
            }
            String[] names = ele.name.split(",");
            block1: for (int k = ele.location - 1; k >= 0; --k) {
                IAUNode.IAUPair pair = quanAry.get(k);
                for (int i = 0; i < names.length; ++i) {
                    String name1 = pair.name;
                    String name2 = names[i];
                    if (!this.isCombine(name1, name2)) continue block1;
                }
                StackElement tmp = new StackElement();
                tmp.name = ele.name + "," + pair.name;
                tmp.utility = ele.utility + (double)(pair.quan * this.item2profits.get(pair.name));
                tmp.location = k;
                stack.add(tmp);
            }
        }
    }

    boolean isCombine(String name1, String name2) {
        block13: {
            Long val;
            block14: {
                block15: {
                    Map<String, Long> subEUCS;
                    block10: {
                        Long val2;
                        block11: {
                            block12: {
                                subEUCS = this.EUCS.get(name1);
                                if (subEUCS == null) break block10;
                                val2 = subEUCS.get(name2);
                                if (val2 != null) break block11;
                                subEUCS = this.EUCS.get(name2);
                                if (subEUCS == null) {
                                    return false;
                                }
                                Long oval = subEUCS.get(name1);
                                if (oval == null) break block12;
                                if (!((double)oval.longValue() < IAUTree.minautil)) break block13;
                            }
                            return false;
                        }
                        if ((double)val2.longValue() < IAUTree.minautil) {
                            return false;
                        }
                        break block13;
                    }
                    subEUCS = this.EUCS.get(name2);
                    if (subEUCS == null) break block13;
                    val = subEUCS.get(name1);
                    if (val != null) break block14;
                    subEUCS = this.EUCS.get(name1);
                    if (subEUCS == null) {
                        return false;
                    }
                    Long oval = subEUCS.get(name2);
                    if (oval == null) break block15;
                    if (!((double)oval.longValue() < IAUTree.minautil)) break block13;
                }
                return false;
            }
            if ((double)val.longValue() < IAUTree.minautil) {
                return false;
            }
        }
        return true;
    }

    void combine(List<List<IAUNode.IAUPair>> arys) {
        Collections.sort(arys, new Comparator<List<IAUNode.IAUPair>>(){

            @Override
            public int compare(List<IAUNode.IAUPair> a, List<IAUNode.IAUPair> b) {
                int cmp = a.size() - b.size();
                if (cmp == 0) {
                    for (int i = 0; i < a.size(); ++i) {
                        IAUNode.IAUPair aval = a.get(i);
                        IAUNode.IAUPair bval = b.get(i);
                        int namecmp = aval.name.compareTo(bval.name);
                        if (namecmp == 0) continue;
                        return namecmp;
                    }
                    return 0;
                }
                return cmp;
            }
        });
        for (int i = 1; i < arys.size(); ++i) {
            List<IAUNode.IAUPair> b;
            List<IAUNode.IAUPair> a = arys.get(i - 1);
            if (!this.isEquals(a, b = arys.get(i))) continue;
            for (int j = 0; j < a.size(); ++j) {
                IAUNode.IAUPair aval = a.get(j);
                aval.quan += b.get((int)j).quan;
            }
            arys.remove(i);
            --i;
        }
    }

    boolean isEquals(List<IAUNode.IAUPair> a, List<IAUNode.IAUPair> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            IAUNode.IAUPair aval = a.get(i);
            IAUNode.IAUPair bval = b.get(i);
            if (aval.name.equals(bval.name)) continue;
            return false;
        }
        return true;
    }

    List<List<IAUNode.IAUPair>> collectIntoList(IAUNode s) {
        ArrayList<List<IAUNode.IAUPair>> arys = new ArrayList<List<IAUNode.IAUPair>>();
        while (s != null) {
            ArrayList<IAUNode.IAUPair> quanAry = s.getQuanAry();
            List sublist = quanAry.subList(0, quanAry.size());
            arys.add(sublist);
            s = s.getRight();
            ++this.numOfNodes;
        }
        return arys;
    }
}

